/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.spread.template.spreadmanager.serializer.afix;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.epm.eb.common.dimension.property.PropertyObj;
import kd.epm.eb.common.utils.RangeModel;
import kd.epm.eb.spread.template.afix.multimanager.MultiAreaManager;
import kd.epm.eb.spread.template.dimension.PageViewDimMember;
import kd.epm.eb.spread.template.spreadmanager.CellDimMember;
import kd.epm.eb.spread.template.spreadmanager.MetricCellDimMember;
import kd.epm.eb.spread.template.spreadmanager.serializer.ESheetSerializer;

public class FixMultiAreaManagerSerializer
extends JsonSerializer<MultiAreaManager> {
    private JsonGenerator jsonGenerator;
    private ESheetSerializer eSheetSerializer = new ESheetSerializer();

    public void seteSheetSerializerInfo(JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        this.eSheetSerializer.setJsonGenerator(jsonGenerator);
        this.eSheetSerializer.setSerializerProvider(serializerProvider);
    }

    public void serialize(MultiAreaManager multiAreaManager, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
        this.jsonGenerator = jsonGenerator;
        jsonGenerator.writeStartObject();
        this.writeAreaRange(multiAreaManager.getAreaRange());
        jsonGenerator.writeStringField("startpoint", multiAreaManager.getStartpoint() == null ? "null" : multiAreaManager.getStartpoint());
        jsonGenerator.writeStringField("areaIndex", multiAreaManager.getAreaIndex() == null ? "null" : multiAreaManager.getAreaIndex());
        this.writeAreaPageViewDimMembs(multiAreaManager.getAreaPageViewDims());
        this.writePartitionDimMembs(multiAreaManager.getColpartitionDimMems(), false);
        this.writeStringCollection("coldims", multiAreaManager.getColpartitionDims());
        if (multiAreaManager.getColHeaders() != null) {
            jsonGenerator.writeStringField("colheaders", SerializationUtils.toJsonString(multiAreaManager.getColHeaders()));
        }
        this.writePartitionDimMembs(multiAreaManager.getRowpartitionDimMems(), true);
        this.writeStringCollection("rowdims", multiAreaManager.getRowpartitionDims());
        if (multiAreaManager.getRowHeaders() != null) {
            jsonGenerator.writeStringField("rowheaders", SerializationUtils.toJsonString(multiAreaManager.getRowHeaders()));
        }
        if (multiAreaManager.getFixReportRowSeqDto() != null) {
            jsonGenerator.writeStringField("seqDto", SerializationUtils.toJsonString((Object)multiAreaManager.getFixReportRowSeqDto()));
        }
        this.writeAreaData(multiAreaManager.getData());
        this.writeStringCollection("delData", multiAreaManager.getToDeleteData());
        this.writeStringCollection("uptData", multiAreaManager.getUpdatedData());
        jsonGenerator.writeNumberField("floatOnWhere", multiAreaManager.getFloatonWhere());
        String propertysJsonStr = "";
        Map<String, List<PropertyObj>> dimPropertys = multiAreaManager.getDimPropertys();
        if (dimPropertys != null && dimPropertys.size() > 0) {
            propertysJsonStr = SerializationUtils.toJsonString(dimPropertys);
        }
        jsonGenerator.writeStringField("DimPropertys", propertysJsonStr);
        jsonGenerator.writeBooleanField("userStyle", multiAreaManager.isUserStyle());
        jsonGenerator.writeBooleanField("hasCellHyperLinkInfo", multiAreaManager.isHasCellHyperLinkInfo());
        jsonGenerator.writeEndObject();
    }

    private void writeAreaRange(RangeModel areaRange) throws IOException {
        if (areaRange != null) {
            this.jsonGenerator.writeObjectFieldStart("areaRange");
            this.jsonGenerator.writeNumberField("pos_sx", areaRange.getX_start());
            this.jsonGenerator.writeNumberField("pos_ex", areaRange.getX_end());
            this.jsonGenerator.writeNumberField("pos_sy", areaRange.getY_start());
            this.jsonGenerator.writeNumberField("pos_ey", areaRange.getY_end());
            this.jsonGenerator.writeEndObject();
        }
    }

    private void writeAreaPageViewDimMembs(Map<String, PageViewDimMember> pageViewDims) throws IOException {
        if (pageViewDims != null && !pageViewDims.isEmpty()) {
            this.jsonGenerator.writeObjectFieldStart("APVDimMembs");
            PageViewDimMember member = null;
            for (Map.Entry<String, PageViewDimMember> dimMemb : pageViewDims.entrySet()) {
                this.jsonGenerator.writeObjectFieldStart(dimMemb.getKey());
                member = dimMemb.getValue();
                this.jsonGenerator.writeStringField("number", member.getNumber());
                this.jsonGenerator.writeBooleanField("leaf", member.isIsleaf());
                this.jsonGenerator.writeEndObject();
            }
            this.jsonGenerator.writeEndObject();
        }
    }

    private void writePartitionDimMembs(List<List<CellDimMember>> partitionDimMembs, boolean isRow) throws IOException {
        if (!isRow) {
            this.jsonGenerator.writeArrayFieldStart("colMembs");
        } else {
            this.jsonGenerator.writeArrayFieldStart("rowMembs");
        }
        if (partitionDimMembs != null && !partitionDimMembs.isEmpty()) {
            for (List<CellDimMember> cellMembs : partitionDimMembs) {
                this.jsonGenerator.writeStartArray();
                if (cellMembs != null && !cellMembs.isEmpty()) {
                    for (CellDimMember cellMemb : cellMembs) {
                        this.jsonGenerator.writeStartObject();
                        if (cellMemb != null) {
                            if (cellMemb.isIsleaf()) {
                                this.jsonGenerator.writeBooleanField("leaf", cellMemb.isIsleaf());
                            }
                            if (cellMemb.getDimMemberNumber() != null) {
                                this.jsonGenerator.writeStringField("number", cellMemb.getDimMemberNumber());
                            }
                            if (cellMemb.isMetric()) {
                                this.jsonGenerator.writeBooleanField("isMetric", cellMemb.isMetric());
                            }
                            if (cellMemb.isProperty()) {
                                this.jsonGenerator.writeBooleanField("isProperty", cellMemb.isProperty());
                            }
                            if (cellMemb.getFormat() != null) {
                                this.jsonGenerator.writeStringField("format", cellMemb.getFormat());
                            }
                            if (cellMemb.getSuffix() != null) {
                                this.jsonGenerator.writeStringField("suffix", cellMemb.getSuffix());
                            }
                            if (cellMemb.getPrefix() != null) {
                                this.jsonGenerator.writeStringField("prefix", cellMemb.getPrefix());
                            }
                            if (cellMemb.isMetric()) {
                                MetricCellDimMember metriccell = (MetricCellDimMember)cellMemb;
                                if (metriccell.getDatatype() != null) {
                                    this.jsonGenerator.writeNumberField("datatype", metriccell.getDatatype().intValue());
                                }
                                if (metriccell.getDecimalnum() != null) {
                                    this.jsonGenerator.writeStringField("decimalnum", metriccell.getDecimalnum());
                                }
                                if (metriccell.getSign() != null) {
                                    this.jsonGenerator.writeStringField("sign", metriccell.getSign());
                                }
                            }
                        } else {
                            this.jsonGenerator.writeStringField("number", "");
                        }
                        this.jsonGenerator.writeEndObject();
                    }
                }
                this.jsonGenerator.writeEndArray();
            }
        }
        this.jsonGenerator.writeEndArray();
    }

    private void writeAreaData(MultiAreaManager.AreaDataInfo areaDataInfo) throws IOException {
        this.jsonGenerator.writeObjectFieldStart("areaData");
        this.eSheetSerializer.serialize(areaDataInfo.getDataSheet());
        this.jsonGenerator.writeEndObject();
    }

    private void writeStringCollection(String fieldKey, Collection<String> collection) throws IOException {
        this.jsonGenerator.writeArrayFieldStart(fieldKey);
        if (collection != null) {
            for (String str : collection) {
                this.jsonGenerator.writeString(str);
            }
        }
        this.jsonGenerator.writeEndArray();
    }
}

