/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.spread.template.spreadmanager.serializer.afix;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.spread.template.afix.multimanager.MultiAreaManager;
import kd.epm.eb.spread.template.dimension.PageViewDimMember;
import kd.epm.eb.spread.template.spreadmanager.fix.FixSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.serializer.afix.FixMultiAreaManagerSerializer;

public class FixSpreadManagerSerializer
extends JsonSerializer<FixSpreadManager> {
    private JsonGenerator jsonGenerator;
    private SerializerProvider serializerProvider;
    private FixMultiAreaManagerSerializer areaManagerSerializer;

    public void serialize(FixSpreadManager fixSpreadManager, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
        this.jsonGenerator = jsonGenerator;
        this.serializerProvider = serializerProvider;
        jsonGenerator.writeStartObject();
        this.writeAllDimAndMembs(fixSpreadManager.getAlldimensionWithMembers());
        this.writeDimensionViews(fixSpreadManager.getDimemsionViews());
        this.writePageViewDimMembs(fixSpreadManager.getPageViewDims());
        jsonGenerator.writeStringField("modelNum", fixSpreadManager.getModelobj().getNumber());
        jsonGenerator.writeNumberField("modelid", fixSpreadManager.getModelobj().getId().longValue());
        jsonGenerator.writeNumberField("busModelid", fixSpreadManager.getBusModelid().longValue());
        jsonGenerator.writeNumberField("datasetid", fixSpreadManager.getDatasetid().longValue());
        jsonGenerator.writeBooleanField("isShowNum", fixSpreadManager.isShowNumber());
        this.writeAreaManager(fixSpreadManager.getMultiAreaManager());
        jsonGenerator.writeBooleanField("isFloat", fixSpreadManager.isHasFloat());
        this.writeFormulaMap(fixSpreadManager.getFormulaMap(), "formulaMap");
        this.writeFormulaMap(fixSpreadManager.getOutAreaHyperLink(), "outAreaHyperLink");
        this.writeProcess(fixSpreadManager.getReportProcessId(), fixSpreadManager.getProcessId(), fixSpreadManager.getProcessType());
        jsonGenerator.writeEndObject();
    }

    private void writeFormulaMap(Map<String, Map<String, String>> formulaMap, String key) throws IOException {
        if (formulaMap != null && !formulaMap.isEmpty()) {
            this.jsonGenerator.writeObjectFieldStart(key);
            for (Map.Entry<String, Map<String, String>> formula : formulaMap.entrySet()) {
                this.jsonGenerator.writeObjectFieldStart(formula.getKey());
                for (Map.Entry<String, String> entry : formula.getValue().entrySet()) {
                    this.jsonGenerator.writeStringField(entry.getKey(), entry.getValue());
                }
                this.jsonGenerator.writeEndObject();
            }
            this.jsonGenerator.writeEndObject();
        }
    }

    private void writeAllDimAndMembs(Map<String, Set<String>> alldimensionWithMembers) throws IOException {
        if (alldimensionWithMembers != null && !alldimensionWithMembers.isEmpty()) {
            this.jsonGenerator.writeObjectFieldStart("allDimMembs");
            for (Map.Entry<String, Set<String>> dimMembs : alldimensionWithMembers.entrySet()) {
                this.jsonGenerator.writeArrayFieldStart(dimMembs.getKey());
                if (dimMembs.getValue() != null) {
                    for (String membNum : dimMembs.getValue()) {
                        this.jsonGenerator.writeString(membNum == null ? "null" : membNum);
                    }
                }
                this.jsonGenerator.writeEndArray();
            }
            this.jsonGenerator.writeEndObject();
        }
    }

    private void writeDimensionViews(Map<String, Long> dimensionViews) throws IOException {
        if (dimensionViews != null && !dimensionViews.isEmpty()) {
            this.jsonGenerator.writeObjectFieldStart("dimemsionViews");
            for (Map.Entry<String, Long> dimView : dimensionViews.entrySet()) {
                if (dimView == null) continue;
                this.jsonGenerator.writeStringField(dimView.getKey(), String.valueOf(dimView.getValue()));
            }
            this.jsonGenerator.writeEndObject();
        }
    }

    private void writePageViewDimMembs(Map<String, PageViewDimMember> pageViewDims) throws IOException {
        if (pageViewDims != null && !pageViewDims.isEmpty()) {
            this.jsonGenerator.writeObjectFieldStart("PVDimMembs");
            PageViewDimMember member = null;
            for (Map.Entry<String, PageViewDimMember> dimMemb : pageViewDims.entrySet()) {
                this.jsonGenerator.writeObjectFieldStart(dimMemb.getKey());
                member = dimMemb.getValue();
                this.jsonGenerator.writeStringField("number", member.getNumber());
                this.jsonGenerator.writeBooleanField("leaf", member.isIsleaf());
                this.jsonGenerator.writeEndObject();
            }
            this.jsonGenerator.writeEndObject();
        }
    }

    private void writeAreaManager(List<MultiAreaManager> multiAreaManager) throws IOException {
        this.jsonGenerator.writeArrayFieldStart("areaManager");
        if (multiAreaManager != null && !multiAreaManager.isEmpty()) {
            this.areaManagerSerializer = new FixMultiAreaManagerSerializer();
            this.areaManagerSerializer.seteSheetSerializerInfo(this.jsonGenerator, this.serializerProvider);
            for (MultiAreaManager areaManager : multiAreaManager) {
                this.areaManagerSerializer.serialize(areaManager, this.jsonGenerator, this.serializerProvider);
            }
        }
        this.jsonGenerator.writeEndArray();
    }

    private void writeProcess(Long reportProcessId, Long processId, String processType) throws IOException {
        if (processId != null && StringUtils.isNotEmpty((String)processType)) {
            if (reportProcessId != null) {
                this.jsonGenerator.writeStringField("reportprocessId", reportProcessId.toString());
            }
            if (processId != null) {
                this.jsonGenerator.writeStringField("processId", processId.toString());
            }
            this.jsonGenerator.writeStringField("processType", processType);
        }
    }
}

