/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.spread.template.spreadmanager.sheet;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.spread.template.spreadmanager.hander.SpanMergeHandler;
import kd.epm.eb.spread.template.spreadmanager.sheet.ECell;
import kd.epm.eb.spread.template.spreadmanager.sheet.ISheet;

public abstract class AbstractESheet
implements ISheet {
    private static final long serialVersionUID = 1L;
    protected static final int DEFAULT_MAX_ROW = 1000;
    protected static final int DEFAULT_MAX_COL = 52;
    private List<List<ECell>> table = new ArrayList<List<ECell>>(16);
    private String sheetName = "defaultSheetName";
    private Map<String, Object> userObject;
    private Map<String, Object> defaultDataNodeStyle;
    private Map<String, Object> sheetDefaults;

    public AbstractESheet() {
    }

    public AbstractESheet(int rows, int cols) {
        for (int i = 0; i < rows; ++i) {
            this.table.add(new ArrayList(cols));
        }
    }

    public AbstractESheet(String sheetName) {
        this.sheetName = sheetName;
    }

    public void putUserObject(String key, Object val) {
        if (this.userObject == null) {
            this.userObject = new HashMap<String, Object>(1);
        }
        this.userObject.put(key, val);
    }

    public <T> T getUserObject(String key) {
        if (this.userObject == null) {
            return null;
        }
        return (T)this.userObject.get(key);
    }

    @Override
    public void setDefaultDataNodeStyle(Map<String, Object> defaultDataNodeStyle) {
        this.defaultDataNodeStyle = defaultDataNodeStyle;
    }

    @Override
    public Map<String, Object> getSheetDefaults() {
        return this.sheetDefaults;
    }

    @Override
    public void setSheetDefaults(Map<String, Object> sheetDefaults) {
        this.sheetDefaults = sheetDefaults;
    }

    @Override
    public void addRow() {
        this.table.add(this.extendSameColCountAtOneRow());
    }

    private List<ECell> extendSameColCountAtOneRow() {
        int maxColumnCount = this.getMaxColumnCount();
        ArrayList<ECell> cols = new ArrayList<ECell>(maxColumnCount);
        if (maxColumnCount > 0) {
            for (int i = 0; i < maxColumnCount; ++i) {
                cols.add(this.createECell(false));
            }
        }
        return cols;
    }

    protected ECell createECell(boolean isCreated) {
        return isCreated ? new ECell() : null;
    }

    @Override
    public void addRows(int rowCount) {
        for (int i = 0; i < rowCount; ++i) {
            this.addRow();
        }
    }

    @Override
    public void addRange(int rowCount, int colCount) {
        this.addRows(rowCount);
        this.addColumns(colCount);
    }

    @Override
    public ECell getECell(int row, int col) {
        this.ensureCapacity(row, col);
        List<ECell> rows = this.table.get(row);
        ECell eCell = rows.get(col);
        if (eCell == null) {
            eCell = this.createECell(true);
            rows.set(col, eCell);
        }
        eCell.setRowAndCol(row, col);
        return eCell;
    }

    @Override
    public void setECell(int row, int col, ECell ecell) {
        this.ensureCapacity(row, col);
        this.table.get(row).set(col, ecell);
    }

    private void ensureCapacity(int row, int col) {
        int maxrow = this.getMaxRowCount();
        int maxcol = this.getMaxColumnCount();
        if (row > maxrow - 1) {
            this.autoGrowRows(row - maxrow + 1);
        }
        if (col > maxcol - 1) {
            this.autoGrowCols(col - maxcol + 1);
        }
    }

    private void autoGrowRows(int rowCount) {
        this.addRows(rowCount);
    }

    private void autoGrowCols(int colCount) {
        this.addColumns(colCount);
    }

    @Override
    public void insertRow(int i) {
        int maxRowCount = this.getMaxRowCount();
        if (i > maxRowCount) {
            this.autoGrowRows(i - maxRowCount);
        }
        this.table.add(i, this.extendSameColCountAtOneRow());
    }

    @Override
    public void insertRow(int i, boolean copybefore) {
        if (!copybefore) {
            this.insertRow(i);
        } else {
            int maxRowCount = this.getMaxRowCount();
            if (i > maxRowCount) {
                this.autoGrowRows(i - maxRowCount);
            }
            if (i - 1 >= 0 && this.table.get(i - 1) != null) {
                List before = (List)ObjectSerialUtil.deSerializedBytes((String)ObjectSerialUtil.toByteSerialized(this.table.get(i - 1)));
                for (ECell cell : before) {
                    if (cell != null && cell.isFloatCell()) {
                        Object isQuickAddNew = cell.getUserObject("isQuickAddNew");
                        cell.setValue(null);
                        cell.clearAllUserObject();
                        if (isQuickAddNew != null) {
                            cell.setUserObject("isQuickAddNew", isQuickAddNew);
                        }
                    }
                    if (cell == null || cell.getUserObject("number") != null) continue;
                    cell.setValue(null);
                }
                this.table.add(i, before);
            } else {
                this.table.add(i, this.extendSameColCountAtOneRow());
            }
        }
    }

    @Override
    public void insertRangeRows(int fromColIdx, int toColIdx, int selcRowindex, int rowcount) {
        int r;
        for (r = 0; r < rowcount; ++r) {
            this.insertRow(r + selcRowindex);
        }
        this.ensureCapacity(selcRowindex, toColIdx + rowcount);
        for (r = rowcount - 1; r >= 0; --r) {
            this.moveRowUp(fromColIdx, toColIdx, selcRowindex + r, r);
        }
    }

    @Override
    public void delRangeRows(int fromColIdx, int toColIdx, int selcRowindex, int rowcount) {
        this.moveRowUpInRangeField(fromColIdx, toColIdx, selcRowindex, rowcount);
    }

    private void moveRowUpInRangeField(int fromColIdx, int toColIdx, int selcRowindex, int rowcount) {
        int c;
        List<ECell> targ;
        int from;
        int maxRowCount = this.getMaxRowCount();
        for (from = selcRowindex + rowcount; from < maxRowCount; ++from) {
            List<ECell> source = this.table.get(from);
            targ = this.table.get(from - rowcount);
            for (c = fromColIdx; c <= toColIdx; ++c) {
                targ.set(c, source.get(c));
            }
        }
        for (from = maxRowCount - rowcount; from < maxRowCount; ++from) {
            targ = this.table.get(from);
            for (c = fromColIdx; c <= toColIdx; ++c) {
                targ.set(c, this.createECell(false));
            }
        }
    }

    @Override
    public void delRangeCols(int fromRowIdx, int toRowIdx, int selcColindex, int colCount) {
        this.moveColLeftInRangeField(fromRowIdx, toRowIdx, selcColindex, colCount);
    }

    private void moveColLeftInRangeField(int fromRowIdx, int toRowIdx, int selcColindex, int colCount) {
        int maxColCount = this.getMaxColumnCount();
        for (int r = fromRowIdx; r <= toRowIdx; ++r) {
            List<ECell> targ = this.table.get(r);
            for (int c = selcColindex + colCount; c < maxColCount; ++c) {
                targ.set(c - colCount, targ.get(c));
            }
        }
        for (int from = maxColCount - colCount; from < maxColCount; ++from) {
            for (int r = fromRowIdx; r <= toRowIdx; ++r) {
                this.table.get(r).set(from, this.createECell(false));
            }
        }
    }

    @Override
    public void insertRangeCols(int fromRowIdx, int toRowIdx, int selcColindex, int colCount) {
        for (int c = 0; c < colCount; ++c) {
            this.insertColumn(c + selcColindex);
        }
        this.ensureCapacity(toRowIdx, selcColindex + colCount);
        this.moveColLeft(fromRowIdx, toRowIdx, selcColindex, colCount);
    }

    private void moveColLeft(int excludeFromRowIdx, int excludeToRowIdx, int selcColindex, int colCount) {
        List<ECell> currRow = null;
        int size = this.getMaxRowCount();
        for (int r = 0; r < size; ++r) {
            if (r >= excludeFromRowIdx && r <= excludeToRowIdx) continue;
            currRow = this.getRowInner(r);
            this.doMoveColLeft(currRow, selcColindex, colCount);
        }
    }

    private void doMoveColLeft(List<ECell> currRow, int selcColindex, int colCount) {
        ECell[] dataElements = currRow.toArray(new ECell[0]);
        int size = dataElements.length;
        System.arraycopy(dataElements, selcColindex + colCount, dataElements, selcColindex, this.getMaxColumnCount() - (selcColindex + colCount));
        for (int c = 0; c < colCount; ++c) {
            dataElements[--size] = this.createECell(false);
        }
        currRow.clear();
        currRow.addAll(Arrays.asList(dataElements));
    }

    private void moveRowUp(int excludeFromColIdx, int excludeToColIdx, int startIndex, int offset) {
        List<ECell> nextRow = null;
        int columSize = this.getMaxColumnCount();
        int size = this.table.size();
        for (int idx = startIndex; idx < size && idx != size - 1 - offset; ++idx) {
            this.ensureCapacity(idx + 1, columSize - 1);
            List<ECell> currRow = this.table.get(idx);
            nextRow = this.table.get(idx + 1);
            this.doReplace(currRow, nextRow, 0, excludeFromColIdx - 1);
            this.doReplace(currRow, nextRow, excludeToColIdx + 1, columSize - 1);
        }
        if (nextRow == null) {
            return;
        }
        size = nextRow.size();
        for (int i = 0; i < size; ++i) {
            if (i >= excludeFromColIdx && i <= excludeToColIdx) continue;
            nextRow.set(i, this.createECell(false));
        }
    }

    private void doReplace(List<ECell> targ, List<ECell> src, int start, int end) {
        if (start > end) {
            return;
        }
        for (int i = start; i <= end; ++i) {
            targ.set(i, src.get(i));
        }
    }

    private List<ECell> getRowInner(int i) {
        return this.table.get(i);
    }

    @Override
    public void delRow(int i) {
        if (!this.ensureMaxRow(i)) {
            return;
        }
        this.table.remove(i);
    }

    @Override
    public void delColumn(int i) {
        if (!this.ensureMaxCol(i)) {
            return;
        }
        for (List<ECell> column : this.table) {
            column.remove(i);
        }
    }

    private boolean ensureMaxRow(int rowIndex) {
        return rowIndex < this.getMaxRowCount();
    }

    private boolean ensureMaxCol(int colIndex) {
        return colIndex < this.getMaxColumnCount();
    }

    @Deprecated
    public Iterator<ECell> iteratorECells() {
        ArrayList<ECell> ECells = new ArrayList<ECell>();
        int rowIdx = 0;
        int colIdx = 0;
        for (List<ECell> row : this.table) {
            colIdx = 0;
            for (ECell ECell2 : row) {
                if (ECell2 != null) {
                    ECell2.setRowAndCol(rowIdx, colIdx);
                    ECells.add(ECell2);
                }
                ++colIdx;
            }
            ++rowIdx;
        }
        return ECells.iterator();
    }

    @Override
    public void iteratorECells(Consumer<ECell> consumer) {
        int rowIdx = 0;
        int colIdx = 0;
        for (List<ECell> row : this.table) {
            colIdx = 0;
            for (ECell ECell2 : row) {
                if (ECell2 != null) {
                    ECell2.setRowAndCol(rowIdx, colIdx);
                    consumer.accept(ECell2);
                }
                ++colIdx;
            }
            ++rowIdx;
        }
    }

    @Override
    public void iteratorECellsByPredicateBreak(Predicate<ECell> predicate) {
        int rowIdx = 0;
        int colIdx = 0;
        block0: for (List<ECell> row : this.table) {
            colIdx = 0;
            for (ECell ECell2 : row) {
                if (ECell2 != null) {
                    ECell2.setRowAndCol(rowIdx, colIdx);
                    if (predicate.test(ECell2)) break block0;
                }
                ++colIdx;
            }
            ++rowIdx;
        }
    }

    @Override
    public void iteratorRowRangeECells(int fromRow, int endRow, Consumer<ECell> consumer) {
        endRow = Math.min(endRow, this.getMaxRowCount() - 1);
        int colIdx = 0;
        for (int r = fromRow; r <= endRow; ++r) {
            colIdx = 0;
            for (ECell ECell2 : this.table.get(r)) {
                if (ECell2 != null) {
                    ECell2.setRowAndCol(r, colIdx);
                    consumer.accept(ECell2);
                }
                ++colIdx;
            }
        }
    }

    @Override
    public void iteratorColRangeECells(int fromCol, int endCol, Consumer<ECell> consumer) {
        endCol = Math.min(endCol, this.getMaxColumnCount() - 1);
        int rowIdx = 0;
        for (List<ECell> row : this.table) {
            for (int c = fromCol; c <= endCol; ++c) {
                ECell ECell2 = row.get(c);
                if (ECell2 == null) continue;
                ECell2.setRowAndCol(rowIdx, c);
                consumer.accept(ECell2);
            }
            ++rowIdx;
        }
    }

    @Override
    public void iteratorRangeECells(int fromRow, int endRow, int fromCol, int endCol, Consumer<ECell> consumer) {
        this.iteratorRangeECells(fromRow, endRow, fromCol, endCol, false, consumer);
    }

    @Override
    public void iteratorRangeECells(int fromRow, int endRow, int fromCol, int endCol, boolean isCreateNew, Consumer<ECell> consumer) {
        endRow = Math.min(endRow, this.getMaxRowCount() - 1);
        endCol = Math.min(endCol, this.getMaxColumnCount() - 1);
        for (int r = fromRow; r <= endRow; ++r) {
            for (int c = fromCol; c <= endCol; ++c) {
                ECell ECell2;
                if (isCreateNew) {
                    ECell2 = this.getECell(r, c);
                    consumer.accept(ECell2);
                    continue;
                }
                ECell2 = this.table.get(r).get(c);
                if (ECell2 == null) continue;
                ECell2.setRowAndCol(r, c);
                consumer.accept(ECell2);
            }
        }
    }

    @Override
    public List<ECell> getRow(int rowIndex) {
        ArrayList<ECell> ECells = new ArrayList<ECell>();
        this.iteratorRowRangeECells(rowIndex, rowIndex, ECell2 -> ECells.add((ECell)ECell2));
        return ECells;
    }

    @Override
    public List<ECell> getCol(int colIndex) {
        ArrayList<ECell> ECells = new ArrayList<ECell>();
        this.iteratorColRangeECells(colIndex, colIndex, ECell2 -> ECells.add((ECell)ECell2));
        return ECells;
    }

    private void shrinkRow() {
        boolean isAllNull;
        for (int i = this.table.size() - 1; i >= 1 && (isAllNull = this.table.get(i).stream().allMatch(ECell2 -> ECell2 == null)); --i) {
            this.table.remove(i);
        }
    }

    @Override
    public void insertColumn(int i) {
        int maxColumnCount = this.getMaxColumnCount();
        if (i > maxColumnCount) {
            this.autoGrowCols(i - maxColumnCount);
        }
        for (List<ECell> column : this.table) {
            column.add(i, this.createECell(false));
        }
    }

    @Override
    public void insertColumn(int i, boolean copybefore) {
        if (!copybefore) {
            this.insertColumn(i);
        } else {
            int maxColumnCount = this.getMaxColumnCount();
            if (i > maxColumnCount) {
                this.autoGrowCols(i - maxColumnCount);
            }
            for (List<ECell> column : this.table) {
                if (i - 1 >= 0 && column.get(i - 1) != null) {
                    ECell before = (ECell)ObjectSerialUtil.deSerializedBytes((String)ObjectSerialUtil.toByteSerialized((Object)column.get(i - 1)));
                    if (before != null && before.isFloatCell()) {
                        before.setValue(null);
                        before.clearAllUserObject();
                    }
                    column.add(i, before);
                    continue;
                }
                column.add(i, this.createECell(false));
            }
        }
    }

    @Override
    public void addColumn() {
        for (List<ECell> column : this.table) {
            column.add(this.createECell(false));
        }
    }

    @Override
    public void addColumns(int colCount) {
        for (List<ECell> row : this.table) {
            for (int i = 0; i < colCount; ++i) {
                row.add(this.createECell(false));
            }
        }
    }

    @Override
    public void clear() {
        this.table.clear();
    }

    @Override
    public int getMaxRowCount() {
        return this.table.size();
    }

    @Override
    public int getCountOnRow(int row) {
        return this.table.get(row).size();
    }

    @Override
    public int getMaxColumnCount() {
        return this.table.isEmpty() ? 0 : this.table.get(0).size();
    }

    @Override
    public String getSheetName() {
        return this.sheetName;
    }

    @Override
    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    public static int getDefaultMaxRow() {
        return 1000;
    }

    public static int getDefaultMaxCol() {
        return 52;
    }

    @Override
    public List<List<ECell>> getTable() {
        return this.table;
    }

    public Map<String, Object> getUserObject() {
        return this.userObject;
    }

    public void getTableJSon(JsonGenerator jsonGenerator) throws IOException {
        SpanMergeHandler spanHandler = new SpanMergeHandler();
        jsonGenerator.writeObjectFieldStart("data");
        jsonGenerator.writeObjectFieldStart("dataTable");
        int r = -1;
        for (List<ECell> row : this.table) {
            jsonGenerator.writeObjectFieldStart(String.valueOf(++r));
            int c = -1;
            for (ECell cell : row) {
                ++c;
                if (cell == null) continue;
                jsonGenerator.writeObjectFieldStart(String.valueOf(c));
                cell.toJSon(jsonGenerator);
                spanHandler.findAndMergeSpan(cell, r, c);
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndObject();
        }
        jsonGenerator.writeEndObject();
        this.writeDefaultStyle(jsonGenerator);
        jsonGenerator.writeEndObject();
        if (!spanHandler.isEmpty()) {
            spanHandler.toJSon(jsonGenerator);
        }
    }

    private void writeDefaultStyle(JsonGenerator jsonGenerator) throws IOException {
        jsonGenerator.writeObjectFieldStart("defaultDataNode");
        jsonGenerator.writeObjectFieldStart("style");
        if (this.defaultDataNodeStyle != null && this.defaultDataNodeStyle.get("font") != null) {
            jsonGenerator.writeStringField("font", String.valueOf(this.defaultDataNodeStyle.get("font")));
        } else {
            jsonGenerator.writeStringField("font", "13.3333px \"Microsoft YaHei\"");
        }
        String borderColor = "#4c4c4c";
        if (this.defaultDataNodeStyle != null && this.defaultDataNodeStyle.get("borderColor") != null) {
            borderColor = String.valueOf(this.defaultDataNodeStyle.get("borderColor"));
        }
        jsonGenerator.writeObjectFieldStart("borderLeft");
        jsonGenerator.writeStringField("color", borderColor);
        jsonGenerator.writeNumberField("style", 1);
        jsonGenerator.writeEndObject();
        jsonGenerator.writeObjectFieldStart("borderTop");
        jsonGenerator.writeStringField("color", borderColor);
        jsonGenerator.writeNumberField("style", 1);
        jsonGenerator.writeEndObject();
        jsonGenerator.writeObjectFieldStart("borderRight");
        jsonGenerator.writeStringField("color", borderColor);
        jsonGenerator.writeNumberField("style", 1);
        jsonGenerator.writeEndObject();
        jsonGenerator.writeObjectFieldStart("borderBottom");
        jsonGenerator.writeStringField("color", borderColor);
        jsonGenerator.writeNumberField("style", 1);
        jsonGenerator.writeEndObject();
        jsonGenerator.writeEndObject();
        jsonGenerator.writeEndObject();
    }

    @Override
    public void setECellToNULL(int row, int col) {
        if (row < this.getMaxRowCount() && col < this.getMaxColumnCount()) {
            this.table.get(row).set(col, null);
        }
    }

    @Override
    public void setRow(int row, List<ECell> rowlist) {
        int maxRowCount = this.getMaxRowCount();
        if (maxRowCount < row) {
            for (int i = maxRowCount; i <= row; ++i) {
                this.getTable().add(new ArrayList());
            }
        }
        this.getTable().set(row, rowlist);
    }
}

