/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.spread.template.spreadmanager.sheet;

import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.base.MoreObjects;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.utils.ExcelUtils;
import kd.epm.eb.ebBusiness.sql.util.TypeConversionUtils;
import kd.epm.eb.ebSpread.common.variant.Variant;
import kd.epm.eb.ebSpread.model.CellData;
import kd.epm.eb.ebSpread.model.IDimMember;
import kd.epm.eb.ebSpread.model.UserObject;
import kd.epm.eb.spread.template.spreadmanager.hander.ESpanInfo;

public class ECell
implements Serializable {
    private static final long serialVersionUID = 1L;
    private volatile CellData cellData;
    private String formula;
    private ESpanInfo spanInfo;
    private UserObject userObject = null;
    private boolean isChangeVal = false;
    private transient int row = -1;
    private transient int col = -1;
    private volatile transient Object newValue;
    private boolean isFloatCell;

    public ECell() {
    }

    public ECell(int row, int col) {
        this.row = row;
        this.col = col;
    }

    public void setRowAndCol(int row, int col) {
        this.row = row;
        this.col = col;
    }

    public ECell(int row, int col, Object value) {
        this.row = row;
        this.col = col;
        this.setValue(value);
    }

    public void setRow(int row) {
        this.row = row;
    }

    public void setCol(int col) {
        this.col = col;
    }

    public final boolean setValue(Object val) {
        boolean oldValIsNull;
        Variant temp = this.convert2Variant(val);
        Variant oldCellData = this.getCellData().getData();
        this.isChangeVal = false;
        boolean bl = oldValIsNull = oldCellData == null || oldCellData.isNull() || oldCellData.isEmpty();
        if (oldValIsNull && val != null && StringUtils.isNotEmpty((String)val.toString()) || !oldValIsNull && val == null || !oldValIsNull && temp.compareTo(oldCellData) != 0) {
            this.isChangeVal = true;
            this.getCellData().setData(temp);
        }
        return this.isChangeVal;
    }

    private Variant convert2Variant(Object val) {
        if (val instanceof BigDecimal) {
            return new Variant(val);
        }
        if (val instanceof Number) {
            return new Variant(new BigDecimal(val.toString()));
        }
        if (val instanceof Variant && Variant.encryptVariant.equals(val)) {
            return (Variant)val;
        }
        return new Variant(val);
    }

    public Object getValue() {
        if (this.hasCellData()) {
            return this.getCellData().getData().getValue();
        }
        return null;
    }

    public Variant getVariant() {
        return this.getCellData().getData();
    }

    public boolean isChangeVal() {
        return this.isChangeVal;
    }

    public void setChangeVal(boolean isChange) {
        this.isChangeVal = isChange;
    }

    public void setCellData(CellData cellData) {
        this.cellData = cellData;
    }

    public boolean hasCellData() {
        return this.cellData != null;
    }

    public CellData getCellData() {
        if (this.cellData == null) {
            this.cellData = new CellData();
        }
        return this.cellData;
    }

    public Object getUserObject(String key) {
        if (this.hasUserObject()) {
            return this.getUserObject().getUserObject(key);
        }
        return null;
    }

    public boolean containsUserObjectKey(String key) {
        return this.userObject != null && this.userObject.containsKey(key);
    }

    public boolean hasUserObject() {
        return this.userObject != null && !this.userObject.isEmpty();
    }

    public boolean hasUserObjectExcludeLock() {
        if (this.userObject == null || this.userObject.isEmpty()) {
            return false;
        }
        if (this.userObject.size() > 1) {
            return true;
        }
        return !this.userObject.containsKey("l");
    }

    public UserObject getUserObject() {
        if (this.userObject == null) {
            this.userObject = new UserObject(0);
        }
        return this.userObject;
    }

    public void setUserObject(String key, Object val) {
        this.getUserObject().setUserObject(key, val);
    }

    public void setUserObject(UserObject userObject) {
        this.userObject = userObject;
    }

    public void removeUserObject(String key) {
        if (this.userObject == null) {
            return;
        }
        this.userObject.remove(key);
        if (this.userObject.isEmpty()) {
            this.userObject = null;
        }
    }

    public void clearAllUserObject() {
        this.userObject = null;
    }

    public <T> T getUserObject(String key, T defaultValue) {
        Object v = this.getUserObject(key);
        return (T)(v == null ? defaultValue : v);
    }

    public void addDim2UserObject(IDimMember member) {
        this.getUserObject().addDim2UserObject(member);
    }

    public void addDims2UserObject(List<IDimMember> members) {
        for (IDimMember m : members) {
            this.addDim2UserObject(m);
        }
    }

    public List<IDimMember> getMemberFromUserObject() {
        return this.getUserObject().getMemberFromUserObject();
    }

    public ESpanInfo getSpanInfo() {
        return this.spanInfo;
    }

    public void setSpanInfo(ESpanInfo spanInfo) {
        if (spanInfo != null && spanInfo.getColcount() < 2 && spanInfo.getRowcount() < 2) {
            return;
        }
        this.spanInfo = spanInfo;
    }

    public String getFormula() {
        return this.formula;
    }

    public void setFormula(String formula) {
        this.formula = formula;
    }

    public boolean hasFormula() {
        return StringUtils.isNotEmpty((String)this.formula);
    }

    public int getRow() {
        return this.row;
    }

    public int getCol() {
        return this.col;
    }

    public String getExcelAxis() {
        return ExcelUtils.xy2Pos((int)this.col, (int)this.row);
    }

    public String displayDimMsg() {
        return ECell.formatDimMsg(this.getMemberFromUserObject());
    }

    public static String formatDimMsg(List<IDimMember> members) {
        StringBuilder sb = new StringBuilder();
        if (members != null && !members.isEmpty()) {
            sb.append("[");
            for (IDimMember mem : members) {
                sb.append(mem.getDimension().getName()).append("!").append(mem.getName()).append('|').append(mem.getNumber()).append(";");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append("]");
        }
        return sb.toString();
    }

    public String valueToString() {
        Variant val = this.getCellData().getData();
        if (val == null) {
            return "";
        }
        if (val.isNumber()) {
            return val.toString();
        }
        if (val.isDate()) {
            return TypeConversionUtils.objToDate(val).toString();
        }
        return val.toString();
    }

    public String toJSon(JsonGenerator jsonGenerator) throws IOException {
        if (this.getValue() != null) {
            jsonGenerator.writeObjectField("value", this.getValue());
        }
        jsonGenerator.writeBooleanField("locked", false);
        jsonGenerator.writeEndObject();
        return null;
    }

    public Object getNewValue() {
        return this.newValue;
    }

    public void setNewValue(Object newValue) {
        this.newValue = newValue;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"").add("value", this.cellData == null ? "null" : this.cellData.getData()).add("formula", (Object)this.formula).add("isChangeVal", this.isChangeVal).add("userObject", this.userObject == null ? "null" : this.userObject).toString();
    }

    public boolean isFloatCell() {
        return this.isFloatCell;
    }

    public void setFloatCell(boolean floatCell) {
        this.isFloatCell = floatCell;
    }

    public static ECell cloneECell(ECell eCell) {
        if (eCell != null) {
            ECell cloned = new ECell(eCell.getRow(), eCell.getCol(), eCell.getValue());
            cloned.getUserObject().putAll(eCell.getUserObject());
            cloned.setFloatCell(eCell.isFloatCell());
            return cloned;
        }
        return null;
    }
}

