/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.spread.template.spreadmanager.sheet;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.epm.eb.spread.template.spreadmanager.sheet.AbstractESheet;
import kd.epm.eb.spread.template.spreadmanager.sheet.ECell;
import kd.epm.eb.spread.template.spreadmanager.sheet.StyleCell;

public class ESheet
extends AbstractESheet {
    private volatile int realMaxRows = 0;
    private volatile int realMaxCols = 0;
    private int valueAreaRowStart = -1;
    private int valueAreaColStart = -1;
    private boolean isdatachanged = false;
    private boolean isStyleCell;
    private int dimRowStart = -1;
    private int dimColStart = -1;

    public ESheet() {
    }

    public ESheet(String sheetName) {
        super.setSheetName(sheetName);
    }

    public ESheet(String sheetName, int rows, int cols) {
        super(rows, cols);
        this.setSheetName(sheetName);
    }

    @Override
    public ECell getECell(int row, int col) {
        this.ensureRealMaxRowCol(row + 1, col + 1);
        return super.getECell(row, col);
    }

    @Override
    public ECell createECell(boolean isCreated) {
        if (this.isStyleCell) {
            return isCreated ? new StyleCell() : null;
        }
        return isCreated ? new ECell() : null;
    }

    @Override
    public ECell getECellNotAdd(int row, int col) {
        if (row < 0 || col < 0) {
            return null;
        }
        if (row >= super.getTable().size()) {
            return null;
        }
        List<ECell> cols = super.getTable().get(row);
        if (cols == null) {
            return null;
        }
        if (col >= cols.size()) {
            return null;
        }
        ECell cell = cols.get(col);
        if (cell != null) {
            cell.setRowAndCol(row, col);
        }
        return cell;
    }

    @Override
    public void getSpreadJson(JsonGenerator jsonGenerator) throws IOException {
        jsonGenerator.writeObjectFieldStart(this.getSheetName());
        jsonGenerator.writeStringField("name", this.getSheetName());
        jsonGenerator.writeNumberField("rowCount", this.realMaxRows > 0 ? this.realMaxRows : ESheet.getDefaultMaxRow());
        jsonGenerator.writeNumberField("columnCount", this.realMaxCols > 0 ? this.realMaxCols : ESheet.getDefaultMaxCol());
        this.getTableJSon(jsonGenerator);
        if (this.getSheetDefaults() != null && !this.getSheetDefaults().isEmpty()) {
            jsonGenerator.writeObjectFieldStart("defaults");
            for (Map.Entry<String, Object> entry : this.getSheetDefaults().entrySet()) {
                if (!(entry.getValue() instanceof String)) continue;
                jsonGenerator.writeStringField(entry.getKey(), (String)entry.getValue());
            }
            jsonGenerator.writeEndObject();
        }
        jsonGenerator.writeBooleanField("isProtected", true);
        jsonGenerator.writeObjectFieldStart("protectionOptions");
        jsonGenerator.writeBooleanField("allowResizeRows", true);
        jsonGenerator.writeBooleanField("allowResizeColumns", true);
        jsonGenerator.writeBooleanField("allowInsertRows", true);
        jsonGenerator.writeBooleanField("allowInsertColumns", true);
        jsonGenerator.writeBooleanField("allowDeleteRows", true);
        jsonGenerator.writeBooleanField("allowDeleteColumns", true);
        jsonGenerator.writeBooleanField("allowFilter", true);
        jsonGenerator.writeEndObject();
        jsonGenerator.writeEndObject();
    }

    @Override
    public int getRealMaxRows() {
        return this.realMaxRows;
    }

    @Override
    public void resetRealMaxRows() {
        this.realMaxRows = this.getMaxRowCount();
    }

    @Override
    public int getRealMaxCols() {
        return this.realMaxCols;
    }

    @Override
    public void resetRealMaxCols() {
        this.realMaxCols = this.getMaxColumnCount();
    }

    @Override
    public int getValueAreaRowStart() {
        return this.valueAreaRowStart;
    }

    @Override
    public void setValueAreaRowStart(int valueAreaRowStart) {
        this.valueAreaRowStart = valueAreaRowStart;
    }

    @Override
    public int getValueAreaColStart() {
        return this.valueAreaColStart;
    }

    @Override
    public void setValueAreaColStart(int valueAreaColStart) {
        this.valueAreaColStart = valueAreaColStart;
    }

    @Override
    public int getDimRowStart() {
        return this.dimRowStart;
    }

    @Override
    public void setDimRowStart(int dimRowStart) {
        this.dimRowStart = dimRowStart;
    }

    @Override
    public int getDimColStart() {
        return this.dimColStart;
    }

    @Override
    public void setDimColStart(int dimColStart) {
        this.dimColStart = dimColStart;
    }

    private void ensureRealMaxRowCol(int row, int col) {
        if (row > this.realMaxRows) {
            this.realMaxRows = row;
        }
        if (col > this.realMaxCols) {
            this.realMaxCols = col;
        }
    }

    @Override
    public List<ECell> packageIntoECells() {
        ArrayList<ECell> ECells = new ArrayList<ECell>();
        int r = -1;
        for (List<ECell> row : super.getTable()) {
            ++r;
            int c = -1;
            for (ECell ECell2 : row) {
                ++c;
                if (ECell2 == null || ECell2.getValue() == null) continue;
                ECell2.setRowAndCol(r, c);
                ECells.add(ECell2);
            }
        }
        return ECells;
    }

    @Override
    public boolean isIsdatachanged() {
        return this.isdatachanged;
    }

    @Override
    public void setIsdatachanged(boolean isdatachanged) {
        this.isdatachanged = isdatachanged;
    }

    @Override
    public void setStyleCell(boolean styleCell) {
        this.isStyleCell = styleCell;
    }

    @Override
    public boolean isStyleCell() {
        return this.isStyleCell;
    }

    @Override
    public String getEmptySheetJson() {
        StringBuilder json = new StringBuilder();
        json.append("\"").append(this.getSheetName()).append("\":{");
        json.append("\"name\":\"").append(this.getSheetName()).append("\",");
        json.append("\"rowCount\":\"").append(1000).append("\",");
        json.append("\"columnCount\":\"").append(52).append("\",");
        json.append(this.getEmptyTableJson());
        json.append("}");
        return json.toString();
    }

    public String getEmptyTableJson() {
        StringBuilder json = new StringBuilder();
        json.append("\"data\": {").append("\"dataTable\": {");
        json.append("}}");
        return json.toString();
    }
}

