/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.spread.utils;

import com.google.common.collect.Lists;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.fileservice.utils.FileUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.AttachmentModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.session.EncreptSessionUtils;
import kd.epm.eb.common.cache.impl.MembersKey;
import kd.epm.eb.common.enums.AttachementTypeEnum;
import kd.epm.eb.common.utils.ExcelUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.spread.control.ISpreadContainer;
import kd.epm.eb.spread.template.spreadmanager.IEbSpreadManager;
import org.apache.commons.collections.CollectionUtils;

public class AttachmentHelper {
    private static final Log log = LogFactory.getLog(AttachmentHelper.class);

    public static Map<MembersKey, String> getTaskCellKeys(Long modelId, List<String> orderDims) {
        Map collect;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("select ter.fmemberskey as memberskey,ter.fremark  as remark,ter.fattachmentcount as attachmentcount,ter.fmodifytime  as modifytime from t_eb_reportattachment ter where ter .fmodelid  = ? and ftype  = ? ");
        HashMap<MembersKey, String> cellTagMaps = new HashMap<MembersKey, String>(16);
        ArrayList<AttachmentQueryDTO> attachmentQueryDTOList = new ArrayList<AttachmentQueryDTO>(16);
        DataSet ds = DB.queryDataSet((String)"gettaskcellkeys", (DBRoute)DBRoute.of((String)"epm"), (String)stringBuilder.toString(), (Object[])new Object[]{modelId, AttachementTypeEnum.CELL.getValue()});
        Object object = null;
        try {
            while (ds.hasNext()) {
                Row row = ds.next();
                attachmentQueryDTOList.add(new AttachmentQueryDTO(row.getString("memberskey"), row.getString("remark"), row.getInteger("attachmentcount"), row.getDate("modifytime")));
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (object != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        if (CollectionUtils.isNotEmpty(attachmentQueryDTOList) && (collect = attachmentQueryDTOList.stream().collect(Collectors.groupingBy(AttachmentQueryDTO::getMemberskey, Collectors.toList()))).size() > 0) {
            for (Map.Entry entry : collect.entrySet()) {
                List value = (List)entry.getValue();
                if (!CollectionUtils.isNotEmpty((Collection)value)) continue;
                value.sort(Comparator.comparing(AttachmentQueryDTO::getModifytime).reversed());
                AttachmentQueryDTO attachmentQueryDTO = (AttachmentQueryDTO)value.get(0);
                MembersKey membersKey = AttachmentHelper.getMembersKeyByStrAttachment(attachmentQueryDTO.getMemberskey(), orderDims);
                cellTagMaps.put(membersKey, attachmentQueryDTO.getRemark());
            }
        }
        return cellTagMaps;
    }

    public static MembersKey getMembersKeyByStr(String membersKeyJson, List<String> orderDims) {
        MembersKey membersKey = new MembersKey();
        if (!StringUtils.isEmpty((String)membersKeyJson)) {
            Map<String, String> membersMap = (Map<String, String>)SerializationUtils.fromJsonString((String)membersKeyJson, Map.class);
            if (orderDims != null && orderDims.size() > 0) {
                membersMap = AttachmentHelper.sortDimByDataSet(membersMap, orderDims);
            }
            List<String> memberList = membersMap.values().stream().collect(Collectors.toList());
            memberList.add(0, null);
            Object[] membersArr = memberList.toArray(new String[memberList.size()]);
            membersKey.setKeys(membersArr);
        }
        return membersKey;
    }

    public static MembersKey getMembersKeyByStrAttachment(String membersKeyJson, List<String> orderDims) {
        MembersKey membersKey = new MembersKey();
        if (!StringUtils.isEmpty((String)membersKeyJson)) {
            Map<String, String> membersMap = (Map<String, String>)SerializationUtils.fromJsonString((String)membersKeyJson, Map.class);
            if (orderDims != null && orderDims.size() > 0) {
                membersMap = AttachmentHelper.sortDimByDataSetAttachment(membersMap, orderDims);
            }
            List<String> memberList = membersMap.values().stream().collect(Collectors.toList());
            memberList.add(0, null);
            Object[] membersArr = memberList.toArray(new String[memberList.size()]);
            membersKey.setKeys(membersArr);
        }
        return membersKey;
    }

    public static Map<String, Object> getCellTag(int row, int col, boolean mark, int pos) {
        HashMap<String, Object> cellTag = new HashMap<String, Object>();
        cellTag.put("r", row);
        cellTag.put("c", col);
        cellTag.put("st", mark);
        cellTag.put("pos", Lists.newArrayList((Object[])new Integer[]{pos}));
        return cellTag;
    }

    public static Map<String, Object> getCellTag(String pointStr, boolean mark, int pos) {
        int col = ExcelUtils.pos2X((String)pointStr);
        int row = ExcelUtils.pos2Y((String)pointStr);
        return AttachmentHelper.getCellTag(row, col, mark, pos);
    }

    public static List<Map<String, Object>> getTaskCellTags(List<String> ranges, Boolean isShow) {
        ArrayList<Map<String, Object>> cellTagMaps = new ArrayList<Map<String, Object>>(16);
        for (String areaRange : ranges) {
            if (StringUtils.isEmpty((String)areaRange)) continue;
            Map<String, Object> cellTags = AttachmentHelper.getCellTag(areaRange, isShow, 1);
            cellTagMaps.add(cellTags);
        }
        return cellTagMaps;
    }

    public static List<Map<String, Object>> getTaskCellTags(List<String> ranges, Boolean isShow, int position) {
        ArrayList<Map<String, Object>> cellTagMaps = new ArrayList<Map<String, Object>>(16);
        for (String areaRange : ranges) {
            if (StringUtils.isEmpty((String)areaRange)) continue;
            Map<String, Object> cellTags = AttachmentHelper.getCellTag(areaRange, isShow, position);
            cellTagMaps.add(cellTags);
        }
        return cellTagMaps;
    }

    public static void setTaskCellTagsByRange(List<String> ranges, Boolean isShow, ISpreadContainer spreadContainer) {
        List<Map<String, Object>> taskCellTags = AttachmentHelper.getTaskCellTags(ranges, isShow);
        if (taskCellTags != null && taskCellTags.size() > 0) {
            spreadContainer.setCellTags(taskCellTags);
        }
    }

    public static void setTaskCellTagsByRange(List<Map<String, Object>> taskCellTags, ISpreadContainer spreadContainer) {
        if (taskCellTags != null && taskCellTags.size() > 0) {
            spreadContainer.setCellTags(taskCellTags);
        }
    }

    public static void setTaskCellTagsByRange(List<String> ranges, Boolean isShow, ISpreadContainer spreadContainer, int position) {
        List<Map<String, Object>> taskCellTags = AttachmentHelper.getTaskCellTags(ranges, isShow, position);
        if (taskCellTags != null && taskCellTags.size() > 0) {
            spreadContainer.setCellTags(taskCellTags);
        }
    }

    public static void setCellCommonByRange(Map<String, String> commentMap, Boolean isShow, ISpreadContainer spreadContainer) {
        List<Map<String, Object>> taskCellComments = AttachmentHelper.getComments(commentMap, isShow);
        if (taskCellComments != null && taskCellComments.size() > 0) {
            spreadContainer.setComment(taskCellComments, 0);
        }
    }

    public static void setCellCommonByRange(List<Map<String, Object>> taskCellComments, ISpreadContainer spreadContainer) {
        if (taskCellComments != null && taskCellComments.size() > 0) {
            spreadContainer.setComment(taskCellComments, 0);
        }
    }

    public static List<Map<String, Object>> getComments(Map<String, String> commentMap, Boolean isShow) {
        ArrayList<Map<String, Object>> comments = new ArrayList<Map<String, Object>>(16);
        for (Map.Entry<String, String> comment : commentMap.entrySet()) {
            if (StringUtils.isEmpty((String)comment.getKey())) continue;
            Map<String, Object> cellTags = AttachmentHelper.getComment(comment.getKey(), comment.getValue(), isShow);
            comments.add(cellTags);
        }
        return comments;
    }

    public static Map<String, Object> getComment(int row, int col, String remark, Boolean isShow) {
        HashMap<String, Object> cellTag = new HashMap<String, Object>();
        cellTag.put("r", row);
        cellTag.put("c", col);
        cellTag.put("v", remark);
        cellTag.put("remove", isShow == false);
        return cellTag;
    }

    public static Map<String, Object> getComment(String pointStr, String remark, Boolean isShow) {
        int col = ExcelUtils.pos2X((String)pointStr);
        int row = ExcelUtils.pos2Y((String)pointStr);
        return AttachmentHelper.getComment(row, col, remark, isShow);
    }

    public static Map<String, String> sortDimByDataSet(Map<String, String> allDimMap, List<String> orderDims) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(16);
        for (String dimNum : orderDims) {
            if (!allDimMap.containsKey(dimNum)) continue;
            result.put(dimNum, allDimMap.get(dimNum));
        }
        return result;
    }

    public static Map<String, String> sortDimByDataSetAttachment(Map<String, String> allDimMap, List<String> orderDims) {
        Map<String, String> result = new LinkedHashMap<String, String>(16);
        if (allDimMap.size() != orderDims.size()) {
            return result;
        }
        result = AttachmentHelper.sortDimByDataSet(allDimMap, orderDims);
        return result;
    }

    public static Map<MembersKey, Long> getCellTagKeys(Long modelId, IEbSpreadManager spreadManager) {
        Map collect;
        if (IDUtils.isNull((Long)modelId) || spreadManager == null || spreadManager.getAlldimensionWithMembers().isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        Map<String, Set<String>> alldimensionWithMembers = spreadManager.getAlldimensionWithMembers();
        Map<String, Integer> dimIndex = AttachmentHelper.getDimIndex(alldimensionWithMembers);
        dimIndex = AttachmentHelper.sortDimNumByPos(dimIndex);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("select ter.fmemberskey as memberskey,ter.fid  as id,ter.fmodifytime  as modifytime from t_eb_reportattachment ter where ter .fmodelid  = ? and ftype  = ? ");
        HashMap<MembersKey, Long> cellTagMaps = new HashMap<MembersKey, Long>(16);
        ArrayList<AttachmentQueryDTO> attachmentQueryDTOList = new ArrayList<AttachmentQueryDTO>(16);
        DataSet ds = DB.queryDataSet((String)"gettaskcellkeys", (DBRoute)DBRoute.of((String)"epm"), (String)stringBuilder.toString(), (Object[])new Object[]{modelId, AttachementTypeEnum.CELL.getValue()});
        Object object = null;
        try {
            while (ds.hasNext()) {
                Row row = ds.next();
                attachmentQueryDTOList.add(new AttachmentQueryDTO(row.getString("memberskey"), row.getDate("modifytime"), row.getLong("id")));
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (object != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        if (CollectionUtils.isNotEmpty(attachmentQueryDTOList) && (collect = attachmentQueryDTOList.stream().collect(Collectors.groupingBy(AttachmentQueryDTO::getMemberskey, Collectors.toList()))).size() > 0) {
            for (Map.Entry entry : collect.entrySet()) {
                List value = (List)entry.getValue();
                if (!CollectionUtils.isNotEmpty((Collection)value)) continue;
                value.sort(Comparator.comparing(AttachmentQueryDTO::getModifytime).reversed());
                AttachmentQueryDTO attachmentQueryDTO = (AttachmentQueryDTO)value.get(0);
                MembersKey membersKey = AttachmentHelper.getMembersKeyByStrAttachment(attachmentQueryDTO.getMemberskey(), dimIndex.keySet().stream().collect(Collectors.toList()));
                cellTagMaps.put(membersKey, attachmentQueryDTO.getId());
            }
        }
        return cellTagMaps;
    }

    public static Map<String, Integer> getDimIndex(Map<String, Set<String>> alldimensionWithMembers) {
        LinkedHashMap<String, Integer> dimIndex = new LinkedHashMap<String, Integer>(16);
        int[] index = new int[]{1};
        dimIndex = new LinkedHashMap(16);
        for (Map.Entry<String, Set<String>> stringSetEntry : alldimensionWithMembers.entrySet()) {
            dimIndex.put(stringSetEntry.getKey(), index[0]);
            index[0] = index[0] + 1;
        }
        return dimIndex;
    }

    public static Map<String, Integer> sortDimNumByPos(Map<String, Integer> dimPosMap) {
        Map<String, Integer> result = new LinkedHashMap<String, Integer>(16);
        if (dimPosMap == null || dimPosMap.size() == 0) {
            return result;
        }
        ArrayList<Map.Entry<String, Integer>> list = new ArrayList<Map.Entry<String, Integer>>(dimPosMap.entrySet());
        list.sort(new Comparator<Map.Entry<String, Integer>>(){

            @Override
            public int compare(Map.Entry<String, Integer> o1, Map.Entry<String, Integer> o2) {
                return o1.getValue().compareTo(o2.getValue());
            }
        });
        result = list.stream().collect(Collectors.toMap(key -> (String)key.getKey(), key -> (Integer)key.getValue(), (o1, o2) -> o1, LinkedHashMap::new));
        return result;
    }

    public static Map<String, String> sortDimNumByKey(Map<String, String> dimMap) {
        Map<String, String> result = new LinkedHashMap<String, String>(16);
        if (dimMap == null || dimMap.size() == 0) {
            return result;
        }
        ArrayList<Map.Entry<String, String>> list = new ArrayList<Map.Entry<String, String>>(dimMap.entrySet());
        list.sort(new Comparator<Map.Entry<String, String>>(){

            @Override
            public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        });
        result = list.stream().collect(Collectors.toMap(key -> (String)key.getKey(), key -> (String)key.getValue(), (o1, o2) -> o1, LinkedHashMap::new));
        return result;
    }

    public static void saveAttachInTemplate(Long templateId, String urlStr, String desc, String weaveId) {
        List<Map<String, Object>> urls = null;
        Long id = Long.parseLong(weaveId);
        QFilter qFilter = new QFilter("fInterID", "=", (Object)weaveId);
        if (StringUtils.isEmpty((String)desc)) {
            if (StringUtils.isEmpty((String)urlStr)) {
                DeleteServiceHelper.delete((String)"eb_weavedescentity", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
                AttachmentHelper.deleteAttachmentData(qFilter);
                return;
            }
            urls = (ArrayList<Map<String, Object>>)SerializationUtils.deSerializeFromBase64((String)urlStr);
            if (urls == null || urls.size() == 0) {
                DeleteServiceHelper.delete((String)"eb_weavedescentity", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
                AttachmentHelper.deleteAttachmentData(qFilter);
                return;
            }
        }
        DynamicObject weaveInfo = BusinessDataServiceHelper.loadSingle((String)"eb_weavedescentity", (String)"desc, modifier, modifydate", (QFilter[])new QFilter[]{new QFilter("template", "=", (Object)templateId)});
        Long user = UserUtils.getUserId();
        Date time = TimeServiceHelper.now();
        if (weaveInfo == null) {
            weaveInfo = BusinessDataServiceHelper.newDynamicObject((String)"eb_weavedescentity");
            weaveInfo.set("id", (Object)weaveId);
            weaveInfo.set("template", (Object)templateId);
            weaveInfo.set("creater", (Object)user);
            weaveInfo.set("createdate", (Object)time);
        }
        weaveInfo.set("desc", (Object)desc);
        weaveInfo.set("modifier", (Object)user);
        weaveInfo.set("modifydate", (Object)time);
        if (urlStr != null) {
            List<String> numbers;
            urls = (List)SerializationUtils.deSerializeFromBase64((String)urlStr);
            if (urls.size() != 0 && (numbers = AttachmentHelper.filterNotDelAtt(urls, id)).size() != 0) {
                qFilter.and(new QFilter("fnumber", "not in", numbers));
            }
        } else {
            urls = new ArrayList<Map<String, Object>>(16);
        }
        try {
            AttachmentHelper.deleteAttachmentData(qFilter);
            AttachmentHelper.saveAttachmentData(urls, id, "eb_weavedescentity");
            List attachments = AttachmentServiceHelper.getAttachments((String)"eb_weavedescentity", (Object)weaveId, (String)"attachmentpanelap");
            AttachmentHelper.uploadTargetAttachments("bgm_report_desc", templateId, "attachmentpanelap1", attachments);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u9644\u4ef6\u4fdd\u5b58\u5931\u8d25\u3002", (String)"AttachementHelper_0", (String)"epm-eb-spread", (Object[])new Object[0]));
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{weaveInfo});
    }

    public static List<String> filterNotDelAtt(List<Map<String, Object>> urls, Long id) {
        ArrayList<String> numbers = new ArrayList<String>(16);
        ArrayList toRemove = new ArrayList(16);
        String sql = "id, fattachmentname, fattachmentsize, fnumber, fdescription";
        QFilter qFilter = new QFilter("fInterID", "=", (Object)String.valueOf(id));
        DynamicObjectCollection attachments = QueryServiceHelper.query((String)"bos_attachment", (String)sql, (QFilter[])new QFilter[]{qFilter});
        for (DynamicObject attachment : attachments) {
            urls.forEach(e -> {
                if (AttachmentHelper.checkAttSame(e, attachment)) {
                    numbers.add(attachment.getString("fnumber"));
                    toRemove.add(e);
                }
            });
        }
        urls.removeAll(toRemove);
        return numbers;
    }

    public static void saveAttachmentData(List<Map<String, Object>> urls, Long id, String formId) throws UnsupportedEncodingException {
        DynamicObject dynObj = null;
        if (urls.size() == 0) {
            return;
        }
        ArrayList<DynamicObject> attachList = new ArrayList<DynamicObject>(16);
        for (Map<String, Object> url : urls) {
            dynObj = BusinessDataServiceHelper.newDynamicObject((String)"bos_attachment");
            dynObj.set("fBillType", (Object)formId);
            dynObj.set("fInterID", (Object)id);
            dynObj.set("fCreateMen_Id", url.get("creator"));
            dynObj.set("fCreateTime", (Object)(url.containsKey("createdate") ? Convert.toDate((Object)url.get("createdate")) : Convert.toDate((Object)System.currentTimeMillis())));
            dynObj.set("fnumber", url.get("uid"));
            String urlToSave = url.get("url").toString();
            String name = url.get("name").toString();
            if (urlToSave.contains(formId)) {
                dynObj.set("fFileId", (Object)urlToSave);
            } else {
                dynObj.set("fFileId", (Object)AttachmentServiceHelper.saveTempToFileService((String)urlToSave, (String)"epm", (String)formId, (Object)id, (String)name));
            }
            dynObj.set("fAttachmentName", (Object)name);
            int index = name.lastIndexOf(".") + 1;
            String type = name.substring(index);
            dynObj.set("fExtName", (Object)type);
            dynObj.set("fAttachmentSize", url.get("size") == null ? Integer.valueOf(100) : url.get("size"));
            dynObj.set("FBillStatus", (Object)"A");
            dynObj.set("fModifyMen_Id", url.get("creator"));
            Date modifyTime = null;
            try {
                if (url.containsKey("lastModified")) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    Long time = sdf.parse(url.get("lastModified").toString()).getTime();
                    modifyTime = Convert.toDate((Object)time);
                } else {
                    modifyTime = Convert.toDate((Object)System.currentTimeMillis());
                }
            }
            catch (Exception e) {
                log.error((Throwable)e);
                modifyTime = Convert.toDate((Object)url.get("lastModified"));
            }
            dynObj.set("fModifyTime", (Object)modifyTime);
            dynObj.set("fdescription", url.get("description"));
            dynObj.set("fattachmentpanel", (Object)"attachmentpanelap");
            attachList.add(dynObj);
        }
        SaveServiceHelper.save((DynamicObject[])attachList.toArray(new DynamicObject[0]));
    }

    public static boolean checkAttSame(Map<String, Object> url, DynamicObject dynObj) {
        String name = url.get("name").toString();
        String size = url.get("size").toString();
        String uid = url.get("uid").toString();
        String desc = Convert.toStr((Object)url.get("description"), (String)"");
        return dynObj.getString("fattachmentname").equals(name) && dynObj.getString("fattachmentsize").equals(size) && dynObj.get("fnumber").equals(uid) && dynObj.getString("fdescription").equals(desc);
    }

    public static void deleteAttachmentData(QFilter qFilter) {
        DynamicObjectCollection attachments = QueryServiceHelper.query((String)"bos_attachment", (String)"fFileId", (QFilter[])new QFilter[]{qFilter});
        if (attachments == null || attachments.size() == 0) {
            return;
        }
        Set urls = attachments.stream().map(e -> e.getString("fFileId")).collect(Collectors.toSet());
        FileService attachmentFileService = FileServiceFactory.getAttachmentFileService();
        for (String url : urls) {
            if (!attachmentFileService.exists(url)) continue;
            attachmentFileService.delete(url);
        }
        DeleteServiceHelper.delete((String)"bos_attachment", (QFilter[])new QFilter[]{qFilter});
    }

    public static void uploadTargetAttachments(String targetBillNo, Object targetPkid, String attachKey, List<Map<String, Object>> attachments) {
        AttachmentServiceHelper.remove((String)targetBillNo, (Object)targetPkid);
        for (Map<String, Object> attachItem : attachments) {
            QFilter[] filters = new QFilter[]{new QFilter("fnumber", "=", (Object)((String)attachItem.get("uid")))};
            DynamicObject att = BusinessDataServiceHelper.loadSingle((String)"bos_attachment", (String)"FFileId", (QFilter[])filters);
            if (att == null) {
                return;
            }
            String resourcePath = att.getString("FFileId");
            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            FileService fs = FileServiceFactory.getAttachmentFileService();
            InputStream inputStream = fs.getInputStream(resourcePath);
            String tempUrl = cache.saveAsUrl((String)attachItem.get("name"), inputStream, 7200);
            tempUrl = EncreptSessionUtils.encryptSession((String)tempUrl);
            String address = RequestContext.get().getClientFullContextPath();
            if (!address.endsWith("/")) {
                address = address + "/";
            }
            String tempUrl3 = address + tempUrl;
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)targetBillNo);
            String appId = dataEntityType.getAppId();
            String name = (String)attachItem.get("name");
            String path = AttachmentServiceHelper.saveTempToFileService((String)tempUrl3, (String)appId, (String)targetBillNo, (Object)targetPkid, (String)name);
            attachItem.put("url", path);
            Object lastModified1 = attachItem.get("lastModified");
            if (lastModified1 instanceof Timestamp) {
                Timestamp lastModified = (Timestamp)lastModified1;
                attachItem.put("lastModified", lastModified.getTime());
            }
            Object description = attachItem.get("description");
            attachItem.put("description", description);
        }
        AttachmentServiceHelper.upload((String)targetBillNo, (Object)targetPkid, (String)attachKey, attachments);
    }

    public static Map<String, Object> saveToTemp(List<Map<String, Object>> attachments, String attchmentControlKey) {
        if (attachments.size() != 0) {
            HashMap<String, Object> attachCache = new HashMap<String, Object>(16);
            TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            for (Map<String, Object> attachment : attachments) {
                String realPath = AttachmentHelper.getRealPath(attachment);
                if (realPath == null || realPath.contains("tempfile")) continue;
                InputStream fileInputStream = null;
                try {
                    fileInputStream = FileServiceFactory.getAttachmentFileService().getInputStream(URLDecoder.decode(realPath, "utf-8"));
                }
                catch (Exception e) {
                    throw new KDBizException(e.getMessage());
                }
                String tempUrl = tempFileCache.saveAsUrl(attachment.get("name").toString(), fileInputStream, 7200);
                String prefix = RequestContext.get().getClientFullContextPath();
                if (!prefix.endsWith("/")) {
                    prefix = prefix + "/";
                }
                tempUrl = prefix + tempUrl;
                attachment.put("url", tempUrl);
            }
            attachCache.put(attchmentControlKey, attachments);
            return attachCache;
        }
        return null;
    }

    public static void addPreView(List<Map<String, Object>> attachments) {
        AttachmentModel attachmentModel = new AttachmentModel();
        for (Map<String, Object> attachment : attachments) {
            String type;
            String name = String.valueOf(attachment.get("name"));
            int index = name.lastIndexOf(".") + 1;
            if (index >= name.length() || !FileUtil.isExtExist((String)(type = name.substring(index))) || attachment.get("previewurl") != null) continue;
            String tempUrl = attachment.get("url").toString();
            String tempFilePreviewUrl = attachmentModel.getTempFilePreviewUrl(tempUrl);
            attachment.put("previewurl", tempFilePreviewUrl);
        }
    }

    public static String getRealPath(Map<String, Object> attachment) {
        String url = attachment.get("url").toString();
        String[] urlArr = url.split("path=|&");
        if (urlArr.length < 2) {
            return null;
        }
        return urlArr[1];
    }

    static class AttachmentQueryDTO {
        private String memberskey;
        private String remark;
        private Integer attachmentcount;
        private Date modifytime;
        private Long id;

        public AttachmentQueryDTO(String memberskey, String remark, Integer attachmentcount, Date modifytime) {
            this.memberskey = memberskey;
            this.remark = remark;
            this.attachmentcount = attachmentcount;
            this.modifytime = modifytime;
        }

        public AttachmentQueryDTO(String memberskey, Date modifytime, Long id) {
            this.memberskey = memberskey;
            this.modifytime = modifytime;
            this.id = id;
        }

        public String getMemberskey() {
            return this.memberskey;
        }

        public void setMemberskey(String memberskey) {
            this.memberskey = memberskey;
        }

        public String getRemark() {
            return this.remark;
        }

        public void setRemark(String remark) {
            this.remark = remark;
        }

        public Integer getAttachmentcount() {
            return this.attachmentcount;
        }

        public void setAttachmentcount(Integer attachmentcount) {
            this.attachmentcount = attachmentcount;
        }

        public Date getModifytime() {
            return this.modifytime;
        }

        public void setModifytime(Date modifytime) {
            this.modifytime = modifytime;
        }

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }
    }
}

