/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.spread.utils;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.dimension.property.PropertyMemObj;
import kd.epm.eb.common.dimension.property.PropertyObj;
import kd.epm.eb.common.ebcommon.common.enums.MemberDisplayTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.spread.template.afix.multimanager.AreaInfo;
import kd.epm.eb.spread.template.afix.multimanager.MultiAreaManager;
import kd.epm.eb.spread.template.headerarea.IHeaderInfo;
import kd.epm.eb.spread.template.spreadmanager.CellDimMember;
import kd.epm.eb.spread.template.spreadmanager.sheet.ECell;
import kd.epm.eb.spread.template.spreadmanager.sheet.ISheet;
import org.apache.commons.collections4.CollectionUtils;

public class DimPropertyHelper {
    public static final String CACHE_DIMPROPERTYSELECTED = "CacheDimPropertySelected";

    public static List<ECell> setCellProperty(int r, int c, String dimNum, Member member, MultiAreaManager multiAreaManager, List<PropertyObj> memEntitys, Boolean isRowPartition, int memberDisplayType) {
        ArrayList<ECell> result = new ArrayList<ECell>();
        if (dimNum == null || multiAreaManager == null) {
            return result;
        }
        Map<String, List<PropertyObj>> propertyMap = multiAreaManager.getDimPropertys();
        ISheet eSheet = multiAreaManager.getData().getDataSheet();
        if (propertyMap != null && eSheet != null && propertyMap.containsKey(dimNum)) {
            Map<Object, Object> memEntityMap = new HashMap(16);
            if (memEntitys != null) {
                memEntityMap = memEntitys.stream().collect(Collectors.toMap(entry -> entry.getNumber(), entry -> entry));
            }
            Map<String, Integer> propPosMap = DimPropertyHelper.getPropPosMap(isRowPartition != false ? multiAreaManager.getRowHeaders() : multiAreaManager.getColHeaders(), dimNum);
            for (PropertyObj property : propertyMap.get(dimNum)) {
                String memNum;
                Integer index = propPosMap.get(property.getNumber());
                if (index == null) continue;
                ECell propertyCell = isRowPartition != false ? eSheet.getECell(r, index) : eSheet.getECell(index, c);
                String propertyNum = "";
                String string = memNum = member == null ? "" : member.getNumber();
                if (memEntityMap.containsKey(property.getNumber())) {
                    List memPropertys = ((PropertyObj)memEntityMap.get(property.getNumber())).getPropertyValueEntries();
                    if (memPropertys != null && memPropertys.size() > 0) {
                        PropertyMemObj propertyMemObj = (PropertyMemObj)memPropertys.get(0);
                        if (MemberDisplayTypeEnum.NUMBER.getIndex() == memberDisplayType) {
                            propertyCell.setValue(property.getNumber() + "#" + propertyMemObj.getNumber());
                        } else if (MemberDisplayTypeEnum.SIMNAMENUMBER.getIndex() == memberDisplayType || MemberDisplayTypeEnum.NAMEANDNUMBER.getIndex() == memberDisplayType) {
                            propertyCell.setValue(propertyMemObj.getName() + " " + property.getNumber() + "#" + propertyMemObj.getNumber());
                        } else {
                            propertyCell.setValue(propertyMemObj.getName());
                        }
                        propertyNum = ((PropertyMemObj)memPropertys.get(0)).getNumber();
                    } else {
                        propertyCell.setValue(null);
                    }
                } else {
                    propertyCell.setValue(null);
                }
                DimPropertyHelper.setPropertyCellUserObject(propertyCell, dimNum, memNum, property.getNumber(), property.getName(), propertyNum);
                ECell cell = DimPropertyHelper.createCell(propertyCell);
                result.add(cell);
            }
        }
        return result;
    }

    public static void setCellDimMember(String dimNum, Map<String, Integer> propIndexes, Map<String, List<PropertyObj>> propertyMap, List<PropertyObj> memEntitys, List<CellDimMember> cellDimMembers) {
        if (cellDimMembers != null && propertyMap.containsKey(dimNum)) {
            Map<Object, Object> memEntityMap = new HashMap(16);
            if (memEntitys != null) {
                memEntityMap = memEntitys.stream().collect(Collectors.toMap(entry -> entry.getNumber(), entry -> entry));
            }
            Integer index = null;
            for (PropertyObj property : propertyMap.get(dimNum)) {
                List memPropertys;
                if (property == null || (index = propIndexes.get(property.getNumber())) == null) continue;
                String propertyNum = "";
                if (memEntityMap.containsKey(property.getNumber()) && (memPropertys = ((PropertyObj)memEntityMap.get(property.getNumber())).getPropertyValueEntries()) != null && memPropertys.size() > 0) {
                    propertyNum = ((PropertyMemObj)memPropertys.get(0)).getNumber();
                }
                String memStr = String.format("%s#%s", property.getNumber(), propertyNum);
                CellDimMember cellProperty = new CellDimMember(true, memStr);
                cellProperty.setProperty(true);
                cellDimMembers.set(index, cellProperty);
            }
        }
    }

    public static void resetPropertyCellUserObject(List<ECell> cells) {
        if (cells != null) {
            for (ECell cell : cells) {
                if (cell == null) continue;
                cell.setValue(null);
                cell.setUserObject("dimnum", "");
                cell.setUserObject("memnum", "");
                cell.setUserObject("typenum", "");
                cell.setUserObject("typename", "");
                cell.setUserObject("properytnum", "");
            }
        }
    }

    public static void resetPropertyCellUserObject(String dimNumber, List<ECell> cells) {
        if (cells != null && dimNumber != null) {
            for (ECell cell : cells) {
                if (cell == null || !dimNumber.equals(cell.getUserObject("dimnum"))) continue;
                cell.setValue(null);
                cell.setUserObject("dimnum", "");
                cell.setUserObject("memnum", "");
                cell.setUserObject("typenum", "");
                cell.setUserObject("typename", "");
                cell.setUserObject("properytnum", "");
            }
        }
    }

    public static void setPropertyCellUserObject(ECell propertyCell, String dimNum, String memNum, String typeNum, String typeName, String properytNum) {
        if (propertyCell == null) {
            return;
        }
        propertyCell.setUserObject("isproperty", "1");
        propertyCell.setUserObject("dimnum", dimNum);
        propertyCell.setUserObject("memnum", memNum);
        propertyCell.setUserObject("memname", propertyCell.getValue());
        propertyCell.setUserObject("typenum", typeNum);
        propertyCell.setUserObject("typename", typeName);
        propertyCell.setUserObject("properytnum", properytNum);
    }

    public static ECell createCell(ECell cell) {
        ECell eCell = new ECell();
        eCell.setRow(cell.getRow());
        eCell.setCol(cell.getCol());
        eCell.setValue(cell.getValue());
        if (cell.hasUserObject()) {
            eCell.setUserObject(cell.getUserObject());
        }
        return eCell;
    }

    public static Map<String, List<String>> getPropertyDimMap(List<List<ECell>> ecellLists) {
        HashMap result = new HashMap(16);
        String dimnum = "";
        String memnum = "";
        for (List<ECell> cellList : ecellLists) {
            if (cellList == null || cellList.size() == 0) continue;
            for (ECell cell : cellList) {
                Boolean isPropertyCell;
                if (cell == null || !(isPropertyCell = Boolean.valueOf(DimPropertyHelper.checkPropertyCell(cell))).booleanValue() || cell.getUserObject("dimnum") == null || cell.getUserObject("memnum") == null) continue;
                dimnum = cell.getUserObject("dimnum").toString();
                memnum = cell.getUserObject("memnum").toString();
                if (result.containsKey(dimnum)) {
                    ((Set)result.get(dimnum)).add(memnum);
                    continue;
                }
                HashSet<String> memList = new HashSet<String>();
                memList.add(memnum);
                result.put(dimnum, memList);
            }
        }
        Map<String, List<String>> resultMap = result.entrySet().stream().collect(Collectors.toMap(kv -> (String)kv.getKey(), kv -> ((Set)kv.getValue()).stream().collect(Collectors.toList())));
        return resultMap;
    }

    public static Map<String, Map<String, List<PropertyObj>>> getNewPropertyDimMap(Map<String, List<String>> dimMap, long modelId) {
        HashMap<String, Map<String, List<PropertyObj>>> propertyMap = new HashMap<String, Map<String, List<PropertyObj>>>(16);
        if (dimMap == null || dimMap.size() == 0) {
            return propertyMap;
        }
        for (Map.Entry<String, List<String>> kvPair : dimMap.entrySet()) {
            Map<String, List<PropertyObj>> memEntitys = DimPropertyHelper.queryMembersCustomProperties(kvPair.getValue(), modelId, kvPair.getKey());
            propertyMap.put(kvPair.getKey(), memEntitys);
        }
        return propertyMap;
    }

    public static List<ECell> getUpdatePropertyCells(List<List<ECell>> ecellLists, long modelId, int memberDisplayType) {
        Map<String, List<String>> dimMap = DimPropertyHelper.getPropertyDimMap(ecellLists);
        Map<String, Map<String, List<PropertyObj>>> propertyMap = DimPropertyHelper.getNewPropertyDimMap(dimMap, modelId);
        return DimPropertyHelper.getUpdatePropertyCells(ecellLists, propertyMap, memberDisplayType);
    }

    public static List<ECell> getUpdatePropertyCells(List<List<ECell>> ecellLists, Map<String, Map<String, List<PropertyObj>>> propertyMap, int memberDisplayType) {
        ArrayList<ECell> updateECells = new ArrayList<ECell>(16);
        String dimnum = "";
        String memnum = "";
        String typenum = "";
        String properytnum = "";
        for (List<ECell> cellList : ecellLists) {
            if (cellList == null || cellList.size() == 0) continue;
            for (ECell cell : cellList) {
                Boolean isPropertyCell;
                if (cell == null || !(isPropertyCell = Boolean.valueOf(DimPropertyHelper.checkPropertyCell(cell))).booleanValue() || DimPropertyHelper.checkUserObjectEmpty("dimnum", cell) || DimPropertyHelper.checkUserObjectEmpty("memnum", cell) || cell.getUserObject("typenum") == null) continue;
                dimnum = cell.getUserObject("dimnum").toString();
                PropertyMemObj newPropertyMemObj = DimPropertyHelper.getMatchPropertyObj(dimnum, memnum = cell.getUserObject("memnum").toString(), typenum = cell.getUserObject("typenum").toString(), properytnum = "", propertyMap);
                if (newPropertyMemObj != null) {
                    if (MemberDisplayTypeEnum.NUMBER.getIndex() == memberDisplayType) {
                        cell.setValue(typenum + "#" + newPropertyMemObj.getNumber());
                    } else if (MemberDisplayTypeEnum.SIMNAMENUMBER.getIndex() == memberDisplayType || MemberDisplayTypeEnum.NAMEANDNUMBER.getIndex() == memberDisplayType) {
                        cell.setValue(newPropertyMemObj.getName() + ":" + typenum + "#" + newPropertyMemObj.getNumber());
                    } else {
                        cell.setValue(newPropertyMemObj.getName());
                    }
                    DimPropertyHelper.setUserObjectValue("properytnum", newPropertyMemObj.getNumber(), cell);
                    updateECells.add(cell);
                    continue;
                }
                if (cell == null) continue;
                cell.setValue("");
                DimPropertyHelper.setUserObjectValue("properytnum", "", cell);
                updateECells.add(cell);
            }
        }
        return updateECells;
    }

    public static void setUserObjectValue(String key, Object value, ECell cell) {
        if (cell != null) {
            cell.setUserObject(key, value);
        }
    }

    public static boolean checkUserObjectEmpty(String key, ECell cell) {
        String value;
        boolean result = true;
        if (cell != null && cell.hasUserObject() && !org.apache.commons.lang.StringUtils.isEmpty((String)(value = (String)cell.getUserObject(key))) && !value.equalsIgnoreCase("null")) {
            result = false;
        }
        return result;
    }

    public static PropertyMemObj getMatchPropertyObj(String dimnum, String memnum, String typenum, String properytnum, Map<String, Map<String, List<PropertyObj>>> propertysMap) {
        PropertyMemObj propertyMem = null;
        if (propertysMap == null || !propertysMap.containsKey(dimnum) || !propertysMap.get(dimnum).containsKey(memnum)) {
            return propertyMem;
        }
        List<PropertyObj> propertys = propertysMap.get(dimnum).get(memnum);
        PropertyObj property = propertys.stream().filter(temProperty -> temProperty.getNumber().equals(typenum)).findAny().orElse(null);
        if (property != null) {
            propertyMem = !org.apache.commons.lang.StringUtils.isEmpty((String)properytnum) ? (PropertyMemObj)property.getPropertyValueEntries().stream().filter(temMem -> temMem.getNumber().equals(properytnum)).findAny().orElse(null) : (PropertyMemObj)property.getPropertyValueEntries().stream().findAny().orElse(null);
        }
        return propertyMem;
    }

    public static Map<String, Integer> getDimPosMap(List<IHeaderInfo> headerInfos) {
        LinkedHashMap<String, Integer> dimsIndex = new LinkedHashMap<String, Integer>(16);
        if (headerInfos != null) {
            for (int i = 0; i < headerInfos.size(); ++i) {
                IHeaderInfo headerInfo = headerInfos.get(i);
                if (headerInfo == null || !"Dimension".equals(headerInfo.getType())) continue;
                dimsIndex.put(headerInfo.getNumber(), i);
            }
        }
        return dimsIndex;
    }

    public static Map<String, Integer> getDimPropPosMap(String dimNumber, List<IHeaderInfo> headerInfos) {
        LinkedHashMap<String, Integer> dimsIndex = new LinkedHashMap<String, Integer>(16);
        if (dimNumber != null && headerInfos != null) {
            for (int i = 0; i < headerInfos.size(); ++i) {
                IHeaderInfo headerInfo = headerInfos.get(i);
                if (headerInfo == null || !"Property".equals(headerInfo.getType()) || !dimNumber.equals(headerInfo.getRefDimension())) continue;
                dimsIndex.put(headerInfo.getNumber(), i);
            }
        }
        return dimsIndex;
    }

    public static Map<String, Integer> getPropPosMap(List<IHeaderInfo> headerInfos) {
        LinkedHashMap<String, Integer> dimsIndex = new LinkedHashMap<String, Integer>(16);
        if (headerInfos != null) {
            for (int i = 0; i < headerInfos.size(); ++i) {
                IHeaderInfo headerInfo = headerInfos.get(i);
                if (headerInfo == null || !"Property".equals(headerInfo.getType())) continue;
                dimsIndex.put(headerInfo.getNumber(), i);
            }
        }
        return dimsIndex;
    }

    public static Map<String, Integer> getPropPosMap(List<IHeaderInfo> headerInfos, String dimNumber) {
        LinkedHashMap<String, Integer> dimsIndex = new LinkedHashMap<String, Integer>(16);
        if (headerInfos != null && dimNumber != null) {
            for (int i = 0; i < headerInfos.size(); ++i) {
                IHeaderInfo headerInfo = headerInfos.get(i);
                if (headerInfo == null || !"Property".equals(headerInfo.getType()) || !dimNumber.equals(headerInfo.getRefDimension())) continue;
                dimsIndex.put(headerInfo.getNumber(), i);
            }
        }
        return dimsIndex;
    }

    public static Boolean isFullDimCells(Map<String, Integer> dimPosMap, List<CellDimMember> dimMembers) {
        if (dimPosMap != null && dimMembers != null) {
            for (Map.Entry<String, Integer> dimPos : dimPosMap.entrySet()) {
                if (dimMembers.get(dimPos.getValue()) != null) continue;
                return false;
            }
        }
        return true;
    }

    public static String getDimNumByPos(MultiAreaManager multiAreaManager, int row, int col, Boolean isrow) {
        int relativeIndex;
        String dimNum = "";
        AreaInfo areaInfo = multiAreaManager.getAreaInfo(row, col);
        Map<Object, Object> dimPosMap = new LinkedHashMap();
        if (isrow.booleanValue()) {
            relativeIndex = areaInfo.getRelativecol();
            dimPosMap = DimPropertyHelper.getDimPosMap(multiAreaManager.getRowHeaders());
        } else {
            relativeIndex = areaInfo.getRelativerow();
            dimPosMap = DimPropertyHelper.getDimPosMap(multiAreaManager.getColHeaders());
        }
        Optional<String> dimOption = dimPosMap.entrySet().stream().filter(kv -> (Integer)kv.getValue() == relativeIndex).map(kv -> (String)kv.getKey()).findFirst();
        if (dimOption.isPresent()) {
            dimNum = dimOption.get();
        }
        return dimNum;
    }

    public static void setCellAbsPos(ECell cell, int row, int col) {
        cell.setRow(cell.getRow() + row);
        cell.setCol(cell.getCol() + col);
    }

    public static boolean checkPropertyCell(ECell cell) {
        Object _isProperty;
        boolean isProperty = false;
        if (cell != null && cell.hasUserObject() && (_isProperty = cell.getUserObject("isproperty")) != null) {
            isProperty = "1".equals(_isProperty);
        }
        return isProperty;
    }

    public static String getDimNumByPos(Map<String, Integer> dimPosMap, int pos) {
        String dim = "";
        if (dimPosMap == null || dimPosMap.size() == 0) {
            return dim;
        }
        ArrayList<Map.Entry<String, Integer>> list = new ArrayList<Map.Entry<String, Integer>>(dimPosMap.entrySet());
        list.sort(new Comparator<Map.Entry<String, Integer>>(){

            @Override
            public int compare(Map.Entry<String, Integer> o1, Map.Entry<String, Integer> o2) {
                return o1.getValue().compareTo(o2.getValue());
            }
        });
        String befDim = null;
        for (Map.Entry entry : list) {
            if ((Integer)entry.getValue() > pos) {
                return org.apache.commons.lang.StringUtils.isEmpty(befDim) ? (String)entry.getKey() : befDim;
            }
            befDim = (String)entry.getKey();
        }
        return befDim;
    }

    public static int getPropertyCount(Map<String, List<PropertyObj>> propertyMap, List<String> dims) {
        int count = 0;
        if (propertyMap == null || propertyMap.size() == 0) {
            return count;
        }
        for (String dim : dims) {
            if (propertyMap.get(dim) == null) continue;
            count += propertyMap.get(dim).size();
        }
        return count;
    }

    public static int getDimMapPos(Map<String, Integer> dimPosMap, String dim) {
        int result = 0;
        if (dimPosMap != null && dimPosMap.size() != 0) {
            for (Map.Entry<String, Integer> kvPair : dimPosMap.entrySet()) {
                if (dim.equals(kvPair.getKey())) break;
                ++result;
            }
        }
        return result;
    }

    public static Map<String, List<PropertyObj>> queryMembersCustomProperties(List<String> memberNumbers, long modelId, String dimensionNum) {
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>(16);
        if (memberNumbers.size() > 0) {
            QFBuilder qfBuilder = new QFBuilder("number", "in", memberNumbers);
            qfBuilder.add("model", "=", (Object)modelId);
            qfBuilder.add("dimension.number", "=", (Object)dimensionNum);
            String selectFileds = "number,propertyentry.propertyvalue";
            String memberKey = SysDimensionEnum.getMemberTreemodelByNumber((String)dimensionNum);
            Map objectDynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)memberKey, (String)selectFileds, (QFilter[])qfBuilder.toArray());
            for (Map.Entry objectDynamicObjectEntry : objectDynamicObjectMap.entrySet()) {
                DynamicObject object = (DynamicObject)objectDynamicObjectEntry.getValue();
                map.put(object.getString("number"), object);
            }
        }
        HashMap<String, List<PropertyObj>> properties = new HashMap<String, List<PropertyObj>>(memberNumbers.size());
        for (String number : memberNumbers) {
            DynamicObject object = (DynamicObject)map.get(String.valueOf(number));
            ArrayList<PropertyObj> list = new ArrayList<PropertyObj>(16);
            if (object != null) {
                if (!object.getDynamicObjectType().getProperties().containsKey((Object)"propertyentry")) continue;
                DynamicObjectCollection propertyentry = object.getDynamicObjectCollection("propertyentry");
                String propertyKey = "";
                ArrayList<String> propertyKeys = new ArrayList<String>(16);
                for (DynamicObject dynamicObject : propertyentry) {
                    DynamicObject propertyValue = dynamicObject.getDynamicObject("propertyvalue");
                    if (propertyValue == null) continue;
                    DynamicObject property = propertyValue.getDynamicObject("property");
                    PropertyObj propertyObj = new PropertyObj(Long.valueOf(property.getLong("id")), property.getString("name"), property.getString("number"));
                    ArrayList<PropertyMemObj> propertyValueEntries = new ArrayList<PropertyMemObj>(4);
                    propertyValueEntries.add(new PropertyMemObj(Long.valueOf(propertyValue.getLong("id")), propertyValue.getString("name"), propertyValue.getString("number"), 10));
                    propertyObj.setPropertyValueEntries(propertyValueEntries);
                    propertyKey = property.getLong("id") + "#" + property.getString("number");
                    if (propertyKeys.contains(propertyKey)) continue;
                    list.add(propertyObj);
                    propertyKeys.add(propertyKey);
                }
            }
            properties.put(number, list);
        }
        return properties;
    }

    public static int getDimAndPropPos(List<IHeaderInfo> headerInfos, String dimNumber, Map<String, Integer> propPosMap) {
        int curDimHeaderIndex = 0;
        if (headerInfos != null && dimNumber != null) {
            for (int i = 0; i < headerInfos.size(); ++i) {
                IHeaderInfo headerInfo = headerInfos.get(i);
                if (headerInfo == null) continue;
                if ("Dimension".equals(headerInfo.getType()) && dimNumber.equals(headerInfo.getNumber())) {
                    curDimHeaderIndex = i;
                    continue;
                }
                if (propPosMap == null || !"Property".equals(headerInfo.getType()) || !dimNumber.equals(headerInfo.getRefDimension())) continue;
                propPosMap.put(headerInfo.getNumber(), i);
            }
        }
        return curDimHeaderIndex;
    }

    public static String getPropertySign(String propertyNumber, String seq, String panelSign) {
        if (propertyNumber == null) {
            return "";
        }
        return "eb_customproperty" + propertyNumber.toLowerCase() + seq + panelSign;
    }

    public static String getFixPropertySign(String propertyNumber, String seq) {
        if (propertyNumber == null) {
            return "";
        }
        return "eb_customproperty_" + propertyNumber.toLowerCase() + "_" + seq;
    }

    public static String beforeDelPropertyByQuoteTemplate(String nodeId) {
        String msg = "";
        QFilter qFilter = new QFilter("entryentity.subentryentity.customproperty.id", "=", (Object)IDUtils.toLong((Object)nodeId));
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_dimproperty", (String)"template.number", (QFilter[])new QFilter[]{qFilter});
        if (query != null && !query.isEmpty()) {
            List collect = query.stream().map(e -> e.getString("template.number")).collect(Collectors.toList());
            String join = StringUtils.join(collect, (String)",");
            msg = ResManager.loadResFormat((String)"\u9009\u4e2d\u7684\u81ea\u5b9a\u4e49\u5c5e\u6027\u5df2\u88ab\u9884\u7b97\u6a21\u677f%1\u5f15\u7528\uff0c\u4e0d\u53ef\u5220\u9664\u3002", (String)"DimPropertyHelper_0", (String)"epm-eb-spread", (Object[])new Object[]{join});
        }
        return msg;
    }

    public static void checkPropertyIsExist(Long modelId, List<Map<String, String>> f7items) {
        if (CollectionUtils.isEmpty(f7items)) {
            return;
        }
        Set numberSet = f7items.stream().map(e -> (String)e.get("number")).collect(Collectors.toSet());
        QFBuilder builder = new QFBuilder();
        builder.add("model", "=", (Object)modelId);
        builder.add("number", "in", numberSet);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_customproperty", (String)"number", (QFilter[])builder.toArrays());
        if (query == null) {
            return;
        }
        Set existNumberSet = query.stream().map(e -> e.getString("number")).collect(Collectors.toSet());
        f7items.removeIf(e -> existNumberSet.contains(e.get("number")));
        if (CollectionUtils.isNotEmpty(f7items)) {
            Set delProNames = f7items.stream().map(e -> (String)e.get("name")).collect(Collectors.toSet());
            String join = StringUtils.join(delProNames, (String)",");
            throw new KDBizException(ResManager.loadResFormat((String)"\u81ea\u5b9a\u4e49\u5c5e\u6027%1\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u6a21\u677f\u3002", (String)"DimPropertyHelper_1", (String)"epm-eb-spread", (Object[])new Object[]{join}));
        }
    }
}

