/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.spread.utils;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.cache.propertycache.entity.MemberPropCache;
import kd.epm.eb.common.dao.formula.MemberCondition;
import kd.epm.eb.common.ebcommon.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.utils.DimensionViewServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.spread.control.ISpreadContainer;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.afix.multimanager.MultiAreaManager;
import kd.epm.eb.spread.template.afix.multisetting.IMultiAreaSetting;
import kd.epm.eb.spread.template.afix.multisetting.MultiAreaSetting;
import kd.epm.eb.spread.template.arearangedim.IRowColDimensionEntry;
import kd.epm.eb.spread.template.dimension.IDimension;
import kd.epm.eb.spread.template.dimension.IDimensionMember;
import kd.epm.eb.spread.template.dimension.PageViewDimMember;
import kd.epm.eb.spread.template.headerarea.IHeaderInfo;
import kd.epm.eb.spread.template.metric.IMetricDimMmeber;
import kd.epm.eb.spread.template.partition.IPartitionSetting;
import kd.epm.eb.spread.template.partition.RowColPartition;
import kd.epm.eb.spread.template.spreadmanager.CellDimMember;
import kd.epm.eb.spread.template.spreadmanager.IEbSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.sheet.ISheet;
import kd.epm.eb.spread.utils.DimPropertyHelper;
import kd.epm.eb.spread.utils.ReportVar.ReportVarUtil;
import org.apache.commons.collections4.CollectionUtils;

public class ReportDimFilterUtils {
    public static final Log log = LogFactory.getLog(ReportDimFilterUtils.class);

    public static Map<String, Set<Integer>> handleDynamicReportProcessFilterHidden(IEbSpreadManager spreadManager, List<Map<String, List<MemberCondition>>> filterMemberList, ISpreadContainer spreadContainer, String currentEntityNumber, List<String> templateFilterDims) {
        HashSet<Boolean> temp;
        boolean templateFilter;
        HashSet<Boolean> centrelViasbleSet;
        HashSet<Boolean> templateViasbleSet;
        ISheet sheet = spreadManager.getEbook().getSheet(0);
        int valueAreaRowStart = sheet.getValueAreaRowStart();
        int valueAreaColStart = sheet.getValueAreaColStart();
        int realMaxRows = sheet.getRealMaxRows();
        int realMaxCols = sheet.getRealMaxCols();
        List<String> row_dimnums = spreadManager.getRowpartitionDims();
        List<String> col_dimnums = spreadManager.getColpartitionDims();
        MemberPropCache memberPropCache = MemberPropCacheService.getOrCreate((Long)spreadManager.getModelobj().getId());
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)spreadManager.getModelobj().getId());
        ArrayList<Map<String, Set<String>>> filterMemberNumberList = new ArrayList<Map<String, Set<String>>>(filterMemberList.size());
        Long busModelid = spreadManager.getBusModelid();
        ReportDimFilterUtils.resolveFilterMember(filterMemberList, memberPropCache, modelCacheHelper, filterMemberNumberList, busModelid, currentEntityNumber);
        if (CollectionUtils.isEmpty(filterMemberNumberList)) {
            return new HashMap<String, Set<Integer>>(16);
        }
        HashSet<Integer> rowVisable = new HashSet<Integer>(16);
        HashSet<Integer> colVisable = new HashSet<Integer>(16);
        HashSet<Integer> allRow = new HashSet<Integer>(16);
        HashSet<Integer> allCol = new HashSet<Integer>(16);
        for (int i = valueAreaRowStart; i < realMaxRows; ++i) {
            allRow.add(i);
            List<CellDimMember> row_dimMembers = spreadManager.getRowpartitionDimMems().get(i);
            if (row_dimMembers == null || row_dimMembers.size() == 0) continue;
            templateViasbleSet = new HashSet<Boolean>(2);
            centrelViasbleSet = new HashSet<Boolean>(2);
            for (Map map : filterMemberNumberList) {
                if (map == null || map.size() == 0 || !CollectionUtils.containsAny(map.keySet(), row_dimnums)) continue;
                templateFilter = map.containsKey("templateFilter");
                temp = new HashSet<Boolean>(row_dimnums.size());
                int len = row_dimnums.size();
                for (int k = 0; k < len; ++k) {
                    String dimKey = row_dimnums.get(k);
                    CellDimMember cellDimMember = row_dimMembers.get(k);
                    if (cellDimMember == null) continue;
                    Set memberNumberSet = (Set)map.get(dimKey);
                    if (memberNumberSet != null) {
                        temp.add(memberNumberSet.contains(cellDimMember.getDimMemberNumber()));
                        continue;
                    }
                    if (map.containsKey(dimKey)) continue;
                }
                if (CollectionUtils.isEmpty(temp)) continue;
                if (templateFilter) {
                    templateViasbleSet.add(!temp.contains(false));
                    continue;
                }
                centrelViasbleSet.add(!temp.contains(false));
            }
            if (CollectionUtils.isNotEmpty(centrelViasbleSet) && CollectionUtils.isNotEmpty(templateViasbleSet)) {
                if (!centrelViasbleSet.contains(true) || !templateViasbleSet.contains(true)) continue;
                rowVisable.add(i);
                continue;
            }
            if (CollectionUtils.isNotEmpty(centrelViasbleSet)) {
                if (!centrelViasbleSet.contains(true)) continue;
                rowVisable.add(i);
                continue;
            }
            if (CollectionUtils.isNotEmpty(templateViasbleSet)) {
                if (!templateViasbleSet.contains(true)) continue;
                rowVisable.add(i);
                continue;
            }
            rowVisable.add(i);
        }
        for (int j = valueAreaColStart; j < realMaxCols; ++j) {
            allCol.add(j);
            List<CellDimMember> col_dimMembers = spreadManager.getColpartitionDimMems().get(j);
            if (col_dimMembers == null || col_dimMembers.size() == 0) continue;
            templateViasbleSet = new HashSet(2);
            centrelViasbleSet = new HashSet(2);
            for (Map map : filterMemberNumberList) {
                if (map == null || map.size() == 0 || !CollectionUtils.containsAny(map.keySet(), col_dimnums)) continue;
                templateFilter = map.containsKey("templateFilter");
                temp = new HashSet(col_dimnums.size());
                for (int i = 0; i < col_dimMembers.size(); ++i) {
                    String dimKey = col_dimnums.get(i);
                    CellDimMember cellDimMember = col_dimMembers.get(i);
                    if (cellDimMember == null) continue;
                    Set memberNumberSet = (Set)map.get(dimKey);
                    if (memberNumberSet != null) {
                        temp.add(memberNumberSet.contains(cellDimMember.getDimMemberNumber()));
                        continue;
                    }
                    if (map.containsKey(dimKey)) continue;
                }
                if (CollectionUtils.isEmpty(temp)) continue;
                if (templateFilter) {
                    templateViasbleSet.add(!temp.contains(false));
                    continue;
                }
                centrelViasbleSet.add(!temp.contains(false));
            }
            if (CollectionUtils.isNotEmpty(centrelViasbleSet) && CollectionUtils.isNotEmpty(templateViasbleSet)) {
                if (!centrelViasbleSet.contains(true) || !templateViasbleSet.contains(true)) continue;
                colVisable.add(j);
                continue;
            }
            if (CollectionUtils.isNotEmpty(centrelViasbleSet)) {
                if (!centrelViasbleSet.contains(true)) continue;
                colVisable.add(j);
                continue;
            }
            if (CollectionUtils.isNotEmpty(templateViasbleSet)) {
                if (!templateViasbleSet.contains(true)) continue;
                colVisable.add(j);
                continue;
            }
            colVisable.add(j);
        }
        allRow.removeAll(rowVisable);
        if (CollectionUtils.isNotEmpty(allRow)) {
            spreadContainer.setRowsVisible(new ArrayList<Integer>(allRow), false);
        }
        allCol.removeAll(colVisable);
        if (CollectionUtils.isNotEmpty(allCol)) {
            spreadContainer.setColumnsVisible(new ArrayList<Integer>(allCol), false);
        }
        HashMap<String, Set<Integer>> map = new HashMap<String, Set<Integer>>(2);
        map.put("row", allRow);
        map.put("col", allCol);
        return map;
    }

    public static void handleFixReportProcessFilterHidden(MultiAreaManager multiAreaManager, List<Map<String, Set<String>>> filterMemberNumberList, String areaOverLap, Map<String, Long> dimensionViews, int startIndex, Set<Integer> rowHidden, Set<Integer> colHidden) {
        if (CollectionUtils.isEmpty(filterMemberNumberList)) {
            return;
        }
        HashSet<Integer> tempRowHidden = new HashSet<Integer>(16);
        HashSet<Integer> tempColHidden = new HashSet<Integer>(16);
        MultiAreaManager.ValueArea valueRowColStart = multiAreaManager.getValueAreaStart();
        int row_start = valueRowColStart.getRow_start();
        int col_start = valueRowColStart.getCol_start();
        List<String> row_dimnums = multiAreaManager.getRowpartitionDims();
        List<String> col_dimnums = multiAreaManager.getColpartitionDims();
        int rowHeadDimsCount = row_dimnums.size();
        int colHeadDimsCount = col_dimnums.size();
        if (multiAreaManager.getDimPropertys() != null) {
            rowHeadDimsCount += DimPropertyHelper.getPropertyCount(multiAreaManager.getDimPropertys(), row_dimnums);
            colHeadDimsCount += DimPropertyHelper.getPropertyCount(multiAreaManager.getDimPropertys(), col_dimnums);
        }
        int rowSize = multiAreaManager.getRowpartitionDimMems().size();
        int colSize = multiAreaManager.getColpartitionDimMems().size();
        Map<String, PageViewDimMember> areaPageViewDims = multiAreaManager.getAreaPageViewDims();
        ArrayList<Map<String, Set<String>>> filterList = new ArrayList<Map<String, Set<String>>>(filterMemberNumberList);
        for (Map.Entry<String, PageViewDimMember> pageViewDimMemberEntry : areaPageViewDims.entrySet()) {
            for (Map<String, Set<String>> stringListMap : filterMemberNumberList) {
                for (Map.Entry<String, Set<String>> filterMap : stringListMap.entrySet()) {
                    if (pageViewDimMemberEntry.getKey().equals(filterMap.getKey()) && CollectionUtils.isNotEmpty((Collection)filterMap.getValue())) {
                        PageViewDimMember pageViewDimMember = pageViewDimMemberEntry.getValue();
                        Long viewId = DimensionViewServiceHelper.getViewId(dimensionViews, (String)filterMap.getKey(), (String)multiAreaManager.getAreaIndex());
                        Member member = multiAreaManager.getModelCacheHelper().getMember(filterMap.getKey(), viewId, pageViewDimMember.getNumber());
                        if (member == null || filterMap.getValue().contains(member.getNumber())) continue;
                        filterList.remove(stringListMap);
                        continue;
                    }
                    if (!pageViewDimMemberEntry.getKey().equals(filterMap.getKey()) || !CollectionUtils.isEmpty((Collection)filterMap.getValue())) continue;
                    filterList.remove(stringListMap);
                }
            }
        }
        log.info("filterList:{}", (Object)JSONObject.toJSONString(filterList));
        boolean onlyTemplateFilter = false;
        if (CollectionUtils.isNotEmpty(filterList)) {
            Optional<Map> templateFilter = filterList.stream().filter(x -> x.containsKey("templateFilter")).findFirst();
            if (templateFilter.isPresent()) {
                if (filterMemberNumberList.size() == 1) {
                    onlyTemplateFilter = true;
                } else if (filterList.size() > 1) {
                    onlyTemplateFilter = true;
                }
            } else {
                onlyTemplateFilter = true;
            }
        }
        if ((CollectionUtils.isEmpty(filterList) || !onlyTemplateFilter) && startIndex == 0) {
            log.info("hidden by areapageview");
            if ("col".equals(areaOverLap) || areaOverLap == null) {
                for (int x2 = multiAreaManager.getAreaRange().getY_start(); x2 <= multiAreaManager.getAreaRange().getY_end(); ++x2) {
                    tempRowHidden.add(x2);
                }
                rowHidden.addAll(tempRowHidden);
            } else {
                for (int j = multiAreaManager.getAreaRange().getX_start(); j <= multiAreaManager.getAreaRange().getX_end(); ++j) {
                    tempColHidden.add(j);
                }
                colHidden.addAll(tempColHidden);
            }
        } else {
            HashSet<Boolean> centrelViasbleSet;
            HashSet<Boolean> templateViasbleSet;
            HashSet<Integer> rowVisable = new HashSet<Integer>(16);
            HashSet<Integer> colVisable = new HashSet<Integer>(16);
            for (int i = startIndex; i <= multiAreaManager.getAreaRange().getY_end() + row_start + colHeadDimsCount; ++i) {
                int row;
                int n = row = multiAreaManager.getFloatonWhere() == 1 ? i - row_start - colHeadDimsCount : i - row_start;
                if (row < 0 || row > rowSize - 1) continue;
                int relativerow = multiAreaManager.getFloatonWhere() == 1 ? row + colHeadDimsCount : row;
                List<CellDimMember> row_dimMembers = multiAreaManager.getRowpartitionDimMems().get(row);
                if (row_dimMembers == null || row_dimMembers.size() == 0) continue;
                long rowDimCount = row_dimMembers.stream().filter(dimmem -> dimmem != null && StringUtils.isNotEmpty((String)dimmem.getDimMemberNumber()) && !dimmem.isProperty()).count();
                if ((long)row_dimnums.size() != rowDimCount) continue;
                tempRowHidden.add(relativerow + row_start);
                templateViasbleSet = new HashSet<Boolean>(2);
                centrelViasbleSet = new HashSet<Boolean>(2);
                for (Map map : filterList) {
                    if (map == null || map.size() == 0 || !CollectionUtils.containsAny(map.keySet(), row_dimnums)) continue;
                    boolean templateFilter = map.containsKey("templateFilter");
                    HashSet<Boolean> temp = new HashSet<Boolean>(row_dimnums.size());
                    int len = row_dimnums.size();
                    for (int k = 0; k < len; ++k) {
                        CellDimMember cellDimMember;
                        String dimKey = row_dimnums.get(k);
                        List<IHeaderInfo> rowHeaders = multiAreaManager.getRowHeaders();
                        int index = -1;
                        for (int i1 = 0; i1 < rowHeaders.size(); ++i1) {
                            IHeaderInfo iHeaderInfo = rowHeaders.get(i1);
                            if (!"Dimension".equals(iHeaderInfo.getType()) || !dimKey.equals(iHeaderInfo.getNumber())) continue;
                            index = i1;
                            break;
                        }
                        if ((cellDimMember = row_dimMembers.get(index)) == null) continue;
                        Set memberNumberSet = (Set)map.get(dimKey);
                        if (memberNumberSet != null) {
                            temp.add(memberNumberSet.contains(cellDimMember.getDimMemberNumber()));
                            continue;
                        }
                        if (map.containsKey(dimKey)) continue;
                    }
                    if (CollectionUtils.isEmpty(temp)) continue;
                    if (templateFilter) {
                        templateViasbleSet.add(!temp.contains(false));
                        continue;
                    }
                    centrelViasbleSet.add(!temp.contains(false));
                }
                if (CollectionUtils.isNotEmpty(centrelViasbleSet) && CollectionUtils.isNotEmpty(templateViasbleSet)) {
                    if (!centrelViasbleSet.contains(true) || !templateViasbleSet.contains(true)) continue;
                    rowVisable.add(relativerow + row_start);
                    continue;
                }
                if (CollectionUtils.isNotEmpty(centrelViasbleSet)) {
                    if (!centrelViasbleSet.contains(true)) continue;
                    rowVisable.add(relativerow + row_start);
                    continue;
                }
                if (CollectionUtils.isNotEmpty(templateViasbleSet)) {
                    if (!templateViasbleSet.contains(true)) continue;
                    rowVisable.add(relativerow + row_start);
                    continue;
                }
                rowVisable.add(relativerow + row_start);
            }
            tempRowHidden.removeAll(rowVisable);
            rowHidden.addAll(tempRowHidden);
            if (startIndex == 0) {
                Integer j = 0;
                while (j <= multiAreaManager.getAreaRange().getX_end() + col_start + rowHeadDimsCount) {
                    int col;
                    int n = col = multiAreaManager.getFloatonWhere() == 0 ? j - col_start - rowHeadDimsCount : j - col_start;
                    if (col >= 0 && col <= colSize - 1) {
                        List<CellDimMember> col_dimMembers;
                        int relativecol;
                        int n2 = relativecol = multiAreaManager.getFloatonWhere() == 0 ? col + rowHeadDimsCount : col;
                        if (!colHidden.contains(relativecol + col_start) && (col_dimMembers = multiAreaManager.getColpartitionDimMems().get(col)) != null && col_dimMembers.size() != 0) {
                            long colDimCount = col_dimMembers.stream().filter(dimmem -> dimmem != null && StringUtils.isNotEmpty((String)dimmem.getDimMemberNumber()) && !dimmem.isProperty()).count();
                            if ((long)col_dimnums.size() == colDimCount) {
                                tempColHidden.add(relativecol + col_start);
                                templateViasbleSet = new HashSet(2);
                                centrelViasbleSet = new HashSet(2);
                                for (Map map : filterList) {
                                    if (map == null || map.size() == 0 || !CollectionUtils.containsAny(map.keySet(), col_dimnums)) continue;
                                    HashSet<Boolean> temp = new HashSet<Boolean>(col_dimnums.size());
                                    boolean templateFilter = map.containsKey("templateFilter");
                                    for (int i = 0; i < col_dimMembers.size(); ++i) {
                                        CellDimMember cellDimMember;
                                        String dimKey = col_dimnums.get(i);
                                        List<IHeaderInfo> colHeaders = multiAreaManager.getColHeaders();
                                        int index = -1;
                                        for (int i1 = 0; i1 < colHeaders.size(); ++i1) {
                                            IHeaderInfo iHeaderInfo = colHeaders.get(i1);
                                            if (!"Dimension".equals(iHeaderInfo.getType()) || !dimKey.equals(iHeaderInfo.getNumber())) continue;
                                            index = i1;
                                            break;
                                        }
                                        if ((cellDimMember = col_dimMembers.get(index)) == null) continue;
                                        Set memberNumberSet = (Set)map.get(dimKey);
                                        if (memberNumberSet != null) {
                                            temp.add(memberNumberSet.contains(cellDimMember.getDimMemberNumber()));
                                            continue;
                                        }
                                        if (map.containsKey(dimKey)) continue;
                                    }
                                    if (CollectionUtils.isEmpty(temp)) continue;
                                    if (templateFilter) {
                                        templateViasbleSet.add(!temp.contains(false));
                                        continue;
                                    }
                                    centrelViasbleSet.add(!temp.contains(false));
                                }
                                if (CollectionUtils.isNotEmpty(centrelViasbleSet) && CollectionUtils.isNotEmpty(templateViasbleSet)) {
                                    if (centrelViasbleSet.contains(true) && templateViasbleSet.contains(true)) {
                                        colVisable.add(relativecol + col_start);
                                    }
                                } else if (CollectionUtils.isNotEmpty(centrelViasbleSet)) {
                                    if (centrelViasbleSet.contains(true)) {
                                        colVisable.add(relativecol + col_start);
                                    }
                                } else if (CollectionUtils.isNotEmpty(templateViasbleSet)) {
                                    if (templateViasbleSet.contains(true)) {
                                        colVisable.add(relativecol + col_start);
                                    }
                                } else {
                                    colVisable.add(relativecol + col_start);
                                }
                            }
                        }
                    }
                    Integer n3 = j;
                    Integer n4 = j = Integer.valueOf(j + 1);
                }
                tempColHidden.removeAll(colVisable);
                colHidden.addAll(tempColHidden);
            }
        }
    }

    public static void resolveFilterMember(List<Map<String, List<MemberCondition>>> filterMemberList, MemberPropCache memberPropCache, IModelCacheHelper modelCacheHelper, List<Map<String, Set<String>>> filterMemberNumberList, Long businessModelId, String currentEntityMember) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelCacheHelper.getModelobj().getId());
        qFilter.and("dimension.number", "=", (Object)SysDimensionEnum.Entity.getNumber());
        DynamicObjectCollection entityViewIdSet = QueryServiceHelper.query((String)"eb_dimensionview", (String)"id", (QFilter[])qFilter.toArray());
        for (Map<String, List<MemberCondition>> stringListMap : filterMemberList) {
            HashMap temp = new HashMap(16);
            for (Map.Entry<String, List<MemberCondition>> entry : stringListMap.entrySet()) {
                HashSet<Object> memberList = new HashSet<Object>(16);
                HashSet propMemberList = new HashSet(16);
                String key = entry.getKey();
                if (key.endsWith("$default")) {
                    key = key.replace("$default", "");
                    if (CollectionUtils.isNotEmpty((Collection)entry.getValue())) {
                        stringListMap.put("templateFilter", new ArrayList(16));
                        temp.put("templateFilter", new HashSet(16));
                    }
                }
                if (stringListMap.containsKey("templateFilter")) {
                    temp.put(key, new HashSet(16));
                }
                for (MemberCondition memberCondition : entry.getValue()) {
                    Set permMembNumbers = DimMembPermHelper.getPermMembNumbers((String)key, (Long)modelCacheHelper.getModelobj().getId(), (Long)businessModelId, (Long)IDUtils.toLong((Object)memberCondition.getViewId()), (DimMembPermType)DimMembPermType.READ, (boolean)true);
                    if (memberCondition.isProp()) {
                        List membersByPropValues1;
                        Dimension dimension = modelCacheHelper.getDimension(key);
                        if (dimension == null || CollectionUtils.isEmpty((Collection)(membersByPropValues1 = memberPropCache.getMembersByPropValues(dimension.getId(), IDUtils.toLong((Object)memberCondition.getViewId()), IDUtils.toLong((Object)memberCondition.getId()))))) continue;
                        Set membersByPropValues = membersByPropValues1.stream().map(x -> x.getNumber()).collect(Collectors.toSet());
                        if (CollectionUtils.isNotEmpty((Collection)permMembNumbers) && CollectionUtils.isNotEmpty(membersByPropValues)) {
                            membersByPropValues.retainAll(permMembNumbers);
                        }
                        if (CollectionUtils.isNotEmpty(membersByPropValues) && SysDimensionEnum.Entity.getNumber().equals(key) && StringUtils.isNotEmpty((String)currentEntityMember) && CollectionUtils.isNotEmpty((Collection)entityViewIdSet)) {
                            HashSet collect = new HashSet(16);
                            for (DynamicObject dynamicObject : entityViewIdSet) {
                                List member = modelCacheHelper.getMember(key, Long.valueOf(dynamicObject.getLong("id")), currentEntityMember, RangeEnum.VALUE_50.getValue());
                                if (!CollectionUtils.isNotEmpty((Collection)member)) continue;
                                collect.addAll(member.stream().map(x -> x.getNumber()).collect(Collectors.toSet()));
                            }
                            membersByPropValues.retainAll(collect);
                        }
                        if (!CollectionUtils.isNotEmpty(membersByPropValues)) continue;
                        propMemberList.addAll(membersByPropValues);
                        continue;
                    }
                    List member = modelCacheHelper.getMember(key, IDUtils.toLong((Object)memberCondition.getViewId()), memberCondition.getNumber(), Integer.parseInt(memberCondition.getRange()));
                    Set collect = member.stream().map(x -> x.getNumber()).collect(Collectors.toSet());
                    if (CollectionUtils.isNotEmpty((Collection)permMembNumbers) && CollectionUtils.isNotEmpty(collect)) {
                        collect.retainAll(permMembNumbers);
                    }
                    if (CollectionUtils.isEmpty(collect)) {
                        collect = member.stream().map(x -> x.getNumber()).collect(Collectors.toSet());
                    }
                    memberList.addAll(collect);
                }
                if (CollectionUtils.isNotEmpty(memberList) && CollectionUtils.isNotEmpty(propMemberList)) {
                    HashSet<Object> result = new HashSet<Object>(16);
                    result.addAll(memberList);
                    result.retainAll(propMemberList);
                    if (CollectionUtils.isEmpty(result)) {
                        memberList.addAll(propMemberList);
                    } else {
                        memberList = result;
                    }
                } else {
                    memberList.addAll(propMemberList);
                }
                if (!CollectionUtils.isNotEmpty(memberList)) continue;
                temp.put(key, memberList);
            }
            if (temp.containsKey("templateFilter") && temp.size() > 1) {
                filterMemberNumberList.add(temp);
                continue;
            }
            if (temp.size() <= 0) continue;
            filterMemberNumberList.add(temp);
        }
    }

    public static Set<String> getFilterMember(List<Map<String, List<MemberCondition>>> filterMemberList, MemberPropCache memberPropCache, IModelCacheHelper modelCacheHelper, String dimNumber, Long businessModelId, String currentEntityMember) {
        DynamicObjectCollection entityViewIdSet = new DynamicObjectCollection();
        if (dimNumber.equals(SysDimensionEnum.Entity.getNumber())) {
            QFilter qFilter = new QFilter("model", "=", (Object)modelCacheHelper.getModelobj().getId());
            qFilter.and("dimension.number", "=", (Object)SysDimensionEnum.Entity.getNumber());
            entityViewIdSet = QueryServiceHelper.query((String)"eb_dimensionview", (String)"id", (QFilter[])qFilter.toArray());
        }
        HashSet<String> memberSets = new HashSet<String>(16);
        for (Map<String, List<MemberCondition>> stringListMap : filterMemberList) {
            for (Map.Entry<String, List<MemberCondition>> entry : stringListMap.entrySet()) {
                String key = entry.getKey();
                HashSet memberList = new HashSet(16);
                HashSet propMemberList = new HashSet(16);
                if (key.endsWith("$default")) {
                    key = key.replace("$default", "");
                }
                if (!key.equals(dimNumber)) continue;
                for (MemberCondition memberCondition : entry.getValue()) {
                    Set permMembNumbers = DimMembPermHelper.getPermMembNumbers((String)key, (Long)modelCacheHelper.getModelobj().getId(), (Long)businessModelId, (Long)IDUtils.toLong((Object)memberCondition.getViewId()), (DimMembPermType)DimMembPermType.READ, (boolean)true);
                    if (memberCondition.isProp()) {
                        List membersByPropValues1;
                        Dimension dimension = modelCacheHelper.getDimension(key);
                        if (dimension == null || CollectionUtils.isEmpty((Collection)(membersByPropValues1 = memberPropCache.getMembersByPropValues(dimension.getId(), IDUtils.toLong((Object)memberCondition.getViewId()), IDUtils.toLong((Object)memberCondition.getId()))))) continue;
                        Set membersByPropValues = membersByPropValues1.stream().map(x -> x.getNumber()).collect(Collectors.toSet());
                        if (CollectionUtils.isNotEmpty((Collection)permMembNumbers) && CollectionUtils.isNotEmpty(membersByPropValues)) {
                            membersByPropValues.retainAll(permMembNumbers);
                        }
                        if (CollectionUtils.isNotEmpty(membersByPropValues) && SysDimensionEnum.Entity.getNumber().equals(key) && StringUtils.isNotEmpty((String)currentEntityMember) && CollectionUtils.isNotEmpty((Collection)entityViewIdSet)) {
                            HashSet collect = new HashSet(16);
                            for (DynamicObject dynamicObject : entityViewIdSet) {
                                List member = modelCacheHelper.getMember(key, Long.valueOf(dynamicObject.getLong("id")), currentEntityMember, RangeEnum.VALUE_50.getValue());
                                if (!CollectionUtils.isNotEmpty((Collection)member)) continue;
                                collect.addAll(member.stream().map(x -> x.getNumber()).collect(Collectors.toSet()));
                            }
                            membersByPropValues.retainAll(collect);
                        }
                        propMemberList.addAll(membersByPropValues);
                        continue;
                    }
                    List member = modelCacheHelper.getMember(key, IDUtils.toLong((Object)memberCondition.getViewId()), memberCondition.getNumber(), Integer.parseInt(memberCondition.getRange()));
                    Set collect = member.stream().map(x -> x.getNumber()).collect(Collectors.toSet());
                    if (CollectionUtils.isNotEmpty((Collection)permMembNumbers) && CollectionUtils.isNotEmpty(collect)) {
                        collect.retainAll(permMembNumbers);
                    }
                    if (CollectionUtils.isEmpty(collect)) {
                        collect = member.stream().map(x -> x.getNumber()).collect(Collectors.toSet());
                    }
                    memberList.addAll(collect);
                }
                boolean b = CollectionUtils.containsAny(memberList, propMemberList);
                if (b) {
                    memberSets.addAll(memberList);
                    memberSets.retainAll(propMemberList);
                    continue;
                }
                memberSets.addAll(memberList);
                memberSets.addAll(propMemberList);
            }
        }
        return memberSets;
    }

    public static List<MemberCondition> getDefaultFilterEntity(IModelCacheHelper modelCacheHelper, String currnetEntityNumber, ITemplateModel templateModel, Long orgViewId) {
        Member member = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), orgViewId, currnetEntityNumber);
        if (member != null) {
            MemberCondition memberCondition = new MemberCondition(member.getNumber(), member.getName(), "", RangeEnum.VALUE_50.getValue() + "");
            memberCondition.setId(member.getId() + "");
            memberCondition.setProp(Boolean.FALSE.booleanValue());
            memberCondition.setViewId(orgViewId + "");
            return Collections.singletonList(memberCondition);
        }
        return Collections.emptyList();
    }

    public static Map<String, List<MemberCondition>> getDefaultFilter(String filterMemberStr, IModelCacheHelper modelCacheHelper, String entityNumber, ITemplateModel templateModel, IPageCache pageCache, Long processId, Long orgViewId) {
        Map filterMember = new HashMap(16);
        if (CollectionUtils.isEmpty(templateModel.getFilterDims())) {
            pageCache.remove(processId + "filterMemberCache");
            return filterMember;
        }
        if (StringUtils.isNotEmpty((String)filterMemberStr)) {
            filterMember = (Map)ObjectSerialUtil.deSerializedBytes((String)filterMemberStr);
            if (filterMember != null && !filterMember.containsKey(SysDimensionEnum.Entity.getNumber()) && !filterMember.containsKey(SysDimensionEnum.Entity.getNumber() + "$default")) {
                List<MemberCondition> defaultFilterEntity;
                List<String> filterDims = templateModel.getFilterDims();
                if (CollectionUtils.isNotEmpty(filterDims) && filterDims.contains(SysDimensionEnum.Entity.getNumber()) && CollectionUtils.isNotEmpty(defaultFilterEntity = ReportDimFilterUtils.getDefaultFilterEntity(modelCacheHelper, entityNumber, templateModel, orgViewId))) {
                    filterMember.put((String)(SysDimensionEnum.Entity.getNumber() + "$default"), defaultFilterEntity);
                    pageCache.put(processId + "filterMemberCache", ObjectSerialUtil.toByteSerialized(filterMember));
                }
            } else if (filterMember == null) {
                filterMember = new HashMap(16);
            } else {
                List<String> filterDims = templateModel.getFilterDims();
                if (CollectionUtils.isEmpty(filterDims) || !filterDims.contains(SysDimensionEnum.Entity.getNumber())) {
                    filterMember.remove(SysDimensionEnum.Entity.getNumber() + "$default");
                }
            }
        } else {
            List<MemberCondition> defaultFilterEntity;
            List<String> filterDims = templateModel.getFilterDims();
            if (CollectionUtils.isNotEmpty(filterDims) && filterDims.contains(SysDimensionEnum.Entity.getNumber()) && CollectionUtils.isNotEmpty(defaultFilterEntity = ReportDimFilterUtils.getDefaultFilterEntity(modelCacheHelper, entityNumber, templateModel, orgViewId))) {
                filterMember.put((String)(SysDimensionEnum.Entity.getNumber() + "$default"), defaultFilterEntity);
                pageCache.put(processId + "filterMemberCache", ObjectSerialUtil.toByteSerialized(filterMember));
            }
        }
        filterMember.put((String)"templateFilter", new ArrayList(16));
        return filterMember;
    }

    public static Set<Long> getFilterId(Long viewId, String dimNumber, Map<String, Long> defaultDimMember, ITemplateModel templateModel, IEbSpreadManager spreadManager, Long processId, String processType) {
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)templateModel.getModelId());
        Set<Long> rowOrColMembers = ReportDimFilterUtils.getRowOrColMembers(dimNumber, templateModel, processId, processType, spreadManager);
        MemberPropCache memberPropCache = MemberPropCacheService.getOrCreate((Long)templateModel.getModelId());
        List propertyValuesByDim = memberPropCache.getPropertyValuesByDim(modelCacheHelper.getDimension(dimNumber).getId());
        if (CollectionUtils.isEmpty(rowOrColMembers) && CollectionUtils.isEmpty((Collection)propertyValuesByDim)) {
            return null;
        }
        if (SysDimensionEnum.Entity.getNumber().equals(dimNumber)) {
            rowOrColMembers = ReportDimFilterUtils.getEntityId(viewId, dimNumber, defaultDimMember, spreadManager, modelCacheHelper, rowOrColMembers);
        }
        rowOrColMembers.addAll(propertyValuesByDim.stream().map(x -> x.getId()).collect(Collectors.toSet()));
        if (CollectionUtils.isEmpty(rowOrColMembers)) {
            return null;
        }
        return rowOrColMembers;
    }

    public static Set<Long> getEntityId(Long viewId, String dimNumber, Map<String, Long> defaultDimMember, IEbSpreadManager spreadManager, IModelCacheHelper modelCacheHelper, Set<Long> rowOrColMembers) {
        if (defaultDimMember != null) {
            Long curOrgId = defaultDimMember.get(dimNumber);
            HashSet<Long> processMemberId = new HashSet<Long>(16);
            HashSet<Long> entityViewIdSet = new HashSet<Long>(16);
            entityViewIdSet.add(viewId);
            for (Map.Entry<String, Long> stringLongEntry : spreadManager.getDimemsionViews().entrySet()) {
                if (!stringLongEntry.getKey().equals(SysDimensionEnum.Entity.getNumber()) && !stringLongEntry.getKey().startsWith(SysDimensionEnum.Entity.getNumber() + "_") || stringLongEntry.getValue().equals(viewId)) continue;
                entityViewIdSet.add(stringLongEntry.getValue());
            }
            if (CollectionUtils.isNotEmpty(entityViewIdSet)) {
                for (Long aLong : entityViewIdSet) {
                    Member member1 = modelCacheHelper.getMember(dimNumber, aLong, curOrgId);
                    if (member1 == null) continue;
                    processMemberId.addAll(member1.getAllMembers().stream().map(x -> x.getId()).collect(Collectors.toSet()));
                }
            }
            rowOrColMembers = processMemberId;
        }
        return rowOrColMembers;
    }

    private static Set<Long> getRowOrColMembers(String dimNumber, ITemplateModel templateModel, Long processId, String processType, IEbSpreadManager spreadManager) {
        int templatetype = templateModel.getTemplateBaseInfo().getTemplatetype();
        Map<String, Map<String, String>> varValus = null;
        if (IDUtils.isNotNull((Long)processId)) {
            varValus = ReportVarUtil.getVarValues(processType, templateModel.getModelId(), processId, templateModel.getTemplateBaseInfo().getVarBase());
        }
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)templateModel.getModelId());
        LinkedHashSet<Long> members = new LinkedHashSet<Long>();
        if (templatetype == 1) {
            IPartitionSetting partitionSetting = templateModel.getPartitionSetting();
            ReportDimFilterUtils.getDynamicTemplateRowOrColMembers(dimNumber, templateModel, varValus, modelCacheHelper, members, partitionSetting.getRowPartition(), spreadManager, true);
            if (CollectionUtils.isNotEmpty(members)) {
                return members;
            }
            ReportDimFilterUtils.getDynamicTemplateRowOrColMembers(dimNumber, templateModel, varValus, modelCacheHelper, members, partitionSetting.getColPartition(), spreadManager, false);
            return members;
        }
        Map<String, Long> dimemsionViews = spreadManager.getDimemsionViews();
        for (MultiAreaManager multiAreaManager : spreadManager.getMultiAreaManager()) {
            Map<String, PageViewDimMember> areaPageViewDims;
            int i;
            List<IHeaderInfo> colHeaders = multiAreaManager.getColHeaders();
            List<IHeaderInfo> rowHeaders = multiAreaManager.getRowHeaders();
            int index = -1;
            Long viewId = DimensionViewServiceHelper.getViewId(dimemsionViews, (String)dimNumber, (String)multiAreaManager.getAreaIndex());
            if (dimemsionViews.containsKey(dimNumber + "_" + multiAreaManager.getAreaIndex())) {
                viewId = dimemsionViews.get(dimNumber + "_" + multiAreaManager.getAreaIndex());
            }
            for (i = 0; i < colHeaders.size(); ++i) {
                IHeaderInfo colDimNumber = colHeaders.get(i);
                if (!"Dimension".equals(colDimNumber.getType()) || !colDimNumber.getNumber().equals(dimNumber)) continue;
                index = i;
            }
            if (index != -1) {
                for (List<CellDimMember> colpartitionDimMem : multiAreaManager.getColpartitionDimMems()) {
                    if (colpartitionDimMem.size() <= index) continue;
                    CellDimMember cellDimMember = colpartitionDimMem.get(index);
                    String number = ReportVarUtil.getRealDimByVar(templateModel.getModelId(), cellDimMember.getDimMemberNumber(), dimNumber, varValus);
                    Member member = modelCacheHelper.getMember(dimNumber, viewId, number);
                    if (member == null) continue;
                    members.add(member.getId());
                }
            }
            index = -1;
            for (i = 0; i < rowHeaders.size(); ++i) {
                IHeaderInfo rowDimNumber = rowHeaders.get(i);
                if (!"Dimension".equals(rowDimNumber.getType()) || !rowDimNumber.getNumber().equals(dimNumber)) continue;
                index = i;
            }
            if (index != -1) {
                List<List<CellDimMember>> rowpartitionDimMems = multiAreaManager.getRowpartitionDimMems();
                for (int i2 = 0; i2 < rowpartitionDimMems.size(); ++i2) {
                    List<CellDimMember> cellDimMembers = rowpartitionDimMems.get(i2);
                    if (!CollectionUtils.isNotEmpty(cellDimMembers) || cellDimMembers.get(index) == null) continue;
                    CellDimMember cellDimMember = cellDimMembers.get(index);
                    String number = ReportVarUtil.getRealDimByVar(templateModel.getModelId(), cellDimMember.getDimMemberNumber(), dimNumber, varValus);
                    Member member = modelCacheHelper.getMember(dimNumber, viewId, number);
                    if (member == null) continue;
                    members.add(member.getId());
                }
                for (IMultiAreaSetting areaRange : templateModel.getAreaRanges()) {
                    if (!areaRange.getAreaRange().startsWith(multiAreaManager.getAreaIndex())) continue;
                    for (MultiAreaSetting.FloatInfo floatInfo : areaRange.getFloatInfos()) {
                        for (IRowColDimensionEntry rowColDimensionEntry : floatInfo.getPartition().getRowColDimensionEntries()) {
                            if (!rowColDimensionEntry.isFloat() || !rowColDimensionEntry.getDimension().getNumber().equals(dimNumber)) continue;
                            for (IDimensionMember member : rowColDimensionEntry.getMembers()) {
                                String number = ReportVarUtil.getRealDimByVar(templateModel.getModelId(), member.getNumber(), dimNumber, varValus);
                                int scope = RangeEnum.VALUE_50.getValue();
                                if (member.getScope() == RangeEnum.VALUE_60.getValue() || member.getScope() == RangeEnum.VALUE_70.getValue()) {
                                    scope = member.getScope();
                                }
                                List member1 = modelCacheHelper.getMember(dimNumber, viewId, number, scope);
                                members.addAll(member1.stream().map(x -> x.getId()).collect(Collectors.toSet()));
                            }
                        }
                    }
                }
            }
            if (!(areaPageViewDims = multiAreaManager.getAreaPageViewDims()).containsKey(dimNumber)) continue;
            PageViewDimMember pageViewDimMember = areaPageViewDims.get(dimNumber);
            String number = ReportVarUtil.getRealDimByVar(templateModel.getModelId(), pageViewDimMember.getNumber(), dimNumber, varValus);
            Member member = modelCacheHelper.getMember(dimNumber, viewId, number);
            if (member == null) continue;
            members.add(member.getId());
        }
        return members;
    }

    private static void getDynamicTemplateRowOrColMembers(String dimNumber, ITemplateModel templateModel, Map<String, Map<String, String>> varValus, IModelCacheHelper modelCacheHelper, Set<Long> members, List<RowColPartition> colPartition, IEbSpreadManager ebSpreadManager, boolean isRow) {
        int partIndex = 0;
        for (RowColPartition rowColPartition : colPartition) {
            String memNumber;
            for (IRowColDimensionEntry rowColDimensionEntry : rowColPartition.getRowColDimensionEntries()) {
                IDimension dimension = rowColDimensionEntry.getDimension();
                if (!dimension.getNumber().equals(dimNumber)) continue;
                String index = isRow ? "_r" : "_c";
                Long viewId = ebSpreadManager.getDimemsionViews().get(dimNumber + index + partIndex);
                for (IDimensionMember member : rowColDimensionEntry.getMembers()) {
                    memNumber = ReportVarUtil.getRealDimByVar(templateModel.getModelId(), member.getNumber(), dimNumber, varValus);
                    List cacheMems = modelCacheHelper.getMember(dimNumber, viewId, memNumber, member.getScope());
                    members.addAll(cacheMems.stream().map(x -> x.getId()).collect(Collectors.toSet()));
                }
            }
            ++partIndex;
            if (!dimNumber.equals(SysDimensionEnum.Metric.getNumber())) continue;
            for (IMetricDimMmeber metricDimMmeber : rowColPartition.getMetricDimMmebers()) {
                memNumber = ReportVarUtil.getRealDimByVar(templateModel.getModelId(), metricDimMmeber.getNumber(), dimNumber, varValus);
                Member member = modelCacheHelper.getMember(dimNumber, null, memNumber);
                members.add(member.getId());
            }
        }
    }

    public static boolean floatRowNeedHidden(MultiAreaSetting.FloatInfo floatInfo, List<Map<String, Set<String>>> templateFilter, ITemplateModel templateModel, Long processId, String processType, IEbSpreadManager spreadManager, String areaIndex) {
        List<IRowColDimensionEntry> rowColDimensionEntries = floatInfo.getPartition().getRowColDimensionEntries();
        if (CollectionUtils.isEmpty(rowColDimensionEntries)) {
            return Boolean.FALSE;
        }
        Map<String, Map<String, String>> varValus = null;
        if (IDUtils.isNotNull((Long)processId)) {
            varValus = ReportVarUtil.getVarValues(processType, templateModel.getModelId(), processId, templateModel.getTemplateBaseInfo().getVarBase());
        }
        Map<String, Long> dimemsionViews = spreadManager.getDimemsionViews();
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)templateModel.getModelId());
        HashSet<Boolean> needHidden = new HashSet<Boolean>(2);
        block0: for (Map<String, Set<String>> stringSetMap : templateFilter) {
            for (Map.Entry<String, Set<String>> stringSetEntry : stringSetMap.entrySet()) {
                if (stringSetEntry.getKey().equals("templateFilter")) continue;
                if (CollectionUtils.isEmpty((Collection)stringSetEntry.getValue())) {
                    IRowColDimensionEntry iRowColDimensionEntry = rowColDimensionEntries.stream().filter(x -> x.getDimension().getNumber().equals(stringSetEntry.getKey())).findFirst().orElse(null);
                    if (iRowColDimensionEntry == null) continue;
                    needHidden.add(Boolean.TRUE);
                    continue;
                }
                Long viewId = DimensionViewServiceHelper.getViewId(dimemsionViews, (String)stringSetEntry.getKey(), (String)areaIndex);
                if (dimemsionViews.containsKey(stringSetEntry.getKey() + "_" + areaIndex)) {
                    viewId = dimemsionViews.get(stringSetEntry.getKey() + "_" + areaIndex);
                }
                HashSet members = new HashSet(16);
                for (IRowColDimensionEntry rowColDimensionEntry : rowColDimensionEntries) {
                    if (!rowColDimensionEntry.getDimension().getNumber().equals(stringSetEntry.getKey())) continue;
                    for (IDimensionMember member : rowColDimensionEntry.getMembers()) {
                        String number = ReportVarUtil.getRealDimByVar(templateModel.getModelId(), member.getNumber(), stringSetEntry.getKey(), varValus);
                        int scope = member.getScope();
                        List member1 = modelCacheHelper.getMember(stringSetEntry.getKey(), viewId, number, scope);
                        members.addAll(member1.stream().map(x -> x.getNumber()).collect(Collectors.toSet()));
                    }
                }
                if (!CollectionUtils.isNotEmpty(members) || !Collections.disjoint((Collection)stringSetEntry.getValue(), members)) continue;
                needHidden.add(Boolean.TRUE);
                continue block0;
            }
        }
        return !needHidden.isEmpty() && needHidden.contains(Boolean.TRUE);
    }
}

