/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.spread.utils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.epm.eb.common.utils.ExcelUtils;
import kd.epm.eb.common.utils.Point;
import kd.epm.eb.spread.baseplugin.AbstractReportPlugin;
import kd.epm.eb.spread.control.ISpreadContainer;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.dimension.PageViewDimMember;
import kd.epm.eb.spread.template.spreadmanager.IEbSpreadManager;
import org.apache.commons.lang3.tuple.Triple;

public class ReportEditHelper {
    private final IFormView formView;
    private final IPageCache pageCache;
    private AbstractReportPlugin reportPlugin = null;

    public ReportEditHelper(IFormView formView) {
        FormViewPluginProxy proxy = (FormViewPluginProxy)formView.getService(FormViewPluginProxy.class);
        for (IFormPlugin plugin : proxy.getPlugIns()) {
            if (!(plugin instanceof AbstractReportPlugin)) continue;
            this.reportPlugin = (AbstractReportPlugin)plugin;
            break;
        }
        if (this.reportPlugin == null) {
            Method reportPluginMethod;
            Class<?> iBgTaskExecutePlugin;
            try {
                iBgTaskExecutePlugin = Class.forName("kd.epm.eb.formplugin.task.command.IBgTaskExecutePlugin");
                reportPluginMethod = iBgTaskExecutePlugin.getMethod("getReportProcessPlugin", new Class[0]);
            }
            catch (ClassNotFoundException | NoSuchMethodException e) {
                throw new KDBizException(e.getMessage());
            }
            this.reportPlugin = this.findReportPlugin(formView, iBgTaskExecutePlugin, reportPluginMethod);
            if (this.reportPlugin == null && formView.getParentView() != null) {
                this.reportPlugin = this.findReportPlugin(formView.getParentView(), iBgTaskExecutePlugin, reportPluginMethod);
            }
        }
        if (this.reportPlugin == null) {
            throw new KDBizException("Page or parent page not ReportEditPage.");
        }
        this.formView = this.reportPlugin.getView();
        this.pageCache = this.reportPlugin.getPageCache();
        this.reportPlugin.getSpreadManager();
        this.reportPlugin.getSpreadContainer();
        this.reportPlugin.getTemplateModel();
    }

    private AbstractReportPlugin findReportPlugin(IFormView formView, Class<?> iBgTaskExecutePlugin, Method reportPluginMethod) {
        FormViewPluginProxy proxy = (FormViewPluginProxy)formView.getService(FormViewPluginProxy.class);
        for (IFormPlugin plugin : proxy.getPlugIns()) {
            if (plugin instanceof AbstractReportPlugin) {
                return (AbstractReportPlugin)plugin;
            }
            if (!iBgTaskExecutePlugin.isAssignableFrom(plugin.getClass())) continue;
            try {
                return (AbstractReportPlugin)reportPluginMethod.invoke((Object)plugin, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new KDBizException(e.getMessage());
            }
        }
        return null;
    }

    public IFormView getFormView() {
        return this.formView;
    }

    public IPageCache getPageCache() {
        return this.pageCache;
    }

    public IEbSpreadManager getSpreadManager() {
        return this.reportPlugin.getSpreadManager();
    }

    public ITemplateModel getTemplateModel() {
        return this.reportPlugin.getTemplateModel();
    }

    public ISpreadContainer getSpreadContainer() {
        return this.reportPlugin.getSpreadContainer();
    }

    public void refreshModelCache() {
        this.reportPlugin.getModelCacheHelper(null, true);
    }

    public List<String> getPageDim() {
        ITemplateModel templateModel = this.getTemplateModel();
        return templateModel.getPagemembentry().stream().map(p -> p.getDimension().getNumber()).collect(Collectors.toList());
    }

    public Map<String, String> getPageViewMember() {
        IEbSpreadManager spreadManager = this.getSpreadManager();
        HashMap<String, String> pageMemberMap = new HashMap<String, String>(16);
        for (Map.Entry<String, PageViewDimMember> pageViewDim : spreadManager.getPageViewDims().entrySet()) {
            pageMemberMap.put(pageViewDim.getKey(), pageViewDim.getValue().getNumber());
        }
        return pageMemberMap;
    }

    public Map<String, Long> getPageViewView() {
        IEbSpreadManager spreadManager = this.getSpreadManager();
        HashMap<String, Long> pageViewMap = new HashMap<String, Long>(16);
        for (Map.Entry<String, PageViewDimMember> pageViewDim : spreadManager.getPageViewDims().entrySet()) {
            String dimNum = pageViewDim.getKey();
            pageViewMap.put(dimNum, spreadManager.getDimemsionViews().get(dimNum));
        }
        return pageViewMap;
    }

    public Map<String, String> getMemberMapByCell(int row, int col) {
        String pos = ExcelUtils.xy2Pos((int)col, (int)row);
        return this.getMemberMapByCell(pos);
    }

    public Map<String, String> getMemberMapByCell(String pos) {
        Point point = ExcelUtils.pos2Point((String)pos);
        return this.reportPlugin.getAllDimMembNumByCell(point);
    }

    public List<Map<String, String>> getMemberMapByRange(List<String> posList) {
        return this.reportPlugin.getAllDimMemNumByRange(posList);
    }

    public Map<String, Long> getDimensionViewByCell(int row, int col) {
        String pos = ExcelUtils.xy2Pos((int)col, (int)row);
        return this.getDimensionViewByCell(pos);
    }

    public Map<String, Long> getDimensionViewByCell(String pos) {
        return this.reportPlugin.getDimensionViewByPos(pos);
    }

    public Triple<Map<String, Long>, Map<String, Map<String, Long>>, Map<String, Map<String, Long>>> getDimensionViewByRange(List<String> posList) {
        return this.reportPlugin.getDimensionViewByRange(posList);
    }

    public boolean existsMultiView(Map<String, Map<String, Long>> viewRangeMap) {
        HashMap<String, Long> viewMap = new HashMap<String, Long>(16);
        for (Map<String, Long> viewRange : viewRangeMap.values()) {
            Set<Map.Entry<String, Long>> entrySet = viewRange.entrySet();
            for (Map.Entry<String, Long> entry : entrySet) {
                String key = entry.getKey();
                Long value = entry.getValue();
                Long viewId = (Long)viewMap.get(key);
                if (viewId == null) {
                    viewMap.put(key, value);
                    continue;
                }
                if (viewId.longValue() == value.longValue()) continue;
                return true;
            }
        }
        return false;
    }

    public List<String> getSelectedRange() {
        return this.reportPlugin.getSpreadSelector().getRangePosition();
    }

    public void showTipNotification(String tips) {
        this.formView.showTipNotification(tips);
    }
}

