/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.spread.utils.ReportVar;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.applybill.SchemeAssignDimGroup;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.ProcessTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.base.JsonUtils;
import kd.epm.eb.spread.utils.ReportVar.TemplateDataVarType;
import kd.epm.eb.spread.utils.ReportVar.TemplateVarCommonUtil;
import kd.epm.eb.spread.utils.ReportVar.VarException;
import org.apache.commons.collections4.CollectionUtils;

public class ReportVarUtil {
    private static Log log = LogFactory.getLog(ReportVarUtil.class);

    public static String getRealDimByVar(Long modelid, String varNumber, String varDimenstion, Map<String, Map<String, String>> varValues) {
        String returnStr = varNumber;
        if (!TemplateVarCommonUtil.checkIsVar(varNumber, varDimenstion).booleanValue()) {
            return returnStr;
        }
        if (varValues == null) {
            return returnStr;
        }
        Map<String, String> varValueMap = varValues.get(varDimenstion);
        String msg = ResManager.loadResFormat((String)"\u62a5\u8868\u4e0a\u8bbe\u7f6e\u7684%1\u7ef4\u5ea6\u53d8\u91cf%2\u6ca1\u6709\u8bbe\u7f6e\u503c\uff0c\u8bf7\u5728\u4efb\u52a1\u3001\u65b9\u6848\u6216\u7ec4\u4ef6\u4e2d\u8bbe\u7f6e\u3002", (String)"ReportVarUtil_0", (String)"epm-eb-spread", (Object[])new Object[]{varDimenstion, varNumber});
        if (varValueMap == null || varNumber == null) {
            log.warn("\u53d8\u91cf\u914d\u7f6e\u503cvarValues:" + JsonUtils.getJsonString(varValues) + ",varValueMap:" + JsonUtils.getJsonString(varValueMap) + "varNumber:" + varNumber);
            throw new VarException(msg);
        }
        returnStr = ReportVarUtil.getVarValue(modelid, varNumber, varValueMap, varDimenstion, msg);
        if (returnStr.contains("!")) {
            returnStr = returnStr.split("!")[1];
            throw new VarException(returnStr);
        }
        return returnStr;
    }

    public static Set<String> getRealDimByVar(Long modelid, String varNumber, String varDimenstion, Map<String, Map<String, Set<String>>> varValues, String msg) {
        Set<String> returnStr = new HashSet<String>(16);
        if (!TemplateVarCommonUtil.checkIsVar(varNumber, varDimenstion).booleanValue()) {
            returnStr.add(varNumber);
            return returnStr;
        }
        if (varValues == null) {
            returnStr.add(varNumber);
            return returnStr;
        }
        Map<String, Set<String>> varValueMap = varValues.get(varDimenstion);
        if (varValues == null || varValueMap == null || varNumber == null) {
            throw new VarException(String.format(msg, varDimenstion, varNumber));
        }
        returnStr = ReportVarUtil.getVarValueByRule(modelid, varNumber, varValueMap, varDimenstion, msg);
        return returnStr;
    }

    public static Map<String, Map<String, String>> getVarValues(String processType, Long modelId, Long processId, String varFlagStr) {
        log.info("\u67e5\u8be2\u65b9\u6848\u6216\u4efb\u52a1\u53d8\u91cf\u914d\u7f6e\u4f20\u53c2:{processType:" + processType + ",modelId:" + modelId + ",processId:" + processId + ",varFlagStr" + varFlagStr);
        if (ProcessTypeEnum.REPORT.getNumber().equals(processType)) {
            return ReportVarUtil.getVarValueFromRptSchemeAssign(modelId, processId, varFlagStr);
        }
        if (ProcessTypeEnum.ANALYSIS.getNumber().equals(processType)) {
            return ReportVarUtil.getVarValueFromAnalysisCanvas(processId);
        }
        return ReportVarUtil.getVarValueFromTask(modelId, processId, varFlagStr);
    }

    public static Map<String, Map<String, String>> getVarValues(Integer processType, Long modelId, Long taskListId) {
        if (ProcessTypeEnum.REPORT.getIndex() == processType.intValue()) {
            return ReportVarUtil.getVarValueFromRptSchemeAssign(modelId, taskListId, "1");
        }
        if (ProcessTypeEnum.TASK.getIndex() == processType.intValue()) {
            return ReportVarUtil.getVarValueFromTaskList(modelId, Collections.singletonList(taskListId));
        }
        return null;
    }

    public static Map<String, Map<String, String>> getVarInfo(SchemeAssignDimGroup schemeAssignDimGroup) {
        Long schemeAssignRecordId = ReportVarUtil.querySchemeAssign(schemeAssignDimGroup.getModelId(), schemeAssignDimGroup.getDataTypeId(), schemeAssignDimGroup.getVersionId(), schemeAssignDimGroup.getYearId(), schemeAssignDimGroup.getSchemeId());
        return ReportVarUtil.getVarValues(ProcessTypeEnum.REPORT.getNumber(), schemeAssignDimGroup.getModelId(), schemeAssignRecordId, "1");
    }

    public static Long querySchemeAssign(Long modelId, Long dataTypeId, Long versionId, Long yearPeriodId, Long schemeId) {
        QFilter qFilter = new QFilter("scheme", "=", (Object)schemeId).and("model", "=", (Object)modelId).and("year", "=", (Object)yearPeriodId).and("datatype", "=", (Object)dataTypeId).and("version", "=", (Object)versionId);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"eb_schemeassign", (String)"id", (QFilter[])qFilter.toArray());
        if (dynamicObject == null) {
            return 0L;
        }
        return dynamicObject.getLong("id");
    }

    public static Map<String, Map<String, Set<String>>> getVarValuesByRule(Integer processType, Long modelId) {
        if (ProcessTypeEnum.RULE.getIndex() == processType.intValue()) {
            return ReportVarUtil.getVarValueFromRuleList(modelId, "1");
        }
        return null;
    }

    public static Map<String, Map<String, String>> getVarValueByTaskList(Long modelId, Long taskListId, Long templateId) {
        return ReportVarUtil.getVarValueFromTaskList(modelId, Collections.singletonList(taskListId));
    }

    private static String getRelFirstSubTaskName(Long taskListId, Long templateId) {
        String sql = "select distinct b.fname from t_eb_taskreftemplate a,t_eb_task_l b where a.fid = b.fid and b.fid in (select fid from t_eb_task where ftasklistid =  ? )and a.ftemplateid = ? ;";
        try (DataSet ds = DB.queryDataSet((String)"getRelFirstSubTaskName", (DBRoute)DBRoute.of((String)"epm"), (String)sql, (Object[])new Object[]{taskListId, templateId});){
            if (ds != null && ds.hasNext()) {
                Row row = ds.next();
                String string = row.getString("fname");
                return string;
            }
        }
        return "";
    }

    private static String getTaskPackName(Long taskListId) {
        String sql = "select fname from t_eb_tasklist_l where fid = ?;";
        try (DataSet ds = DB.queryDataSet((String)"getRelSubTaskNames", (DBRoute)DBRoute.of((String)"epm"), (String)sql, (Object[])new Object[]{taskListId});){
            if (ds != null && ds.hasNext()) {
                Row row = ds.next();
                String string = row.getString("fname");
                return string;
            }
        }
        return "";
    }

    private static String getSchemeName(Long schemeId) {
        DynamicObject object = QueryServiceHelper.queryOne((String)"eb_rptscheme", (String)"name", (QFilter[])new QFilter("id", "=", (Object)schemeId).toArray());
        if (object != null) {
            return object.getString("name");
        }
        return "";
    }

    @Deprecated
    public static Map<String, Map<String, String>> getVarValuesByScheme(Long modelId, Long schemeId) {
        Map<String, Map<String, String>> varValueFromRptScheme = ReportVarUtil.getVarValueFromRptScheme(modelId, schemeId);
        HashMap<String, String> schemeInfo = new HashMap<String, String>(3);
        schemeInfo.put("schemeId", String.valueOf(schemeId));
        schemeInfo.put("schemeName", ReportVarUtil.getSchemeName(schemeId));
        varValueFromRptScheme.put("schemeInfo!", schemeInfo);
        return varValueFromRptScheme;
    }

    private static Map<String, Map<String, String>> getVarValueFromRptSchemeAssign(Long modelId, Long schemeAssignId, String varFlagStr) {
        Map<String, Map<String, String>> stringMapMap1;
        if (!TemplateVarCommonUtil.checkIsVar("isNeedVar", "").booleanValue()) {
            return null;
        }
        if (varFlagStr == null || !varFlagStr.equals("1")) {
            return null;
        }
        if (schemeAssignId == null) {
            return null;
        }
        QFilter qFilter = new QFilter("id", "=", (Object)schemeAssignId);
        Map<Long, Map<String, Map<String, String>>> stringMapMap = ReportVarUtil.queryVarValue("eb_schemeassign", qFilter, true);
        if (stringMapMap != null && !stringMapMap.isEmpty() && (stringMapMap1 = stringMapMap.get(schemeAssignId)) != null && !stringMapMap1.isEmpty()) {
            return stringMapMap1;
        }
        DynamicObject schemeAssign = BusinessDataServiceHelper.loadSingleFromCache((Object)schemeAssignId, (String)"eb_schemeassign", (String)"scheme.id");
        if (schemeAssign == null) {
            return new HashMap<String, Map<String, String>>(16);
        }
        return ReportVarUtil.getVarValueFromRptScheme(modelId, schemeAssign.getLong("scheme.id"));
    }

    @Deprecated
    public static Map<String, Map<String, String>> getVarValueFromRptScheme(Long modelId, Long schemeId) {
        return ReportVarUtil.getVarValueFromRptScheme(modelId, schemeId, true);
    }

    @Deprecated
    public static Map<String, Map<String, String>> getVarValueFromRptScheme(Long modelId, Long schemeId, boolean joinVarNameAndNum) {
        String formID = "eb_rptscheme";
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and(new QFilter("id", "=", (Object)schemeId));
        Map<Long, Map<String, Map<String, String>>> longMapMap = ReportVarUtil.queryVarValue(formID, qFilter, joinVarNameAndNum);
        if (longMapMap == null) {
            return null;
        }
        return longMapMap.get(schemeId);
    }

    private static Map<Long, Map<String, Map<String, String>>> queryVarValue(String formID, QFilter qFilter, boolean joinVarNameAndNum) {
        HashMap<Long, Map<String, Map<String, String>>> returnMap = new HashMap<Long, Map<String, Map<String, String>>>(16);
        String selectFields1 = "entryentity3.dimension.number,entryentity3.variablenumber.number,entryentity3.variablenumber.name,entryentity3.variablejson, dimension, variablenumber";
        Map objectDynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)formID, (String)selectFields1, (QFilter[])qFilter.toArray());
        for (Map.Entry entry : objectDynamicObjectMap.entrySet()) {
            Map map = returnMap.computeIfAbsent((Long)entry.getKey(), v -> new HashMap(16));
            DynamicObject dataRow = (DynamicObject)entry.getValue();
            DynamicObjectCollection entryentity3 = dataRow.getDynamicObjectCollection("entryentity3");
            for (DynamicObject dynamicObject : entryentity3) {
                String json = dynamicObject.getString("variablejson");
                String dimNum = dynamicObject.getDynamicObject("dimension").getString("number");
                String varNum = dynamicObject.getDynamicObject("variablenumber").getString("number");
                String varName = dynamicObject.getDynamicObject("variablenumber").getString("name");
                Map valueMap = (Map)SerializationUtils.fromJsonString((String)json, Map.class);
                String varInfo = joinVarNameAndNum ? varNum + "!" + varName : varNum;
                ReportVarUtil.putValue2Map(map, dimNum, varInfo, valueMap.get("number").toString());
            }
        }
        return returnMap;
    }

    public static Map<String, Map<String, String>> getVarValueFromAnalysisCanvas(Long itemId) {
        QFilter qFilter = new QFilter("itemid", "=", (Object)itemId);
        DynamicObjectCollection dataList = QueryServiceHelper.query((String)"eb_analysiscanvas_var", (String)"id, canvasid, itemid, dimension, variable, variablejson", (QFilter[])qFilter.toArray());
        if (dataList.isEmpty()) {
            return null;
        }
        HashMap<String, Map<String, String>> returnMap = new HashMap<String, Map<String, String>>(16);
        dataList.forEach(var -> {
            Map valueMap = (Map)SerializationUtils.fromJsonString((String)var.getString("variablejson"), Map.class);
            ReportVarUtil.putValue2Map(returnMap, var.getString("dimension"), var.getString("variable") + "! ", valueMap.get("number").toString());
        });
        return returnMap;
    }

    public static Map<Long, Map<String, Map<String, String>>> queryAllVarValueByScheme(Set<Long> schemeIds, boolean joinVarNameAndNum) {
        if (!TemplateVarCommonUtil.checkIsVar("isNeedVar", "").booleanValue()) {
            return null;
        }
        if (schemeIds == null || schemeIds.isEmpty()) {
            return null;
        }
        QFilter qFilter = new QFilter("scheme.id", "in", schemeIds);
        return ReportVarUtil.queryVarValue("eb_schemeassign", qFilter, joinVarNameAndNum);
    }

    public static Map<String, Map<String, String>> getVarValueFromTask(Long modelId, Long taskProcessId, String varFlagStr) {
        if (!TemplateVarCommonUtil.checkIsVar("isNeedVar", "").booleanValue()) {
            return null;
        }
        if (varFlagStr == null || !varFlagStr.equals("1")) {
            return null;
        }
        Collection<Long> taskListIds = ReportVarUtil.getTaskListFromTaskProcess(modelId, taskProcessId);
        return ReportVarUtil.getVarValueFromTaskList(modelId, taskListIds);
    }

    public static Map<String, Map<String, String>> getVarValueFromTaskList(Long modelId, Collection<Long> taskListIds) {
        if (taskListIds == null || taskListIds.isEmpty()) {
            return new HashMap<String, Map<String, String>>(16);
        }
        String selectFields = "entryentity.dimension.number as dimension,entryentity.variablenumber.number as varnumber,entryentity.variablenumber.name as varname,entryentity.variablejson as variablejson";
        String formID = "eb_tasklist";
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and(new QFilter("id", "in", taskListIds));
        HashMap<String, Map<String, String>> returnMap = new HashMap<String, Map<String, String>>(16);
        try (DataSet dataset = QueryServiceHelper.queryDataSet((String)"ReportVarUtil", (String)formID, (String)selectFields, (QFilter[])qFilter.toArray(), null);){
            if (dataset != null) {
                while (dataset.hasNext()) {
                    Row dataRow = dataset.next();
                    String json = dataRow.getString("variablejson");
                    if (json == null || json.isEmpty()) continue;
                    Map valueMap = (Map)SerializationUtils.fromJsonString((String)json, Map.class);
                    String varNumberName = dataRow.getString("varnumber") + "!" + dataRow.getString("varname");
                    ReportVarUtil.putValue2Map(returnMap, dataRow.getString("dimension"), varNumberName, valueMap.get("number").toString());
                }
            }
        }
        return returnMap;
    }

    public static Map<String, Map<String, Set<String>>> getVarValueFromRuleList(Long modelId, String type) {
        String selectFields = "entryentity.dimension.number as dimension,entryentity.variablenumber.number as varnumber,entryentity.variablenumber.name as varname,entryentity.variablejson as variablejson";
        String formID = "eb_rule_varible";
        QFilter qFilter = new QFilter("model", "=", (Object)modelId).and("type", "=", (Object)type);
        HashMap<String, Map<String, Set<String>>> returnMap = new HashMap<String, Map<String, Set<String>>>(16);
        try (DataSet dataset = QueryServiceHelper.queryDataSet((String)"ReportVarUtil", (String)formID, (String)selectFields, (QFilter[])qFilter.toArray(), null);){
            if (dataset != null) {
                while (dataset.hasNext()) {
                    Row dataRow = dataset.next();
                    String json = dataRow.getString("variablejson");
                    if (json == null || json.isEmpty()) continue;
                    String varNumberName = dataRow.getString("varnumber") + "!" + dataRow.getString("varname");
                    List valueMap = (List)SerializationUtils.fromJsonString((String)json, List.class);
                    for (Map map : valueMap) {
                        ReportVarUtil.putValue2MapByRule(returnMap, dataRow.getString("dimension"), varNumberName, map.get("number").toString());
                    }
                }
            }
        }
        return returnMap;
    }

    private static String getMatchVarValue(String var, Map<String, String> varValueMap) {
        for (Map.Entry<String, String> entry : varValueMap.entrySet()) {
            String varNumberName = entry.getKey();
            String[] varSingleNumberName = varNumberName.split("!");
            if (varSingleNumberName == null || !var.equalsIgnoreCase(varSingleNumberName[0])) continue;
            return varNumberName;
        }
        return "";
    }

    private static String getMatchVarValueByRule(String var, Map<String, Set<String>> varValueMap) {
        for (Map.Entry<String, Set<String>> entry : varValueMap.entrySet()) {
            String varNumberName = entry.getKey();
            String[] varSingleNumberName = varNumberName.split("!");
            if (varSingleNumberName == null || !var.equalsIgnoreCase(varSingleNumberName[0])) continue;
            return varNumberName;
        }
        return "";
    }

    private static String getErrInfo(String dimension, String var, String msg) {
        return "error!" + msg;
    }

    private static String getVarValue(Long modelid, String number, Map<String, String> varValueMap, String dimension, String msg) {
        String[] str;
        if (varValueMap == null || varValueMap.size() == 0) {
            return ReportVarUtil.getErrInfo(dimension, number, msg);
        }
        String returnStr = null;
        String num = number;
        if (number.indexOf("+") > 0) {
            str = number.split("[+]");
            num = str[0].trim();
        }
        if (number.indexOf("-") > 0) {
            str = number.split("-");
            num = str[0].trim();
        }
        if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dimension) && (number.startsWith("@NextY") || number.startsWith("@BaseY") || number.startsWith("@LastY"))) {
            returnStr = ReportVarUtil.getRealNumber(dimension, number, varValueMap, modelid, msg);
            if (returnStr.contains("!")) {
                return returnStr;
            }
            returnStr = ReportVarUtil.getOff(modelid, returnStr);
        } else {
            String varNumberName = ReportVarUtil.getMatchVarValue(num, varValueMap);
            if (varNumberName == null) {
                return ReportVarUtil.getErrInfo(dimension, num, msg);
            }
            String[] varSingleNumberName = varNumberName.split("!");
            if (varSingleNumberName == null) {
                return ReportVarUtil.getErrInfo(dimension, num, msg);
            }
            String varValue = varValueMap.get(varNumberName);
            if (varValue == null) {
                return ReportVarUtil.getErrInfo(dimension, num, msg);
            }
            String fomulaStr = number.replace(varSingleNumberName[0], varValue);
            returnStr = SysDimensionEnum.BudgetPeriod.getNumber().equals(dimension) ? ReportVarUtil.getOff(modelid, fomulaStr) : fomulaStr;
            if (returnStr.equalsIgnoreCase("error")) {
                return "error!" + String.format(ResManager.loadKDString((String)"\u53d8\u91cf%1$s\u8bbe\u7f6e\u7684\u503c%2$s\u504f\u79fb\u4e3a[%3$s]\u540e\u4e0d\u5728\u9884\u7b97\u671f\u95f4\u5185\uff0c\u8bf7\u8c03\u6574\u3002", (String)"ReportVarUtil_2", (String)"epm-eb-spread", (Object[])new Object[0]), varSingleNumberName[0], varValue, fomulaStr);
            }
        }
        return returnStr;
    }

    private static Set<String> getVarValueByRule(Long modelid, String number, Map<String, Set<String>> varValueMap, String dimension, String msg) {
        String[] str;
        if (varValueMap == null || varValueMap.size() == 0) {
            throw new VarException(msg);
        }
        Set<String> returnStr = null;
        String num = number;
        if (number.indexOf("+") > 0) {
            str = number.split("[+]");
            num = str[0].trim();
        }
        if (number.indexOf("-") > 0) {
            str = number.split("-");
            num = str[0].trim();
        }
        if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dimension) && (number.startsWith("@NextY") || number.startsWith("@BaseY") || number.startsWith("@LastY"))) {
            returnStr = ReportVarUtil.getRealNumberByRule(dimension, number, varValueMap, modelid, msg);
        }
        return returnStr;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getRealNumber(String dimension, String number, Map<String, String> varValueMap, Long modelId, String msg) {
        String varNumberName = ReportVarUtil.getMatchVarValue("@BaseY", varValueMap);
        String[] varSingleNumberName = varNumberName.split("!");
        if (varSingleNumberName == null) {
            return ReportVarUtil.getErrInfo(dimension, number, msg);
        }
        String base = varValueMap.get(varNumberName);
        if (StringUtils.isEmpty((String)base)) {
            return ReportVarUtil.getErrInfo(dimension, number, msg);
        }
        String realNumber = null;
        IModelCacheHelper modelcache = ModelCacheContext.getOrCreate((Long)modelId);
        if (number.startsWith("@BaseY")) {
            String[] split = number.split("\\.");
            if (split == null) return base;
            if (split.length == 0) return base;
            if (split.length == 1) {
                return base;
            }
            if (split.length != 2) throw new VarException(ResManager.loadResFormat((String)"\u7ef4\u5ea6\uff1a%1\u4e0b\u53d8\u91cf\uff1a%2\u4e0d\u5b58\u5728\u3002", (String)"ReportVarUtil_5", (String)"epm-eb-spread", (Object[])new Object[]{dimension, number}));
            String suffix = split[1];
            return base + "." + suffix;
        }
        if (!number.startsWith("@NextY") && !number.startsWith("@LastY")) throw new VarException(ResManager.loadResFormat((String)"\u7ef4\u5ea6\uff1a%1\u4e0b\u53d8\u91cf\uff1a%2\u4e0d\u5b58\u5728\u3002", (String)"ReportVarUtil_5", (String)"epm-eb-spread", (Object[])new Object[]{dimension, number}));
        String[] split = number.split("\\.");
        String splitNumber = "";
        splitNumber = split.length == 0 ? number : split[0];
        int offset = kd.epm.eb.common.var.ReportVarUtil.queryVariableOffSet((Long)modelId, (String)SysDimensionEnum.BudgetPeriod.getNumber(), (String)splitNumber);
        Member memberOffset = modelcache.getMemberOffset(dimension, base, offset);
        if (memberOffset == null) {
            throw new VarException(String.format(ResManager.loadKDString((String)"\u53d8\u91cf\u201c%1$s\u201d\u57fa\u4e8e\u57fa\u51c6\u503c\u201c%2$s\u201d\u504f\u79fb\u4e3a\u201c%3$s\u201c\u540e\u4e0d\u5728\u9884\u7b97\u671f\u95f4\u5185\uff0c\u8bf7\u8c03\u6574\u3002", (String)"ReportVarUtil_7", (String)"epm-eb-spread", (Object[])new Object[0]), number, base, offset));
        }
        if (split.length < 2) return memberOffset.getNumber();
        return memberOffset.getNumber() + "." + split[1];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Set<String> getRealNumberByRule(String dimension, String number, Map<String, Set<String>> varValueMap, Long modelId, String msg) {
        String varNumberName = ReportVarUtil.getMatchVarValueByRule("@BaseY", varValueMap);
        String[] varSingleNumberName = varNumberName.split("!");
        if (varSingleNumberName == null) {
            throw new VarException(msg);
        }
        Set<String> baseNum = varValueMap.get(varNumberName);
        if (CollectionUtils.isEmpty(baseNum)) {
            throw new VarException(msg);
        }
        HashSet<String> realNumers = new HashSet<String>(baseNum.size());
        for (String base : baseNum) {
            String[] split;
            String realNumber = null;
            IModelCacheHelper modelcache = ModelCacheContext.getOrCreate((Long)modelId);
            if (number.startsWith("@BaseY")) {
                split = number.split("\\.");
                if (split.length == 0 || split.length == 1) {
                    realNumber = base;
                } else {
                    if (split.length != 2) throw new VarException(ResManager.loadResFormat((String)"\u7ef4\u5ea6\uff1a%1\u4e0b\u53d8\u91cf\uff1a%2\u4e0d\u5b58\u5728\u3002", (String)"ReportVarUtil_5", (String)"epm-eb-spread", (Object[])new Object[]{dimension, number}));
                    String suffix = split[1];
                    realNumber = base + "." + suffix;
                }
            } else {
                if (!number.startsWith("@NextY") && !number.startsWith("@LastY")) throw new VarException(ResManager.loadResFormat((String)"\u7ef4\u5ea6\uff1a%1\u4e0b\u53d8\u91cf\uff1a%2\u4e0d\u5b58\u5728\u3002", (String)"ReportVarUtil_5", (String)"epm-eb-spread", (Object[])new Object[]{dimension, number}));
                split = number.split("\\.");
                String splitNumber = "";
                splitNumber = split.length == 0 ? number : split[0];
                DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"eb_periodvariable", (String)"offset", (QFilter[])new QFilter("model", "=", (Object)modelId).and("dimension.number", "=", (Object)SysDimensionEnum.BudgetPeriod.getNumber()).and("number", "=", (Object)splitNumber).toArray());
                if (dynamicObject == null) {
                    throw new VarException(ResManager.loadResFormat((String)"\u7ef4\u5ea6\uff1a%1,\u53d8\u91cf\uff1a%2\u4e0d\u5b58\u5728,\u8bf7\u68c0\u67e5\u53d8\u91cf\u3002", (String)"ReportVarUtil_6", (String)"epm-eb-spread", (Object[])new Object[]{dimension, number}));
                }
                int offset = dynamicObject.getInt("offset");
                Member memberOffset = modelcache.getMemberOffset(dimension, base, offset);
                if (memberOffset == null) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53d8\u91cf\u201c%1$s\u201d\u57fa\u4e8e\u57fa\u51c6\u503c\u201c%2$s\u201d\u504f\u79fb\u4e3a\u201c%3$s\u201c\u540e\u4e0d\u5728\u9884\u7b97\u671f\u95f4\u5185\uff0c\u8bf7\u8c03\u6574\u3002", (String)"ReportVarUtil_7", (String)"epm-eb-spread", (Object[])new Object[0]), number, base, offset));
                }
                realNumber = split.length >= 2 ? memberOffset.getNumber() + "." + split[1] : memberOffset.getNumber();
            }
            realNumers.add(realNumber);
        }
        return realNumers;
    }

    private static String getOff(Long modelid, String number) {
        String[] str;
        String returnstr = number;
        if (number.indexOf("+") > 0) {
            str = number.split("[+]");
            returnstr = TemplateVarCommonUtil.getOff(str[0].trim(), Integer.parseInt(str[1].trim()), modelid);
        }
        if (number.indexOf("-") > 0) {
            str = number.split("-");
            returnstr = TemplateVarCommonUtil.getOff(str[0].trim(), Integer.parseInt("-" + str[1].trim()), modelid);
        }
        return returnstr;
    }

    private static void putValue2Map(Map<String, Map<String, String>> returnMap, String dimension, String varNumber, String valueNumber) {
        if (returnMap == null) {
            return;
        }
        Map<String, String> varValue = returnMap.get(dimension);
        if (varValue == null) {
            varValue = new HashMap<String, String>(16);
            varValue.put(varNumber, valueNumber);
            returnMap.put(dimension, varValue);
        } else {
            varValue.put(varNumber, valueNumber);
        }
    }

    public static void putValue2MapByRule(Map<String, Map<String, Set<String>>> returnMap, String dimension, String varNumber, String valueNumber) {
        if (returnMap == null) {
            return;
        }
        Map<String, Set<String>> varValue = returnMap.get(dimension);
        if (varValue == null) {
            varValue = new HashMap<String, Set<String>>(16);
            HashSet<String> var = new HashSet<String>(16);
            var.add(valueNumber);
            varValue.put(varNumber, var);
            returnMap.put(dimension, varValue);
        } else {
            Set<String> var = varValue.get(varNumber);
            if (var == null) {
                var = new HashSet<String>(16);
            }
            var.add(valueNumber);
            varValue.put(varNumber, var);
        }
    }

    private static Collection<Long> getTaskListFromQFilter(QFilter qFilter) {
        ArrayList<Long> taskLists = new ArrayList<Long>(16);
        String formID = "eb_taskprocess";
        String selectFields = "task.id,task.number,task.name,task.tasklist.id as tasklistid,task.tasklist.number as tasklistnumber";
        try (DataSet dataset = QueryServiceHelper.queryDataSet((String)"ReportVarUtil", (String)formID, (String)selectFields, (QFilter[])qFilter.toArray(), null);){
            if (dataset != null) {
                while (dataset.hasNext()) {
                    Row dataRow = dataset.next();
                    taskLists.add(dataRow.getLong("tasklistid"));
                }
            }
        }
        return taskLists;
    }

    private static Collection<Long> getTemplateFromQFilter(QFilter qFilter) {
        ArrayList<Long> templateLists = new ArrayList<Long>(16);
        String formID = "eb_taskprocess";
        String selectFields = "template.id,template.number,template.name,task.tasklist.id as tasklistid,task.tasklist.number as tasklistnumber";
        try (DataSet dataset = QueryServiceHelper.queryDataSet((String)"ReportVarUtil", (String)formID, (String)selectFields, (QFilter[])qFilter.toArray(), null);){
            if (dataset != null) {
                while (dataset.hasNext()) {
                    Row dataRow = dataset.next();
                    templateLists.add(dataRow.getLong("template.id"));
                }
            }
        }
        return templateLists;
    }

    private static Collection<Long> getTemplateFromTaskList(Long modelId, Long taskListId) {
        QFilter qFilter = new QFilter("task.tasklist.id", "=", (Object)taskListId);
        return ReportVarUtil.getTemplateFromQFilter(qFilter);
    }

    public static Collection<Long> getTaskListFromTaskProcess(Long modelId, Long taskProcessId) {
        QFilter qFilter = new QFilter("id", "=", (Object)taskProcessId);
        return ReportVarUtil.getTaskListFromQFilter(qFilter);
    }

    public static Collection<String> getNoValiadPeriodVar(Long modelId, String tempName, List<String> fomulaVar, Map<String, String> yearVarValues) {
        if (fomulaVar == null || fomulaVar.size() == 0 || yearVarValues == null || yearVarValues.size() == 0) {
            return null;
        }
        ArrayList<String> returns = new ArrayList<String>();
        for (String fomula : fomulaVar) {
            String msg = ResManager.loadResFormat((String)"\u62a5\u8868\u4e0a\u8bbe\u7f6e\u7684%1\u7ef4\u5ea6\u53d8\u91cf%2\u6ca1\u6709\u8bbe\u7f6e\u503c\uff0c\u8bf7\u5728\u4efb\u52a1\u6216\u65b9\u6848\u4e2d\u8bbe\u7f6e\u3002", (String)"ReportVarUtil_4", (String)"epm-eb-spread", (Object[])new Object[]{SysDimensionEnum.BudgetPeriod.getNumber(), fomula});
            String info = ReportVarUtil.getVarValue(modelId, fomula, yearVarValues, SysDimensionEnum.BudgetPeriod.getNumber(), msg);
            if (!info.contains("!")) continue;
            returns.add(ResManager.loadResFormat((String)"\u6a21\u677f\uff1a%1 \u4e0a%2", (String)"ReportVarUtil_3", (String)"epm-eb-spread", (Object[])new Object[]{tempName, info.split("!")[1]}));
        }
        return returns;
    }

    public static List<String> checkYearVarHasFomula(Map<String, List<String>> templateVarDim) {
        if (templateVarDim == null) {
            return null;
        }
        List<String> varFomula = templateVarDim.get(SysDimensionEnum.BudgetPeriod.getNumber());
        if (varFomula == null || varFomula.size() == 0) {
            return null;
        }
        ArrayList<String> returns = new ArrayList<String>(16);
        for (String fomula : varFomula) {
            if (fomula.indexOf("+") <= 0 && fomula.indexOf("-") <= 0) continue;
            returns.add(fomula);
        }
        return returns;
    }

    public static Collection<String> checkYearVarValidBySchemeVarValus(Long modelId, List<Long> templates, Map<String, Map<String, String>> varValues) {
        if (varValues == null) {
            return null;
        }
        Map<String, String> yearVarValues = varValues.get(SysDimensionEnum.BudgetPeriod.getNumber());
        if (yearVarValues == null) {
            return null;
        }
        Map<Long, TemplateDataVarType> tempVars = TemplateVarCommonUtil.getTempDataVarTypeInfo(modelId, templates);
        if (tempVars == null) {
            return null;
        }
        ArrayList<String> returns = new ArrayList<String>();
        HashMap<String, List<String>> templateVarDim = null;
        for (Map.Entry<Long, TemplateDataVarType> entry : tempVars.entrySet()) {
            TemplateDataVarType tempVarInfo = entry.getValue();
            if (!tempVarInfo.getIsVar().booleanValue()) continue;
            templateVarDim = new HashMap<String, List<String>>(16);
            TemplateVarCommonUtil.getVarDimFromTemplateData(tempVarInfo.getData(), templateVarDim, false);
            List<String> fomulaVar = ReportVarUtil.checkYearVarHasFomula(templateVarDim);
            if (fomulaVar == null || fomulaVar.size() == 0) {
                return null;
            }
            returns.addAll(ReportVarUtil.getNoValiadPeriodVar(modelId, tempVarInfo.getName(), fomulaVar, yearVarValues));
        }
        return returns;
    }

    public static Collection<String> checkYearVarValidByTaskVarValus(Long modelId, Long taskList, Map<String, Map<String, String>> varValues) {
        if (varValues == null) {
            return null;
        }
        Map<String, String> yearVarValues = varValues.get(SysDimensionEnum.BudgetPeriod.getNumber());
        if (yearVarValues == null) {
            return null;
        }
        Collection<Long> templates = ReportVarUtil.getTemplateFromTaskList(modelId, taskList);
        if (templates == null || templates.size() == 0) {
            return null;
        }
        Map<Long, TemplateDataVarType> tempVars = TemplateVarCommonUtil.getTempDataVarTypeInfo(modelId, templates);
        if (tempVars == null) {
            return null;
        }
        ArrayList<String> returns = new ArrayList<String>();
        HashMap<String, List<String>> templateVarDim = null;
        for (Map.Entry<Long, TemplateDataVarType> entry : tempVars.entrySet()) {
            TemplateDataVarType tempVarInfo = entry.getValue();
            if (!tempVarInfo.getIsVar().booleanValue()) continue;
            templateVarDim = new HashMap<String, List<String>>(16);
            TemplateVarCommonUtil.getVarDimFromTemplateData(tempVarInfo.getData(), templateVarDim, false);
            List<String> fomulaVar = ReportVarUtil.checkYearVarHasFomula(templateVarDim);
            if (fomulaVar == null || fomulaVar.size() == 0) {
                return null;
            }
            returns.addAll(ReportVarUtil.getNoValiadPeriodVar(modelId, tempVarInfo.getName(), fomulaVar, yearVarValues));
        }
        return returns;
    }

    public static Collection<String> checkYearVarValidByTaskList(Long modelId, Long taskList) {
        ArrayList<Long> taskListCol = new ArrayList<Long>(1);
        taskListCol.add(taskList);
        Map<String, Map<String, String>> varValues = ReportVarUtil.getVarValueFromTaskList(modelId, taskListCol);
        return ReportVarUtil.checkYearVarValidByTaskVarValus(modelId, taskList, varValues);
    }
}

