/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.spread.utils.ReportVar;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.applyTemplate.TempDimConfig;
import kd.epm.eb.common.applyTemplate.TempDimConfigType;
import kd.epm.eb.common.applyTemplate.entity.tableconfig.BizTableConfig;
import kd.epm.eb.common.applytemplatecolumn.CalculateColumn;
import kd.epm.eb.common.applytemplatecolumn.ColumnList;
import kd.epm.eb.common.applytemplatecolumn.DataMapDimension;
import kd.epm.eb.common.applytemplatecolumn.DimensionColumn;
import kd.epm.eb.common.applytemplatecolumn.DimensionDataColumn;
import kd.epm.eb.common.applytemplatecolumn.DimensionMemberRange;
import kd.epm.eb.common.applytemplatecolumn.MeasureColumn;
import kd.epm.eb.common.applytemplatecolumn.RelationValueColumn;
import kd.epm.eb.common.applytemplatecolumn.RowDimensionColumn;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.enums.memberQuote.MemberTypeEnum;
import kd.epm.eb.common.model.Member;
import kd.epm.eb.common.model.Pair;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.TemplateModelJSONUtil;
import kd.epm.eb.spread.utils.ReportVar.Template;
import kd.epm.eb.spread.utils.ReportVar.TemplateDataVarType;
import kd.epm.eb.spread.utils.ReportVar.TemplateVarUtil;
import org.apache.commons.collections4.CollectionUtils;

public class TemplateVarCommonUtil {
    public static final String ISNEEDVAR = "isNeedVar";
    public static final String VARROOTID = "11";
    public static final String PARENT_ID = "parentid";
    public static final String SINGLE_VAR_ID = "22";
    public static final String MULTI_VAR_ID = "33";
    public static final String ONLY_SINGLE = "onlySingle";
    public static final String ONLY_MULTI_VAR = "onlyMultiVar";
    public static final String SPLIT = "!";
    public static final String VIRTRULROOT = "virtrulRoot";
    public static final String ERRINFOFLAG = "error";
    public static final String VARTEMPLATE = "1";
    public static final String VARPREF = "@";
    private static final String LOGPROF = "varReplace:";

    public static void doLog(String info, Log log) {
        log.info(LOGPROF + info);
    }

    public static Boolean checkIsVar(String dimDetail, String dimKey) {
        if (dimDetail == null || dimDetail.isEmpty()) {
            return false;
        }
        if (dimDetail.equalsIgnoreCase(ISNEEDVAR)) {
            return true;
        }
        if (dimDetail.contains("+") || dimDetail.contains("-")) {
            return SysDimensionEnum.BudgetPeriod.getNumber().equals(dimKey);
        }
        return dimDetail.startsWith(VARPREF);
    }

    public static String getVarbaseforeb(Map<String, Collection<String>> dimScope) {
        if (!TemplateVarCommonUtil.checkIsVar(ISNEEDVAR, "").booleanValue()) {
            return "0";
        }
        return TemplateVarCommonUtil.isIncloudeVar(dimScope) != false ? VARTEMPLATE : "0";
    }

    public static Map<Long, Map<String, List<String>>> getVarDimFromTemplateIds(List<Long> templateIds) {
        if (!TemplateVarCommonUtil.checkIsVar(ISNEEDVAR, "").booleanValue()) {
            return null;
        }
        if (templateIds == null || templateIds.size() == 0) {
            return null;
        }
        HashMap<Long, Map<String, List<String>>> returnMap = new HashMap<Long, Map<String, List<String>>>(16);
        String selectFields = "id, number,model, name, data, templatetype, dataset, varbaseforeb, templatecatalog ";
        QFilter qFilter = new QFilter("id", "in", templateIds);
        String formID = "eb_templateentity";
        Long model = 0L;
        HashMap<Long, Set> dataSetAndTemplateMap = new HashMap<Long, Set>(16);
        DataSet dataset = QueryServiceHelper.queryDataSet((String)"TemplateVarCommonUtil", (String)formID, (String)selectFields, (QFilter[])qFilter.toArray(), null);
        Object object = null;
        try {
            if (dataset != null) {
                while (dataset.hasNext()) {
                    Row dataRow = dataset.next();
                    String string = dataRow.getString("data");
                    if (StringUtils.isEmpty((CharSequence)string) || !string.contains(VARPREF)) continue;
                    if (IDUtils.isNull((Long)model)) {
                        model = dataRow.getLong("model");
                    }
                    Set set = dataSetAndTemplateMap.computeIfAbsent(dataRow.getLong("dataset"), k -> new HashSet(16));
                    set.add(dataRow.getLong("id"));
                }
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (dataset != null) {
                if (object != null) {
                    try {
                        dataset.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    dataset.close();
                }
            }
        }
        if (!dataSetAndTemplateMap.isEmpty() && IDUtils.isNotNull((Long)model)) {
            Map varMap = null;
            for (Map.Entry entry : dataSetAndTemplateMap.entrySet()) {
                HashSet<Long> templateId = new HashSet<Long>(16);
                varMap = returnMap.computeIfAbsent((Long)entry.getKey(), (Function<Long, Map<String, List<String>>>)((Function<Long, Map>)k -> new HashMap()));
                if (CollectionUtils.isEmpty((Collection)((Collection)entry.getValue()))) continue;
                templateId.addAll((Collection)entry.getValue());
                TemplateVarCommonUtil.queryQuoteInfo(model, varMap, templateId);
            }
        }
        return returnMap;
    }

    private static void queryQuoteInfo(Long model, Map<String, List<String>> varMap, Set<Long> templateId) {
        if (CollectionUtils.isNotEmpty(templateId) && varMap != null) {
            SqlBuilder sql = new SqlBuilder();
            sql.append("select  fdimensionid  ,fmemberid from  t_eb_memberquote tem  where tem .ftype  = ? ", new Object[]{MemberTypeEnum.VARIABLE.getType()});
            sql.append(" and tem.fid in ( select tem2.fquoteid from t_eb_memberquoteentry tem2 where ", new Object[0]);
            sql.appendIn(" tem2.fsourceid ", (Object[])templateId.toArray(new Long[0]));
            sql.append(")", new Object[0]);
            HashSet<Long> memberIds = new HashSet<Long>(16);
            try (DataSet ds = DB.queryDataSet((String)"queryTemplateVarQuote", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
                while (ds.hasNext()) {
                    Row next = ds.next();
                    memberIds.add(next.getLong("fmemberid"));
                }
            }
            if (CollectionUtils.isNotEmpty(memberIds)) {
                QFilter qFilter1 = new QFilter("model", "=", (Object)model);
                qFilter1.and("id", "in", memberIds);
                DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_periodvariable", (String)"dimension.number,number", (QFilter[])new QFilter[]{qFilter1});
                for (DynamicObject dynamicObject : query) {
                    List list = varMap.computeIfAbsent(dynamicObject.getString("dimension.number"), k -> new ArrayList(16));
                    if (list.contains(dynamicObject.getString("number"))) continue;
                    list.add(dynamicObject.getString("number"));
                }
            }
        }
    }

    public static Map<Long, Map<String, Set<String>>> getVarDimByApplyTempIds(Set<Long> templateIds) {
        if (templateIds == null || templateIds.size() == 0) {
            return null;
        }
        HashMap<Long, Map<String, Set<String>>> returnMap = new HashMap<Long, Map<String, Set<String>>>(16);
        String selectFields = "id,cachedata_tag,entrycfgjson_tag,dataset";
        QFilter qFilter = new QFilter("id", "in", templateIds);
        try (DataSet dataset = QueryServiceHelper.queryDataSet((String)"TemplateVarCommonUtil", (String)"eb_applytemplate", (String)selectFields, (QFilter[])qFilter.toArray(), null);){
            if (dataset != null) {
                while (dataset.hasNext()) {
                    Row dataRow = dataset.next();
                    String entrycfgjson_tag = dataRow.getString("entrycfgjson_tag");
                    String cachedata_tag = dataRow.getString("cachedata_tag");
                    Long dataSetId = dataRow.getLong("dataset");
                    Map varMap = returnMap.computeIfAbsent(dataSetId, k -> new HashMap(16));
                    List allDimConfig = SerializationUtils.fromJsonStringToList((String)cachedata_tag, TempDimConfig.class);
                    ColumnList columnList = (ColumnList)SerializationUtils.fromJsonString((String)entrycfgjson_tag, ColumnList.class);
                    TemplateVarCommonUtil.selectApplyTempVarInfo(columnList, allDimConfig, varMap);
                }
            }
        }
        returnMap.entrySet().removeIf(entry -> {
            Map allVarInfo = (Map)entry.getValue();
            if (allVarInfo == null) {
                return true;
            }
            allVarInfo.entrySet().removeIf(dimInfo -> dimInfo.getKey() == null || dimInfo.getValue() == null || ((Set)dimInfo.getValue()).isEmpty());
            return allVarInfo.isEmpty();
        });
        return returnMap;
    }

    public static void selectApplyTempVarInfo(ColumnList columnList, List<TempDimConfig> allDimConfig, Map<String, Set<String>> varMap) {
        columnList.getColumns().forEach(col -> {
            if (col instanceof DimensionColumn) {
                TemplateVarCommonUtil.selectVarInfo(((DimensionColumn)col).getDimNumber(), ((DimensionColumn)col).getDimensionMemberRanges(), varMap);
            }
            if (col instanceof RowDimensionColumn) {
                TemplateVarCommonUtil.selectVarInfo(((RowDimensionColumn)col).getDimNumber(), ((RowDimensionColumn)col).getDimensionMemberRanges(), varMap);
            } else if (col instanceof MeasureColumn) {
                TemplateVarCommonUtil.selectVarInfo(((MeasureColumn)col).getDataMapDimensions(), varMap);
            } else if (col instanceof CalculateColumn) {
                TemplateVarCommonUtil.selectVarInfo(((CalculateColumn)col).getDataMapDimensions(), varMap);
            } else if (col instanceof RelationValueColumn) {
                TemplateVarCommonUtil.selectVarInfo(((RelationValueColumn)col).getDataMapDimensions(), varMap);
            } else if (col instanceof DimensionDataColumn) {
                TemplateVarCommonUtil.selectVarInfo(((DimensionDataColumn)col).getDataMapDimensions(), varMap);
            }
        });
        TemplateVarCommonUtil.selectVarInfoOnHideDim(allDimConfig, varMap);
        List bizTableConfigList = columnList.getBizTableConfigList();
        if (CollectionUtils.isNotEmpty((Collection)bizTableConfigList)) {
            for (BizTableConfig bizTableConfig : bizTableConfigList) {
                TemplateVarCommonUtil.selectVarInfoOnHideDim(bizTableConfig.getDimFlexInfo().getDimConfigList(), varMap);
            }
        }
    }

    private static void selectVarInfoOnHideDim(List<TempDimConfig> allDimConfig, Map<String, Set<String>> varMap) {
        allDimConfig.forEach(membInfo -> {
            if (membInfo.getPanel().equals(TempDimConfigType.HIDEDIM.getValue()) && membInfo.isVar()) {
                String dimNumber = membInfo.getDimensionNumber();
                String varMembNum = membInfo.getMemberNumber();
                Set varNums = varMap.computeIfAbsent(dimNumber, key -> new HashSet(16));
                varNums.add(varMembNum);
            }
        });
    }

    private static void selectVarInfo(List<DataMapDimension> dataMapDimensions, Map<String, Set<String>> varMap) {
        dataMapDimensions.forEach(dataMapDim -> {
            String dimNumber = dataMapDim.getDimNum();
            if (dimNumber != null && dataMapDim.isVar()) {
                Set varNums = varMap.computeIfAbsent(dimNumber, key -> new HashSet(16));
                varNums.add(dataMapDim.getMembNum());
            }
        });
    }

    private static void selectVarInfo(String dimNumber, List<DimensionMemberRange> memberRanges, Map<String, Set<String>> varMap) {
        if (dimNumber != null) {
            Set varNums = varMap.computeIfAbsent(dimNumber, key -> new HashSet(16));
            memberRanges.forEach(memberRange -> {
                if (memberRange.isVar()) {
                    varNums.add(memberRange.getNumber());
                }
            });
        }
    }

    public static String getVarDimName(String name, String number, String dimKey, Map<String, Map<String, String>> varNumberNameMap) {
        if (varNumberNameMap == null || varNumberNameMap.size() == 0) {
            return name;
        }
        Map<String, String> varMap = varNumberNameMap.get(dimKey);
        if (varMap == null || varMap.size() == 0 || name == null) {
            return name;
        }
        String varNumber = number.replace("+", SPLIT).replace("-", SPLIT).split(SPLIT)[0].trim();
        String varName = name.replace("+", SPLIT).replace("-", SPLIT).split(SPLIT)[0].trim();
        String newName = varMap.get(varNumber);
        if (newName == null) {
            return name;
        }
        return name.replace(varName, newName.split(SPLIT)[0]);
    }

    public static void getVarDimFromTemplateData(String data, Map<String, List<String>> returnMap, boolean isRemoveFomula) {
        if (StringUtils.isEmpty((CharSequence)data)) {
            return;
        }
        ITemplateModel templateModel = TemplateModelJSONUtil.parseITemplateModel(data);
        if (templateModel == null) {
            return;
        }
        TemplateVarCommonUtil.getVarDimFromTemplateData(templateModel, returnMap, isRemoveFomula);
    }

    public static Matcher getMatchFormula(String lookupNumber, String formula) {
        Pattern pattern = Pattern.compile(formula);
        return pattern.matcher(lookupNumber);
    }

    public static String getFormulaString(Set<String> numberSet, Boolean includeFormula) {
        if (numberSet == null || numberSet.size() == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder(numberSet.size());
        sb.append("^(@)?(");
        for (String num : numberSet) {
            sb.append(num);
            sb.append("|");
        }
        String pref = sb.substring(0, sb.length() - 1) + ")";
        if (includeFormula.booleanValue()) {
            String postf = "[ ]{0,}[1-9][0-9]*";
            return StringUtils.join((Object[])new String[]{pref, "([ ]{0,}[+|-]", postf, ")*"});
        }
        return pref;
    }

    public static String checkVarAndRetErrMessage(Map<String, List<String>> taskListVariable, Map<String, List<String>> taskVariable, Boolean isDispatch, boolean isScheme) {
        String pre = TemplateVarCommonUtil.getPreStr(isDispatch);
        String entityName = isScheme ? ResManager.loadKDString((String)"\u7f16\u5236\u65b9\u6848", (String)"TemplateVarCommonUtil_9", (String)"epm-eb-spread", (Object[])new Object[0]) : "";
        return TemplateVarCommonUtil.checkVarAndRetErrMessage(taskListVariable, taskVariable, entityName, pre);
    }

    private static String getPreStr(boolean isDispatch) {
        return isDispatch ? ResManager.loadKDString((String)"\u4e0b\u8fbe", (String)"TemplateVarCommonUtil_4", (String)"epm-eb-spread", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"TemplateVarCommonUtil_5", (String)"epm-eb-spread", (Object[])new Object[0]);
    }

    public static String checkVarAndRetErrMessage(Map<String, List<String>> variableValues, Map<String, List<String>> variables, String entityName, String preInfo) {
        if (!TemplateVarCommonUtil.checkIsVar(ISNEEDVAR, "").booleanValue()) {
            return null;
        }
        HashMap<String, Set<String>> errorMessage = new HashMap<String, Set<String>>(16);
        if (variables == null || variables.size() == 0) {
            return null;
        }
        for (Map.Entry<String, List<String>> variable : variables.entrySet()) {
            String dimension = variable.getKey();
            HashSet tmp = new HashSet(variable.getValue().size());
            if (variableValues != null && variableValues.size() != 0) {
                List taskVarList = variableValues.getOrDefault(dimension, new ArrayList(16));
                variable.getValue().forEach(number -> {
                    if (number.startsWith("@LastY") || number.startsWith("@NextY") || number.startsWith("@BaseY")) {
                        if (!taskVarList.contains("@BaseY")) {
                            tmp.add("@BaseY");
                        }
                    } else if (!taskVarList.contains(number)) {
                        tmp.add(number);
                    }
                });
            } else {
                variable.getValue().forEach(number -> {
                    if (number.startsWith("@LastY") || number.startsWith("@NextY") || number.startsWith("@BaseY")) {
                        tmp.add("@BaseY");
                    } else {
                        tmp.add(number);
                    }
                });
            }
            if (tmp.isEmpty()) continue;
            errorMessage.put(dimension, tmp);
        }
        if (errorMessage.isEmpty()) {
            return null;
        }
        return TemplateVarCommonUtil.getErrorMessage(errorMessage, preInfo, entityName);
    }

    public static String checkVarOfAccountByDataSet(List<String> memberNumList, Long modelId, Long dataSetId) {
        HashMap<Template, Set<String>> errMessage = new HashMap<Template, Set<String>>(16);
        if (memberNumList == null || memberNumList.size() == 0 || modelId == 0L || dataSetId == 0L || !TemplateVarCommonUtil.checkIsVar(ISNEEDVAR, "").booleanValue()) {
            return null;
        }
        HashSet<String> memNumSet = new HashSet<String>(16);
        for (String number : memberNumList) {
            if (!StringUtils.startsWith((CharSequence)number, (CharSequence)VARPREF)) continue;
            memNumSet.add(number);
        }
        if (memNumSet.size() == 0) {
            return null;
        }
        Map<Long, String> variableMap = TemplateVarCommonUtil.getVariableMap(memNumSet, modelId);
        HashMap<Long, Long> quoteMemberMap = new HashMap<Long, Long>(16);
        String sql = "select n.fsourceid as templateId, m.fmemberid as varId from t_eb_memberquote m left join t_eb_memberquoteentry n on m.fid = n.fquoteid where m.fmemberid in (%s) and n.fsourcetype = %s and m.ftype = '%s' and m.fmodelid = %s";
        DataSet ds = DB.queryDataSet((String)"queryQuote", (DBRoute)DBRoute.of((String)"epm"), (String)String.format(sql, variableMap.keySet().stream().map(Object::toString).collect(Collectors.joining(",")), MemberQuoteResourceEnum.Template.getType(), MemberTypeEnum.VARIABLE.getType(), modelId));
        Object object = null;
        try {
            while (ds.hasNext()) {
                Row row = ds.next();
                quoteMemberMap.put(row.getLong("varId"), row.getLong("templateId"));
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (object != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        if (quoteMemberMap.size() == 0) {
            return null;
        }
        Map<Long, Template> templates = TemplateVarCommonUtil.getTemplateInfos(quoteMemberMap.values());
        for (Map.Entry entry : quoteMemberMap.entrySet()) {
            Long templateId = (Long)entry.getValue();
            Template template = templates.get(templateId);
            Long quoteDataSet = template.getDataSetId();
            if (quoteDataSet.equals(dataSetId)) continue;
            Set quoteVars = errMessage.computeIfAbsent(template, k -> new HashSet(16));
            quoteVars.add(variableMap.get(entry.getKey()));
        }
        DynamicObject dataSet = QueryServiceHelper.queryOne((String)"eb_dataset", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)dataSetId)});
        return TemplateVarCommonUtil.getVarOfAccountErrMessage(errMessage, dataSet.getString("name"));
    }

    private static Map<Long, String> getVariableMap(Set<String> memNumSet, Long modelId) {
        HashMap<Long, String> variableMap = new HashMap<Long, String>(16);
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("number", "in", memNumSet);
        DynamicObjectCollection variables = QueryServiceHelper.query((String)"eb_periodvariable", (String)"id, name", (QFilter[])new QFilter[]{qFilter});
        variables.forEach(e -> variableMap.put(e.getLong("id"), e.getString("name")));
        return variableMap;
    }

    private static Map<Long, Template> getTemplateInfos(Collection<Long> templateIds) {
        HashMap<Long, Template> templates = new HashMap<Long, Template>(16);
        String sql = "select t.fid as templateid, t.fnumber as templatenumber, t.fname as templatename, d.fid as datasetid, d.fnumber as datasetnumber, d.fname as datasetname from t_eb_template t left join t_eb_dataset d on t.fdatasetid = d.fid where t.fid in (%s)";
        try (DataSet ds = DB.queryDataSet((String)"getAllDataSets", (DBRoute)DBRoute.of((String)"epm"), (String)String.format(sql, templateIds.stream().map(String::valueOf).collect(Collectors.joining(","))));){
            while (ds.hasNext()) {
                Row row = ds.next();
                Long templateId = row.getLong("templateid");
                Template template = (Template)templates.get(templateId);
                if (template != null) continue;
                template = new Template();
                template.setId(templateId);
                template.setName(row.getString("templatename"));
                template.setNumber(row.getString("templatenumber"));
                template.setDataSetId(row.getLong("datasetid"));
                template.setDataSetName(row.getString("datasetname"));
                template.setDataSetNumber(row.getString("datasetnumber"));
                templates.put(templateId, template);
            }
        }
        return templates;
    }

    public static String checkAccountVarByMember(Map<String, Map<String, Object>> accountMemberMap, Map<Long, Map<String, List<String>>> variablesInDataset, Long modelId) {
        HashMap memberVarMap = new HashMap(16);
        HashSet memberIds = new HashSet(16);
        if (accountMemberMap == null || accountMemberMap.size() == 0 || modelId == 0L || !TemplateVarCommonUtil.checkIsVar(ISNEEDVAR, "").booleanValue() || variablesInDataset.size() == 0) {
            return null;
        }
        Map<String, List<Long>> accountVarMap = TemplateVarCommonUtil.getAccountVarMap(variablesInDataset);
        if (accountVarMap.size() == 0) {
            return null;
        }
        accountMemberMap.forEach((key, value) -> {
            memberVarMap.put(value.get("number").toString(), key);
            memberIds.add(Long.parseLong(value.get("id").toString()));
        });
        DynamicObjectCollection dataSetInfos = QueryServiceHelper.query((String)"eb_dataset", (String)"name, id", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId)});
        if (dataSetInfos == null || dataSetInfos.size() == 0) {
            return null;
        }
        Map<Long, String> dataSetMap = dataSetInfos.stream().collect(Collectors.toMap(e -> e.getLong("id"), e -> e.getString("name"), (n1, n2) -> n2));
        DynamicObjectCollection accountInfo = QueryServiceHelper.query((String)"epm_accountmembertree", (String)"name, number, dataset.id, dataset.name", (QFilter[])new QFilter[]{new QFilter("id", "in", memberIds)});
        if (accountInfo == null || accountInfo.size() == 0) {
            return null;
        }
        String errInfo = "";
        for (DynamicObject account : accountInfo) {
            String accountNum = account.getString("number");
            String accountName = account.getString("name");
            String varNum = (String)memberVarMap.get(accountNum);
            List<Long> dataSetIds = accountVarMap.get(varNum);
            if (dataSetIds == null || dataSetIds.size() == 0) continue;
            if (dataSetIds.size() != 1) {
                List dataSets = dataSetIds.stream().map(dataSetMap::get).collect(Collectors.toList());
                errInfo = StringUtils.join((Object[])new String[]{errInfo, ResManager.loadResFormat((String)"\u79d1\u76ee\u53d8\u91cf[%1]\u5df2\u88ab\u6570\u636e\u96c6[%2]\u5f15\u7528\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"TemplateVarCommonUtil_7", (String)"epm-eb-spread", (Object[])new Object[]{varNum, String.join((CharSequence)",", dataSets)})});
                continue;
            }
            long dataSetId = account.getLong("dataset.id");
            if (dataSetIds.contains(dataSetId)) continue;
            errInfo = StringUtils.join((Object[])new String[]{errInfo, ResManager.loadResFormat((String)"\u79d1\u76ee\u53d8\u91cf%1\u5df2\u88ab\u6570\u636e\u96c6%2\u5f15\u7528\uff0c\u4e0d\u53ef\u8d4b\u503c\u4e3a\u6570\u636e\u96c6%3\u7684\u7ef4\u5ea6\u6210\u5458%4\u3002", (String)"TemplateVarCommonUtil_6", (String)"epm-eb-spread", (Object[])new Object[]{varNum, dataSetMap.get(dataSetIds.get(0)), dataSetMap.get(dataSetId), accountName})});
        }
        return StringUtils.isEmpty((CharSequence)errInfo) ? null : errInfo.substring(0, errInfo.length());
    }

    private static Map<String, List<Long>> getAccountVarMap(Map<Long, Map<String, List<String>>> variablesInDataset) {
        HashMap<String, List<Long>> accountVarMap = new HashMap<String, List<Long>>(16);
        for (Map.Entry<Long, Map<String, List<String>>> variableMap : variablesInDataset.entrySet()) {
            Map<String, List<String>> value = variableMap.getValue();
            List<String> accountList = value.get(SysDimensionEnum.Account.getNumber());
            if (accountList == null || accountList.size() == 0) continue;
            Long dataSetId = variableMap.getKey();
            accountList.forEach(e -> {
                List dataSetIds = accountVarMap.computeIfAbsent((String)e, k -> new ArrayList(16));
                if (!dataSetIds.contains(dataSetId)) {
                    dataSetIds.add(dataSetId);
                }
            });
        }
        return accountVarMap;
    }

    public static String getPeriodOffset(String periodNumber, int offValue, Long modelId) {
        String offPeriodNumbers = TemplateVarCommonUtil.getOff(periodNumber, offValue, modelId);
        if (ERRINFOFLAG.equals(offPeriodNumbers)) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u83b7\u53d6\u671f\u95f4%1\u7684\u504f\u79fb%2\u6210\u5458\u5931\u8d25", (String)"TemplateVarCommonUtil_11", (String)"epm-eb-spread", (Object[])new Object[]{periodNumber, offValue}));
        }
        return offPeriodNumbers;
    }

    public static String getOff(String periodNumber, int offValue, Long modelId) {
        Pair pair;
        IModelCacheHelper modelcache = ModelCacheContext.getOrCreate((Long)modelId);
        HashMap<String, Pair> number2index = new HashMap<String, Pair>(16);
        kd.epm.eb.common.cache.impl.Member member1 = modelcache.getMember(SysDimensionEnum.BudgetPeriod.getNumber(), null, periodNumber);
        if (member1 == null) {
            return periodNumber;
        }
        int level1 = member1.getLevel();
        List<kd.epm.eb.common.cache.impl.Member> budgetPeriod1 = TemplateVarCommonUtil.getBudgetPeriodByLevel(level1, modelcache);
        if (budgetPeriod1 == null || budgetPeriod1.isEmpty()) {
            return periodNumber;
        }
        int index1 = TemplateVarCommonUtil.binarySearch(budgetPeriod1, member1.getSeq(), 0, budgetPeriod1.size());
        if (index1 > -1) {
            number2index.put(periodNumber, new Pair((Object)member1, (Object)index1));
        }
        if ((pair = (Pair)number2index.get(periodNumber)) == null) {
            return periodNumber;
        }
        kd.epm.eb.common.cache.impl.Member member2 = (kd.epm.eb.common.cache.impl.Member)pair.getKey();
        Integer index2 = (Integer)pair.getValue();
        int level2 = member2.getLevel();
        List<kd.epm.eb.common.cache.impl.Member> budgetPeriod2 = TemplateVarCommonUtil.getBudgetPeriodByLevel(level2, modelcache);
        if ((index2 = Integer.valueOf(index2 + offValue)) < 0 || index2 > budgetPeriod2.size() - 1) {
            return ERRINFOFLAG;
        }
        String offPeriodNumbers = budgetPeriod2.get(index2).getNumber();
        return offPeriodNumbers;
    }

    public static Map<String, Map<String, String>> getVarIDNumberMap(String needVar, Long modelid) {
        if (!TemplateVarCommonUtil.checkIsVar(needVar, "").booleanValue()) {
            return null;
        }
        DynamicObjectCollection query = TemplateVarCommonUtil.getVarList(modelid, null, null, null);
        if (query == null || query.size() == 0) {
            return null;
        }
        HashMap<String, Map<String, String>> returnMap = new HashMap<String, Map<String, String>>(query.size());
        for (DynamicObject object : query) {
            String varNumber = object.getString("number");
            String varName = object.getString("name");
            String varId = object.getString("id");
            String dimesionnumber = object.getString("dimesionnumber");
            Map varNumberNameSingle = returnMap.computeIfAbsent(dimesionnumber, k -> Maps.newHashMap());
            varNumberNameSingle.put(varNumber, varName + SPLIT + varId);
        }
        return returnMap;
    }

    public static DynamicObjectCollection getVarList(Long modelid, String varDimension, String lookupNumber, String onlySingle) {
        if (!TemplateVarCommonUtil.checkIsVar(ISNEEDVAR, "").booleanValue()) {
            return null;
        }
        String selectFields = "dimension.number as dimesionnumber,id,number,name,grouptype,periodtype," + TemplateVarCommonUtil.getOtherField();
        String formID = "eb_periodvariable";
        QFilter qFilter = new QFilter("model", "=", (Object)modelid);
        if (varDimension != null && !varDimension.isEmpty()) {
            qFilter.and(new QFilter("dimension.number", "=", (Object)varDimension));
        }
        if (StringUtils.isNotEmpty((CharSequence)onlySingle) && ONLY_SINGLE.equals(onlySingle)) {
            qFilter.and(new QFilter("grouptype", "!=", (Object)"2"));
        }
        if (StringUtils.isNotEmpty((CharSequence)onlySingle) && ONLY_MULTI_VAR.equals(onlySingle)) {
            qFilter.and(new QFilter("grouptype", "=", (Object)"2"));
        }
        if (lookupNumber != null && !lookupNumber.isEmpty()) {
            qFilter.and(new QFilter("number", "like", (Object)('%' + lookupNumber + '%')).or(new QFilter("name", "like", (Object)('%' + lookupNumber + '%'))));
        }
        return QueryServiceHelper.query((String)formID, (String)selectFields, (QFilter[])qFilter.toArray(), (String)"number asc");
    }

    private static String getOtherField() {
        StringBuilder sb = new StringBuilder(16);
        sb.append("parentid as parent");
        sb.append(", number as longnumber");
        sb.append(", id as memberid");
        sb.append(", '' as aggoprt");
        sb.append(", 1 as pid");
        sb.append(", '' as level");
        sb.append(", (case when periodtype='3' and grouptype = '2' then 1 else 0 end) as isleaf");
        sb.append(", 1 as dseq");
        sb.append(", 1 as use");
        return sb.toString();
    }

    private static Boolean isIncloudeVar(Map<String, Collection<String>> dimScope) {
        if (dimScope == null || dimScope.size() == 0) {
            return Boolean.FALSE;
        }
        for (Map.Entry<String, Collection<String>> entry : dimScope.entrySet()) {
            Collection<String> dimDetails = entry.getValue();
            for (String dimDetail : dimDetails) {
                if (!TemplateVarCommonUtil.checkIsVar(dimDetail, entry.getKey()).booleanValue()) continue;
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    private static void putValue2Map(Map<String, List<String>> returnMap, String dimKey, String varNumber, boolean isRemoveFomula) {
        if (returnMap == null) {
            return;
        }
        List<String> varNumbers = returnMap.get(dimKey);
        if (varNumbers == null) {
            varNumbers = new ArrayList<String>(16);
            varNumbers.add(TemplateVarCommonUtil.getVarNum(varNumber, isRemoveFomula));
            returnMap.put(dimKey, varNumbers);
        } else {
            String var = TemplateVarCommonUtil.getVarNum(varNumber, isRemoveFomula);
            if (!varNumbers.contains(var)) {
                varNumbers.add(var);
            }
        }
    }

    private static String getVarNum(String varNumber, boolean isRemoveFomula) {
        if (!isRemoveFomula) {
            return varNumber;
        }
        if (varNumber.contains("+") || varNumber.contains("-")) {
            int index;
            int n = index = varNumber.contains("+") ? varNumber.indexOf("+") : varNumber.indexOf("-");
            if (varNumber.startsWith(VARPREF)) {
                return varNumber.substring(0, index).trim();
            }
            return org.apache.commons.lang3.StringUtils.join((Object[])new String[]{VARPREF, varNumber.substring(0, index)}).trim();
        }
        return varNumber.trim();
    }

    private static String getErrorMessage(Map<String, Set<String>> errorMessage, String pre, String entryName) {
        if (errorMessage.size() == 0) {
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)entryName)) {
            entryName = ResManager.loadKDString((String)"\u4efb\u52a1\u5217\u8868\u5206\u7c7b", (String)"TemplateVarCommonUtil_10", (String)"epm-eb-spread", (Object[])new Object[0]);
        }
        String varErr = errorMessage.entrySet().stream().map(e -> {
            HashSet<String> varMsg = new HashSet<String>(((Set)e.getValue()).size());
            for (String varNumber : (Set)e.getValue()) {
                if (SysDimensionEnum.BudgetPeriod.getNumber().equals(e.getKey()) && (varNumber.startsWith("@NextY") || varNumber.startsWith("@BaseY") || varNumber.startsWith("@LastY"))) {
                    varMsg.add("@BaseY");
                    continue;
                }
                varMsg.add(varNumber);
            }
            return (String)e.getKey() + varMsg;
        }).collect(Collectors.joining(", "));
        if (StringUtils.isNotEmpty((CharSequence)pre)) {
            return ResManager.loadResFormat((String)"%1\u5931\u8d25\uff0c%2\u4e2d\u672a\u8bbe\u7f6e\u53d8\u91cf\uff1a%3\u3002", (String)"TemplateVarCommonUtil_8", (String)"epm-eb-spread", (Object[])new Object[]{pre, entryName, varErr});
        }
        return ResManager.loadResFormat((String)"%1\u4e2d\u672a\u8bbe\u7f6e\u53d8\u91cf\uff1a%2\u3002", (String)"TemplateVarCommonUtil_12", (String)"epm-eb-spread", (Object[])new Object[]{entryName, varErr});
    }

    public static String getErrorMessage(Map<String, Set<String>> errorMessage, Boolean isDispatch) {
        return TemplateVarCommonUtil.getErrorMessage(errorMessage, TemplateVarCommonUtil.getPreStr(isDispatch), "");
    }

    private static String getVarOfAccountErrMessage(Map<Template, Set<String>> errorMessage, String dataSetName) {
        if (errorMessage.size() == 0) {
            return null;
        }
        ArrayList<String> returnMessages = new ArrayList<String>(16);
        for (Map.Entry<Template, Set<String>> errEntry : errorMessage.entrySet()) {
            Template template = errEntry.getKey();
            returnMessages.add(ResManager.loadResFormat((String)"\u79d1\u76ee\u53d8\u91cf[%1]\u5df2\u88ab\u6570\u636e\u96c6[%2]\u7684\u6a21\u677f[%3]\u5f15\u7528", (String)"TemplateVarCommonUtil_2", (String)"epm-eb-spread", (Object[])new Object[]{String.join((CharSequence)",", (Iterable<? extends CharSequence>)errEntry.getValue()), template.getDataSetName(), template.getName()}));
        }
        returnMessages.add(ResManager.loadResFormat((String)"\u4e0d\u80fd\u7528\u4e8e\u6570\u636e\u96c6[%1]\u3002", (String)"TemplateVarCommonUtil_3", (String)"epm-eb-spread", (Object[])new Object[]{dataSetName}));
        return String.join((CharSequence)", ", returnMessages);
    }

    private static int binarySearch(List<kd.epm.eb.common.cache.impl.Member> members, int seq, int low, int high) {
        if (members == null || members.isEmpty() || low > high) {
            return -1;
        }
        int mid = low + (high - low) / 2;
        kd.epm.eb.common.cache.impl.Member midMember = members.get(mid);
        int midSeq = midMember.getSeq();
        if (midSeq == seq) {
            return mid;
        }
        if (midSeq > seq) {
            return TemplateVarCommonUtil.binarySearch(members, seq, low, mid - 1);
        }
        if (midSeq < seq) {
            return TemplateVarCommonUtil.binarySearch(members, seq, mid + 1, high);
        }
        return -1;
    }

    private static List<kd.epm.eb.common.cache.impl.Member> getBudgetPeriodByLevel(int level, IModelCacheHelper modelcache) {
        HashMap<Integer, List> bpMembers = new HashMap<Integer, List>(16);
        List members = (List)bpMembers.get(level);
        if (members == null) {
            kd.epm.eb.common.cache.impl.Member member = modelcache.getMember(SysDimensionEnum.BudgetPeriod.getNumber(), null, SysDimensionEnum.BudgetPeriod.getNumber());
            members = member.getLevelMembers(level);
            members.sort(Comparator.comparingInt(BaseCache::getSeq));
            bpMembers.put(level, members);
        }
        return members;
    }

    public static String getVarDisplayNumber() {
        return ResManager.loadKDString((String)"\u53d8\u91cf", (String)"TemplateVarCommonUtil_1", (String)"epm-eb-spread", (Object[])new Object[0]);
    }

    public static Map<String, Map<String, Set<String>>> getTemplateDimMapByTempOrTaskprdIds(Long modelId, Collection<Long> tempIds, Collection<Long> taskprodIds) {
        HashMap<String, Map<String, Set<String>>> templateDimMap = new HashMap<String, Map<String, Set<String>>>(16);
        Map<Long, TemplateDataVarType> templateDataVarTypeMap = TemplateVarCommonUtil.getTempDataVarTypeInfo(modelId, tempIds);
        Map<Long, Set<Long>> tempTaskLists = TemplateVarCommonUtil.getTaskListByTempOrTaskProdIds(templateDataVarTypeMap.keySet(), taskprodIds);
        QFilter qf = new QFilter("id", "in", TemplateVarCommonUtil.getTaskListsFromMap(tempTaskLists));
        HashMap<Long, Map<String, Map<String, String>>> varInfos = new HashMap<Long, Map<String, Map<String, String>>>(16);
        TemplateVarCommonUtil.queryTaskListVarMap(qf, varInfos, null);
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        for (Map.Entry<Long, TemplateDataVarType> templateEntry : templateDataVarTypeMap.entrySet()) {
            Map<String, Collection<Member>> singleTemplateDimMap;
            Long tempid = templateEntry.getKey();
            TemplateDataVarType templateInfo = templateEntry.getValue();
            ITemplateModel templateModel = TemplateModelJSONUtil.parseITemplateModel(templateInfo.getData());
            if (templateModel == null || (singleTemplateDimMap = templateModel.retrieveQuoteMembersWithScope()) == null || singleTemplateDimMap.isEmpty()) continue;
            Set<Long> taskLists = tempTaskLists.get(tempid);
            if (taskLists == null || taskLists.size() == 0) {
                templateDimMap.put(tempid.toString(), TemplateVarCommonUtil.getDetailMembers(modelCacheHelper, templateModel.getDimemsionViews(), singleTemplateDimMap));
                continue;
            }
            if (templateInfo.getIsVar().booleanValue()) {
                for (Long taskList : taskLists) {
                    TemplateVarCommonUtil.replaceVarInDImMap(singleTemplateDimMap, (Map)varInfos.get(taskList));
                    templateDimMap.put(TemplateVarCommonUtil.getMapKey(tempid, taskList), TemplateVarCommonUtil.getDetailMembers(modelCacheHelper, templateModel.getDimemsionViews(), singleTemplateDimMap));
                }
                continue;
            }
            templateDimMap.put(tempid.toString(), TemplateVarCommonUtil.getDetailMembers(modelCacheHelper, templateModel.getDimemsionViews(), singleTemplateDimMap));
        }
        return templateDimMap;
    }

    private static Map<String, Set<String>> getDetailMembers(IModelCacheHelper modelCacheHelper, Map<String, Long> dimensionViews, Map<String, Collection<Member>> singleTemplateDimMap) {
        if (singleTemplateDimMap == null) {
            return null;
        }
        HashMap<String, Set<String>> returnMap = new HashMap<String, Set<String>>(16);
        for (Map.Entry<String, Collection<Member>> subEntry : singleTemplateDimMap.entrySet()) {
            String dimKey = subEntry.getKey();
            Collection<Member> scopeCols = subEntry.getValue();
            HashSet<String> members = new HashSet<String>(16);
            for (Member mem : scopeCols) {
                List member = modelCacheHelper.getMember(dimKey, dimensionViews.get(dimKey), mem.getNumber(), mem.getRange());
                if (member != null && !member.isEmpty()) {
                    members.addAll(member.stream().map(BaseCache::getNumber).collect(Collectors.toSet()));
                    continue;
                }
                members.add(mem.getNumber());
            }
            returnMap.put(dimKey, members);
        }
        return returnMap;
    }

    private static Set<Long> getTaskListsFromMap(Map<Long, Set<Long>> tempTaskLists) {
        if (tempTaskLists == null) {
            return null;
        }
        HashSet<Long> returnCols = new HashSet<Long>(16);
        for (Map.Entry<Long, Set<Long>> templateEntry : tempTaskLists.entrySet()) {
            returnCols.addAll((Collection<Long>)templateEntry.getValue());
        }
        return returnCols;
    }

    private static Map<Long, Set<Long>> getTaskListByTempOrTaskProdIds(Collection<Long> templateInfos, Collection<Long> taskprodIds) {
        HashMap<Long, Set<Long>> returnMap = new HashMap<Long, Set<Long>>(16);
        QFilter qf = new QFilter(VARTEMPLATE, "=", (Object)1);
        if (templateInfos != null && templateInfos.size() > 0) {
            qf.and(new QFilter("template", "in", templateInfos));
        }
        if (taskprodIds != null && taskprodIds.size() > 0) {
            qf.and(new QFilter("id", "in", taskprodIds));
        }
        try (DataSet dataset = QueryServiceHelper.queryDataSet((String)"TemplateVarCommonUtil", (String)"eb_taskprocess", (String)"template.id, task.tasklist.id", (QFilter[])qf.toArray(), null);){
            if (dataset != null) {
                while (dataset.hasNext()) {
                    Row dataRow = dataset.next();
                    Long tempid = dataRow.getLong("template.id");
                    Long taskList = dataRow.getLong("task.tasklist.id");
                    HashSet<Long> taskLists = (HashSet<Long>)returnMap.get(tempid);
                    if (taskLists == null) {
                        taskLists = new HashSet<Long>(16);
                        taskLists.add(taskList);
                        returnMap.put(tempid, taskLists);
                        continue;
                    }
                    taskLists.add(taskList);
                }
            }
        }
        return returnMap;
    }

    public static Map<Long, TemplateDataVarType> getTempDataVarTypeInfo(Long modelId, Collection<Long> tempIds) {
        HashMap<Long, TemplateDataVarType> templateDataVarTypeMap = new HashMap<Long, TemplateDataVarType>(16);
        QFilter qf = new QFilter("model", "=", (Object)modelId);
        if (tempIds != null && tempIds.size() > 0) {
            qf.and(new QFilter("id", "in", tempIds));
        }
        try (DataSet dataset = QueryServiceHelper.queryDataSet((String)"TemplateVarCommonUtil", (String)"eb_templateentity", (String)"id, name, data, varbaseforeb", (QFilter[])qf.toArray(), null);){
            if (dataset != null) {
                while (dataset.hasNext()) {
                    Row dataRow = dataset.next();
                    TemplateDataVarType templatevarType = new TemplateDataVarType();
                    templatevarType.setTempId(dataRow.getLong("id"));
                    templatevarType.setIsVar(VARTEMPLATE.equals(dataRow.getString("varbaseforeb")) ? Boolean.TRUE : Boolean.FALSE);
                    templatevarType.setData(dataRow.getString("data"));
                    templatevarType.setName(dataRow.getString("name"));
                    templateDataVarTypeMap.put(dataRow.getLong("id"), templatevarType);
                }
            }
        }
        return templateDataVarTypeMap;
    }

    private static String getMapKey(Long tempid, Long taskListId) {
        return tempid + SPLIT + taskListId;
    }

    private static void replaceVarInDImMap(Map<String, Collection<Member>> dimMap, Map<String, Map<String, String>> varInfos) {
        if (dimMap == null || varInfos == null) {
            return;
        }
        for (Map.Entry<String, Collection<Member>> dimEntry : dimMap.entrySet()) {
            HashSet<Member> dimSet = new HashSet<Member>(16);
            String dimKey = dimEntry.getKey();
            Collection<Member> dimMembers = dimEntry.getValue();
            if (dimMembers == null) continue;
            Map<String, String> varInfo = varInfos.get(dimKey);
            for (Member member : dimMembers) {
                String memNumber = member.getNumber();
                if (varInfo == null || StringUtils.isEmpty((CharSequence)varInfo.get(memNumber))) {
                    dimSet.add(member);
                    continue;
                }
                member.setNumber(varInfo.get(memNumber));
                dimSet.add(member);
            }
            dimMembers = dimSet;
        }
    }

    public static Map<Long, Map<String, Map<String, String>>> getTaskListVarMapByTaskList(Long modelId, Collection<Long> taskLists) {
        HashMap<Long, Map<String, Map<String, String>>> varInfos = new HashMap<Long, Map<String, Map<String, String>>>(16);
        QFilter qf = new QFilter("model", "=", (Object)modelId);
        if (taskLists != null && taskLists.size() > 0) {
            qf.and(new QFilter("id", "in", taskLists));
        }
        TemplateVarCommonUtil.queryTaskListVarMap(qf, varInfos, null);
        return varInfos;
    }

    public static Map<String, Map<String, Object>> getTaskListAccountVarMember(Long taskListId) {
        if (taskListId == 0L) {
            return null;
        }
        HashMap<String, Map<String, Object>> accountMemberMap = new HashMap<String, Map<String, Object>>(16);
        QFilter qFilter = new QFilter("id", "=", (Object)taskListId);
        TemplateVarCommonUtil.queryTaskListVarMap(qFilter, null, accountMemberMap);
        return accountMemberMap;
    }

    private static void queryTaskListVarMap(QFilter qFilter, Map<Long, Map<String, Map<String, String>>> varInfos, Map<String, Map<String, Object>> accountMemberMap) {
        if (varInfos == null && accountMemberMap == null) {
            return;
        }
        String sql = "id, entryentity.dimension.number, entryentity.variablenumber.number, entryentity.variablejson";
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_tasklist", (String)sql, (QFilter[])new QFilter[]{qFilter});
        for (DynamicObject obj : query) {
            String dimNum = obj.getString("entryentity.dimension.number");
            if (StringUtils.isEmpty((CharSequence)dimNum)) continue;
            String varNum = obj.getString("entryentity.variablenumber.number");
            String varJson = obj.getString("entryentity.variablejson");
            Map varDetail = (Map)SerializationUtils.fromJsonString((String)varJson, Map.class);
            if (varInfos != null) {
                Map<String, String> varValue;
                Map<String, Map<String, String>> varInfo = varInfos.get(obj.getLong("id"));
                if (varInfo == null) {
                    varInfo = new HashMap<String, Map<String, String>>(16);
                }
                if ((varValue = varInfo.get(dimNum)) == null) {
                    varValue = new HashMap<String, String>(16);
                }
                varValue.put(varNum, varDetail.get("number").toString());
                varInfo.put(dimNum, varValue);
                varInfos.put(obj.getLong("id"), varInfo);
            }
            if (accountMemberMap == null || !SysDimensionEnum.Account.getNumber().equals(dimNum)) continue;
            accountMemberMap.put(varNum, varDetail);
        }
    }

    public static Map<Long, Map<String, List<String>>> getTemplateVarInfo(Set<Long> templateIds) {
        HashMap<Long, Map<String, List<String>>> templateVarInfo = new HashMap<Long, Map<String, List<String>>>(16);
        if (CollectionUtils.isEmpty(templateIds)) {
            return templateVarInfo;
        }
        DynamicObjectCollection templateObjects = QueryServiceHelper.query((String)"eb_templateentity", (String)"id, number, name, data", (QFilter[])new QFilter("id", "in", templateIds).toArray());
        if (CollectionUtils.isNotEmpty((Collection)templateObjects)) {
            for (DynamicObject templateObject : templateObjects) {
                HashMap<String, List<String>> varMap = new HashMap<String, List<String>>(16);
                String data = templateObject.getString("data");
                if (StringUtils.isEmpty((CharSequence)data) || !data.contains(VARPREF)) continue;
                TemplateVarCommonUtil.getVarDimFromTemplateData(data, varMap, true);
                if (varMap.size() <= 0) continue;
                templateVarInfo.put(templateObject.getLong("id"), varMap);
            }
        }
        return templateVarInfo;
    }

    public static void getVarDimFromTemplateData(ITemplateModel templateModel, Map<String, List<String>> returnMap, boolean isRemoveFomula) {
        Map<String, Collection<String>> dimScope = templateModel.retrieveQuoteMembers();
        for (Map.Entry<String, Collection<String>> entry : dimScope.entrySet()) {
            String dimKey = entry.getKey();
            Collection<String> dimDetails = entry.getValue();
            for (String dimDetail : dimDetails) {
                if (!TemplateVarCommonUtil.checkIsVar(dimDetail, dimKey).booleanValue()) continue;
                TemplateVarCommonUtil.putValue2Map(returnMap, dimKey, dimDetail, isRemoveFomula);
            }
        }
    }

    public static Map<String, List<String>> getTemplateVarInfoInScheme(Map<Long, Set<Long>> schemeIdRelTemplateIds, Map<Long, Map<String, List<String>>> templateIdToVarInfoMap, DynamicObjectCollection allocateRecord) {
        DynamicObjectCollection applyTemplateObjects;
        HashMap<String, List<String>> templateVarInfo;
        DynamicObjectCollection budgetTemplateObjects;
        HashSet<Long> applyTemplateIds = new HashSet<Long>(16);
        HashSet<Long> budgetTemplateIds = new HashSet<Long>(16);
        if (allocateRecord != null && allocateRecord.size() > 0) {
            for (DynamicObject record : allocateRecord) {
                String templateType = record.getString("templatetype");
                Set ids = schemeIdRelTemplateIds.computeIfAbsent(record.getLong("scheme"), e -> new HashSet());
                if (VARTEMPLATE.equals(templateType)) {
                    applyTemplateIds.add(record.getLong("applytemplate"));
                    ids.add(record.getLong("applytemplate"));
                    continue;
                }
                budgetTemplateIds.add(record.getLong("template"));
                ids.add(record.getLong("template"));
            }
        }
        HashMap<Long, Map<String, List<String>>> varInfoOfBudget = new HashMap<Long, Map<String, List<String>>>(16);
        if (budgetTemplateIds.size() > 0 && (budgetTemplateObjects = QueryServiceHelper.query((String)"eb_templateentity", (String)"id,data,dataset,varbaseforeb", (QFilter[])new QFilter("id", "in", budgetTemplateIds).toArray())) != null && budgetTemplateObjects.size() > 0) {
            for (Object templateObject : budgetTemplateObjects) {
                ITemplateModel templateModel;
                if (!VARTEMPLATE.equals(templateObject.getString("varbaseforeb")) || (templateModel = TemplateModelJSONUtil.parseITemplateModel(templateObject.getString("data"))) == null) continue;
                templateVarInfo = new HashMap(16);
                TemplateVarCommonUtil.getVarDimFromTemplateData(templateModel, templateVarInfo, true);
                templateIdToVarInfoMap.put(templateObject.getLong("id"), templateVarInfo);
                Map dataSetVarInfo = varInfoOfBudget.computeIfAbsent(templateObject.getLong("dataset"), e -> new HashMap());
                TemplateVarCommonUtil.addToDataSetVarInfo(templateVarInfo, dataSetVarInfo);
            }
        }
        HashMap<Long, Map<String, Set<String>>> varInfoOfApply = new HashMap<Long, Map<String, Set<String>>>(16);
        if (applyTemplateIds.size() > 0 && (applyTemplateObjects = QueryServiceHelper.query((String)"eb_applytemplate", (String)"id,cachedata_tag,entrycfgjson_tag,dataset", (QFilter[])new QFilter("id", "in", applyTemplateIds).toArray())) != null && applyTemplateObjects.size() > 0) {
            for (DynamicObject object : applyTemplateObjects) {
                templateVarInfo = new HashMap<String, List<String>>(16);
                List allDimConfig = SerializationUtils.fromJsonStringToList((String)object.getString("cachedata_tag"), TempDimConfig.class);
                ColumnList columnList = (ColumnList)SerializationUtils.fromJsonString((String)object.getString("entrycfgjson_tag"), ColumnList.class);
                TemplateVarCommonUtil.selectApplyTempVarInfo(columnList, allDimConfig, templateVarInfo);
                Map<String, List<String>> listMap = TemplateVarCommonUtil.switchSetToList(templateVarInfo);
                templateIdToVarInfoMap.put(object.getLong("id"), listMap);
                Map dataSetVarInfo = varInfoOfBudget.computeIfAbsent(object.getLong("dataset"), e -> new HashMap());
                TemplateVarCommonUtil.addToDataSetVarInfo(listMap, dataSetVarInfo);
            }
        }
        Map<Long, Map<String, List<String>>> dataSetTemplateVarInfo = TemplateVarUtil.mergeVarInfo(varInfoOfBudget, varInfoOfApply);
        HashMap<String, List<String>> templateVarInfo2 = new HashMap<String, List<String>>(16);
        TemplateVarUtil.mergeVariables(dataSetTemplateVarInfo, templateVarInfo2);
        return templateVarInfo2;
    }

    private static void addToDataSetVarInfo(Map<String, List<String>> templateVarInfo, Map<String, List<String>> dataSetVarInfo) {
        for (Map.Entry<String, List<String>> entry : templateVarInfo.entrySet()) {
            String dimNum = entry.getKey();
            List<String> temDimVarNums = entry.getValue();
            List dataSetDimVarNums = dataSetVarInfo.computeIfAbsent(dimNum, e -> new ArrayList());
            dataSetDimVarNums.addAll(temDimVarNums);
        }
    }

    private static Map<String, List<String>> switchSetToList(Map<String, Set<String>> setMap) {
        HashMap<String, List<String>> listMap = new HashMap<String, List<String>>(setMap.size());
        for (Map.Entry<String, Set<String>> entry : setMap.entrySet()) {
            String kkk = entry.getKey();
            Set<String> vvv = entry.getValue();
            if (!CollectionUtils.isNotEmpty(vvv)) continue;
            listMap.put(kkk, new ArrayList<String>(vvv));
        }
        return listMap;
    }

    public static Map<String, Long> getVariablesId(Set<String> varNumbers, Long modelId) {
        LinkedHashMap<String, Long> variableIdMap = new LinkedHashMap<String, Long>(16);
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        Set varNumbers1 = varNumbers.stream().map(varNumber -> {
            if (varNumber.startsWith("@NextY") || varNumber.startsWith("@BaseY") || varNumber.startsWith("@LastY")) {
                return "@BaseY";
            }
            return varNumber;
        }).collect(Collectors.toSet());
        qFilter.and("number", "in", varNumbers1);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"getVariablesId", (String)"eb_periodvariable", (String)"id,number,dimension.number", (QFilter[])qFilter.toArray(), (String)"dimension");){
            if (ds != null) {
                while (ds.hasNext()) {
                    Row row = ds.next();
                    variableIdMap.put(row.getString("dimension.number") + "_" + row.getString("number"), row.getLong("id"));
                }
            }
        }
        return variableIdMap;
    }
}

