/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.spread.utils.ReportVar;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SpreadTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.BizModel;
import kd.epm.eb.spread.template.BgTemplate;
import kd.epm.eb.spread.template.IBaseEntry;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.arearangedim.IRowColDimensionEntry;
import kd.epm.eb.spread.template.dimension.IDimension;
import kd.epm.eb.spread.template.dimension.IDimensionMember;
import kd.epm.eb.spread.template.pagedim.IPageDimensionEntry;
import kd.epm.eb.spread.template.partition.RowColPartition;
import kd.epm.eb.spread.template.viewpointdim.IViewPointDimensionEntry;
import kd.epm.eb.spread.utils.ReportVar.ReportVarUtil;
import kd.epm.eb.spread.utils.ReportVar.TemplateVarCommonUtil;
import kd.epm.eb.spread.utils.ReportVar.VarException;

public class TemplateVarUtil {
    private static Log log = LogFactory.getLog(TemplateVarUtil.class);
    private static final String ROOTID = "0";
    private static String CONST_VAR = "var";
    private static String CONST_NOVAR = "novar";
    private static String FROM_TASK = "task";
    private static String FROM_TASKLIST = "tasklist";
    private static String FROM_DISPATCH = "dispatch";

    public static Boolean checkIsVar(IDimensionMember member, String dimKey) {
        return TemplateVarCommonUtil.checkIsVar(member.getNumber(), dimKey);
    }

    public static boolean isReport(ITemplateModel templateModel) {
        return SpreadTypeEnum.SPREADTYPE_REPORT.getIndex().equals(templateModel.getTemplateBaseInfo().getSpreadType());
    }

    public static boolean isVarTemplate(ITemplateModel templateModel) {
        return "1".equalsIgnoreCase(templateModel.getTemplateBaseInfo().getVarBase());
    }

    public static Member getNewVarMember(Long modelid, String varNumber, String dimKey, Map<String, Map<String, String>> varNumberNameMap, IModelCacheHelper modelCacheHelper) {
        if (varNumberNameMap == null || modelCacheHelper == null) {
            return null;
        }
        String id = TemplateVarUtil.getVarNameID(Boolean.FALSE, dimKey, varNumber, varNumber, varNumberNameMap);
        String name = TemplateVarUtil.getVarNameID(Boolean.TRUE, dimKey, varNumber, varNumber, varNumberNameMap);
        Member member = new Member(modelCacheHelper.getDimension(dimKey));
        member.setId(Long.valueOf(Long.parseLong(id)));
        member.setName(name);
        member.setNumber(varNumber);
        return member;
    }

    public static String getVarNameID(Boolean getName, String dimKey, String number, String nameOrId, Map<String, Map<String, String>> varNumberNameMap) {
        String varNumAndId;
        String[] str;
        if (!TemplateVarCommonUtil.checkIsVar(number, dimKey).booleanValue()) {
            return nameOrId;
        }
        if (varNumberNameMap == null || varNumberNameMap.size() == 0) {
            return nameOrId;
        }
        Map<String, String> varNumberName = varNumberNameMap.get(dimKey);
        if (varNumberName == null) {
            return nameOrId;
        }
        if (number.indexOf("+") > 0) {
            str = number.split("[+]");
            number = str[0].trim();
        }
        if (number.indexOf("-") > 0) {
            str = number.split("-");
            number = str[0].trim();
        }
        if ((varNumAndId = varNumberName.get(number)) == null) {
            throw new VarException(ResManager.loadResFormat((String)"\u6a21\u677f\u4e0a\u7684\u7ef4\u5ea6%1\u8bbe\u7f6e\u7684\u7ef4\u5ea6\u53d8\u91cf%2\u4e0d\u5b58\u5728\u3002", (String)"TemplateVarUtil_1", (String)"epm-eb-spread", (Object[])new Object[]{dimKey, number}));
        }
        if (getName.booleanValue()) {
            return varNumAndId.split("!")[0];
        }
        return varNumAndId.split("!")[1];
    }

    public static DynamicObjectCollection addVar2DimLst(Long modelid, IDimension dimension, IDimensionMember member, Set<Member> OneDimension_members, Set<String> membernums, DynamicObjectCollection varList) {
        if (!TemplateVarCommonUtil.checkIsVar("isNeedVar", "").booleanValue()) {
            return varList;
        }
        if (varList == null || varList.size() == 0) {
            varList = TemplateVarCommonUtil.getVarList(modelid, dimension.getNumber(), null, null);
        }
        if (varList == null || varList.size() == 0) {
            TemplateVarCommonUtil.doLog(StringUtils.join((Object[])new String[]{"dimension has no var:", dimension.getNumber()}), log);
            return varList;
        }
        if (membernums != null) {
            membernums.add(member.getNumber());
        }
        TemplateVarUtil.addDimension(member, OneDimension_members, varList);
        return varList;
    }

    public static void addVar2TreeEntryRoot(String needVar, Long modelid, String varDimension, List<DynamicObject> dcs, String varType) {
        if (dcs == null || needVar == null || !TemplateVarCommonUtil.checkIsVar(needVar, "").booleanValue()) {
            return;
        }
        DynamicObjectCollection query = TemplateVarCommonUtil.getVarList(modelid, varDimension, null, varType);
        if (query == null || query.size() == 0) {
            return;
        }
        TemplateVarUtil.setVarDefaultRoot(dcs, varType, varDimension);
        for (DynamicObject object : query) {
            if (object.get("parent") == null || object.get("parent").equals("") || object.get("parent").equals(ROOTID)) {
                if ("2".equals(object.get("grouptype"))) {
                    object.set("parent", (Object)"33");
                } else {
                    object.set("parent", (Object)"22");
                }
            }
            dcs.add(object);
        }
    }

    public static DynamicObjectCollection getVar2TreeEntryRoot(String needVar, Long modelid, String varDimension, String varType) {
        if (needVar == null || !TemplateVarCommonUtil.checkIsVar(needVar, "").booleanValue()) {
            return null;
        }
        DynamicObjectCollection query = TemplateVarCommonUtil.getVarList(modelid, varDimension, null, varType);
        if (query == null || query.size() == 0) {
            return query;
        }
        TemplateVarUtil.setVarDefaultRoot((List<DynamicObject>)query, varType, varDimension);
        return query;
    }

    public static void addVar2FixLookUp(String needVar, Long modelid, IDimension dimension, String lookupNumber, List<Object> dcs) {
        if (dimension == null || dcs == null || needVar == null || !TemplateVarCommonUtil.checkIsVar(needVar, "").booleanValue()) {
            return;
        }
        String varDimensionNumber = dimension.getNumber();
        DynamicObjectCollection query = TemplateVarCommonUtil.getVarList(modelid, varDimensionNumber, lookupNumber, null);
        if (query != null) {
            for (DynamicObject object : query) {
                ArrayList<String> arr = new ArrayList<String>(16);
                arr.add(object.getString("id"));
                arr.add(object.getString("number"));
                arr.add(object.getString("name"));
                dcs.add(arr);
            }
        }
        if (varDimensionNumber.equalsIgnoreCase(SysDimensionEnum.BudgetPeriod.getNumber())) {
            TemplateVarUtil.doForumula(modelid, varDimensionNumber, lookupNumber, dcs);
        }
    }

    private static boolean checkLookupNumber(String lookupNumber) {
        Pattern pattern = Pattern.compile("[+\\-]");
        Matcher matcher = pattern.matcher(lookupNumber);
        int count = 0;
        while (matcher.find()) {
            ++count;
        }
        return count > 1;
    }

    private static void doForumula(Long modelid, String varDimension, String lookupNumber, List<Object> dcs) {
        if (lookupNumber != null && !lookupNumber.isEmpty()) {
            if (TemplateVarUtil.checkLookupNumber(lookupNumber)) {
                return;
            }
            Map<String, String> varNumberNameMap = TemplateVarUtil.queryVarNumberName(modelid, varDimension);
            if (varNumberNameMap == null) {
                return;
            }
            HashSet<String> varNames = new HashSet<String>(varNumberNameMap.size());
            varNumberNameMap.entrySet().forEach(entry -> varNames.add((String)entry.getValue()));
            String formula = TemplateVarCommonUtil.getFormulaString(varNames, Boolean.TRUE);
            if (formula == null) {
                return;
            }
            Matcher findMatcher = TemplateVarCommonUtil.getMatchFormula(lookupNumber, formula);
            if (!findMatcher.matches()) {
                formula = TemplateVarCommonUtil.getFormulaString(varNumberNameMap.keySet(), Boolean.TRUE);
            }
            findMatcher = TemplateVarCommonUtil.getMatchFormula(lookupNumber, formula);
            while (findMatcher.find()) {
                String varInfo;
                String key = findMatcher.group();
                if (!TemplateVarUtil.isInList(key, dcs).booleanValue() || !lookupNumber.equals(key) || !key.contains("+") && !key.contains("-")) continue;
                int index = key.contains("+") ? key.indexOf("+") : key.indexOf("-");
                String num = key.substring(0, index).trim();
                String name = varNumberNameMap.get(num);
                if (num.startsWith("@")) {
                    name = varNumberNameMap.get(num.substring(1));
                }
                if (StringUtils.isEmpty((CharSequence)name)) {
                    name = num;
                    for (Map.Entry<String, String> entry2 : varNumberNameMap.entrySet()) {
                        if (!name.equals(entry2.getValue()) && !name.equals(org.apache.commons.lang3.StringUtils.join((Object[])new String[]{"@", entry2.getValue()}))) continue;
                        num = entry2.getKey();
                    }
                }
                if (StringUtils.isEmpty((CharSequence)name) || StringUtils.isEmpty((CharSequence)num)) continue;
                ArrayList<Object> arr = new ArrayList<Object>(16);
                arr.add(System.currentTimeMillis());
                String string = varInfo = key.startsWith("@") ? key.substring(1).replace(name, num) : key.replace(name, num);
                if (varInfo.startsWith("@")) {
                    arr.add(varInfo);
                } else {
                    arr.add(org.apache.commons.lang3.StringUtils.join((Object[])new String[]{"@", varInfo}));
                }
                varInfo = key;
                varInfo = varInfo.replace(num, name);
                arr.add(varInfo);
                dcs.add(arr);
            }
        }
    }

    private static Boolean isInList(String number, List<Object> dcs) {
        if (dcs == null) {
            return Boolean.FALSE;
        }
        if (dcs.size() == 0) {
            return Boolean.TRUE;
        }
        for (Object nums : dcs) {
            if (!nums.toString().equalsIgnoreCase(number)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private static Map<String, String> queryVarNumberName(Long modelid, String varDimension) {
        HashMap<String, String> returnMap = new HashMap<String, String>(16);
        DynamicObjectCollection query = TemplateVarCommonUtil.getVarList(modelid, varDimension, null, null);
        if (query == null || query.size() == 0) {
            return returnMap;
        }
        for (DynamicObject object : query) {
            String varNumber = object.getString("number");
            if (varNumber.startsWith("@")) {
                varNumber = varNumber.substring(1);
            }
            returnMap.put(varNumber, object.getString("name"));
        }
        return returnMap;
    }

    private static void addDimension(IDimensionMember member, Set<Member> OneDimension_members, DynamicObjectCollection varList) {
        if (OneDimension_members != null) {
            TemplateVarUtil.reSetIDandName(member, varList);
            Optional<DynamicObject> optional = varList.stream().filter(x -> x.getString("number").equals(member.getNumber())).findFirst();
            if (!optional.isPresent()) {
                return;
            }
            DynamicObject dynamicObject1 = optional.get();
            if (dynamicObject1 == null) {
                return;
            }
            if ("2".equals(dynamicObject1.getString("grouptype"))) {
                List<Object> subVarList = new ArrayList(16);
                Map<Long, List<DynamicObject>> varMaps = varList.stream().filter(x -> "2".equals(x.getString("grouptype"))).collect(Collectors.groupingBy(x -> x.getLong("parent")));
                Map<Long, DynamicObject> idVarMaps = varList.stream().filter(x -> "2".equals(x.getString("grouptype"))).collect(Collectors.toMap(x -> x.getLong("id"), x -> x));
                if (RangeEnum.DIRECTSUB_EXCLUDE.getIndex() == member.getScope()) {
                    subVarList = varMaps.get(member.getId());
                } else if (RangeEnum.DIRECTSUB.getIndex() == member.getScope()) {
                    subVarList = varMaps.get(member.getId());
                    if (subVarList == null) {
                        subVarList = new ArrayList(16);
                    }
                    subVarList.add(dynamicObject1);
                } else if (RangeEnum.ALL_EXCLUDE.getIndex() == member.getScope()) {
                    subVarList = varMaps.get(member.getId());
                    subVarList = TemplateVarUtil.queryAllCludeMember(subVarList, varMaps);
                } else if (RangeEnum.ALL.getIndex() == member.getScope()) {
                    subVarList = varMaps.get(member.getId());
                    subVarList = TemplateVarUtil.queryAllCludeMember(subVarList, varMaps);
                    subVarList.add(dynamicObject1);
                } else if (RangeEnum.PEERS_EXCLUDE.getIndex() == member.getScope()) {
                    subVarList.add(dynamicObject1);
                } else if (RangeEnum.PEERS.getIndex() == member.getScope()) {
                    subVarList.add(dynamicObject1);
                } else if (RangeEnum.ALL_DETAIL.getIndex() == member.getScope()) {
                    subVarList = varMaps.get(member.getId());
                    subVarList = TemplateVarUtil.queryAllCludeMember(subVarList, varMaps);
                    subVarList = subVarList.stream().filter(x -> "3".equals(x.getString("periodtype"))).collect(Collectors.toList());
                } else if (RangeEnum.ALL_DETAIL_INCLUDE.getIndex() == member.getScope()) {
                    subVarList = varMaps.get(member.getId());
                    subVarList = TemplateVarUtil.queryAllCludeMember(subVarList, varMaps);
                    subVarList = subVarList.stream().filter(x -> "3".equals(x.getString("periodtype"))).collect(Collectors.toList());
                    subVarList.add(dynamicObject1);
                } else if (RangeEnum.ALL_NOTDETAIL.getIndex() == member.getScope()) {
                    subVarList = varMaps.get(member.getId());
                    subVarList = TemplateVarUtil.queryAllCludeMember(subVarList, varMaps);
                    subVarList = subVarList.stream().filter(x -> !"3".equals(x.getString("periodtype"))).collect(Collectors.toList());
                } else if (RangeEnum.ANCESTOR.getIndex() == member.getScope()) {
                    subVarList = TemplateVarUtil.queryParentMmeber(dynamicObject1, idVarMaps);
                    subVarList.add(dynamicObject1);
                } else if (RangeEnum.ANCESTOR_EXCLUDE.getIndex() == member.getScope()) {
                    subVarList = TemplateVarUtil.queryParentMmeber(dynamicObject1, idVarMaps);
                } else {
                    subVarList.add(dynamicObject1);
                }
                if (subVarList != null && !subVarList.isEmpty()) {
                    subVarList = subVarList.stream().sorted((e1, e2) -> {
                        if (e1.getString("periodtype").equals(e2.getString("periodtype"))) {
                            return e1.getString("number").compareTo(e2.getString("number"));
                        }
                        return e1.getString("periodtype").compareTo(e2.getString("periodtype"));
                    }).collect(Collectors.toList());
                    for (DynamicObject dynamicObject : subVarList) {
                        Member varMember = new Member();
                        varMember.setId(Long.valueOf(dynamicObject.getLong("id")));
                        varMember.setNumber(dynamicObject.getString("number"));
                        varMember.setName(dynamicObject.getString("name"));
                        varMember.addName(Lang.get(), dynamicObject.getString("name"));
                        Dimension dim = new Dimension();
                        dim.setNumber(dynamicObject.getString("number"));
                        dim.setShortNumber(dynamicObject.getString("number"));
                        dim.setId(varMember.getId());
                        dim.setName(dynamicObject.getString("name"));
                        varMember.setDimension(dim);
                        OneDimension_members.add(varMember);
                    }
                }
            } else {
                Member varMember = new Member();
                varMember.setId(member.getId());
                varMember.setNumber(member.getNumber());
                varMember.setName(member.getName());
                varMember.addName(Lang.get(), member.getName());
                Dimension dim = new Dimension();
                dim.setNumber(member.getNumber());
                dim.setShortNumber(member.getNumber());
                dim.setId(varMember.getId());
                dim.setName(member.getName());
                varMember.setDimension(dim);
                OneDimension_members.add(varMember);
            }
        }
    }

    private static List<DynamicObject> queryParentMmeber(DynamicObject dynamicObject1, Map<Long, DynamicObject> idVarMaps) {
        ArrayList<DynamicObject> dynamicObjectList = new ArrayList<DynamicObject>(16);
        if (dynamicObject1 == null) {
            return dynamicObjectList;
        }
        DynamicObject dynamicObject = idVarMaps.get(dynamicObject1.getLong("parentid"));
        if (dynamicObject != null) {
            dynamicObjectList.add(dynamicObject);
            List<DynamicObject> dynamicObjectList1 = TemplateVarUtil.queryParentMmeber(dynamicObject, idVarMaps);
            if (dynamicObjectList1 != null && !dynamicObjectList1.isEmpty()) {
                dynamicObjectList.addAll(dynamicObjectList1);
            }
        }
        return dynamicObjectList;
    }

    private static List<DynamicObject> queryAllCludeMember(List<DynamicObject> directSub, Map<Long, List<DynamicObject>> varMaps) {
        ArrayList<DynamicObject> newAllMember = new ArrayList<DynamicObject>(16);
        if (directSub == null || directSub.isEmpty()) {
            return newAllMember;
        }
        for (DynamicObject dynamicObject : directSub) {
            List<DynamicObject> dynamicObjectList1;
            List<DynamicObject> dynamicObjectList = varMaps.get(dynamicObject.getLong("id"));
            if (dynamicObjectList == null || dynamicObjectList.isEmpty() || (dynamicObjectList1 = TemplateVarUtil.queryAllCludeMember(dynamicObjectList, varMaps)) == null || dynamicObjectList1.isEmpty()) continue;
            newAllMember.addAll(dynamicObjectList1);
        }
        newAllMember.addAll(directSub);
        return newAllMember;
    }

    private static void reSetIDandName(IDimensionMember member, DynamicObjectCollection varList) {
        if (varList == null) {
            return;
        }
        for (DynamicObject object : varList) {
            if (!member.getNumber().equalsIgnoreCase(object.getString("number"))) continue;
            if (member.getId() == null) {
                member.setId(object.getLong("id"));
            }
            if (member.getName() != null) break;
            member.setName(object.getString("name"));
            break;
        }
    }

    private static void setVarDefaultRoot(List<DynamicObject> dcs, String onlySingle, String varDimension) {
        if (dcs == null || dcs.size() == 0) {
            return;
        }
        DynamicObject varroot = TemplateVarUtil.genNode(dcs.get(0).getDynamicObjectType(), "11", ResManager.loadKDString((String)"\u53d8\u91cf", (String)"TemplateVarUtil_0", (String)"epm-eb-spread", (Object[])new Object[0]), ROOTID, "Variable");
        dcs.add(varroot);
        if (SysDimensionEnum.BudgetPeriod.getNumber().equals(varDimension)) {
            if (StringUtils.isEmpty((CharSequence)onlySingle) || !"onlySingle".equals(onlySingle)) {
                DynamicObject varroot2 = TemplateVarUtil.genNode(dcs.get(0).getDynamicObjectType(), "33", ResManager.loadKDString((String)"\u5e74\u53d8\u91cf", (String)"TemplateVarUtil_3", (String)"epm-eb-spread", (Object[])new Object[0]), "11", "Year variables");
                dcs.add(varroot2);
            }
            if (StringUtils.isEmpty((CharSequence)onlySingle) || !"onlyMultiVar".equals(onlySingle)) {
                DynamicObject varroot1 = TemplateVarUtil.genNode(dcs.get(0).getDynamicObjectType(), "22", ResManager.loadKDString((String)"\u671f\u95f4\u53d8\u91cf", (String)"TemplateVarUtil_2", (String)"epm-eb-spread", (Object[])new Object[0]), "11", "Period variables");
                dcs.add(varroot1);
            }
        }
    }

    private static DynamicObject genNode(DynamicObjectType dynamicObjectType, String id, String name, String parentId, String displayNumber) {
        DynamicObject varroot = new DynamicObject(dynamicObjectType);
        if (varroot.getDynamicObjectType().getProperty("id") != null) {
            varroot.set("id", (Object)id);
        }
        if (varroot.getDynamicObjectType().getProperty("number") != null) {
            varroot.set("number", (Object)displayNumber);
        }
        if (varroot.getDynamicObjectType().getProperty("name") != null) {
            varroot.set("name", (Object)ResManager.loadKDString((String)name, (String)"TemplateVarUtil_0", (String)"epm-eb-spread", (Object[])new Object[0]));
        }
        if (varroot.getDynamicObjectType().getProperty("parent") != null) {
            varroot.set("parent", (Object)parentId);
        }
        if (varroot.getDynamicObjectType().getProperty("longnumber") != null) {
            varroot.set("longnumber", (Object)TemplateVarCommonUtil.getVarDisplayNumber());
        }
        if (varroot.getDynamicObjectType().getProperty("memberid") != null) {
            varroot.set("memberid", (Object)id);
        }
        if (varroot.getDynamicObjectType().getProperty("aggoprt") != null) {
            varroot.set("aggoprt", (Object)"");
        }
        if (varroot.getDynamicObjectType().getProperty("pid") != null) {
            varroot.set("pid", (Object)1);
        }
        if (varroot.getDynamicObjectType().getProperty("level") != null) {
            varroot.set("level", (Object)"");
        }
        if (varroot.getDynamicObjectType().getProperty("isleaf") != null) {
            varroot.set("isleaf", (Object)0);
        }
        if (varroot.getDynamicObjectType().getProperty("dseq") != null) {
            varroot.set("dseq", (Object)1);
        }
        return varroot;
    }

    private static Map<String, List<String>> splitVarNumbers(String dimension, List<String> numbers) {
        if (numbers == null || numbers.size() == 0) {
            return null;
        }
        HashMap<String, List<String>> returnMap = new HashMap<String, List<String>>(16);
        ArrayList<String> varNumbers = new ArrayList<String>(16);
        ArrayList<String> noVarNumbers = new ArrayList<String>(16);
        for (String number : numbers) {
            if (TemplateVarCommonUtil.checkIsVar(number, dimension).booleanValue()) {
                varNumbers.add(number);
                continue;
            }
            noVarNumbers.add(number);
        }
        returnMap.put(CONST_VAR, varNumbers);
        returnMap.put(CONST_NOVAR, noVarNumbers);
        return returnMap;
    }

    public static List<Member> getMemberVar(IModelCacheHelper modelCacheHelper, List<String> numbers, String dimension, Map<String, Map<String, String>> varNumberNameMap, Long viewId) {
        List<String> varNumbers;
        if (varNumberNameMap == null || !TemplateVarCommonUtil.checkIsVar("isNeedVar", "").booleanValue()) {
            return modelCacheHelper.getMembers(dimension, viewId, numbers);
        }
        ArrayList<Member> returnLists = new ArrayList<Member>(16);
        Map<String, List<String>> splitNumbers = TemplateVarUtil.splitVarNumbers(dimension, numbers);
        if (splitNumbers == null) {
            return returnLists;
        }
        List<String> novarNumbers = splitNumbers.get(CONST_NOVAR);
        if (novarNumbers != null && novarNumbers.size() > 0) {
            returnLists.addAll(modelCacheHelper.getMembers(dimension, viewId, novarNumbers));
        }
        if ((varNumbers = splitNumbers.get(CONST_VAR)) == null || varNumbers.size() == 0) {
            return returnLists;
        }
        Map<String, String> varNumberMap = varNumberNameMap.get(dimension);
        if (varNumberMap == null || varNumberMap.size() == 0) {
            return returnLists;
        }
        for (String number : varNumbers) {
            Member varMember = new Member();
            String varNameId = varNumberMap.get(number);
            if (varNameId == null) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u6a21\u677f\u4e0a\u7684\u7ef4\u5ea6%1\u8bbe\u7f6e\u7684\u7ef4\u5ea6\u53d8\u91cf%2\u4e0d\u5b58\u5728\u3002", (String)"TemplateVarUtil_1", (String)"epm-eb-spread", (Object[])new Object[]{dimension, number}));
            }
            varMember.setId(Long.valueOf(Long.parseLong(varNameId.split("!")[1])));
            varMember.setNumber(number);
            varMember.setName(varNameId.split("!")[0]);
            returnLists.add(varMember);
        }
        return returnLists;
    }

    public static String checkVarInTemplate(Long taskPack, BizModel model, DynamicObjectCollection varListEntries, List<Long> templateIds, String fromPage) {
        if (!TemplateVarCommonUtil.checkIsVar("isNeedVar", "").booleanValue()) {
            return null;
        }
        HashSet<Long> taskPackSet = new HashSet<Long>(16);
        if (taskPack != null) {
            taskPackSet.add(taskPack);
        }
        HashMap<String, List<String>> taskVariable = new HashMap<String, List<String>>(16);
        Map<Object, Object> accountVarMember = new HashMap(16);
        if (FROM_TASK.equals(fromPage) || FROM_TASKLIST.equals(fromPage)) {
            for (DynamicObject entry : varListEntries) {
                ArrayList<String> var;
                String dimension = entry.getString("dimension.number");
                String string = entry.getDynamicObject("variablenumber").getString("number");
                if (SysDimensionEnum.Account.getNumber().equals(dimension)) {
                    String memberJson = entry.getString("variablejson");
                    accountVarMember.put(string, SerializationUtils.fromJsonString((String)memberJson, Map.class));
                }
                if ((var = (ArrayList<String>)taskVariable.get(dimension)) == null) {
                    var = new ArrayList<String>(16);
                }
                var.add(string);
                taskVariable.put(dimension, var);
            }
        } else {
            Map<Long, Map<String, Map<String, String>>> taskListVariables = TemplateVarCommonUtil.getTaskListVarMapByTaskList(model.getId(), taskPackSet);
            if (taskListVariables.size() != 0) {
                Map<String, Map<String, String>> taskListVariable = taskListVariables.entrySet().iterator().next().getValue();
                for (Map.Entry entry : taskListVariable.entrySet()) {
                    ArrayList varList = new ArrayList(((Map)entry.getValue()).keySet());
                    taskVariable.put((String)entry.getKey(), varList);
                }
            }
            accountVarMember = TemplateVarCommonUtil.getTaskListAccountVarMember(taskPack);
        }
        HashMap<String, List<String>> variables = new HashMap<String, List<String>>(16);
        HashMap<Long, Map<String, List<String>>> variablesInDataset = new HashMap(16);
        if (FROM_TASKLIST.equals(fromPage) || FROM_DISPATCH.equals(fromPage)) {
            DynamicObjectCollection tasks = QueryServiceHelper.query((String)"eb_task", (String)"entryentity.templateid", (QFilter[])new QFilter[]{new QFilter("tasklist", "in", taskPackSet)});
            templateIds = tasks.stream().map(e -> e.getLong("entryentity.templateid")).collect(Collectors.toList());
        }
        if ((variablesInDataset = TemplateVarCommonUtil.getVarDimFromTemplateIds(templateIds)) == null) {
            return null;
        }
        TemplateVarUtil.mergeVariables(variablesInDataset, variables);
        String checkVar = TemplateVarCommonUtil.checkVarAndRetErrMessage(taskVariable, variables, FROM_DISPATCH.equals(fromPage), false);
        String string = TemplateVarCommonUtil.checkAccountVarByMember(accountVarMember, variablesInDataset, model.getId());
        if (StringUtils.isEmpty((CharSequence)checkVar) && StringUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        String errInfo = null;
        errInfo = StringUtils.isEmpty((CharSequence)checkVar) ? string : (StringUtils.isEmpty((CharSequence)string) ? checkVar : checkVar.substring(0, checkVar.length() - 1) + "\uff1b" + string);
        return errInfo;
    }

    public static void mergeVariables(Map<Long, Map<String, List<String>>> variablesInDataset, Map<String, List<String>> variables) {
        for (Map<String, List<String>> variableMap : variablesInDataset.values()) {
            variableMap.forEach((key, value) -> {
                List list = variables.computeIfAbsent((String)key, k -> new ArrayList(16));
                HashSet vars = new HashSet(value);
                vars.addAll(list);
                list.clear();
                list.addAll(vars);
            });
        }
    }

    public static String checkVarInTemplate(BizModel model, DynamicObjectCollection varListEntries, List<Long> bgmdTempIds, Set<Long> applyTempIds) {
        if (!TemplateVarCommonUtil.checkIsVar("isNeedVar", "").booleanValue()) {
            return null;
        }
        HashMap<String, List<String>> schemeVariable = new HashMap<String, List<String>>(16);
        HashMap<String, Map<String, Object>> accountVarMember = new HashMap<String, Map<String, Object>>(16);
        HashMap<String, List<String>> variables = new HashMap<String, List<String>>(16);
        Map<Long, Map<String, List<String>>> variablesInDataset = TemplateVarCommonUtil.getVarDimFromTemplateIds(bgmdTempIds);
        Map<Long, Map<String, Set<String>>> variablesInDataset1 = TemplateVarCommonUtil.getVarDimByApplyTempIds(applyTempIds);
        if (variablesInDataset == null && variablesInDataset1 == null) {
            return null;
        }
        variablesInDataset = TemplateVarUtil.mergeVarInfo(variablesInDataset, variablesInDataset1);
        TemplateVarUtil.mergeVariables(variablesInDataset, variables);
        TemplateVarUtil.getSchemeVariable(varListEntries, accountVarMember, schemeVariable);
        String checkVar = TemplateVarCommonUtil.checkVarAndRetErrMessage(schemeVariable, variables, false, true);
        String checkAccount = TemplateVarCommonUtil.checkAccountVarByMember(accountVarMember, variablesInDataset, model.getId());
        if (StringUtils.isEmpty((CharSequence)checkVar) && StringUtils.isEmpty((CharSequence)checkAccount)) {
            return null;
        }
        String errInfo = null;
        errInfo = StringUtils.isEmpty((CharSequence)checkVar) ? checkAccount : (StringUtils.isEmpty((CharSequence)checkAccount) ? checkVar : checkVar.substring(0, checkVar.length() - 1) + "\uff1b" + checkAccount);
        return errInfo;
    }

    public static Map<Long, Map<String, List<String>>> mergeVarInfo(Map<Long, Map<String, List<String>>> variablesInDataset, Map<Long, Map<String, Set<String>>> variablesInDataset1) {
        if (variablesInDataset == null) {
            variablesInDataset = new HashMap<Long, Map<String, List<String>>>(16);
        }
        if (variablesInDataset1 != null) {
            for (Map.Entry<Long, Map<String, Set<String>>> varEntry : variablesInDataset1.entrySet()) {
                Long datasetId = varEntry.getKey();
                Map<String, Set<String>> varInfo = varEntry.getValue();
                Map dimVars = variablesInDataset.computeIfAbsent(datasetId, key -> new HashMap(16));
                varInfo.forEach((dimNum, varNums) -> {
                    List eVarNums = dimVars.computeIfAbsent(dimNum, key -> new ArrayList(16));
                    eVarNums.addAll(varNums);
                });
            }
        }
        return variablesInDataset;
    }

    public static Map<Long, Map<String, List<String>>> getRefRptSchemeVars(Collection<Long> tempIds) {
        HashMap<Long, Map<String, List<String>>> result = new HashMap<Long, Map<String, List<String>>>(16);
        HashSet<Long> refSchemeIds = new HashSet<Long>();
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"getRefRptSchemeVars", (String)"eb_templateorg", (String)"scheme", (QFilter[])new QFilter("applytemplate", "in", tempIds).toArray(), null);
        Object object = null;
        try {
            for (Row row : dataSet) {
                refSchemeIds.add(row.getLong("scheme"));
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (object != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        Map<Long, Map<String, Map<String, String>>> allVarValueByScheme = ReportVarUtil.queryAllVarValueByScheme(refSchemeIds, false);
        if (allVarValueByScheme == null) {
            return result;
        }
        for (Map.Entry entry : allVarValueByScheme.entrySet()) {
            Long assignRecordId = (Long)entry.getKey();
            Map varInfo = (Map)entry.getValue();
            if (varInfo == null || varInfo.size() == 0) continue;
            Map refAssignVarInfo = result.computeIfAbsent(assignRecordId, e -> new HashMap());
            for (Map.Entry varEntry : varInfo.entrySet()) {
                String dimNum = (String)varEntry.getKey();
                if (varEntry.getValue() == null || ((Map)varEntry.getValue()).size() == 0) continue;
                List dimVarInfo = refAssignVarInfo.computeIfAbsent(dimNum, e -> new ArrayList());
                dimVarInfo.addAll(((Map)varEntry.getValue()).keySet());
            }
        }
        return result;
    }

    public static void getSchemeVariable(DynamicObjectCollection varListEntries, Map<String, Map<String, Object>> accountVarMember, Map<String, List<String>> taskVariable) {
        for (DynamicObject entry : varListEntries) {
            List<String> var;
            String dimension = entry.getString("dimension.number");
            String varNum = entry.getDynamicObject("variablenumber").getString("number");
            if (SysDimensionEnum.Account.getNumber().equals(dimension) && accountVarMember != null) {
                String memberJson = entry.getString("variablejson");
                accountVarMember.put(varNum, (Map<String, Object>)SerializationUtils.fromJsonString((String)memberJson, Map.class));
            }
            if ((var = taskVariable.get(dimension)) == null) {
                var = new ArrayList<String>(16);
            }
            var.add(varNum);
            taskVariable.put(dimension, var);
        }
    }

    public static String checkAccountVar(ITemplateModel templateModel, Collection<String> pageViewDims, Collection<String> colDims, Collection<String> rowDims, Boolean isFix) {
        List<String> memberNumList;
        Long model;
        Long dataSet;
        block6: {
            String accountNum;
            block8: {
                block7: {
                    accountNum = SysDimensionEnum.Account.getNumber();
                    BgTemplate templateBaseInfo = templateModel.getTemplateBaseInfo();
                    dataSet = templateBaseInfo.getDatasetID();
                    model = templateBaseInfo.getModelID();
                    memberNumList = new ArrayList<String>(16);
                    if (!pageViewDims.contains(accountNum)) break block7;
                    List<IPageDimensionEntry> pageMemEntry = templateModel.getPagemembentry();
                    for (IPageDimensionEntry pageMember : pageMemEntry) {
                        if (!accountNum.equals(pageMember.getDimension().getNumber())) continue;
                        memberNumList = pageMember.getMembers().stream().map(IBaseEntry::getNumber).collect(Collectors.toList());
                        break block6;
                    }
                    break block6;
                }
                if (!colDims.contains(accountNum) && !rowDims.contains(accountNum)) break block8;
                List<Object> partition = new ArrayList(16);
                if (isFix.booleanValue()) {
                    return null;
                }
                if (colDims.contains(accountNum)) {
                    partition = templateModel.getPartitionSetting().getColPartition();
                } else if (rowDims.contains(accountNum)) {
                    partition = templateModel.getPartitionSetting().getRowPartition();
                }
                if (partition == null) break block6;
                memberNumList = TemplateVarUtil.getAccountNumbers(partition, accountNum);
                break block6;
            }
            List<IViewPointDimensionEntry> hideDimEntries = templateModel.getViewpointmembentry();
            for (IViewPointDimensionEntry hideDimEntry : hideDimEntries) {
                if (!accountNum.equals(hideDimEntry.getDimension().getNumber())) continue;
                memberNumList = Collections.singletonList(hideDimEntry.getMember().getNumber());
                break;
            }
        }
        return TemplateVarCommonUtil.checkVarOfAccountByDataSet(memberNumList, model, dataSet);
    }

    private static List<String> getAccountNumbers(List<RowColPartition> colPartition, String accountNum) {
        List<String> memberNumList = new ArrayList<String>(16);
        for (RowColPartition col : colPartition) {
            List<IRowColDimensionEntry> rowColDimensionEntries = col.getRowColDimensionEntries();
            for (IRowColDimensionEntry rowColDimensionEntry : rowColDimensionEntries) {
                if (!accountNum.equals(rowColDimensionEntry.getDimension().getNumber())) continue;
                memberNumList = rowColDimensionEntry.getMembers().stream().map(IBaseEntry::getNumber).collect(Collectors.toList());
                break;
            }
            if (memberNumList.size() == 0) continue;
            break;
        }
        return memberNumList;
    }
}

