/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.algo.olap;

import java.io.InputStream;
import java.sql.SQLException;
import java.util.Map;
import kd.epm.eb.algo.olap.Connection;
import kd.epm.eb.algo.olap.Database;
import kd.epm.eb.algo.olap.Engine;
import kd.epm.eb.algo.olap.OlapConfig;
import kd.epm.eb.algo.olap.OlapException;
import kd.epm.eb.algo.olap.def.SchemaDef;
import kd.epm.eb.algo.olap.def.SchemaLoader;
import kd.epm.eb.algo.olap.impl.ConnectionImpl;
import kd.epm.eb.algo.olap.impl.Stats;
import org.apache.log4j.Logger;

public final class Driver {
    private static Logger logger = Logger.getLogger(Driver.class);

    public static Connection openConnection(InputStream schemaDefInputStream, Map param) throws OlapException {
        return Driver.openConnection(schemaDefInputStream, param, new OlapConfig());
    }

    public static Connection openConnection(SchemaDef schemaDef, Map param) throws OlapException {
        return Driver.openConnection(schemaDef, param, new OlapConfig());
    }

    public static Connection openConnection(InputStream schemaDefInputStream, Map param, OlapConfig config) throws OlapException {
        return Driver.openConnection(SchemaLoader.load(schemaDefInputStream), param, config);
    }

    public static Connection openConnection(SchemaDef schemaDef, Map param, OlapConfig config) throws OlapException {
        try {
            Stats stats = new Stats();
            return Driver.openConnection(Engine.buildWithoutCheck(schemaDef, param, config, stats), stats);
        }
        catch (SQLException e) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)"Can't open olap connection.", (Throwable)e);
            }
            throw new OlapException(e);
        }
    }

    public static Connection openConnection(Database db, Stats stats) {
        return new ConnectionImpl(db, stats);
    }
}

