/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.algo.olap;

import java.io.Closeable;
import java.sql.SQLException;
import java.util.Iterator;
import kd.bos.algo.Input;
import kd.bos.algo.InputExecutor;
import kd.bos.algo.Row;
import kd.bos.algo.dataset.input.InputExecutorFactory;
import kd.bos.algo.dataset.input.InputExecutorRowIterator;
import kd.bos.algo.dataset.input.ParallelInputExecutorsRowIterator;
import kd.epm.eb.algo.olap.OlapException;
import kd.epm.eb.algo.olap.RowIteratorTable;
import kd.epm.eb.algo.olap.dbsource.Table;
import kd.epm.eb.algo.olap.dbsource.TableManager;
import kd.epm.eb.algo.olap.dbsource.TableProvider;

public class InputTableProvider
extends TableProvider {
    private Input[] inputs;

    InputTableProvider(TableManager manager, Input ... inputs) {
        super(manager);
        this.inputs = inputs;
    }

    @Override
    public Table createTable() throws SQLException, OlapException {
        if (this.inputs.length == 1) {
            InputExecutorRowIterator iter = new InputExecutorRowIterator(InputExecutorFactory.create((Input)this.inputs[0]));
            return new RowIteratorTable(this.inputs[0].getRowMeta(), (Iterator<Row>)iter, (Closeable)iter);
        }
        InputExecutor[] executors = new InputExecutor[this.inputs.length];
        for (int i = 0; i < this.inputs.length; ++i) {
            executors[i] = InputExecutorFactory.create((Input)this.inputs[i]);
        }
        ParallelInputExecutorsRowIterator iter = new ParallelInputExecutorsRowIterator(executors);
        return new RowIteratorTable(this.inputs[0].getRowMeta(), (Iterator<Row>)iter, (Closeable)iter);
    }
}

