/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.algo.olap.cubedata;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.epm.eb.algo.olap.Aggregator;
import kd.epm.eb.algo.olap.Cell;
import kd.epm.eb.algo.olap.Cube;
import kd.epm.eb.algo.olap.Member;
import kd.epm.eb.algo.olap.OlapConfig;
import kd.epm.eb.algo.olap.OlapException;
import kd.epm.eb.algo.olap.cubedata.CubeData;
import kd.epm.eb.algo.olap.cubedata.CubeDataReader;
import kd.epm.eb.algo.olap.cubedata.DisableAggTester;
import kd.epm.eb.algo.olap.impl.BBFilterIndexes;
import kd.epm.eb.algo.olap.impl.Coordy;
import kd.epm.eb.algo.olap.impl.CubeEvaluateContext;
import kd.epm.eb.algo.olap.impl.EvaluatorImpl;
import kd.epm.eb.algo.olap.impl.MemberImpl;
import kd.epm.eb.algo.olap.impl.MetadataAPIImpl;
import kd.epm.eb.algo.olap.impl.Stats;
import kd.epm.eb.algo.olap.impl.WeightCalculation;
import kd.epm.eb.algo.olap.mdx.Evaluator;
import kd.epm.eb.algo.olap.mdx.MdxQuery;
import kd.epm.eb.algo.olap.mdx.calc.Calc;
import org.apache.log4j.Logger;

public class MemCubeData2
extends CubeData
implements CubeDataReader {
    private static final Logger logger = Logger.getLogger(MemCubeData2.class);
    HashMap<PointWithMembers, Object> detailCubeData = new HashMap();
    HashMap<PointWithMembers, Object> selfData = new HashMap();
    HashMap<PointWithMembers, Object> selfDataRollup = new HashMap();
    HashMap<PointWithMembers, Object> detailCubeCache = new HashMap();
    private OlapConfig config;
    private BBFilterIndexes bbFilterCube;
    private final Coordy coordy;
    private WeightCalculation wc;
    private DisableAggTester disableAggTester;
    private Object[] nullObjects = new Object[0];

    public MemCubeData2(Cube _cube, OlapConfig config) throws OlapException {
        super(_cube);
        this.config = config;
        this.measures = this.cube.getMeasures();
        this.aggs = new Aggregator[this.measures.length];
        for (int i = 0; i < this.aggs.length; ++i) {
            String aggName = (String)this.measures[i].getProperty("aggregator");
            if (aggName == null) continue;
            this.aggs[i] = Aggregator.getAggregator(aggName);
        }
        this.bbFilterCube = new BBFilterIndexes(_cube);
        this.coordy = new Coordy(this.cube.getDimensions(true));
        this.wc = new WeightCalculation(_cube);
        if (!this.wc.hasWeight()) {
            this.wc = null;
        }
        this.disableAggTester = DisableAggTester.get(this.cube);
    }

    @Override
    public void addRecord(Member[] members, Object[] values) throws OlapException {
        boolean isLeaf = true;
        for (int i = 0; i < members.length; ++i) {
            if (members[i].isLeaf()) continue;
            isLeaf = false;
            break;
        }
        if (!(isLeaf || this.config.supportSelfData || this.config.useSelfData)) {
            return;
        }
        if (isLeaf) {
            PointWithMembers p = new PointWithMembers(members, false);
            Object[] vs = (Object[])this.detailCubeData.get(p);
            vs = this.appendValue(vs, values);
            this.detailCubeData.put(p, vs);
            this.buildBB(this.bbFilterCube, members);
        } else {
            PointWithMembers p = new PointWithMembers(members, true);
            Object[] vs = (Object[])this.selfData.get(p);
            vs = this.appendValue(vs, values);
            this.selfData.put(p, vs);
        }
    }

    public void buildBB(Member[] members) {
        this.buildBB(this.bbFilterCube, members);
    }

    private void buildBB(BBFilterIndexes bbFilter, Member[] members) {
        if (bbFilter.inAll(members)) {
            return;
        }
        bbFilter.add(members);
        Member[] members2 = null;
        for (int i = 0; i < members.length; ++i) {
            Member parent = members[i].getParentMember();
            if (parent == null) continue;
            members2 = new Member[members.length];
            System.arraycopy(members, 0, members2, 0, members.length);
            members2[i] = parent;
            this.buildBB(bbFilter, members2);
        }
    }

    @Override
    public void finishAddRecord(Stats stats) throws OlapException {
        if (this.config.supportSelfData && this.selfData.size() > 0) {
            Stats.StatItem item = stats.createStatItem("rollup self data");
            logger.info((Object)"begin rollup self data");
            long begin = System.currentTimeMillis();
            HashSet<Map.Entry<PointWithMembers, Object>> entrySet = new HashSet<Map.Entry<PointWithMembers, Object>>();
            entrySet.addAll(this.selfData.entrySet());
            for (Map.Entry entry : entrySet) {
                Member[] members = ((PointWithMembers)entry.getKey()).ms;
                PointWithMembers.access$002((PointWithMembers)entry.getKey(), null);
                Object[] values = (Object[])entry.getValue();
                this.rollupParentForSelfData(members, values);
            }
            long end = System.currentTimeMillis();
            logger.info((Object)("data rollup cost " + (end - begin) + "ms, size:" + this.selfDataRollup.size()));
            item.append("size:" + this.selfDataRollup.size());
            item.close();
        }
    }

    private void rollupParentForSelfData(Member[] members, Object[] values) throws OlapException {
        HashSet<PointWithMembers> excludePoints = new HashSet<PointWithMembers>();
        for (int i = 0; i < members.length; ++i) {
            if (members[i].getParentMember() == null) continue;
            Member[] tempMembers = new Member[members.length];
            System.arraycopy(members, 0, tempMembers, 0, members.length);
            tempMembers[i] = members[i].getParentMember();
            this._rollupParentForSelfData(i, tempMembers, members, values, excludePoints);
        }
    }

    private void _rollupParentForSelfData(int rollupMemberIndex, Member[] members, Member[] childMembers, Object[] values, HashSet<PointWithMembers> excludePoints) throws OlapException {
        PointWithMembers point = new PointWithMembers(members, false);
        if (excludePoints.contains(point)) {
            return;
        }
        values = this.calcWeight(members, values, rollupMemberIndex);
        Object[] vs = (Object[])this.selfDataRollup.get(point);
        vs = this.appendValue(vs, values);
        this.selfDataRollup.put(point, vs);
        excludePoints.add(point);
        for (int i = 0; i < members.length; ++i) {
            if (members[i].getParentMember() == null) continue;
            Member[] tempMembers = new Member[members.length];
            System.arraycopy(members, 0, tempMembers, 0, members.length);
            tempMembers[i] = members[i].getParentMember();
            this._rollupParentForSelfData(i, tempMembers, members, values, excludePoints);
        }
    }

    public Object[] getByMembers(Member[] members) throws OlapException {
        throw new OlapException("Not supported.");
    }

    @Override
    public Object getByEvaluator(Evaluator evaluator) {
        return this._getByEvaluator((EvaluatorImpl)evaluator, evaluator.getCurrentMembers(), evaluator.getCurrentMeasure());
    }

    public Object _getByEvaluator(Evaluator evaluator, Member[] members, Member measure) {
        int i;
        boolean hasCalc = false;
        boolean allLeaf = true;
        boolean hasDisableAgg = false;
        if (this.disableAggTester != null && this.disableAggTester.test(evaluator.getCurrentMembers())) {
            hasDisableAgg = true;
        }
        for (i = 0; i < members.length; ++i) {
            if (members[i].isLeaf()) continue;
            allLeaf = false;
        }
        for (i = 0; i < members.length; ++i) {
            boolean b = ((MemberImpl)members[i]).hasCalc(!hasDisableAgg);
            if (!b) continue;
            hasCalc = true;
            Calc calc = ((MemberImpl)members[i]).getCalc(members, (EvaluatorImpl)evaluator, !hasDisableAgg, allLeaf);
            if (calc == null) continue;
            return calc.evaluate(evaluator.push());
        }
        if (hasDisableAgg) {
            return null;
        }
        if (!hasCalc) {
            for (i = 0; i < members.length; ++i) {
                if (members[i].hasData()) continue;
                return null;
            }
            if (!this.bbFilterCube.inAll(members)) {
                return null;
            }
        }
        PointWithMembers point = new PointWithMembers(members, false);
        Object[] values = null;
        if (!allLeaf) {
            values = (Object[])this.detailCubeCache.get(point);
            if (values == this.nullObjects) {
                return null;
            }
            if (values != null) {
                return this.fetchMeasureObject(values, measure);
            }
        }
        if ((values = (Object[])this.detailCubeData.get(point)) != null) {
            return this.fetchMeasureObject(values, measure);
        }
        Member[] ms = new Member[members.length];
        System.arraycopy(members, 0, ms, 0, ms.length);
        for (int i2 = 0; i2 < members.length; ++i2) {
            MemberImpl[] children = ((MemberImpl)members[i2]).getChildren();
            if (children == null || children.length <= 0) continue;
            for (int j = 0; j < children.length; ++j) {
                Object[] vs;
                ms[i2] = children[j];
                if (!hasCalc && !ms[i2].hasData() && !ms[i2].hasCalc(true) || (vs = this._getByEvaluatorAllMeasure(evaluator.push(ms), ms)) == null || (vs = this.calcWeight(ms, vs, i2)) == null) continue;
                if (values == null) {
                    values = new Object[this.aggs.length];
                }
                for (int k = 0; k < this.measures.length; ++k) {
                    if (this.aggs[k] == null) continue;
                    values[k] = this.aggs[k].appendAggregator(values[k], vs[k]);
                }
            }
            break;
        }
        if (values == null) {
            this.detailCubeCache.put(point, this.nullObjects);
            return null;
        }
        this.detailCubeCache.put(point, values);
        return this.fetchMeasureObject(values, measure);
    }

    public Object[] _getByEvaluatorAllMeasure(Evaluator evaluator, Member[] currentMembers) {
        Member[] measures = evaluator.getSchemaReader().getCube().getMeasures();
        Object[] values = new Object[measures.length];
        for (int i = 0; i < measures.length; ++i) {
            evaluator.setContext(measures[i]);
            values[i] = this._getByEvaluator(evaluator, currentMembers, measures[i]);
        }
        return values;
    }

    private final Object fetchMeasureObject(Object[] values, Member measure) {
        return values[measure.getOrdinal()];
    }

    private Object[] calcWeight(Member[] ms, Object[] vs, int index) {
        return this.wc == null ? vs : this.wc.calc(ms, vs, index);
    }

    public Object[] appendAggregator(Object[] v1, Object[] v2) throws OlapException {
        if (v1 == null && v2 == null) {
            return null;
        }
        if (v2 == null) {
            return v1;
        }
        if (v1 == null) {
            v1 = new Object[this.measures.length];
            for (int i = 0; i < this.measures.length; ++i) {
                v1[i] = this.aggs[i] == null ? v2[i] : this.aggs[i].appendAggregator(v1[i], v2[i]);
            }
            return v1;
        }
        Object[] result = new Object[v1.length];
        for (int i = 0; i < v1.length; ++i) {
            if (this.aggs[i] == null) {
                if (v2[i] == null) continue;
                if (v1[i] != null) {
                    throw new OlapException("Measure '" + this.measures[i].getName() + "' no aggregator defined.");
                }
                result[i] = v2[i];
                continue;
            }
            result[i] = this.aggs[i].appendAggregator(v1[i], v2[i]);
        }
        return result;
    }

    public Object[] appendValue(Object[] v1, Object[] v2) throws OlapException {
        if (v1 == null && v2 == null) {
            return null;
        }
        if (v2 == null) {
            return v1;
        }
        if (v1 == null) {
            v1 = new Object[v2.length];
            for (int i = 0; i < v1.length; ++i) {
                v1[i] = this.aggs[i] == null ? v2[i] : this.aggs[i].appendValue(v1[i], v2[i]);
            }
            return v1;
        }
        Object[] result = new Object[v1.length];
        for (int i = 0; i < v1.length; ++i) {
            if (this.aggs[i] == null) {
                if (v2[i] == null) continue;
                if (v1[i] != null) {
                    throw new OlapException("Measure '" + this.measures[i].getName() + "' no aggregator defined.");
                }
                result[i] = v2[i];
                continue;
            }
            result[i] = this.aggs[i].appendValue(v1[i], v2[i]);
        }
        return result;
    }

    @Override
    public void finishBuildData(Stats stats) throws OlapException {
        String message = "After finish build data:";
        logger.info((Object)message);
        this.printStatistics(stats);
    }

    @Override
    public void release() {
        this.detailCubeData.clear();
        this.selfData.clear();
        this.selfDataRollup.clear();
        this.detailCubeCache.clear();
    }

    @Override
    public void printStatistics(Stats stats) {
        String message = "All Cuba Data size:" + (this.detailCubeData.size() + this.detailCubeCache.size() + this.selfData.size() + this.selfDataRollup.size());
        this.println(message);
        stats.appendMessage(message);
        message = "    detail data size:" + this.detailCubeData.size();
        this.println(message);
        stats.appendMessage(message);
        if (this.detailCubeCache.size() > 0) {
            message = " detail rollup cache size:" + this.detailCubeCache.size();
            this.println(message);
            stats.appendMessage(message);
        }
        if (this.selfData.size() > 0) {
            message = "    --not detail data size:" + this.selfData.size();
            this.println(message);
            stats.appendMessage(message);
        }
        if (this.selfData.size() > 0) {
            message = "    --not detail data rollup size:" + this.selfDataRollup.size();
            this.println(message);
            stats.appendMessage(message);
        }
    }

    private void println(String message) {
        logger.info((Object)message);
    }

    @Override
    public void setCalcBBFilterIndexes(BBFilterIndexes bbIndexes) {
    }

    @Override
    public Iterator<Cell> cellIterator() {
        throw new OlapException("Not supported, only support with olapConfig.onlyRollupCubes=true");
    }

    @Override
    public void afterBuild(CubeEvaluateContext evaluateContext, MetadataAPIImpl metadataAPI, MdxQuery mdxQuery, List<Map<String, Member>> allLinkMembers) {
    }

    private class PointWithMembers {
        private long coordinate;
        private Member[] ms;
        private int[] keys;
        private transient int h = 0;

        public PointWithMembers(Member[] members, boolean keepMembers) {
            this.ms = new Member[members.length];
            System.arraycopy(members, 0, this.ms, 0, members.length);
            this.keys = new int[members.length];
            for (int i = 0; i < this.keys.length; ++i) {
                this.keys[i] = ((MemberImpl)members[i]).getGlobalOrder();
            }
            this.coordinate = MemCubeData2.this.coordy.getCoord(this.keys);
        }

        public int hashCode() {
            if (this.coordinate > 0L) {
                return (int)(this.coordinate ^ this.coordinate >>> 32);
            }
            if (this.h == 0) {
                this.h = Arrays.hashCode(this.keys);
            }
            return this.h;
        }

        public boolean equals(Object x) {
            if (x == null) {
                return false;
            }
            PointWithMembers p2 = (PointWithMembers)x;
            if (this.coordinate > 0L) {
                return this.coordinate == p2.coordinate;
            }
            int[] keys1 = this.keys;
            int[] keys2 = p2.keys;
            for (int i = 0; i < keys2.length; ++i) {
                if (keys1[i] == keys2[i]) continue;
                return false;
            }
            return true;
        }

        static /* synthetic */ Member[] access$002(PointWithMembers x0, Member[] x1) {
            x0.ms = x1;
            return x1;
        }
    }
}

