/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.algo.olap.cubedata;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.epm.eb.algo.olap.Aggregator;
import kd.epm.eb.algo.olap.Cell;
import kd.epm.eb.algo.olap.Cube;
import kd.epm.eb.algo.olap.Member;
import kd.epm.eb.algo.olap.OlapConfig;
import kd.epm.eb.algo.olap.OlapException;
import kd.epm.eb.algo.olap.cubedata.CubeData;
import kd.epm.eb.algo.olap.cubedata.CubeDataReader;
import kd.epm.eb.algo.olap.cubedata.DisableAggTester;
import kd.epm.eb.algo.olap.cubedata.PointWithMembers;
import kd.epm.eb.algo.olap.impl.BBFilterIndexes;
import kd.epm.eb.algo.olap.impl.Coordy;
import kd.epm.eb.algo.olap.impl.CubeEvaluateContext;
import kd.epm.eb.algo.olap.impl.DimensionImpl;
import kd.epm.eb.algo.olap.impl.EvaluatorImpl;
import kd.epm.eb.algo.olap.impl.MemberImpl;
import kd.epm.eb.algo.olap.impl.MetadataAPIImpl;
import kd.epm.eb.algo.olap.impl.Stats;
import kd.epm.eb.algo.olap.impl.WeightCalculation;
import kd.epm.eb.algo.olap.mdx.Evaluator;
import kd.epm.eb.algo.olap.mdx.MdxQuery;
import kd.epm.eb.algo.olap.mdx.calc.Calc;
import kd.epm.eb.algo.olap.util.BitSetFactory;
import kd.epm.eb.algo.olap.util.LongBitSet;
import kd.epm.eb.algo.olap.util.LongObjectHashMap;
import org.apache.log4j.Logger;

public class MemCubeDataForEas
extends CubeData
implements CubeDataReader {
    private static final Logger logger = Logger.getLogger(MemCubeDataForEas.class);
    LongObjectHashMap<Object> detailCubeData = new LongObjectHashMap();
    LongObjectHashMap<Object> selfData = new LongObjectHashMap();
    LongObjectHashMap<Object> calcCache = new LongObjectHashMap();
    private OlapConfig config;
    private BBFilterIndexes bbFilterCube;
    private BBFilterIndexes bbFilterCalc;
    private final Coordy coordy;
    private WeightCalculation wc;
    private DisableAggTester disableAggTester;
    private LongBitSet nullBitSet = BitSetFactory.createLongBitSet();
    private LongBitSet calculatingBitSet = BitSetFactory.createLongBitSet();
    private int calcDimensionIndex = -1;
    private int cacheSize = 0;

    public MemCubeDataForEas(Cube _cube, OlapConfig config) throws OlapException {
        super(_cube);
        this.config = config;
        this.measures = this.cube.getMeasures();
        this.aggs = new Aggregator[this.measures.length];
        for (int i = 0; i < this.aggs.length; ++i) {
            String aggName = (String)this.measures[i].getProperty("aggregator");
            if (aggName == null) continue;
            this.aggs[i] = Aggregator.getAggregator(aggName);
        }
        this.bbFilterCube = new BBFilterIndexes(_cube);
        this.coordy = new Coordy(this.cube.getDimensions(true));
        this.wc = new WeightCalculation(_cube);
        if (!this.wc.hasWeight()) {
            this.wc = null;
        }
        this.disableAggTester = DisableAggTester.get(this.cube);
    }

    @Override
    public void addRecord(Member[] members, Object[] values) throws OlapException {
        boolean isLeaf = true;
        for (int i = 0; i < members.length; ++i) {
            if (members[i].isLeaf()) continue;
            isLeaf = false;
            break;
        }
        if (isLeaf) {
            PointWithMembers p = new PointWithMembers(this.coordy, members, false);
            for (int i = 0; i < members.length; ++i) {
                ((MemberImpl)members[i]).setHasData(true);
            }
            Object vs = this.detailCubeData.get(p.coordinate);
            vs = this.appendValue(vs, values[0]);
            this.detailCubeData.put(p.coordinate, vs);
            this.buildBB(this.bbFilterCube, members);
        } else if (this.config.supportSelfData) {
            PointWithMembers p = new PointWithMembers(this.coordy, members, true);
            for (int i = 0; i < members.length; ++i) {
                ((MemberImpl)members[i]).setHasData(true);
                ((MemberImpl)members[i]).setHasSelfData(true);
            }
            Object vs = this.selfData.get(p.coordinate);
            vs = this.appendValue(vs, values[0]);
            this.selfData.put(p.coordinate, vs);
            this.buildBB(this.bbFilterCube, members);
        }
    }

    private void buildBB(BBFilterIndexes bbFilter, Member[] members) {
        if (bbFilter.inAll(members)) {
            return;
        }
        bbFilter.add(members);
        Member[] members2 = null;
        for (int i = 0; i < members.length; ++i) {
            Member parent = members[i].getParentMember();
            if (parent == null) continue;
            members2 = new Member[members.length];
            System.arraycopy(members, 0, members2, 0, members.length);
            members2[i] = parent;
            this.buildBB(bbFilter, members2);
        }
    }

    @Override
    public void finishAddRecord(Stats stats) throws OlapException {
    }

    private void putCache(PointWithMembers point, Object value) {
        if (this.cacheSize < this.config.CUBE_CALC_CACHE_MAXSIZE) {
            ++this.cacheSize;
            this.calcCache.put(point.coordinate, value);
        }
    }

    @Override
    public Object getByEvaluator(Evaluator evaluator) {
        if (this.calcDimensionIndex < 0) {
            return this.getByCube((EvaluatorImpl)evaluator, evaluator.getCurrentMembers(), evaluator.getCurrentMeasure());
        }
        return this._getByEvaluator((EvaluatorImpl)evaluator, evaluator.getCurrentMembers(), evaluator.getCurrentMeasure());
    }

    private Object getByCube(EvaluatorImpl evaluator, Member[] currentMembers, Member currentMeasure) {
        if (this.disableAggTester != null && this.disableAggTester.test(currentMembers)) {
            return null;
        }
        PointWithMembers point = new PointWithMembers(this.coordy, currentMembers, false);
        return this._getDataInCube0(currentMembers, point);
    }

    private Object _getByEvaluator(Evaluator evaluator, Member[] members, Member measure) {
        MemberImpl[] children;
        boolean bbFilterCalcTest;
        Calc calc;
        PointWithMembers point = new PointWithMembers(this.coordy, members, false);
        if (this.nullBitSet.get(point.coordinate)) {
            return null;
        }
        Object values = this.calcCache.get(point.coordinate);
        if (values != null) {
            return values;
        }
        boolean allLeaf = true;
        boolean hasDisableAgg = false;
        if (this.disableAggTester != null && this.disableAggTester.test(evaluator.getCurrentMembers())) {
            hasDisableAgg = true;
        }
        for (int i = 0; i < members.length; ++i) {
            if (members[i].isLeaf()) continue;
            allLeaf = false;
        }
        if (this.calcDimensionIndex > -1 && (calc = ((MemberImpl)members[this.calcDimensionIndex]).getCalc(members, (EvaluatorImpl)evaluator, !hasDisableAgg, allLeaf)) != null) {
            if (!this.config.checkLoopDependence) {
                Object value = calc.evaluate(evaluator.push());
                if (value == null) {
                    this.nullBitSet.set(point.coordinate);
                    return null;
                }
                this.putCache(point, value);
                return value;
            }
            if (this.calculatingBitSet.get(point.coordinate)) {
                throw new OlapException("Calc of member " + members[this.calcDimensionIndex].getUniqueName() + " recursive invoked: " + calc.toString());
            }
            this.calculatingBitSet.set(point.coordinate);
            Object value = calc.evaluate(evaluator.push());
            this.calculatingBitSet.remove(point.coordinate);
            if (value == null) {
                this.nullBitSet.set(point.coordinate);
                return null;
            }
            this.putCache(point, value);
            return value;
        }
        if (hasDisableAgg) {
            return null;
        }
        if (allLeaf) {
            return this.detailCubeData.get(point.coordinate);
        }
        boolean bl = bbFilterCalcTest = this.bbFilterCalc != null && this.bbFilterCalc.inOne(members);
        if (!bbFilterCalcTest) {
            if (!this.bbFilterCube.inAll(members)) {
                return null;
            }
            return this.aggInCube(members, point);
        }
        Member[] ms = new Member[members.length];
        System.arraycopy(members, 0, ms, 0, ms.length);
        boolean processed = false;
        for (int i = 0; i < members.length; ++i) {
            MemberImpl[] children2;
            if (this.calcDimensionIndex == i || (children2 = ((MemberImpl)members[i]).getChildren()) == null || children2.length <= 0) continue;
            for (int j = 0; j < children2.length; ++j) {
                ms[i] = children2[j];
                Object vs = null;
                if (this.bbFilterCalc.inOne(ms)) {
                    vs = this._getByEvaluator(evaluator.push(ms), ms, evaluator.getCurrentMeasure());
                } else if (ms[i].hasData()) {
                    vs = this._getDataInCube(ms);
                }
                if (vs == null || (vs = this.calcWeight(ms, vs, i)) == null) continue;
                values = this.appendAggregator(values, vs);
            }
            processed = true;
            break;
        }
        if (!processed && members[this.calcDimensionIndex].isDesendantHasExpression() && (children = ((MemberImpl)members[this.calcDimensionIndex]).getChildren()) != null && children.length > 0) {
            for (int j = 0; j < children.length; ++j) {
                ms[this.calcDimensionIndex] = children[j];
                Object vs = null;
                if (this.bbFilterCalc.inOne(ms)) {
                    vs = this._getByEvaluator(evaluator.push(ms), ms, evaluator.getCurrentMeasure());
                } else if (ms[this.calcDimensionIndex].hasData()) {
                    vs = this._getDataInCube(ms);
                }
                if (vs == null || (vs = this.calcWeight(ms, vs, this.calcDimensionIndex)) == null) continue;
                values = this.appendAggregator(values, vs);
            }
        }
        if (values == null) {
            this.nullBitSet.set(point.coordinate);
            return null;
        }
        return values;
    }

    private Object appendSelf(PointWithMembers point, Object values) {
        if (this.config.supportSelfData && this.selfData.size() > 0) {
            Object vs = this.selfData.get(point.coordinate);
            if (vs == null) {
                return values;
            }
            if (values != null) {
                vs = this.appendValue(vs, values);
            }
            return vs;
        }
        return values;
    }

    private Object _getDataInCube(Member[] members) throws OlapException {
        if (!this.bbFilterCube.inAll(members)) {
            return null;
        }
        PointWithMembers point = new PointWithMembers(this.coordy, members, false);
        return this._getDataInCube0(members, point);
    }

    private Object _getDataInCube0(Member[] members, PointWithMembers point) throws OlapException {
        boolean allLeaf = true;
        for (int i = 0; i < members.length; ++i) {
            if (!members[i].hasData()) {
                return null;
            }
            if (members[i].isLeaf()) continue;
            allLeaf = false;
        }
        if (allLeaf) {
            return this.detailCubeData.get(point.coordinate);
        }
        if (this.nullBitSet.get(point.coordinate)) {
            return null;
        }
        Object values = this.calcCache.get(point.coordinate);
        if (values != null) {
            return values;
        }
        return this.aggInCube(members, point);
    }

    private Object aggInCube(Member[] members, PointWithMembers point) throws OlapException {
        Object values = null;
        Member[] ms = new Member[members.length];
        System.arraycopy(members, 0, ms, 0, ms.length);
        for (int i = 0; i < members.length; ++i) {
            MemberImpl[] children = ((MemberImpl)members[i]).getChildren();
            if (children == null || children.length <= 0) continue;
            for (int j = 0; j < children.length; ++j) {
                Object vs;
                ms[i] = children[j];
                if (!ms[i].hasData() || (vs = this._getDataInCube(ms)) == null || (vs = this.calcWeight(ms, vs, i)) == null) continue;
                values = this.appendAggregator(values, vs);
            }
            break;
        }
        if ((values = this.appendSelf(point, values)) == null) {
            this.nullBitSet.set(point.coordinate);
            return null;
        }
        this.putCache(point, values);
        return values;
    }

    private Object calcWeight(Member[] ms, Object vs, int index) {
        return this.wc == null ? vs : this.wc.calc(ms, vs, index);
    }

    public Object appendAggregator(Object v1, Object v2) throws OlapException {
        return this.aggs[0].appendAggregator(v1, v2);
    }

    public Object appendValue(Object v1, Object v2) throws OlapException {
        return this.aggs[0].appendValue(v1, v2);
    }

    @Override
    public void finishBuildData(Stats stats) throws OlapException {
        String message = "After finish build data:";
        logger.info((Object)message);
        this.printStatistics(stats);
    }

    @Override
    public void release() {
        this.detailCubeData.clear();
        this.selfData.clear();
        this.calcCache.clear();
    }

    @Override
    public void printStatistics(Stats stats) {
        String message = "All Cuba Data size:" + (this.detailCubeData.size() + this.calcCache.size() + this.selfData.size());
        this.println(message);
        stats.appendMessage(message);
        message = "    detail data size:" + this.detailCubeData.size();
        this.println(message);
        stats.appendMessage(message);
        if (this.calcCache.size() > 0) {
            message = " cache data size:" + this.calcCache.size();
            this.println(message);
            stats.appendMessage(message);
        }
        if (this.selfData.size() > 0) {
            message = "    --not detail data size:" + this.selfData.size();
            this.println(message);
            stats.appendMessage(message);
        }
    }

    private void println(String message) {
        logger.info((Object)message);
    }

    @Override
    public void setCalcBBFilterIndexes(BBFilterIndexes bbIndexes) {
        this.bbFilterCalc = bbIndexes;
        DimensionImpl[] dims = (DimensionImpl[])this.cube.getDimensions();
        for (int i = 0; i < dims.length; ++i) {
            if (!dims[i].hasCalcMembers()) continue;
            this.calcDimensionIndex = i;
            break;
        }
    }

    @Override
    public Iterator<Cell> cellIterator() {
        throw new OlapException("Not supported, only support with olapConfig.onlyRollupCubes=true");
    }

    @Override
    public void afterBuild(CubeEvaluateContext evaluateContext, MetadataAPIImpl metadataAPI, MdxQuery mdxQuery, List<Map<String, Member>> allLinkMembers) {
    }
}

