/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.algo.olap.cubedata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.epm.eb.algo.olap.Aggregator;
import kd.epm.eb.algo.olap.Cell;
import kd.epm.eb.algo.olap.Cube;
import kd.epm.eb.algo.olap.LeafFeature;
import kd.epm.eb.algo.olap.Member;
import kd.epm.eb.algo.olap.OlapConfig;
import kd.epm.eb.algo.olap.OlapException;
import kd.epm.eb.algo.olap.cubedata.CubeData;
import kd.epm.eb.algo.olap.cubedata.CubeDataReader;
import kd.epm.eb.algo.olap.cubedata.DisableAggTester;
import kd.epm.eb.algo.olap.cubedata.DisableCalcTester;
import kd.epm.eb.algo.olap.cubedata.PurePoint;
import kd.epm.eb.algo.olap.impl.BBFilterIndex;
import kd.epm.eb.algo.olap.impl.BBFilterIndexes;
import kd.epm.eb.algo.olap.impl.Coordy;
import kd.epm.eb.algo.olap.impl.CubeEvaluateContext;
import kd.epm.eb.algo.olap.impl.DimensionImpl;
import kd.epm.eb.algo.olap.impl.EvaluateContext;
import kd.epm.eb.algo.olap.impl.EvaluatorImpl;
import kd.epm.eb.algo.olap.impl.MemberCalcResult;
import kd.epm.eb.algo.olap.impl.MemberImpl;
import kd.epm.eb.algo.olap.impl.MetadataAPIImpl;
import kd.epm.eb.algo.olap.impl.NotLeafException;
import kd.epm.eb.algo.olap.impl.ScopedCalc;
import kd.epm.eb.algo.olap.impl.Stats;
import kd.epm.eb.algo.olap.impl.WeightCalculation;
import kd.epm.eb.algo.olap.mdx.CellReader;
import kd.epm.eb.algo.olap.mdx.Evaluator;
import kd.epm.eb.algo.olap.mdx.MdxQuery;
import kd.epm.eb.algo.olap.mdx.calc.Calc;
import kd.epm.eb.algo.olap.mdx.calc.impl.func.AggregateCalc;
import kd.epm.eb.algo.olap.util.BitSetFactory;
import kd.epm.eb.algo.olap.util.LongBitSet;
import kd.epm.eb.algo.olap.util.LongObjectHashMap;
import org.apache.log4j.Logger;

public class NewCubeData
extends CubeData
implements CubeDataReader {
    private static final Logger logger = Logger.getLogger(NewCubeData.class);
    private HashMap<PurePoint, Object> pureCubeData = new HashMap();
    private HashMap<PurePoint, Object> pureSelfData = new HashMap();
    private LongObjectHashMap<Object> detailCubeData = new LongObjectHashMap();
    private LongObjectHashMap<Object> selfData = new LongObjectHashMap();
    private LongObjectHashMap<Object> calcCache = new LongObjectHashMap();
    private OlapConfig config;
    private BBFilterIndexes bbFilterCube;
    private Coordy coordy;
    private WeightCalculation wc;
    private DisableAggTester disableAggTester;
    private DisableCalcTester disableCalcTester;
    private LongBitSet nullBitSet = BitSetFactory.createLongBitSet();
    private LongBitSet calculatingBitSet = BitSetFactory.createLongBitSet();
    private int calcDimensionIndex = -1;
    private DimensionImpl calcDimension = null;
    private DimensionImpl[] dimensions = null;
    private int cacheSize = 0;
    private int detailCalcValueCount;
    private Stats stats;
    private int tempCalcCount = 0;

    public NewCubeData(MetadataAPIImpl metadataApi, Cube _cube, OlapConfig config, Stats stats) throws OlapException {
        super(_cube);
        int i;
        this.config = config;
        this.stats = stats;
        this.measures = this.cube.getMeasures();
        this.aggs = new Aggregator[this.measures.length];
        for (i = 0; i < this.aggs.length; ++i) {
            String aggName = (String)this.measures[i].getProperty("aggregator");
            if (aggName == null) continue;
            this.aggs[i] = Aggregator.getAggregator(aggName);
        }
        this.wc = new WeightCalculation(_cube);
        if (!this.wc.hasWeight()) {
            this.wc = null;
        }
        this.disableAggTester = DisableAggTester.get(this.cube);
        this.dimensions = (DimensionImpl[])this.cube.getDimensions();
        for (i = 0; i < this.dimensions.length; ++i) {
            if (!this.dimensions[i].hasCalcMembers()) continue;
            this.calcDimensionIndex = i;
            this.calcDimension = this.dimensions[i];
            break;
        }
    }

    @Override
    public void addRecord(Member[] members, Object[] values) throws OlapException {
        boolean isLeaf = true;
        for (int i = 0; i < members.length; ++i) {
            if (members[i].isLeaf()) continue;
            isLeaf = false;
            break;
        }
        if (isLeaf) {
            PurePoint p = new PurePoint(members);
            for (int i = 0; i < members.length; ++i) {
                ((MemberImpl)members[i]).setHasData(true);
            }
            if (this.config.useLastData) {
                this.pureCubeData.put(p, values[0]);
            } else {
                Object v = this.pureCubeData.get(p);
                v = this.appendValue(v, values[0]);
                this.pureCubeData.put(p, v);
            }
        } else if (this.config.useSelfData || this.config.supportSelfData) {
            PurePoint p = new PurePoint(members);
            for (int i = 0; i < members.length; ++i) {
                ((MemberImpl)members[i]).setHasData(true);
                ((MemberImpl)members[i]).setHasSelfData(true);
            }
            if (this.config.useLastData) {
                this.pureSelfData.put(p, values[0]);
            } else {
                Object v = this.pureSelfData.get(p);
                v = this.appendValue(v, values[0]);
                this.pureSelfData.put(p, v);
            }
        }
    }

    private void buildBB(BBFilterIndexes bbFilter, Member[] members) {
        if (bbFilter.inAll(members)) {
            return;
        }
        bbFilter.add(members);
        Member[] members2 = null;
        for (int i = 0; i < members.length; ++i) {
            Member parent = members[i].getParentMember();
            if (parent == null) continue;
            members2 = new Member[members.length];
            System.arraycopy(members, 0, members2, 0, members.length);
            members2[i] = parent;
            this.buildBB(bbFilter, members2);
        }
    }

    @Override
    public void finishAddRecord(Stats stats) throws OlapException {
    }

    @Override
    public void afterBuild(CubeEvaluateContext evaluateContext, MetadataAPIImpl metadataAPI, MdxQuery mdxQuery, List<Map<String, Member>> allLinkMembers) {
        this.trimEmptyMember(evaluateContext, metadataAPI, mdxQuery, allLinkMembers);
        this.pureCubeData = null;
    }

    private boolean isNotFakeInLink(List<Map<String, Member>> allLinkMembers, String uniqueName) {
        if (allLinkMembers != null) {
            for (Map<String, Member> map : allLinkMembers) {
                Member member = map.get(uniqueName);
                if (member == null || ((MemberImpl)member).isFake()) continue;
                return true;
            }
        }
        return false;
    }

    private void trimEmptyMember(CubeEvaluateContext evaluateContext, MetadataAPIImpl metadataAPI, MdxQuery mdxQuery, List<Map<String, Member>> allLinkMembers) {
        Evaluator evaluator = evaluateContext.createEvaluator();
        if (this.calcDimensionIndex > -1) {
            this.calcDimension.markScopeMembers(evaluator);
        }
        HashSet<Member> inCubeMembers = new HashSet<Member>();
        for (PurePoint purePoint : this.pureCubeData.keySet()) {
            inCubeMembers.addAll(Arrays.asList(purePoint.getMembers()));
        }
        for (PurePoint purePoint : this.pureSelfData.keySet()) {
            inCubeMembers.addAll(Arrays.asList(purePoint.getMembers()));
        }
        for (DimensionImpl dim : this.dimensions) {
            boolean flag = false;
            Iterator<Member> leafMemberIter = dim.leafMemberIterator();
            while (leafMemberIter.hasNext()) {
                MemberImpl member = (MemberImpl)leafMemberIter.next();
                if (inCubeMembers.contains(member) || member.isInScope() || member.hasCalc(false) || member.isInner() || this.isNotFakeInLink(allLinkMembers, member.getUniqueName())) continue;
                member.setIsFake(true);
                flag = true;
            }
            if (!flag) continue;
            dim.rebuildMembers();
            int originCount = dim.getMemberCount();
            int newCount = dim.getRealMemberCount();
            this.stats.appendMessage("Trim dimension members of " + dim.getName() + " from " + originCount + " to " + newCount);
        }
        this.coordy = new Coordy(this.cube.getDimensions(true));
        this.bbFilterCube = new BBFilterIndexes(this.cube);
        for (Map.Entry<PurePoint, Object> entry : this.pureCubeData.entrySet()) {
            PointWithMembers pointWithMembers = new PointWithMembers(this.coordy, entry.getKey().getMembers(), false);
            this.detailCubeData.put(pointWithMembers.coordinate, entry.getValue());
            this.buildBB(this.bbFilterCube, entry.getKey().getMembers());
        }
        for (Map.Entry<PurePoint, Object> entry : this.pureSelfData.entrySet()) {
            PointWithMembers pointWithMembers = new PointWithMembers(this.coordy, entry.getKey().getMembers(), false);
            if (this.config.useSelfData) {
                this.calcCache.put(pointWithMembers.coordinate, entry.getValue());
            }
            if (this.config.supportSelfData) {
                this.selfData.put(pointWithMembers.coordinate, entry.getValue());
            }
            this.buildBB(this.bbFilterCube, entry.getKey().getMembers());
        }
        this.pureCubeData = null;
        this.pureSelfData = null;
        this.detailCubeData.put(Long.MAX_VALUE, null);
        if (metadataAPI.getDisableCalcDimMembers() != null && metadataAPI.getDisableCalcMembers() != null) {
            this.disableCalcTester = new DisableCalcTester().init(metadataAPI.getDisableCalcDimMembers(), this.cube, metadataAPI.getDisableCalcMembers());
        }
    }

    private void processLeafCalc(CubeEvaluateContext evaluateContext) {
        Set<MemberImpl> memberSet = this.calcDimension.getCalcMembersOfLeaf();
        if (memberSet == null) {
            return;
        }
        HashMap<MemberImpl, Calc> defaultMemberCalcs = new HashMap<MemberImpl, Calc>();
        HashMap<MemberImpl, List<ScopedCalc>> memberScopedCalcs = new HashMap<MemberImpl, List<ScopedCalc>>();
        Evaluator ev = evaluateContext.createEvaluator();
        TempCalcEvaluatorImpl0 evaluator = new TempCalcEvaluatorImpl0(evaluateContext, this.cube, ((EvaluatorImpl)ev).getCellReader());
        for (MemberImpl memberImpl : memberSet) {
            Calc calc = memberImpl.getMemberCalcFeature(evaluator).getDefaultLeafCalc();
            if (calc != null) {
                defaultMemberCalcs.put(memberImpl, calc);
                continue;
            }
            List<ScopedCalc> leafCalcs = memberImpl.getMemberCalcFeature(evaluator).getLeafCalcs();
            if (leafCalcs == null) continue;
            memberScopedCalcs.put(memberImpl, leafCalcs);
        }
        HashMap<PointWithMembers, Object> calcDetailCache = new HashMap<PointWithMembers, Object>();
        evaluator.setDefaultMemberCalcsMap(defaultMemberCalcs);
        evaluator.setLeafScopedCalcsMap(memberScopedCalcs);
        evaluator.setCalcCache(calcDetailCache);
        for (MemberImpl calcMember : memberSet) {
            Member[] members = new Member[this.dimensions.length];
            members[this.calcDimensionIndex] = calcMember;
            this.doTempCalcLoop0(0, members, evaluator);
        }
        int n = this.detailCubeData.size();
        for (Map.Entry entry : evaluator.calcDetailCache.entrySet()) {
            PointWithMembers p = (PointWithMembers)entry.getKey();
            Member[] members = p.ms;
            p.ms = null;
            for (int i = 0; i < members.length; ++i) {
                ((MemberImpl)members[i]).setHasData(true);
            }
            this.detailCubeData.put(p.coordinate, entry.getValue());
            this.buildBB(this.bbFilterCube, members);
        }
        for (MemberImpl calcMember : memberSet) {
            calcMember.getMemberCalcFeature(evaluator).removeLeafCalcs();
        }
        if (!evaluator.calcDetailCache.isEmpty()) {
            logger.info((Object)("Original detail cube data size:" + n + ", calc detail data size: " + evaluator.calcDetailCache.size()));
            logger.info((Object)("detailCalcValueCount:" + this.detailCalcValueCount));
        }
    }

    private void doTempCalcLoop0(int n, Member[] members, TempCalcEvaluatorImpl0 evaluator) {
        if (n == this.calcDimensionIndex) {
            ++n;
        }
        if (n == members.length) {
            this.executeTempCalc0(members, evaluator);
            ++this.tempCalcCount;
            return;
        }
        Iterator<Member> iter = this.dimensions[n].leafMemberIterator();
        while (iter.hasNext()) {
            members[n] = iter.next();
            this.doTempCalcLoop0(n + 1, members, evaluator);
        }
    }

    private void executeTempCalc0(Member[] members, TempCalcEvaluatorImpl0 evaluator) {
        List list;
        PointWithMembers point = new PointWithMembers(this.coordy, members, true);
        Calc calc = (Calc)evaluator.defaultMemberCalcsMap.get(members[this.calcDimensionIndex]);
        if (calc == null && (list = (List)evaluator.memberScopedCalcMap.get(members[this.calcDimensionIndex])) != null) {
            for (ScopedCalc sc : list) {
                if (!sc.validate(members, evaluator)) continue;
                calc = sc.getCalc();
                break;
            }
        }
        if (calc != null) {
            try {
                evaluator.setContext(members);
                Object value = calc.evaluate(evaluator);
                if (value != null) {
                    evaluator.calcDetailCache.put(point, value);
                }
            }
            catch (NotLeafException e) {
                evaluator.calcDetailCache.put(point, calc);
                ++this.detailCalcValueCount;
            }
        }
    }

    private void putCache(PointWithMembers point, Object value) {
        if (point.coordinate == Long.MAX_VALUE) {
            return;
        }
        if (this.cacheSize < this.config.CUBE_CALC_CACHE_MAXSIZE) {
            ++this.cacheSize;
            this.calcCache.put(point.coordinate, value);
        }
    }

    private void putCache(long coordinate, Object value) {
        if (coordinate == Long.MAX_VALUE) {
            return;
        }
        if (this.cacheSize < this.config.CUBE_CALC_CACHE_MAXSIZE) {
            ++this.cacheSize;
            this.calcCache.put(coordinate, value);
        }
    }

    private void putCacheIncludeNull(long coordinate, Object value) {
        if (coordinate == Long.MAX_VALUE) {
            return;
        }
        if (value == null) {
            this.nullBitSet.set(coordinate);
        } else if (this.cacheSize < this.config.CUBE_CALC_CACHE_MAXSIZE) {
            ++this.cacheSize;
            this.calcCache.put(coordinate, value);
        }
    }

    private void putCache(Member[] members, Object value) {
        if (this.cacheSize < this.config.CUBE_CALC_CACHE_MAXSIZE) {
            ++this.cacheSize;
            this.calcCache.put(NewCubeData.calcCoordinate(this.coordy, members), value);
        }
    }

    public Object getCache(PointWithMembers point) {
        if (point.coordinate == Long.MAX_VALUE) {
            return null;
        }
        return this.calcCache.get(point.coordinate);
    }

    public Object getCache(Member[] members) {
        return this.calcCache.get(NewCubeData.calcCoordinate(this.coordy, members));
    }

    public Object getCache(long coordinate) {
        if (coordinate == Long.MAX_VALUE) {
            return null;
        }
        return this.calcCache.get(coordinate);
    }

    public final Object getDetailData(PointWithMembers point, Evaluator evaluator) {
        return this.detailCubeData.get(point.coordinate);
    }

    @Override
    public Object getByEvaluator(Evaluator evaluator) {
        if (this.calcDimensionIndex < 0) {
            return this.getByCube((EvaluatorImpl)evaluator, evaluator.getCurrentMembers());
        }
        return this._getByEvaluator((EvaluatorImpl)evaluator, evaluator.getCurrentMembers());
    }

    private Object getByCube(EvaluatorImpl evaluator, Member[] currentMembers) {
        if (this.disableAggTester != null && this.disableAggTester.test(currentMembers)) {
            return null;
        }
        if (!this.bbFilterCube.inAll(currentMembers)) {
            return null;
        }
        PointWithMembers point = new PointWithMembers(this.coordy, currentMembers, false);
        if (point.isFake) {
            return null;
        }
        return this._getDataInCube0(evaluator, currentMembers, point);
    }

    private Object evaluateCalc(Evaluator evaluator, Calc calc, PointWithMembers point) {
        Object value = calc.evaluate(evaluator);
        if (value == null) {
            if (point.coordinate != Long.MAX_VALUE) {
                this.nullBitSet.set(point.coordinate);
            }
        } else {
            this.putCache(point, value);
        }
        return value;
    }

    private Object _getByEvaluator(Evaluator evaluator, Member[] members) {
        PointWithMembers point = new PointWithMembers(this.coordy, members, false);
        if (point.isFake) {
            return null;
        }
        boolean allLeaf = true;
        for (int i = 0; i < members.length; ++i) {
            if (members[i].isLeaf()) continue;
            allLeaf = false;
            break;
        }
        if (this.nullBitSet.get(point.coordinate)) {
            return null;
        }
        Object values = this.calcCache.get(point.coordinate);
        if (values != null) {
            return values;
        }
        MemberCalcResult mcr = allLeaf && this.disableCalcTester != null && this.disableCalcTester.test(members) ? null : ((MemberImpl)members[this.calcDimensionIndex]).getMemberCalcFeature(evaluator).query(members, allLeaf, evaluator);
        if (mcr == null) {
            if (!this.bbFilterCube.inAll(members)) {
                return null;
            }
            if (this.disableAggTester != null && this.disableAggTester.test(members)) {
                return null;
            }
            return this._getDataInCube1(evaluator, members, point, allLeaf);
        }
        if (mcr.calc != null) {
            if (!this.config.checkLoopDependence) {
                if (mcr.calc instanceof AggregateCalc && this.disableAggTester != null && this.disableAggTester.test(members)) {
                    return null;
                }
                return this.evaluateCalc(evaluator.push(), mcr.calc, point);
            }
            if (this.calculatingBitSet.get(point.coordinate)) {
                throw new OlapException("Calc of member " + members[this.calcDimensionIndex].getUniqueName() + " recursive invoked: " + mcr.calc.toString());
            }
            this.calculatingBitSet.set(point.coordinate);
            if (mcr.calc instanceof AggregateCalc && this.disableAggTester != null && this.disableAggTester.test(members)) {
                return null;
            }
            Object value = this.evaluateCalc(evaluator.push(), mcr.calc, point);
            this.calculatingBitSet.remove(point.coordinate);
            return value;
        }
        if (this.disableAggTester != null && this.disableAggTester.test(evaluator.getCurrentMembers())) {
            return null;
        }
        if (mcr.notLeafScopedCalcList != null && this.config.FOREAS) {
            ScopedCalc[] scs = null;
            if (mcr.leafScopedCalcList == null) {
                scs = mcr.notLeafScopedCalcList.toArray(new ScopedCalc[mcr.notLeafScopedCalcList.size()]);
                if (scs.length == 1) {
                    ScopedCalc sc = scs[0];
                    BBFilterIndex bbFilter = sc.getBBFilter();
                    int[] ordinals = sc.getDimOrdinals();
                    int ordinalsFlag = 0;
                    for (int i = 0; i < ordinals.length; ++i) {
                        ordinalsFlag = (int)((long)ordinalsFlag | 1L << ordinals[i]);
                    }
                    boolean othersLeaf = true;
                    for (int i = 0; i < members.length; ++i) {
                        if (((long)ordinalsFlag & 1L << i) != 0L || members[i].isLeaf()) continue;
                        othersLeaf = false;
                        break;
                    }
                    return this._getByNotLeafScopedCalc(evaluator, members, sc, bbFilter, ordinals, ordinalsFlag, othersLeaf);
                }
                int[] ordinalsFlags = new int[scs.length];
                BBFilterIndex[] bbFilters = new BBFilterIndex[scs.length];
                int overlapedOrdinalsFlag = 0;
                for (int i = 0; i < scs.length; ++i) {
                    bbFilters[i] = scs[i].getBBFilter();
                    int[] ordinals = scs[i].getDimOrdinals();
                    int ordinalsFlag = 0;
                    for (int j = 0; j < ordinals.length; ++j) {
                        ordinalsFlag = (int)((long)ordinalsFlag | 1L << ordinals[j]);
                    }
                    ordinalsFlags[i] = ordinalsFlag;
                    overlapedOrdinalsFlag |= ordinalsFlag;
                }
                boolean othersLeaf = true;
                for (int i = 0; i < members.length; ++i) {
                    if (((long)overlapedOrdinalsFlag & 1L << i) != 0L || members[i].isLeaf()) continue;
                    othersLeaf = false;
                    break;
                }
                return this._getByNotLeafScopedCalc(evaluator, members, scs, bbFilters, overlapedOrdinalsFlag, othersLeaf);
            }
            ArrayList<ScopedCalc> list = new ArrayList<ScopedCalc>();
            list.addAll(mcr.notLeafScopedCalcList);
            for (ScopedCalc sc : mcr.leafScopedCalcList) {
                if (list.contains(sc)) continue;
                list.add(sc);
            }
            scs = list.toArray(new ScopedCalc[list.size()]);
            if (scs.length == 1) {
                ScopedCalc sc = scs[0];
                BBFilterIndex bbFilter = sc.getBBFilter();
                int[] ordinals = sc.getDimOrdinals();
                int ordinalsFlag = 0;
                for (int i = 0; i < ordinals.length; ++i) {
                    ordinalsFlag = (int)((long)ordinalsFlag | 1L << ordinals[i]);
                }
                return this._getByBothScopedCalc(evaluator, members, sc, bbFilter, ordinals, ordinalsFlag);
            }
            int[] ordinalsFlags = new int[scs.length];
            BBFilterIndex[] bbFilters = new BBFilterIndex[scs.length];
            int overlapedOrdinalsFlag = 0;
            for (int i = 0; i < scs.length; ++i) {
                bbFilters[i] = scs[i].getBBFilter();
                int[] ordinals = scs[i].getDimOrdinals();
                int ordinalsFlag = 0;
                for (int j = 0; j < ordinals.length; ++j) {
                    ordinalsFlag = (int)((long)ordinalsFlag | 1L << ordinals[j]);
                }
                ordinalsFlags[i] = ordinalsFlag;
                overlapedOrdinalsFlag |= ordinalsFlag;
            }
            return this._getByBothScopedCalc(evaluator, members, scs, bbFilters, overlapedOrdinalsFlag);
        }
        if (mcr.leafScopedCalcList != null) {
            ScopedCalc[] scs = mcr.leafScopedCalcList.toArray(new ScopedCalc[mcr.leafScopedCalcList.size()]);
            if (scs.length == 1) {
                ScopedCalc sc = scs[0];
                BBFilterIndex bbFilter = sc.getBBFilter();
                int[] ordinals = sc.getDimOrdinals();
                int ordinalsFlag = 0;
                for (int i = 0; i < ordinals.length; ++i) {
                    ordinalsFlag = (int)((long)ordinalsFlag | 1L << ordinals[i]);
                }
                boolean othersLeaf = true;
                for (int i = 0; i < members.length; ++i) {
                    if (((long)ordinalsFlag & 1L << i) != 0L || members[i].isLeaf()) continue;
                    othersLeaf = false;
                    break;
                }
                return this._getByLeafScopedCalc(evaluator, members, sc, bbFilter, ordinals, ordinalsFlag, othersLeaf);
            }
            int[] ordinalsFlags = new int[scs.length];
            BBFilterIndex[] bbFilters = new BBFilterIndex[scs.length];
            int overlapedOrdinalsFlag = 0;
            for (int i = 0; i < scs.length; ++i) {
                bbFilters[i] = scs[i].getBBFilter();
                int[] ordinals = scs[i].getDimOrdinals();
                int ordinalsFlag = 0;
                for (int j = 0; j < ordinals.length; ++j) {
                    ordinalsFlag = (int)((long)ordinalsFlag | 1L << ordinals[j]);
                }
                ordinalsFlags[i] = ordinalsFlag;
                overlapedOrdinalsFlag |= ordinalsFlag;
            }
            boolean othersLeaf = true;
            for (int i = 0; i < members.length; ++i) {
                if (((long)overlapedOrdinalsFlag & 1L << i) != 0L || members[i].isLeaf()) continue;
                othersLeaf = false;
                break;
            }
            return this._getByLeafScopedCalc(evaluator, members, scs, bbFilters, overlapedOrdinalsFlag, othersLeaf);
        }
        throw new OlapException("Shouldn't go here.");
    }

    private Object _getByBothScopedCalc(Evaluator evaluator, Member[] members, ScopedCalc sc, BBFilterIndex bbFilter, int[] ordinals, int ordinalsFlag) {
        Object values = null;
        Member[] ms = new Member[members.length];
        System.arraycopy(members, 0, ms, 0, ms.length);
        boolean processed = false;
        long coordinate = -1L;
        for (int i = 0; i < ordinals.length; ++i) {
            MemberImpl[] children = ((MemberImpl)members[ordinals[i]]).getRealOrOriginChildren();
            if (children == null || children.length <= 0) continue;
            for (int j = 0; j < children.length; ++j) {
                ms[ordinals[i]] = children[j];
                coordinate = NewCubeData.calcCoordinate(this.coordy, ms);
                Object vs = null;
                if (this.nullBitSet.get(coordinate) || (vs = this.getCache(coordinate)) != null) continue;
                if (sc.validate(ms)) {
                    vs = sc.calc.evaluate(evaluator.push(ms));
                } else if (bbFilter.get(ms)) {
                    vs = this._getByBothScopedCalc(evaluator, ms, sc, bbFilter, ordinals, ordinalsFlag);
                } else if (ms[ordinals[i]].hasData()) {
                    vs = this._getDataInCube(evaluator, ms);
                }
                if (vs == null || (vs = this.calcWeight(ms, vs, ordinals[i])) == null) continue;
                values = values == null ? vs : this.appendAggregator(values, vs);
            }
            processed = true;
            break;
        }
        if (!processed) {
            return this._aggByBothScopedCalc(evaluator, members, ms, sc, bbFilter, ordinalsFlag);
        }
        return values;
    }

    private Object _aggByBothScopedCalc(Evaluator evaluator, Member[] members, ScopedCalc sc, BBFilterIndex bbFilter, int ordinalsFlag) {
        Member[] ms = new Member[members.length];
        System.arraycopy(members, 0, ms, 0, ms.length);
        return this._aggByBothScopedCalc(evaluator, members, ms, sc, bbFilter, ordinalsFlag);
    }

    private Object _aggByBothScopedCalc(Evaluator evaluator, Member[] members, Member[] tempMs, ScopedCalc sc, BBFilterIndex bbFilter, int ordinalsFlag) {
        Object values = null;
        Member[] ms = tempMs;
        System.arraycopy(members, 0, ms, 0, ms.length);
        long coordinate = -1L;
        for (int i = 0; i < members.length; ++i) {
            MemberImpl[] children;
            if (((long)ordinalsFlag & 1L << i) != 0L || (children = ((MemberImpl)members[i]).getRealOrOriginChildren()) == null || children.length <= 0) continue;
            for (int j = 0; j < children.length; ++j) {
                ms[i] = children[j];
                coordinate = NewCubeData.calcCoordinate(this.coordy, ms);
                Object vs = null;
                if (this.nullBitSet.get(coordinate) || (vs = this.getCache(coordinate)) != null) continue;
                if (sc.validate(ms)) {
                    vs = sc.calc.evaluate(evaluator.push(ms));
                } else if (bbFilter.get(ms)) {
                    vs = this._aggByBothScopedCalc(evaluator, ms, sc, bbFilter, ordinalsFlag);
                } else if (ms[i].hasData()) {
                    vs = this._getDataInCube(evaluator, ms);
                }
                if (vs == null || (vs = this.calcWeight(ms, vs, i)) == null) continue;
                values = values == null ? vs : this.appendAggregator(values, vs);
            }
            break;
        }
        return values;
    }

    private Object _getByLeafScopedCalc(Evaluator evaluator, Member[] members, ScopedCalc[] baseScs, boolean[] scSelecteds) {
        ArrayList<ScopedCalc> list = new ArrayList<ScopedCalc>();
        for (int i = 0; i < scSelecteds.length; ++i) {
            if (!scSelecteds[i]) continue;
            list.add(baseScs[i]);
        }
        if (list.size() == 1) {
            ScopedCalc sc = (ScopedCalc)list.get(0);
            BBFilterIndex bbFilter = sc.getBBFilter();
            int[] ordinals = sc.getDimOrdinals();
            int ordinalsFlag = 0;
            for (int i = 0; i < ordinals.length; ++i) {
                ordinalsFlag = (int)((long)ordinalsFlag | 1L << ordinals[i]);
            }
            boolean othersLeaf = true;
            for (int i = 0; i < members.length; ++i) {
                if (((long)ordinalsFlag & 1L << i) != 0L || members[i].isLeaf()) continue;
                othersLeaf = false;
                break;
            }
            return this._getByLeafScopedCalc(evaluator, members, sc, bbFilter, ordinals, ordinalsFlag, othersLeaf);
        }
        ScopedCalc[] scs = list.toArray(new ScopedCalc[list.size()]);
        int[] ordinalsFlags = new int[scs.length];
        BBFilterIndex[] bbFilters = new BBFilterIndex[scs.length];
        int overlapedOrdinalsFlag = 0;
        for (int i = 0; i < scs.length; ++i) {
            bbFilters[i] = scs[i].getBBFilter();
            int[] ordinals = scs[i].getDimOrdinals();
            int ordinalsFlag = 0;
            for (int j = 0; j < ordinals.length; ++j) {
                ordinalsFlag = (int)((long)ordinalsFlag | 1L << ordinals[j]);
            }
            ordinalsFlags[i] = ordinalsFlag;
            overlapedOrdinalsFlag |= ordinalsFlag;
        }
        boolean othersLeaf = true;
        for (int i = 0; i < members.length; ++i) {
            if (((long)overlapedOrdinalsFlag & 1L << i) != 0L || members[i].isLeaf()) continue;
            othersLeaf = false;
            break;
        }
        return this._getByLeafScopedCalc(evaluator, members, scs, bbFilters, overlapedOrdinalsFlag, othersLeaf);
    }

    private Object _getByNotLeafScopedCalc(Evaluator evaluator, Member[] members, ScopedCalc[] baseScs, boolean[] scSelecteds) {
        ArrayList<ScopedCalc> list = new ArrayList<ScopedCalc>();
        for (int i = 0; i < scSelecteds.length; ++i) {
            if (!scSelecteds[i]) continue;
            list.add(baseScs[i]);
        }
        if (list.size() == 1) {
            ScopedCalc sc = (ScopedCalc)list.get(0);
            BBFilterIndex bbFilter = sc.getBBFilter();
            int[] ordinals = sc.getDimOrdinals();
            int ordinalsFlag = 0;
            for (int i = 0; i < ordinals.length; ++i) {
                ordinalsFlag = (int)((long)ordinalsFlag | 1L << ordinals[i]);
            }
            boolean othersLeaf = true;
            for (int i = 0; i < members.length; ++i) {
                if (((long)ordinalsFlag & 1L << i) != 0L || members[i].isLeaf()) continue;
                othersLeaf = false;
                break;
            }
            return this._getByNotLeafScopedCalc(evaluator, members, sc, bbFilter, ordinals, ordinalsFlag, othersLeaf);
        }
        ScopedCalc[] scs = list.toArray(new ScopedCalc[list.size()]);
        int[] ordinalsFlags = new int[scs.length];
        BBFilterIndex[] bbFilters = new BBFilterIndex[scs.length];
        int overlapedOrdinalsFlag = 0;
        for (int i = 0; i < scs.length; ++i) {
            bbFilters[i] = scs[i].getBBFilter();
            int[] ordinals = scs[i].getDimOrdinals();
            int ordinalsFlag = 0;
            for (int j = 0; j < ordinals.length; ++j) {
                ordinalsFlag = (int)((long)ordinalsFlag | 1L << ordinals[j]);
            }
            ordinalsFlags[i] = ordinalsFlag;
            overlapedOrdinalsFlag |= ordinalsFlag;
        }
        boolean othersLeaf = true;
        for (int i = 0; i < members.length; ++i) {
            if (((long)overlapedOrdinalsFlag & 1L << i) != 0L || members[i].isLeaf()) continue;
            othersLeaf = false;
            break;
        }
        return this._getByNotLeafScopedCalc(evaluator, members, scs, bbFilters, overlapedOrdinalsFlag, othersLeaf);
    }

    private Object _getByBothScopedCalc(Evaluator evaluator, Member[] members, ScopedCalc[] baseScs, boolean[] scSelecteds) {
        ArrayList<ScopedCalc> list = new ArrayList<ScopedCalc>();
        for (int i = 0; i < scSelecteds.length; ++i) {
            if (!scSelecteds[i]) continue;
            list.add(baseScs[i]);
        }
        if (list.size() == 1) {
            ScopedCalc sc = (ScopedCalc)list.get(0);
            BBFilterIndex bbFilter = sc.getBBFilter();
            int[] ordinals = sc.getDimOrdinals();
            int ordinalsFlag = 0;
            for (int i = 0; i < ordinals.length; ++i) {
                ordinalsFlag = (int)((long)ordinalsFlag | 1L << ordinals[i]);
            }
            boolean othersLeaf = true;
            if (sc.leafFeature != LeafFeature.ALL) {
                for (int i = 0; i < members.length; ++i) {
                    if (((long)ordinalsFlag & 1L << i) != 0L || members[i].isLeaf()) continue;
                    othersLeaf = false;
                    break;
                }
            }
            switch (sc.leafFeature) {
                case ALL: {
                    return this._getByBothScopedCalc(evaluator, members, sc, bbFilter, ordinals, ordinalsFlag);
                }
                case LEAF: {
                    return this._getByLeafScopedCalc(evaluator, members, sc, bbFilter, ordinals, ordinalsFlag, othersLeaf);
                }
            }
            return this._getByNotLeafScopedCalc(evaluator, members, sc, bbFilter, ordinals, ordinalsFlag, othersLeaf);
        }
        ScopedCalc[] scs = list.toArray(new ScopedCalc[list.size()]);
        int[] ordinalsFlags = new int[scs.length];
        BBFilterIndex[] bbFilters = new BBFilterIndex[scs.length];
        int overlapedOrdinalsFlag = 0;
        boolean hasLeaf = false;
        boolean hasNotLeaf = false;
        for (int i = 0; i < scs.length; ++i) {
            hasLeaf = hasLeaf || scs[i].leafFeature.contains(true);
            hasNotLeaf = hasNotLeaf || scs[i].leafFeature.contains(false);
            bbFilters[i] = scs[i].getBBFilter();
            int[] ordinals = scs[i].getDimOrdinals();
            int ordinalsFlag = 0;
            for (int j = 0; j < ordinals.length; ++j) {
                ordinalsFlag = (int)((long)ordinalsFlag | 1L << ordinals[j]);
            }
            ordinalsFlags[i] = ordinalsFlag;
            overlapedOrdinalsFlag |= ordinalsFlag;
        }
        boolean othersLeaf = true;
        if (!hasLeaf || !hasNotLeaf) {
            for (int i = 0; i < members.length; ++i) {
                if (((long)overlapedOrdinalsFlag & 1L << i) != 0L || members[i].isLeaf()) continue;
                othersLeaf = false;
                break;
            }
        }
        if (hasLeaf && hasNotLeaf) {
            return this._getByBothScopedCalc(evaluator, members, scs, bbFilters, overlapedOrdinalsFlag);
        }
        if (hasLeaf) {
            return this._getByLeafScopedCalc(evaluator, members, scs, bbFilters, overlapedOrdinalsFlag, othersLeaf);
        }
        return this._getByNotLeafScopedCalc(evaluator, members, scs, bbFilters, overlapedOrdinalsFlag, othersLeaf);
    }

    private Object _getByNotLeafScopedCalc(Evaluator evaluator, Member[] members, ScopedCalc sc, BBFilterIndex bbFilter, int[] ordinals, int ordinalsFlag, boolean othersLeaf) {
        Object values = null;
        Member[] ms = new Member[members.length];
        System.arraycopy(members, 0, ms, 0, ms.length);
        boolean processed = false;
        long coordinate = -1L;
        for (int i = 0; i < ordinals.length; ++i) {
            MemberImpl[] children = ((MemberImpl)members[ordinals[i]]).getRealOrOriginChildren();
            if (children == null || children.length <= 0) continue;
            for (int j = 0; j < children.length; ++j) {
                ms[ordinals[i]] = children[j];
                coordinate = NewCubeData.calcCoordinate(this.coordy, ms);
                Object vs = null;
                if (!othersLeaf || this.isNotLeaf(ms, ordinals)) {
                    if (!this.nullBitSet.get(coordinate) && (vs = this.getCache(coordinate)) == null) {
                        if (sc.validate(ms)) {
                            vs = sc.calc.evaluate(evaluator.push(ms));
                            this.putCacheIncludeNull(coordinate, vs);
                        } else if (bbFilter.get(ms)) {
                            vs = this._getByNotLeafScopedCalc(evaluator, ms, sc, bbFilter, ordinals, ordinalsFlag, othersLeaf);
                            this.putCacheIncludeNull(coordinate, vs);
                        } else if (ms[ordinals[i]].hasData()) {
                            vs = this._getDataInCube(evaluator, ms);
                        }
                    }
                } else if (ms[ordinals[i]].hasData()) {
                    vs = this._getDataInCube(evaluator, ms);
                }
                if (vs == null || (vs = this.calcWeight(ms, vs, ordinals[i])) == null) continue;
                values = values == null ? vs : this.appendAggregator(values, vs);
            }
            processed = true;
            break;
        }
        if (!processed) {
            return this._aggByNotLeafScopedCalc(evaluator, members, ms, sc, bbFilter, ordinalsFlag);
        }
        return values;
    }

    private Object _getByLeafScopedCalc(Evaluator evaluator, Member[] members, ScopedCalc sc, BBFilterIndex bbFilter, int[] ordinals, int ordinalsFlag, boolean othersLeaf) {
        Object vs;
        int j;
        MemberImpl[] children;
        int i;
        Object values = null;
        Member[] ms = new Member[members.length];
        System.arraycopy(members, 0, ms, 0, ms.length);
        boolean processed = false;
        for (i = 0; i < ordinals.length; ++i) {
            children = ((MemberImpl)members[ordinals[i]]).getRealOrOriginChildren();
            if (children == null || children.length <= 0) continue;
            for (j = 0; j < children.length; ++j) {
                ms[ordinals[i]] = children[j];
                vs = null;
                if (othersLeaf && this.isLeaf(ms, ordinals)) {
                    if (sc.validate(ms)) {
                        vs = sc.calc.evaluate(evaluator.push(ms));
                    } else if (ms[ordinals[i]].hasData()) {
                        vs = this._getDataInCube(evaluator, ms);
                    }
                } else if (bbFilter.get(ms)) {
                    vs = this._getByLeafScopedCalc(evaluator, ms, sc, bbFilter, ordinals, ordinalsFlag, othersLeaf);
                } else if (ms[ordinals[i]].hasData()) {
                    vs = this._getDataInCube(evaluator, ms);
                }
                if (vs == null || (vs = this.calcWeight(ms, vs, ordinals[i])) == null) continue;
                values = values == null ? vs : this.appendAggregator(values, vs);
            }
            processed = true;
            break;
        }
        if (!processed) {
            for (i = 0; i < members.length; ++i) {
                if (((long)ordinalsFlag & 1L << i) != 0L || (children = ((MemberImpl)members[i]).getRealOrOriginChildren()) == null || children.length <= 0) continue;
                for (j = 0; j < children.length; ++j) {
                    ms[i] = children[j];
                    vs = null;
                    if (ms[i].isLeaf() && this.isLeaf(ms)) {
                        if (sc.validate(ms) && (this.disableCalcTester == null || !this.disableCalcTester.test(ms))) {
                            vs = sc.calc.evaluate(evaluator.push(ms));
                        } else if (ms[i].hasData()) {
                            vs = this._getDataInCube(evaluator, ms);
                        }
                    } else if (bbFilter.get(ms)) {
                        vs = this._aggByLeafScopedCalc(evaluator.push(ms), ms, sc, bbFilter, ordinalsFlag);
                    } else if (ms[i].hasData()) {
                        vs = this._getDataInCube(evaluator, ms);
                    }
                    if (vs == null || (vs = this.calcWeight(ms, vs, i)) == null) continue;
                    values = values == null ? vs : this.appendAggregator(values, vs);
                }
                break;
            }
        }
        return values;
    }

    private boolean isLeaf(Member[] members) {
        for (int i = 0; i < members.length; ++i) {
            if (members[i].isLeaf()) continue;
            return false;
        }
        return true;
    }

    private boolean isNotLeaf(Member[] members) {
        for (int i = 0; i < members.length; ++i) {
            if (!members[i].isLeaf()) continue;
            return false;
        }
        return true;
    }

    private boolean isLeaf(Member[] members, int[] ordinals) {
        for (int i = 0; i < ordinals.length; ++i) {
            if (members[ordinals[i]].isLeaf()) continue;
            return false;
        }
        return true;
    }

    private boolean isNotLeaf(Member[] members, int[] ordinals) {
        for (int i = 0; i < ordinals.length; ++i) {
            if (!members[ordinals[i]].isLeaf()) continue;
            return false;
        }
        return true;
    }

    private Object _getByLeafScopedCalc(Evaluator evaluator, Member[] members, ScopedCalc[] scs, BBFilterIndex[] bbFilters, int overlapedOrdinalsFlag, boolean othersLeaf) {
        Object values = null;
        Member[] ms = new Member[members.length];
        System.arraycopy(members, 0, ms, 0, ms.length);
        boolean processed = false;
        for (int i = 0; i < members.length; ++i) {
            MemberImpl[] children;
            if (((long)overlapedOrdinalsFlag & 1L << i) == 0L || (children = ((MemberImpl)members[i]).getRealOrOriginChildren()) == null || children.length <= 0) continue;
            for (int j = 0; j < children.length; ++j) {
                ms[i] = children[j];
                Object vs = null;
                boolean found = false;
                if (othersLeaf && this.isLeaf(ms)) {
                    for (ScopedCalc sc : scs) {
                        if (!sc.validate(ms)) continue;
                        vs = sc.calc.evaluate(evaluator.push(ms));
                        found = true;
                        break;
                    }
                    if (!found && ms[i].hasData()) {
                        vs = this.detailCubeData.get(this.getCoordinate(ms));
                    }
                } else {
                    boolean[] scSelecteds = new boolean[scs.length];
                    int count = 0;
                    for (int m = 0; m < scs.length; ++m) {
                        if (!scs[m].inBBFilter(ms)) continue;
                        scSelecteds[m] = true;
                        ++count;
                    }
                    if (count == scs.length) {
                        vs = this._getByLeafScopedCalc(evaluator, ms, scs, bbFilters, overlapedOrdinalsFlag, othersLeaf);
                    } else if (count > 0) {
                        vs = this._getByLeafScopedCalc(evaluator, ms, scs, scSelecteds);
                    } else if (ms[i].hasData()) {
                        vs = this._getDataInCube(evaluator, ms);
                    }
                }
                if (vs == null || (vs = this.calcWeight(ms, vs, i)) == null) continue;
                values = values == null ? vs : this.appendAggregator(values, vs);
            }
            processed = true;
            break;
        }
        if (!processed) {
            return this._aggByLeafScopedCalc(evaluator, members, ms, scs, bbFilters, overlapedOrdinalsFlag);
        }
        return values;
    }

    private Object _getByNotLeafScopedCalc(Evaluator evaluator, Member[] members, ScopedCalc[] scs, BBFilterIndex[] bbFilters, int overlapedOrdinalsFlag, boolean othersLeaf) {
        Object values = null;
        Member[] ms = new Member[members.length];
        System.arraycopy(members, 0, ms, 0, ms.length);
        boolean processed = false;
        long coordinate = -1L;
        for (int i = 0; i < members.length; ++i) {
            MemberImpl[] children;
            if (((long)overlapedOrdinalsFlag & 1L << i) == 0L || (children = ((MemberImpl)members[i]).getRealOrOriginChildren()) == null || children.length <= 0) continue;
            for (int j = 0; j < children.length; ++j) {
                ms[i] = children[j];
                coordinate = NewCubeData.calcCoordinate(this.coordy, ms);
                Object vs = null;
                boolean found = false;
                if (!othersLeaf || this.isNotLeaf(ms)) {
                    if (!this.nullBitSet.get(coordinate) && (vs = this.getCache(coordinate)) == null) {
                        for (ScopedCalc sc : scs) {
                            if (!sc.validate(ms)) continue;
                            vs = sc.calc.evaluate(evaluator.push(ms));
                            this.putCacheIncludeNull(coordinate, vs);
                            found = true;
                            break;
                        }
                        if (!found) {
                            boolean[] scSelecteds = new boolean[scs.length];
                            int count = 0;
                            for (int m = 0; m < scs.length; ++m) {
                                if (!scs[m].inBBFilter(ms)) continue;
                                scSelecteds[m] = true;
                                ++count;
                            }
                            if (count == scs.length) {
                                vs = this._getByNotLeafScopedCalc(evaluator, ms, scs, bbFilters, overlapedOrdinalsFlag, othersLeaf);
                            } else if (count > 0) {
                                vs = this._getByNotLeafScopedCalc(evaluator, ms, scs, scSelecteds);
                            } else if (ms[i].hasData()) {
                                vs = this._getDataInCube(evaluator, ms);
                            }
                        }
                    }
                } else if (ms[i].hasData()) {
                    vs = this._getDataInCube(evaluator, ms);
                }
                if (vs == null || (vs = this.calcWeight(ms, vs, i)) == null) continue;
                values = values == null ? vs : this.appendAggregator(values, vs);
            }
            processed = true;
            break;
        }
        if (!processed) {
            return this._aggByNotLeafScopedCalc(evaluator, members, ms, scs, bbFilters, overlapedOrdinalsFlag);
        }
        return values;
    }

    private Object _getByBothScopedCalc(Evaluator evaluator, Member[] members, ScopedCalc[] scs, BBFilterIndex[] bbFilters, int overlapedOrdinalsFlag) {
        Object values = null;
        Member[] ms = new Member[members.length];
        System.arraycopy(members, 0, ms, 0, ms.length);
        boolean processed = false;
        long coordinate = -1L;
        for (int i = 0; i < members.length; ++i) {
            MemberImpl[] children;
            if (((long)overlapedOrdinalsFlag & 1L << i) == 0L || (children = ((MemberImpl)members[i]).getRealOrOriginChildren()) == null || children.length <= 0) continue;
            for (int j = 0; j < children.length; ++j) {
                ms[i] = children[j];
                coordinate = NewCubeData.calcCoordinate(this.coordy, ms);
                Object vs = null;
                if (!this.nullBitSet.get(coordinate) && (vs = this.getCache(coordinate)) == null) {
                    boolean found = false;
                    for (ScopedCalc sc : scs) {
                        if (!sc.validate(ms)) continue;
                        vs = sc.calc.evaluate(evaluator.push(ms));
                        found = true;
                        break;
                    }
                    if (!found) {
                        boolean[] scSelecteds = new boolean[scs.length];
                        int count = 0;
                        for (int m = 0; m < scs.length; ++m) {
                            if (!scs[m].inBBFilter(ms)) continue;
                            scSelecteds[m] = true;
                            ++count;
                        }
                        if (count == scs.length) {
                            vs = this._getByBothScopedCalc(evaluator, ms, scs, bbFilters, overlapedOrdinalsFlag);
                        } else if (count > 0) {
                            vs = this._getByBothScopedCalc(evaluator, ms, scs, scSelecteds);
                        } else if (ms[i].hasData()) {
                            vs = this._getDataInCube(evaluator, ms);
                        }
                    }
                }
                if (vs == null || (vs = this.calcWeight(ms, vs, i)) == null) continue;
                values = values == null ? vs : this.appendAggregator(values, vs);
            }
            processed = true;
            break;
        }
        if (!processed) {
            return this._aggByBothScopedCalc(evaluator, members, ms, scs, bbFilters, overlapedOrdinalsFlag);
        }
        return values;
    }

    private Object _aggByLeafScopedCalc(Evaluator evaluator, Member[] members, ScopedCalc[] scs, BBFilterIndex[] bbFilters, int overlapedOrdinalsFlag) {
        Member[] tempMs = new Member[members.length];
        System.arraycopy(members, 0, tempMs, 0, tempMs.length);
        return this._aggByLeafScopedCalc(evaluator, members, tempMs, scs, bbFilters, overlapedOrdinalsFlag);
    }

    private Object _aggByNotLeafScopedCalc(Evaluator evaluator, Member[] members, ScopedCalc[] scs, BBFilterIndex[] bbFilters, int overlapedOrdinalsFlag) {
        Member[] tempMs = new Member[members.length];
        System.arraycopy(members, 0, tempMs, 0, tempMs.length);
        return this._aggByNotLeafScopedCalc(evaluator, members, tempMs, scs, bbFilters, overlapedOrdinalsFlag);
    }

    private Object _aggByLeafScopedCalc(Evaluator evaluator, Member[] members, Member[] tempMs, ScopedCalc[] scs, BBFilterIndex[] bbFilters, int overlapedOrdinalsFlag) {
        Object values = null;
        Member[] ms = tempMs;
        for (int i = 0; i < members.length; ++i) {
            MemberImpl[] children;
            if (((long)overlapedOrdinalsFlag & 1L << i) != 0L || (children = ((MemberImpl)members[i]).getRealOrOriginChildren()) == null || children.length <= 0) continue;
            for (int j = 0; j < children.length; ++j) {
                ms[i] = children[j];
                Object vs = null;
                boolean found = false;
                if (ms[i].isLeaf() && this.isLeaf(ms)) {
                    for (ScopedCalc sc : scs) {
                        if (!sc.validate(ms)) continue;
                        vs = sc.calc.evaluate(evaluator.push(ms));
                        found = true;
                        break;
                    }
                    if (!found && ms[i].hasData()) {
                        vs = this.detailCubeData.get(this.getCoordinate(ms));
                    }
                } else {
                    boolean[] scSelecteds = new boolean[scs.length];
                    int count = 0;
                    for (int m = 0; m < scs.length; ++m) {
                        if (!scs[m].inBBFilter(ms)) continue;
                        scSelecteds[m] = true;
                        ++count;
                    }
                    if (count == scs.length) {
                        vs = this._aggByLeafScopedCalc(evaluator, ms, scs, bbFilters, overlapedOrdinalsFlag);
                    } else if (count > 0) {
                        vs = this._aggByLeafScopedCalc(evaluator, ms, scs, scSelecteds);
                    } else if (ms[i].hasData()) {
                        vs = this._getDataInCube(evaluator, ms);
                    }
                }
                if (vs == null || (vs = this.calcWeight(ms, vs, i)) == null) continue;
                values = values == null ? vs : this.appendAggregator(values, vs);
            }
            break;
        }
        return values;
    }

    private Object _aggByNotLeafScopedCalc(Evaluator evaluator, Member[] members, Member[] tempMs, ScopedCalc[] scs, BBFilterIndex[] bbFilters, int overlapedOrdinalsFlag) {
        Object values = null;
        Member[] ms = tempMs;
        long coordinate = -1L;
        for (int i = 0; i < members.length; ++i) {
            MemberImpl[] children;
            if (((long)overlapedOrdinalsFlag & 1L << i) != 0L || (children = ((MemberImpl)members[i]).getRealOrOriginChildren()) == null || children.length <= 0) continue;
            for (int j = 0; j < children.length; ++j) {
                ms[i] = children[j];
                coordinate = NewCubeData.calcCoordinate(this.coordy, ms);
                Object vs = null;
                boolean found = false;
                if (!ms[i].isLeaf() || this.isNotLeaf(ms)) {
                    if (!this.nullBitSet.get(coordinate) && (vs = this.getCache(coordinate)) == null) {
                        for (ScopedCalc sc : scs) {
                            if (!sc.validate(ms)) continue;
                            vs = sc.calc.evaluate(evaluator.push(ms));
                            this.putCacheIncludeNull(coordinate, vs);
                            found = true;
                            break;
                        }
                        if (!found) {
                            boolean[] scSelecteds = new boolean[scs.length];
                            int count = 0;
                            for (int m = 0; m < scs.length; ++m) {
                                if (!scs[m].inBBFilter(ms)) continue;
                                scSelecteds[m] = true;
                                ++count;
                            }
                            if (count == scs.length) {
                                vs = this._aggByNotLeafScopedCalc(evaluator, ms, scs, bbFilters, overlapedOrdinalsFlag);
                            } else if (count > 0) {
                                vs = this._aggByNotLeafScopedCalc(evaluator, ms, scs, scSelecteds);
                            } else if (ms[i].hasData()) {
                                vs = this._getDataInCube(evaluator, ms);
                            }
                        }
                    }
                } else if (ms[i].hasData()) {
                    vs = this._getDataInCube(evaluator, ms);
                }
                if (vs == null || (vs = this.calcWeight(ms, vs, i)) == null) continue;
                values = values == null ? vs : this.appendAggregator(values, vs);
            }
            break;
        }
        return values;
    }

    private Object _aggByBothScopedCalc(Evaluator evaluator, Member[] members, ScopedCalc[] scs, BBFilterIndex[] bbFilters, int overlapedOrdinalsFlag) {
        Member[] ms = new Member[members.length];
        System.arraycopy(members, 0, ms, 0, ms.length);
        return this._aggByBothScopedCalc(evaluator, members, ms, scs, bbFilters, overlapedOrdinalsFlag);
    }

    private Object _aggByBothScopedCalc(Evaluator evaluator, Member[] members, Member[] tempMs, ScopedCalc[] scs, BBFilterIndex[] bbFilters, int overlapedOrdinalsFlag) {
        Object values = null;
        Member[] ms = tempMs;
        long coordinate = -1L;
        for (int i = 0; i < members.length; ++i) {
            MemberImpl[] children;
            if (((long)overlapedOrdinalsFlag & 1L << i) != 0L || (children = ((MemberImpl)members[i]).getRealOrOriginChildren()) == null || children.length <= 0) continue;
            for (int j = 0; j < children.length; ++j) {
                ms[i] = children[j];
                coordinate = NewCubeData.calcCoordinate(this.coordy, ms);
                Object vs = null;
                if (!this.nullBitSet.get(coordinate) && (vs = this.getCache(coordinate)) == null) {
                    boolean found = false;
                    for (ScopedCalc sc : scs) {
                        if (!sc.validate(ms)) continue;
                        vs = sc.calc.evaluate(evaluator.push(ms));
                        found = true;
                        break;
                    }
                    if (!found) {
                        boolean[] scSelecteds = new boolean[scs.length];
                        int count = 0;
                        for (int m = 0; m < scs.length; ++m) {
                            if (!scs[m].inBBFilter(ms)) continue;
                            scSelecteds[m] = true;
                            ++count;
                        }
                        if (count == scs.length) {
                            vs = this._aggByBothScopedCalc(evaluator, ms, scs, bbFilters, overlapedOrdinalsFlag);
                        } else if (count > 0) {
                            vs = this._aggByBothScopedCalc(evaluator, ms, scs, scSelecteds);
                        } else if (ms[i].hasData()) {
                            vs = this._getDataInCube(evaluator, ms);
                        }
                    }
                }
                if (vs == null || (vs = this.calcWeight(ms, vs, i)) == null) continue;
                values = values == null ? vs : this.appendAggregator(values, vs);
            }
            break;
        }
        return values;
    }

    private Object _aggByLeafScopedCalc(Evaluator evaluator, Member[] members, ScopedCalc[] baseScs, boolean[] scSelecteds) {
        ArrayList<ScopedCalc> list = new ArrayList<ScopedCalc>();
        for (int i = 0; i < scSelecteds.length; ++i) {
            if (!scSelecteds[i]) continue;
            list.add(baseScs[i]);
        }
        if (list.size() == 1) {
            ScopedCalc sc = (ScopedCalc)list.get(0);
            BBFilterIndex bbFilter = sc.getBBFilter();
            int[] ordinals = sc.getDimOrdinals();
            int ordinalsFlag = 0;
            for (int i = 0; i < ordinals.length; ++i) {
                ordinalsFlag = (int)((long)ordinalsFlag | 1L << ordinals[i]);
            }
            return this._aggByLeafScopedCalc(evaluator, members, sc, bbFilter, ordinalsFlag);
        }
        ScopedCalc[] scs = list.toArray(new ScopedCalc[list.size()]);
        int[] ordinalsFlags = new int[scs.length];
        BBFilterIndex[] bbFilters = new BBFilterIndex[scs.length];
        int overlapedOrdinalsFlag = 0;
        for (int i = 0; i < scs.length; ++i) {
            bbFilters[i] = scs[i].getBBFilter();
            int[] ordinals = scs[i].getDimOrdinals();
            int ordinalsFlag = 0;
            for (int j = 0; j < ordinals.length; ++j) {
                ordinalsFlag = (int)((long)ordinalsFlag | 1L << ordinals[j]);
            }
            ordinalsFlags[i] = ordinalsFlag;
            overlapedOrdinalsFlag |= ordinalsFlag;
        }
        return this._aggByLeafScopedCalc(evaluator, members, scs, bbFilters, overlapedOrdinalsFlag);
    }

    private Object _aggByNotLeafScopedCalc(Evaluator evaluator, Member[] members, ScopedCalc[] baseScs, boolean[] scSelecteds) {
        ArrayList<ScopedCalc> list = new ArrayList<ScopedCalc>();
        for (int i = 0; i < scSelecteds.length; ++i) {
            if (!scSelecteds[i]) continue;
            list.add(baseScs[i]);
        }
        if (list.size() == 1) {
            ScopedCalc sc = (ScopedCalc)list.get(0);
            BBFilterIndex bbFilter = sc.getBBFilter();
            int[] ordinals = sc.getDimOrdinals();
            int ordinalsFlag = 0;
            for (int i = 0; i < ordinals.length; ++i) {
                ordinalsFlag = (int)((long)ordinalsFlag | 1L << ordinals[i]);
            }
            return this._aggByNotLeafScopedCalc(evaluator, members, sc, bbFilter, ordinalsFlag);
        }
        ScopedCalc[] scs = list.toArray(new ScopedCalc[list.size()]);
        int[] ordinalsFlags = new int[scs.length];
        BBFilterIndex[] bbFilters = new BBFilterIndex[scs.length];
        int overlapedOrdinalsFlag = 0;
        for (int i = 0; i < scs.length; ++i) {
            bbFilters[i] = scs[i].getBBFilter();
            int[] ordinals = scs[i].getDimOrdinals();
            int ordinalsFlag = 0;
            for (int j = 0; j < ordinals.length; ++j) {
                ordinalsFlag = (int)((long)ordinalsFlag | 1L << ordinals[j]);
            }
            ordinalsFlags[i] = ordinalsFlag;
            overlapedOrdinalsFlag |= ordinalsFlag;
        }
        return this._aggByNotLeafScopedCalc(evaluator, members, scs, bbFilters, overlapedOrdinalsFlag);
    }

    private Object _aggByBothScopedCalc(Evaluator evaluator, Member[] members, ScopedCalc[] baseScs, boolean[] scSelecteds) {
        ArrayList<ScopedCalc> list = new ArrayList<ScopedCalc>();
        for (int i = 0; i < scSelecteds.length; ++i) {
            if (!scSelecteds[i]) continue;
            list.add(baseScs[i]);
        }
        if (list.size() == 1) {
            ScopedCalc sc = (ScopedCalc)list.get(0);
            BBFilterIndex bbFilter = sc.getBBFilter();
            int[] ordinals = sc.getDimOrdinals();
            int ordinalsFlag = 0;
            for (int i = 0; i < ordinals.length; ++i) {
                ordinalsFlag = (int)((long)ordinalsFlag | 1L << ordinals[i]);
            }
            return this._aggByBothScopedCalc(evaluator, members, sc, bbFilter, ordinalsFlag);
        }
        ScopedCalc[] scs = list.toArray(new ScopedCalc[list.size()]);
        int[] ordinalsFlags = new int[scs.length];
        BBFilterIndex[] bbFilters = new BBFilterIndex[scs.length];
        int overlapedOrdinalsFlag = 0;
        for (int i = 0; i < scs.length; ++i) {
            bbFilters[i] = scs[i].getBBFilter();
            int[] ordinals = scs[i].getDimOrdinals();
            int ordinalsFlag = 0;
            for (int j = 0; j < ordinals.length; ++j) {
                ordinalsFlag = (int)((long)ordinalsFlag | 1L << ordinals[j]);
            }
            ordinalsFlags[i] = ordinalsFlag;
            overlapedOrdinalsFlag |= ordinalsFlag;
        }
        return this._aggByBothScopedCalc(evaluator, members, scs, bbFilters, overlapedOrdinalsFlag);
    }

    private Object _aggByLeafScopedCalc(Evaluator evaluator, Member[] members, ScopedCalc sc, BBFilterIndex bbFilter, int ordinalsFlag) {
        Member[] ms = new Member[members.length];
        System.arraycopy(members, 0, ms, 0, ms.length);
        return this._aggByLeafScopedCalc(evaluator, members, ms, sc, bbFilter, ordinalsFlag);
    }

    private Object _aggByLeafScopedCalc(Evaluator evaluator, Member[] members, Member[] tempMs, ScopedCalc sc, BBFilterIndex bbFilter, int ordinalsFlag) {
        Object values = null;
        Member[] ms = tempMs;
        for (int i = 0; i < members.length; ++i) {
            MemberImpl[] children;
            if (((long)ordinalsFlag & 1L << i) != 0L || (children = ((MemberImpl)members[i]).getRealOrOriginChildren()) == null || children.length <= 0) continue;
            for (int j = 0; j < children.length; ++j) {
                ms[i] = children[j];
                Object vs = null;
                if (ms[i].isLeaf() && this.isLeaf(ms)) {
                    if (sc.validate(ms) && (this.disableCalcTester == null || !this.disableCalcTester.test(ms))) {
                        vs = sc.calc.evaluate(evaluator.push(ms));
                    } else if (ms[i].hasData()) {
                        vs = this.detailCubeData.get(this.getCoordinate(ms));
                    }
                } else if (bbFilter.get(ms)) {
                    vs = this._aggByLeafScopedCalc(evaluator, ms, sc, bbFilter, ordinalsFlag);
                } else if (ms[i].hasData()) {
                    vs = this._getDataInCube(evaluator, ms);
                }
                if (vs == null || (vs = this.calcWeight(ms, vs, i)) == null) continue;
                values = values == null ? vs : this.appendAggregator(values, vs);
            }
            break;
        }
        return values;
    }

    private Object _aggByNotLeafScopedCalc(Evaluator evaluator, Member[] members, ScopedCalc sc, BBFilterIndex bbFilter, int ordinalsFlag) {
        Member[] ms = new Member[members.length];
        System.arraycopy(members, 0, ms, 0, ms.length);
        return this._aggByNotLeafScopedCalc(evaluator, members, ms, sc, bbFilter, ordinalsFlag);
    }

    private Object _aggByNotLeafScopedCalc(Evaluator evaluator, Member[] members, Member[] tempMs, ScopedCalc sc, BBFilterIndex bbFilter, int ordinalsFlag) {
        Object values = null;
        Member[] ms = tempMs;
        long coordinate = -1L;
        for (int i = 0; i < members.length; ++i) {
            MemberImpl[] children;
            if (((long)ordinalsFlag & 1L << i) != 0L || (children = ((MemberImpl)members[i]).getRealOrOriginChildren()) == null || children.length <= 0) continue;
            for (int j = 0; j < children.length; ++j) {
                ms[i] = children[j];
                coordinate = NewCubeData.calcCoordinate(this.coordy, ms);
                Object vs = null;
                if (!(ms[i].isLeaf() && !this.isNotLeaf(ms) || this.nullBitSet.get(coordinate))) {
                    vs = this.getCache(coordinate);
                    if (vs == null) {
                        if (sc.validate(ms)) {
                            vs = sc.calc.evaluate(evaluator.push(ms));
                            this.putCacheIncludeNull(coordinate, vs);
                        } else if (bbFilter.get(ms)) {
                            vs = this._aggByNotLeafScopedCalc(evaluator, ms, sc, bbFilter, ordinalsFlag);
                            this.putCacheIncludeNull(coordinate, vs);
                        } else if (ms[i].hasData()) {
                            vs = this._getDataInCube(evaluator, ms);
                        }
                    } else if (ms[i].hasData()) {
                        vs = this._getDataInCube(evaluator, ms);
                    }
                }
                if (vs == null || (vs = this.calcWeight(ms, vs, i)) == null) continue;
                values = values == null ? vs : this.appendAggregator(values, vs);
            }
            break;
        }
        return values;
    }

    private Object appendSelf(PointWithMembers point, Object values) {
        if (this.config.supportSelfData && this.selfData.size() > 0) {
            Object vs = this.selfData.get(point.coordinate);
            if (vs == null) {
                return values;
            }
            if (values != null) {
                vs = this.appendValue(vs, values);
            }
            return vs;
        }
        return values;
    }

    private Object _getDataInCube(Evaluator evaluator, Member[] members) throws OlapException {
        if (!this.bbFilterCube.inAll(members)) {
            return null;
        }
        PointWithMembers point = new PointWithMembers(this.coordy, members, false);
        return this._getDataInCube0(evaluator, members, point);
    }

    private Object _getDataInCube0(Evaluator evaluator, Member[] members, PointWithMembers point) throws OlapException {
        boolean allLeaf = true;
        for (int i = 0; i < members.length; ++i) {
            if (!members[i].hasData()) {
                return null;
            }
            if (members[i].isLeaf()) continue;
            allLeaf = false;
        }
        return this._getDataInCube1(evaluator, members, point, allLeaf);
    }

    private Object _getDataInCube1(Evaluator evaluator, Member[] members, PointWithMembers point, boolean leaf) throws OlapException {
        if (leaf) {
            return this.getDetailData(point, evaluator);
        }
        if (this.nullBitSet.get(point.coordinate)) {
            return null;
        }
        Object values = this.calcCache.get(point.coordinate);
        if (values != null) {
            return values;
        }
        return this.aggInCube(evaluator, members, point);
    }

    private Object aggInCube(Evaluator evaluator, Member[] members, PointWithMembers point) throws OlapException {
        Object values = null;
        Member[] ms = new Member[members.length];
        System.arraycopy(members, 0, ms, 0, ms.length);
        for (int i = 0; i < members.length; ++i) {
            MemberImpl[] children = ((MemberImpl)members[i]).getRealOrOriginChildren();
            if (children == null || children.length <= 0) continue;
            for (int j = 0; j < children.length; ++j) {
                Object vs;
                ms[i] = children[j];
                if (!ms[i].hasData() || (vs = this._getDataInCube(evaluator, ms)) == null || (vs = this.calcWeight(ms, vs, i)) == null) continue;
                values = values == null ? vs : this.appendAggregator(values, vs);
            }
            break;
        }
        if ((values = this.appendSelf(point, values)) == null) {
            if (point.coordinate != Long.MAX_VALUE) {
                this.nullBitSet.set(point.coordinate);
            }
            return null;
        }
        this.calcCache.put(point.coordinate, values);
        return values;
    }

    public Object _getByTempCalc0(TempCalcEvaluatorImpl0 evaluator) {
        List list;
        Member[] members = evaluator.getCurrentMembers();
        boolean allLeaf = true;
        for (int i = 0; i < members.length; ++i) {
            if (members[i].isLeaf()) continue;
            allLeaf = false;
        }
        if (!allLeaf) {
            throw new NotLeafException();
        }
        PointWithMembers point = new PointWithMembers(this.coordy, members, true);
        Object values = evaluator.calcDetailCache.get(point);
        if (values != null) {
            return values;
        }
        Calc calc = (Calc)evaluator.defaultMemberCalcsMap.get(members[this.calcDimensionIndex]);
        if (calc == null && (list = (List)evaluator.memberScopedCalcMap.get(members[this.calcDimensionIndex])) != null) {
            for (ScopedCalc sc : list) {
                if (!sc.validate(members, evaluator)) continue;
                calc = sc.getCalc();
            }
        }
        if (calc == null) {
            return this.detailCubeData.get(point.coordinate);
        }
        Object value = calc.evaluate(evaluator.push());
        return value;
    }

    private Object calcWeight(Member[] ms, Object vs, int index) {
        return this.wc == null ? vs : this.wc.calc(ms, vs, index);
    }

    public Object appendAggregator(Object v1, Object v2) throws OlapException {
        return this.aggs[0].appendAggregator(v1, v2);
    }

    public Object appendValue(Object v1, Object v2) throws OlapException {
        return this.aggs[0].appendValue(v1, v2);
    }

    public long getCoordinate(Member[] members) {
        int[] keys = new int[members.length];
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = ((MemberImpl)members[i]).getGlobalOrder();
        }
        return this.coordy.getCoord(keys);
    }

    @Override
    public void finishBuildData(Stats stats) throws OlapException {
        String message = "After finish build data:";
        logger.info((Object)message);
        this.printStatistics(stats);
    }

    @Override
    public void release() {
        this.detailCubeData.clear();
        this.selfData.clear();
        this.calcCache.clear();
    }

    @Override
    public void printStatistics(Stats stats) {
        String message = "All Cuba Data size:" + (this.detailCubeData.size() + this.calcCache.size() + this.selfData.size());
        this.println(message);
        stats.appendMessage(message);
        message = "    detail data size:" + this.detailCubeData.size();
        this.println(message);
        stats.appendMessage(message);
        if (this.calcCache.size() > 0) {
            message = " cache data size:" + this.calcCache.size();
            this.println(message);
            stats.appendMessage(message);
        }
        if (this.selfData.size() > 0) {
            message = "    --not detail data size:" + this.selfData.size();
            this.println(message);
            stats.appendMessage(message);
        }
    }

    private void println(String message) {
        logger.info((Object)message);
    }

    @Override
    public void setCalcBBFilterIndexes(BBFilterIndexes bbIndexes) {
    }

    @Override
    public Iterator<Cell> cellIterator() {
        throw new OlapException("Not supported, only support with olapConfig.onlyRollupCubes=true");
    }

    public static long calcCoordinate(Coordy coordy, Member[] members) {
        boolean isFake = false;
        int[] keys = new int[members.length];
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = ((MemberImpl)members[i]).getGlobalOrder();
            if (keys[i] != -1) continue;
            isFake = true;
        }
        if (isFake) {
            return Long.MAX_VALUE;
        }
        return coordy.getCoord(keys);
    }

    private static class PointWithMembers {
        long coordinate;
        Member[] ms;
        private boolean isFake;

        public PointWithMembers(Coordy coordy, Member[] members, boolean keepMembers) {
            if (keepMembers) {
                this.ms = new Member[members.length];
                System.arraycopy(members, 0, this.ms, 0, members.length);
            }
            int[] keys = new int[members.length];
            for (int i = 0; i < keys.length; ++i) {
                keys[i] = ((MemberImpl)members[i]).getGlobalOrder();
                if (keys[i] != -1) continue;
                this.isFake = true;
            }
            if (this.isFake) {
                this.coordinate = Long.MAX_VALUE;
            } else {
                this.coordinate = coordy.getCoord(keys);
                if (this.coordinate < 0L || this.coordinate == Long.MAX_VALUE) {
                    throw new OlapException("Cube coordinate exceed Long.MAX.");
                }
            }
        }

        public int hashCode() {
            if (this.coordinate > 0L) {
                return (int)(this.coordinate ^ this.coordinate >>> 32);
            }
            return (int)this.coordinate;
        }

        public boolean equals(Object x) {
            if (x == null) {
                return false;
            }
            PointWithMembers p2 = (PointWithMembers)x;
            return this.coordinate == p2.coordinate;
        }
    }

    class TempCalcEvaluatorImpl0
    extends EvaluatorImpl {
        private HashMap<PointWithMembers, Object> calcDetailCache;
        private HashMap<MemberImpl, List<ScopedCalc>> memberScopedCalcMap;
        private HashMap<MemberImpl, Calc> defaultMemberCalcsMap;

        public TempCalcEvaluatorImpl0(EvaluateContext context, Cube cube, CellReader cellReader) throws OlapException {
            super(context, cube, cellReader);
        }

        public void setCalcCache(HashMap<PointWithMembers, Object> calcDetailCache) {
            this.calcDetailCache = calcDetailCache;
        }

        public void setLeafScopedCalcsMap(HashMap<MemberImpl, List<ScopedCalc>> memberScopedCalcMap) {
            this.memberScopedCalcMap = memberScopedCalcMap;
        }

        public void setDefaultMemberCalcsMap(HashMap<MemberImpl, Calc> defaultMemberCalcsMap) {
            this.defaultMemberCalcsMap = defaultMemberCalcsMap;
        }

        public TempCalcEvaluatorImpl0(EvaluateContext context, Cube cube, Member[] cloneCurrentMembers, TempCalcEvaluatorImpl0 evaluatorImpl2) {
            super(context, cube, cloneCurrentMembers, evaluatorImpl2);
        }

        @Override
        public Evaluator push() {
            Member[] cloneCurrentMembers = (Member[])this.currentMembers.clone();
            TempCalcEvaluatorImpl0 evaluator = new TempCalcEvaluatorImpl0(this.context, this.cube, cloneCurrentMembers, this);
            return evaluator;
        }

        @Override
        public Object evaluateCurrent() throws OlapException {
            return NewCubeData.this._getByTempCalc0(this);
        }
    }
}

