/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.algo.olap.cubedata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.epm.eb.algo.olap.Aggregator;
import kd.epm.eb.algo.olap.Cell;
import kd.epm.eb.algo.olap.Cube;
import kd.epm.eb.algo.olap.Member;
import kd.epm.eb.algo.olap.OlapConfig;
import kd.epm.eb.algo.olap.OlapException;
import kd.epm.eb.algo.olap.cubedata.CubeData;
import kd.epm.eb.algo.olap.cubedata.CubeDataReader;
import kd.epm.eb.algo.olap.cubedata.PointWithMembers;
import kd.epm.eb.algo.olap.impl.BBFilterIndexes;
import kd.epm.eb.algo.olap.impl.CellImpl;
import kd.epm.eb.algo.olap.impl.Coordy;
import kd.epm.eb.algo.olap.impl.CubeEvaluateContext;
import kd.epm.eb.algo.olap.impl.MemberImpl;
import kd.epm.eb.algo.olap.impl.MetadataAPIImpl;
import kd.epm.eb.algo.olap.impl.Stats;
import kd.epm.eb.algo.olap.impl.WeightCalculation;
import kd.epm.eb.algo.olap.mdx.Evaluator;
import kd.epm.eb.algo.olap.mdx.MdxQuery;
import org.apache.log4j.Logger;

public class OnlyRollupCubeData
extends CubeData
implements CubeDataReader {
    private static final Logger logger = Logger.getLogger(OnlyRollupCubeData.class);
    private HashMap<PointWithMembers, Object> detailCubeData = new HashMap();
    private HashMap<PointWithMembers, Object> virtualParentChildRelationData = new HashMap();
    private HashMap<Member, List<Member>> virtualParentChildRelation = null;
    private final Coordy coordy;
    private WeightCalculation wc;
    private Member currentMeasure;
    private MetadataAPIImpl metadataApi;

    public OnlyRollupCubeData(MetadataAPIImpl metadataApi, Cube _cube, OlapConfig config) throws OlapException {
        super(_cube);
        this.metadataApi = metadataApi;
        this.measures = this.cube.getMeasures();
        this.aggs = new Aggregator[this.measures.length];
        for (int i = 0; i < this.aggs.length; ++i) {
            String aggName = (String)this.measures[i].getProperty("aggregator");
            if (aggName == null) continue;
            this.aggs[i] = Aggregator.getAggregator(aggName);
        }
        this.coordy = new Coordy(this.cube.getDimensions(true));
        this.wc = new WeightCalculation(_cube);
        if (!this.wc.hasWeight()) {
            this.wc = null;
        }
        this.currentMeasure = this.measures[0];
    }

    @Override
    public void addRecord(Member[] members, Object[] values) throws OlapException {
        boolean isLeaf = true;
        for (int i = 0; i < members.length; ++i) {
            if (members[i].isLeaf()) continue;
            isLeaf = false;
            break;
        }
        if (isLeaf) {
            PointWithMembers p = new PointWithMembers(this.coordy, members, true);
            for (int i = 0; i < members.length; ++i) {
                ((MemberImpl)members[i]).setHasData(true);
            }
            Object vs = this.detailCubeData.get(p);
            vs = this.appendValue(vs, values[0]);
            this.detailCubeData.put(p, vs);
        }
    }

    private void buildVirtualParentChildRelation(HashMap<Member, List<Member>> virtualParentChildRelation, Member child, Member toRollupMember) {
        if (child.isLeaf()) {
            List<Member> list = virtualParentChildRelation.get(child);
            if (list != null) {
                list.add(toRollupMember);
            } else {
                list = new ArrayList<Member>();
                list.add(toRollupMember);
                virtualParentChildRelation.put(child, list);
            }
        } else {
            MemberImpl[] children = ((MemberImpl)child).getChildren();
            for (int i = 0; i < children.length; ++i) {
                this.buildVirtualParentChildRelation(virtualParentChildRelation, children[i], toRollupMember);
            }
        }
    }

    private void buildRollupData(Stats stats) {
        List<Member> members = this.metadataApi.getRollupMembers();
        if (members == null) {
            return;
        }
        this.virtualParentChildRelation = new HashMap();
        for (Member parent : members) {
            if (parent.isLeaf()) {
                throw new OlapException("Rollup member couldn't be leaf: " + parent.getUniqueName());
            }
            for (MemberImpl child : ((MemberImpl)parent).getChildren()) {
                this.buildVirtualParentChildRelation(this.virtualParentChildRelation, child, parent);
            }
        }
        if (this.virtualParentChildRelation != null && this.virtualParentChildRelation.size() > 0) {
            Stats.StatItem item = stats.createStatItem("rollup vitual members");
            logger.info((Object)"begin rollup vitual members");
            long begin = System.currentTimeMillis();
            for (Map.Entry<PointWithMembers, Object> entry : this.detailCubeData.entrySet()) {
                Member[] ms = entry.getKey().ms;
                Object values = entry.getValue();
                this.rollupParentForVitualMembers(ms, values);
            }
            long end = System.currentTimeMillis();
            logger.info((Object)("rollup vitual members cost " + (end - begin) + "ms, size:" + this.virtualParentChildRelationData.size()));
            item.append("size:" + this.virtualParentChildRelationData.size());
            item.close();
        }
    }

    @Override
    public void finishAddRecord(Stats stats) throws OlapException {
        this.buildRollupData(stats);
    }

    private void rollupParentForVitualMembers(Member[] members, Object values) throws OlapException {
        for (int i = 0; i < members.length; ++i) {
            List<Member> virtualParents = this.virtualParentChildRelation.get(members[i]);
            if (virtualParents == null) continue;
            for (Member virtualParent : virtualParents) {
                Member[] tempMembers = new Member[members.length];
                System.arraycopy(members, 0, tempMembers, 0, members.length);
                tempMembers[i] = virtualParent;
                this._rollupParentForVitualMembers(i, tempMembers, values);
            }
        }
    }

    private void _rollupParentForVitualMembers(int rollupMemberIndex, Member[] members, Object values) throws OlapException {
        PointWithMembers point = new PointWithMembers(this.coordy, members, false);
        Object vs = this.virtualParentChildRelationData.get(point);
        vs = this.appendValue(vs, values);
        this.virtualParentChildRelationData.put(point, vs);
    }

    @Override
    public Object getByEvaluator(Evaluator evaluator) {
        throw new OlapException("Not supported.");
    }

    @Override
    public Iterator<Cell> cellIterator() {
        return new MyCellIterator();
    }

    public Object appendValue(Object v1, Object v2) throws OlapException {
        return this.aggs[0].appendValue(v1, v2);
    }

    @Override
    public void finishBuildData(Stats stats) throws OlapException {
        String message = "After finish build data:";
        logger.info((Object)message);
        this.printStatistics(stats);
    }

    @Override
    public void release() {
        this.detailCubeData.clear();
        this.virtualParentChildRelationData.clear();
    }

    @Override
    public void printStatistics(Stats stats) {
        String message = "All Cuba Data size:" + (this.detailCubeData.size() + this.virtualParentChildRelationData.size());
        this.println(message);
        stats.appendMessage(message);
        message = "    detail data size:" + this.detailCubeData.size();
        this.println(message);
        stats.appendMessage(message);
        if (this.virtualParentChildRelationData.size() > 0) {
            message = "    --virtualParentChildRelationData data size:" + this.virtualParentChildRelationData.size();
            this.println(message);
            stats.appendMessage(message);
        }
    }

    private void println(String message) {
        logger.info((Object)message);
    }

    @Override
    public void setCalcBBFilterIndexes(BBFilterIndexes bbIndexes) {
        throw new OlapException("Not supported.");
    }

    @Override
    public void afterBuild(CubeEvaluateContext evaluateContext, MetadataAPIImpl metadataAPI, MdxQuery mdxQuery, List<Map<String, Member>> allLinkMembers) {
    }

    private class MyCellIterator
    implements Iterator<Cell> {
        private boolean first = true;
        private Iterator<Map.Entry<PointWithMembers, Object>> iter;

        MyCellIterator() {
            this.iter = OnlyRollupCubeData.this.detailCubeData.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            boolean b = this.iter.hasNext();
            if (!b && this.first) {
                this.first = false;
                this.iter = OnlyRollupCubeData.this.virtualParentChildRelationData.entrySet().iterator();
                b = this.iter.hasNext();
            }
            return b;
        }

        @Override
        public Cell next() {
            Map.Entry<PointWithMembers, Object> entry = this.iter.next();
            return this.toCell(entry.getKey(), entry.getValue());
        }

        private Cell toCell(PointWithMembers point, Object values) {
            CellImpl cell = new CellImpl(point.ms, OnlyRollupCubeData.this.currentMeasure, values, null);
            return cell;
        }

        @Override
        public void remove() {
        }
    }
}

