/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.algo.olap.cubedata;

import java.util.Arrays;
import kd.epm.eb.algo.olap.Member;
import kd.epm.eb.algo.olap.OlapException;
import kd.epm.eb.algo.olap.impl.Coordy;
import kd.epm.eb.algo.olap.impl.MemberImpl;

class PointWithMembers {
    long coordinate;
    Member[] ms;
    private int[] keys;
    private transient int h = 0;

    public PointWithMembers(Coordy coordy, Member[] members, boolean keepMembers) {
        if (keepMembers) {
            this.ms = new Member[members.length];
            System.arraycopy(members, 0, this.ms, 0, members.length);
        }
        this.keys = new int[members.length];
        for (int i = 0; i < this.keys.length; ++i) {
            this.keys[i] = ((MemberImpl)members[i]).getGlobalOrder();
        }
        this.coordinate = coordy.getCoord(this.keys);
        if (this.coordinate <= 0L) {
            throw new OlapException("Cube coordinate exceed Long.MAX.");
        }
    }

    public int hashCode() {
        if (this.coordinate > 0L) {
            return (int)(this.coordinate ^ this.coordinate >>> 32);
        }
        if (this.h == 0) {
            this.h = Arrays.hashCode(this.keys);
        }
        return this.h;
    }

    public boolean equals(Object x) {
        if (x == null) {
            return false;
        }
        PointWithMembers p2 = (PointWithMembers)x;
        if (this.coordinate > 0L) {
            return this.coordinate == p2.coordinate;
        }
        int[] keys1 = this.keys;
        int[] keys2 = p2.keys;
        for (int i = 0; i < keys2.length; ++i) {
            if (keys1[i] == keys2[i]) continue;
            return false;
        }
        return true;
    }
}

