/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.algo.olap.dbsource;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import kd.epm.eb.algo.olap.OlapException;
import kd.epm.eb.algo.olap.def.ConnectionDef;

public class ConnectionHelper {
    public static Connection makeConnection(ConnectionDef def) throws OlapException {
        ConnectionHelper.loadDriver(def.driver);
        Connection con = null;
        Properties prop = new Properties();
        if (def.user != null) {
            prop.put("user", def.user);
            prop.put("password", def.password);
        }
        try {
            con = DriverManager.getConnection(def.connectionString, prop);
        }
        catch (SQLException e) {
            throw new OlapException(e);
        }
        if (con == null) {
            throw new OlapException("Can't connection to " + def.connectionString);
        }
        return con;
    }

    private static void loadDriver(String driver) throws OlapException {
        if (driver == null) {
            return;
        }
        try {
            Class.forName(driver).newInstance();
        }
        catch (Exception e) {
            throw new OlapException("Jdbc driver is not found:" + driver, e);
        }
    }
}

