/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.algo.olap.dbsource;

import java.sql.SQLException;
import kd.epm.eb.algo.olap.OlapException;
import kd.epm.eb.algo.olap.dbsource.MemoryTable;
import kd.epm.eb.algo.olap.dbsource.Table;
import kd.epm.eb.algo.olap.dbsource.TableManager;

public abstract class TableProvider {
    Table table;
    TableManager manager;
    String usecase = "";
    int ref = 0;

    public TableProvider(TableManager manager) {
        this.manager = manager;
    }

    void addUse() {
        ++this.ref;
    }

    boolean release() {
        --this.ref;
        if (this.ref == 0) {
            this.close();
        }
        return this.ref == 0;
    }

    void close() {
        if (this.table != null) {
            this.table.close();
        }
    }

    public void setUseCase(String usecase) {
        this.usecase = usecase;
    }

    public String getUseCase() {
        return this.usecase;
    }

    public Table get() throws SQLException, OlapException {
        if (this.table == null) {
            this.table = this.createTable();
        } else if (this.ref > 1 && !(this.table instanceof MemoryTable)) {
            this.table = new MemoryTable(this.table);
        }
        return this.table;
    }

    public abstract Table createTable() throws SQLException, OlapException;
}

