/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.algo.olap.dbsource;

import java.sql.Timestamp;
import java.util.Date;
import java.util.GregorianCalendar;
import kd.epm.eb.algo.olap.OlapException;
import kd.epm.eb.algo.olap.dbsource.Table;

public class TimeRangeTable
implements Table {
    private String columnName;
    private Date end;
    GregorianCalendar calendar = new GregorianCalendar();

    public TimeRangeTable(String columnName, Date start, Date end) {
        this.columnName = columnName;
        this.end = end;
        this.calendar.setTime(start);
        this.calendar.add(5, -1);
    }

    @Override
    public int getColumnCount() throws OlapException {
        return 1;
    }

    @Override
    public int getColumnType(int index) throws OlapException {
        return 91;
    }

    @Override
    public int getColumnIndex(String name) throws OlapException {
        if (this.columnName.equalsIgnoreCase(name)) {
            return 0;
        }
        throw new OlapException("wrong column name:" + name);
    }

    @Override
    public String[] getColumnNames() throws OlapException {
        return new String[]{this.columnName};
    }

    @Override
    public boolean next() throws OlapException {
        if (this.calendar.getTime().before(this.end)) {
            this.calendar.add(5, 1);
            return true;
        }
        return false;
    }

    @Override
    public Object getValue(int index) throws OlapException {
        if (index == 0) {
            return new Timestamp(this.calendar.getTimeInMillis());
        }
        throw new OlapException("wrong index");
    }

    @Override
    public Object[] getValues() throws OlapException {
        return new Object[]{this.getValue(0)};
    }

    @Override
    public void close() {
    }
}

