/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.algo.olap.def;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Element {
    private org.w3c.dom.Element element;
    List<Element> children;

    public Element(org.w3c.dom.Element element) {
        this.element = element;
    }

    public String getName() {
        return this.element.getNodeName();
    }

    public String getAttributeValue(String name) {
        String attribute = this.element.getAttribute(name);
        if (attribute == null || attribute.isEmpty()) {
            return null;
        }
        return attribute;
    }

    public List<Element> getChildren() {
        this.children = Optional.ofNullable(this.children).orElseGet(() -> {
            NodeList childNodes = this.element.getChildNodes();
            if (childNodes == null || childNodes.getLength() == 0) {
                return new ArrayList();
            }
            LinkedList<Element> res = new LinkedList<Element>();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                res.add(new Element((org.w3c.dom.Element)childNodes.item(i)));
            }
            return res;
        });
        return this.children;
    }

    public List<Element> getChildren(String name) {
        List<Element> children = this.getChildren();
        return children.stream().filter(item -> name.equals(item.getName())).collect(Collectors.toList());
    }

    public Element getChild(String name) {
        List<Element> children = this.getChildren(name);
        return children.isEmpty() ? null : children.get(0);
    }

    public String getText() {
        return this.element.getTextContent();
    }

    public void setText(String text) {
        this.element.setTextContent(text);
    }

    public void setAttribute(String name, String value) {
        this.element.setAttribute(name, value);
    }

    public void addContent(Element child) {
        this.element.appendChild(child.getElement());
    }

    public Node getElement() {
        return this.element;
    }
}

