/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.algo.olap.def;

import java.util.HashMap;
import java.util.HashSet;
import kd.epm.eb.algo.olap.OlapException;
import kd.epm.eb.algo.olap.def.AbstractCubeDimensionDef;
import kd.epm.eb.algo.olap.def.CalculatedMemberDef;
import kd.epm.eb.algo.olap.def.CalculatedMemberPropertyDef;
import kd.epm.eb.algo.olap.def.ConnectionDef;
import kd.epm.eb.algo.olap.def.CubeDef;
import kd.epm.eb.algo.olap.def.DimensionUsageDef;
import kd.epm.eb.algo.olap.def.HierarchyDef;
import kd.epm.eb.algo.olap.def.LevelDef;
import kd.epm.eb.algo.olap.def.MeasureDef;
import kd.epm.eb.algo.olap.def.ParameterDef;
import kd.epm.eb.algo.olap.def.PermissionDef;
import kd.epm.eb.algo.olap.def.PermissionItemDef;
import kd.epm.eb.algo.olap.def.PropertyDef;
import kd.epm.eb.algo.olap.def.SchemaDef;
import kd.epm.eb.algo.olap.def.SharedDimensionDef;
import kd.epm.eb.algo.olap.def.TableDef;
import kd.epm.eb.algo.olap.util.UniqueNameUtil;

public class SchemaChecker {
    private SchemaDef schema;
    private HashMap tables = new HashMap();
    private HashMap dims = new HashMap();
    private HashMap cubes = new HashMap();
    private HashMap rules = new HashMap();
    private HashMap conns = new HashMap();

    public SchemaChecker(SchemaDef _schema) {
        this.schema = _schema;
    }

    public void check() throws OlapException {
        int i;
        if (this.schema.cubes == null || this.schema.cubes.length == 0) {
            throw new OlapException("no cube defined.");
        }
        if (this.schema.parameters != null) {
            for (i = 0; i < this.schema.parameters.length; ++i) {
                this.checkParameter(this.schema.parameters[i]);
            }
        }
        if (this.schema.connection != null) {
            this.checkConnection(this.schema.connection);
        }
        if (this.schema.tables != null) {
            for (i = 0; i < this.schema.tables.length; ++i) {
                TableDef def = this.schema.tables[i];
                this.checkTable(def);
            }
        }
        if (this.schema.dimensions != null) {
            for (i = 0; i < this.schema.dimensions.length; ++i) {
                this.checkShareDimension(this.schema.dimensions[i]);
            }
        }
        if (this.schema.cubes == null || this.schema.cubes.length == 0) {
            throw new OlapException(this.schema + " no cube defined.");
        }
        for (i = 0; i < this.schema.cubes.length; ++i) {
            this.checkCube(this.schema.cubes[i]);
        }
    }

    private void checkCube(CubeDef cube) throws OlapException {
        if (cube.name == null) {
            throw new OlapException("Cube name required.");
        }
        this.newCube(cube.name, cube);
        if (cube.table == null) {
            throw new OlapException(cube + " property table required.");
        }
        if (cube.dimensions == null || cube.dimensions.length == 0) {
            throw new OlapException(cube + " no dimension defined.");
        }
        HashMap cdims = new HashMap();
        if (cube.dimensions != null) {
            for (int i = 0; i < cube.dimensions.length; ++i) {
                AbstractCubeDimensionDef dim = cube.dimensions[i];
                this.checkDimensionUsage(cube, cdims, (DimensionUsageDef)dim);
            }
        }
        if (cube.measures == null || cube.measures.length == 0) {
            throw new OlapException(cube + " no measure defined.");
        }
        HashMap ht = new HashMap();
        for (int i = 0; i < cube.measures.length; ++i) {
            this.checkMeasure(cube, ht, cube.measures[i]);
        }
        if (cube.calculatedMembers != null) {
            HashSet set = new HashSet();
            for (int i = 0; i < cube.calculatedMembers.length; ++i) {
                this.checkCalculatedMember(cube, set, cube.calculatedMembers[i]);
            }
        }
    }

    private void checkCalculatedMember(CubeDef cube, HashSet set, CalculatedMemberDef def) throws OlapException {
        if (def.name == null || def.name == "") {
            throw new OlapException(cube + " CalculatedMember name required.");
        }
        if (def.dimension == null || def.dimension == "") {
            throw new OlapException(cube + " CalculatedMember " + def.name + " dimension required.");
        }
        String uniqueName = UniqueNameUtil.createUniqueName(new String[]{def.dimension, def.name});
        if (!set.add(uniqueName)) {
            throw new OlapException(cube + " CalculatedMember " + uniqueName + " required.");
        }
        if (def.formula == null || def.formula == "") {
            throw new OlapException(cube + " CalculatedMember " + def.name + " formula required.");
        }
        if (!"Measures".equalsIgnoreCase(def.dimension) && !this.dims.containsKey(def.dimension)) {
            throw new OlapException(cube + " CalculatedMember " + def.name + " " + def.dimension + "  Dimension not found.");
        }
        if (def.properties != null) {
            for (int i = 0; i < def.properties.length; ++i) {
                this.checkCalculatedMemberProperty(cube, uniqueName, def.properties[i]);
            }
        }
    }

    private void checkCalculatedMemberProperty(CubeDef cube, String uniqueName, CalculatedMemberPropertyDef def) throws OlapException {
        if (def.name == null || def.name == "") {
            throw new OlapException(cube + " CalculatedMember " + uniqueName + " property name required.");
        }
        if (def.value == null || def.value == "") {
            throw new OlapException(cube + " CalculatedMember " + uniqueName + " property value required.");
        }
    }

    private void checkMeasure(CubeDef cube, HashMap measures, MeasureDef measure) throws OlapException {
        if (measure.name == null) {
            throw new OlapException(cube + " Measure name required.");
        }
        if (measures.containsKey(measure.name)) {
            throw new OlapException(cube + " " + measure + " redefined.");
        }
        measures.put(measure.name, measure);
        if (measure.column == null) {
            throw new OlapException(cube + " " + measure + " no column defined.");
        }
        if (measure.permission != null) {
            this.checkPermission(measure.permission);
        }
    }

    private void checkDimensionUsage(CubeDef cube, HashMap cdims, DimensionUsageDef dim) throws OlapException {
        if (dim.name == null) {
            throw new OlapException(cube + " DimensionUsage name required.");
        }
        if (!this.dims.containsKey(dim.name)) {
            throw new OlapException(cube + " " + dim + "  Dimension not found.");
        }
        if (cdims.containsKey(dim.name)) {
            throw new OlapException(cube + " " + dim + " redefined.");
        }
        cdims.put(dim.name, dim);
        if (dim.foreignKey == null) {
            throw new OlapException(cube + " " + dim + " property foreignKey required.");
        }
    }

    private void checkShareDimension(SharedDimensionDef dim) throws OlapException {
        if (dim.name == null) {
            throw new OlapException("Dimension name required.");
        }
        this.newDimension(dim.name, dim);
        if (dim.type != null && !dim.type.equals("Standard") && !dim.type.equals("Time")) {
            throw new OlapException(dim + " type must be Standard or Time.");
        }
        if (dim.table == null) {
            throw new OlapException(dim + " property table required.");
        }
        if (dim.primaryKey == null) {
            throw new OlapException(dim + " property primaryKey required.");
        }
        if (dim.hierarchies == null || dim.hierarchies.length == 0) {
            throw new OlapException(dim + " no Hierarchy defined.");
        }
        for (int i = 0; i < dim.hierarchies.length; ++i) {
            HashMap hies = new HashMap();
            this.checkHierarchy(dim, hies, dim.hierarchies[i]);
        }
        if (dim.permission != null) {
            this.checkPermission(dim.permission);
        }
    }

    private void checkPermission(PermissionDef permission) throws OlapException {
        if (permission.type == null) {
            throw new OlapException("Permission property type required.");
        }
        if (!permission.type.equalsIgnoreCase("EAS")) {
            throw new OlapException("Unknown Permission type '" + permission.type + "'.");
        }
        if (permission.items == null || permission.items.length == 0) {
            throw new OlapException("Permission no PermissionItem defined.");
        }
        for (int i = 0; i < permission.items.length; ++i) {
            this.checkPermissionItem(permission.items[i]);
        }
    }

    private void checkPermissionItem(PermissionItemDef item) throws OlapException {
        if (item.type == null) {
            throw new OlapException("PermissionItem property type required.");
        }
        if (!item.type.equalsIgnoreCase("BOOLEAN") && !item.type.equalsIgnoreCase("SQL_FILTER")) {
            throw new OlapException("Unknown PermissionItem type '" + item.type + "'.");
        }
        if (item.name == null) {
            throw new OlapException("PermissionItem property name required");
        }
        if (item.type.equalsIgnoreCase("SQL_FILTER") && item.column == null) {
            throw new OlapException("PermissionItem typed 'SQL_FILTER' require property column at the same time.");
        }
    }

    private void checkHierarchy(AbstractCubeDimensionDef dim, HashMap hies, HierarchyDef hie) throws OlapException {
        if (hie.name != null) {
            if (hies.containsKey(hie.name)) {
                throw new OlapException(dim + " " + hie + " redefined.");
            }
            hies.put(hie.name, hie);
        }
        if (hie.levels == null || hie.levels.length == 0) {
            throw new OlapException(dim + " " + hie + " not level defined.");
        }
        for (int i = 0; i < hie.levels.length; ++i) {
            HashMap levels = new HashMap();
            this.checkLevel(dim, levels, hie.levels[i]);
        }
    }

    private void checkLevel(AbstractCubeDimensionDef dim, HashMap levels, LevelDef level) throws OlapException {
        if (level.name == null) {
            throw new OlapException(dim + " Level name required.");
        }
        if (level.column == null) {
            throw new OlapException(dim + " " + level + " property column required.");
        }
        if (levels.containsKey(level.name)) {
            throw new OlapException(dim + " " + level + " redefined.");
        }
        levels.put(level.name, level);
        if (level.rule != null && !this.rules.containsKey(level.rule)) {
            throw new OlapException(dim + " " + level + " rule '" + level.rule + "' not found.");
        }
        HashMap<String, PropertyDef> props = new HashMap<String, PropertyDef>();
        if (level.properties != null) {
            for (int i = 0; i < level.properties.length; ++i) {
                PropertyDef prop = level.properties[i];
                if (prop.name == null) {
                    throw new OlapException(dim + " " + level + " Property name required.");
                }
                if (prop.column == null) {
                    throw new OlapException(dim + " " + level + " " + prop + " property column required.");
                }
                if (props.containsKey(prop.name)) {
                    throw new OlapException(dim + " " + level + " " + prop + " redefined.");
                }
                props.put(prop.name, prop);
            }
        }
        if (level.orderMethod != null && !level.orderMethod.equalsIgnoreCase("asc") && !level.orderMethod.equalsIgnoreCase("desc")) {
            throw new OlapException(dim + "" + level + " orderMethod must be 'asc' or 'desc'.");
        }
    }

    private void checkConnection(ConnectionDef cn) throws OlapException {
        if (cn.connectionString == null) {
            throw new OlapException(cn + " connectionString required.");
        }
    }

    private void checkTable(TableDef table) throws OlapException {
        if (table.name == null) {
            throw new OlapException("Table name required.");
        }
        this.newTable(table.name, table);
    }

    private void checkParameter(ParameterDef p) throws OlapException {
        if (p.name == null) {
            throw new OlapException("Parameter name required.");
        }
        if (p.type == null) {
            throw new OlapException(p.toString() + " property 'type' required.");
        }
        if (p.type.equals("Connection")) {
            this.newConnection(p.name, p);
        } else if (p.type.equalsIgnoreCase("Table")) {
            this.newTable(p.name, p);
        } else if (p.type.equals("ParentMemberRule")) {
            this.newRule(p.name, p);
        } else {
            throw new OlapException(p.toString() + " unknown type '" + p.type + "'");
        }
    }

    private void newConnection(String name, Object x) throws OlapException {
        this.newObject("Connection", this.conns, name, x);
    }

    private void newDimension(String name, Object x) throws OlapException {
        this.newObject("Dimension", this.dims, name, x);
    }

    private void newCube(String name, Object x) throws OlapException {
        this.newObject("Cube", this.cubes, name, x);
    }

    private void newTable(String name, Object x) throws OlapException {
        this.newObject("Table", this.tables, name, x);
    }

    private void newRule(String name, Object x) throws OlapException {
        this.newObject("ParentMemberRule", this.rules, name, x);
    }

    private void newObject(String type, HashMap set, String name, Object x) throws OlapException {
        if (set.containsKey(name)) {
            throw new OlapException(type + " redefined in " + x.toString());
        }
        set.put(name, x);
    }
}

