/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.algo.olap.impl;

import kd.epm.eb.algo.olap.Cube;
import kd.epm.eb.algo.olap.Dimension;
import kd.epm.eb.algo.olap.Member;
import kd.epm.eb.algo.olap.impl.DimensionImpl;
import kd.epm.eb.algo.olap.util.BBFilter;

public class BBFilterIndex {
    private int[] indexes;
    BBFilter filter;
    private int[] coords;

    public BBFilterIndex(Cube cube, Dimension ... dims) {
        int[] cards = new int[dims.length];
        this.indexes = new int[dims.length];
        for (int i = 0; i < dims.length; ++i) {
            this.indexes[i] = dims[i].getOrdinal(cube);
            cards[i] = ((DimensionImpl)dims[i]).getRealMemberCount();
            if (cards[i] != 0) continue;
            cards[i] = ((DimensionImpl)dims[i]).getMemberCount();
        }
        this.filter = new BBFilter(cards);
        this.coords = new int[this.indexes.length];
    }

    public BBFilterIndex(int[] cards, int[] indexes) {
        this.indexes = indexes;
        this.filter = new BBFilter(cards);
        this.coords = new int[indexes.length];
    }

    public BBFilter getFilter() {
        return this.filter;
    }

    public void add(Member ... members) {
        for (int i = 0; i < this.indexes.length; ++i) {
            this.coords[i] = members[this.indexes[i]].getGlobalOrder();
        }
        this.filter.set(this.coords);
    }

    public boolean get(Member[] members) {
        for (int i = 0; i < this.indexes.length; ++i) {
            this.coords[i] = members[this.indexes[i]].getGlobalOrder();
        }
        return this.filter.get(this.coords);
    }

    public void addRaw(Member ... members) {
        for (int i = 0; i < this.indexes.length; ++i) {
            this.coords[i] = members[i].getGlobalOrder();
        }
        this.filter.set(this.coords);
    }

    public boolean getRaw(Member[] members) {
        for (int i = 0; i < this.indexes.length; ++i) {
            this.coords[i] = members[i].getGlobalOrder();
        }
        return this.filter.get(this.coords);
    }

    public boolean getRaw(Member[] members, Member member, int index) {
        for (int i = 0; i < this.indexes.length; ++i) {
            this.coords[i] = members[i].getGlobalOrder();
        }
        this.coords[index] = member.getGlobalOrder();
        return this.filter.get(this.coords);
    }
}

