/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.algo.olap.impl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Set;
import kd.epm.eb.algo.olap.OlapElement;

public abstract class CubeElementBase
implements OlapElement,
Serializable {
    public static final long serialVersionUID = 4576323458477547547L;
    private HashMap props;
    protected String name;
    protected String caption;

    @Override
    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        Object key = this.getProperty("key");
        if (key != null) {
            return key.toString();
        }
        return null;
    }

    @Override
    public String getCaption() {
        return this.caption != null && !this.caption.equals("") ? this.caption : this.getName();
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    @Override
    public String[] getPropertyNames() {
        if (this.props == null) {
            return new String[0];
        }
        Set ns = this.props.keySet();
        String[] names = new String[ns.size()];
        ns.toArray(names);
        Arrays.sort(names, new Comparator(){

            public int compare(Object v1, Object v2) {
                return ((String)v1).compareTo((String)v2);
            }
        });
        return names;
    }

    @Override
    public Object getProperty(String name) {
        if ("name".equals(name)) {
            return this.getName();
        }
        if ("caption".equals(name)) {
            return this.getCaption();
        }
        if (this.props == null) {
            return null;
        }
        return this.props.get(name);
    }

    public boolean containsProperty(String name) {
        if (this.props == null) {
            return false;
        }
        return this.props.containsKey(name);
    }

    @Override
    public Object getProperty(String name, Object defaultValue) {
        if ("name".equals(name)) {
            return this.getName();
        }
        if ("caption".equals(name)) {
            return this.getCaption();
        }
        if (this.props == null) {
            return defaultValue;
        }
        if (this.props.containsKey(name)) {
            return this.props.get(name);
        }
        return defaultValue;
    }

    public void removeProperty(String name) {
        if (this.props != null) {
            this.props.remove(name);
        }
    }

    @Override
    public void setProperty(String name, Object value) {
        if ("name".equals(name)) {
            this.setName(value == null ? null : value.toString());
        } else if ("caption".equals(name)) {
            this.setCaption(value == null ? null : value.toString());
        } else if (value == null) {
            this.removeProperty(name);
        } else {
            if (this.props == null) {
                this.props = new HashMap(2);
            }
            this.props.put(name, value);
        }
    }

    public String toString() {
        return this.getCaption();
    }

    public Object clone() {
        return this;
    }

    public String toMdx() {
        return this.getUniqueName();
    }

    public void unparse(StringBuffer sb) {
        sb.append(this.getUniqueName());
    }
}

