/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.algo.olap.impl;

import java.util.HashMap;
import kd.epm.eb.algo.olap.Connection;
import kd.epm.eb.algo.olap.Database;
import kd.epm.eb.algo.olap.OlapException;
import kd.epm.eb.algo.olap.impl.ConnectionImpl;
import kd.epm.eb.algo.olap.impl.CubeImpl;
import kd.epm.eb.algo.olap.impl.EvaluateContext;
import kd.epm.eb.algo.olap.impl.EvaluatorImpl;
import kd.epm.eb.algo.olap.impl.LinkCellReader;
import kd.epm.eb.algo.olap.mdx.Evaluator;
import kd.epm.eb.algo.olap.mdx.Exp;
import kd.epm.eb.algo.olap.mdx.ParserHelp;
import kd.epm.eb.algo.olap.mdx.SchemaReader;
import kd.epm.eb.algo.olap.mdx.StackExpResolver;
import kd.epm.eb.algo.olap.mdx.calc.Calc;
import kd.epm.eb.algo.olap.mdx.calc.impl.BetterScalarExpCompiler;

public class CubeEvaluateContext
implements EvaluateContext {
    private SchemaReader schemaReader;
    private BetterScalarExpCompiler compiler;
    private StackExpResolver resolver;
    private CubeImpl cube;
    private Database db;
    private HashMap<String, LinkCellReader> linkCellReaderMap;

    public CubeEvaluateContext(Database db) {
        this.db = db;
        this.schemaReader = db.getSchemaReader();
        this.cube = (CubeImpl)this.schemaReader.getCube();
        this.resolver = new StackExpResolver(this.schemaReader, db.getUdfTable());
        this.compiler = new BetterScalarExpCompiler(this.resolver);
    }

    @Override
    public SchemaReader getSchemaReader() {
        return this.schemaReader;
    }

    @Override
    public Calc getCellCalculation(Evaluator evaluator) throws OlapException {
        return null;
    }

    @Override
    public Exp parseExpression(String expression, boolean resolve) {
        Exp exp = ParserHelp.parseExpression(expression);
        return resolve ? this.resolver.resolve(exp) : exp;
    }

    @Override
    public Calc compileExpression(Exp exp, boolean scalar) throws OlapException {
        if (scalar) {
            return this.compiler.compileScalar(exp, false);
        }
        return exp.compile(this.compiler);
    }

    @Override
    public boolean hasFormulas() {
        return false;
    }

    @Override
    public Evaluator createEvaluator() {
        EvaluatorImpl evaluator = new EvaluatorImpl(this, this.cube, this.db.getCellReader());
        evaluator.setContext(this.cube.getMeasures()[0]);
        return evaluator;
    }

    @Override
    public LinkCellReader getLinkCellReader(String linkName) {
        LinkCellReader lcr;
        Connection linkConnection = this.db.getConnection().getLink(linkName);
        if (this.linkCellReaderMap == null) {
            this.linkCellReaderMap = new HashMap();
        }
        if ((lcr = this.linkCellReaderMap.get(linkName)) == null) {
            lcr = new LinkCellReader((ConnectionImpl)linkConnection);
            this.linkCellReaderMap.put(linkName, lcr);
        }
        return lcr;
    }
}

