/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.algo.olap.impl;

import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import kd.epm.eb.algo.olap.OlapException;
import kd.epm.eb.algo.olap.dbsource.Table;
import kd.epm.eb.algo.olap.dbsource.TableProvider;
import kd.epm.eb.algo.olap.def.HierarchyDef;
import kd.epm.eb.algo.olap.def.SharedDimensionDef;
import kd.epm.eb.algo.olap.impl.DimensionBuildResult;
import kd.epm.eb.algo.olap.impl.DimensionImpl;
import kd.epm.eb.algo.olap.impl.HierarchyFetch;
import kd.epm.eb.algo.olap.impl.HierarchyImpl;
import kd.epm.eb.algo.olap.impl.Key;
import kd.epm.eb.algo.olap.impl.MemberImpl;
import kd.epm.eb.algo.olap.impl.Stats;
import org.apache.log4j.Logger;

public class DimensionBuilderRunnable
implements Runnable {
    private static Logger logger = Logger.getLogger(DimensionBuilderRunnable.class);
    private DimensionImpl dim;
    private SharedDimensionDef dimDef;
    private Map<String, Object> resultHolder;
    private CountDownLatch latch;
    private TableProvider tableProvider;
    private Stats stats;

    public DimensionBuilderRunnable(TableProvider tableProvider, DimensionImpl dim, SharedDimensionDef dimDef, Map<String, Object> resultHolder, CountDownLatch latch, Stats stats) {
        this.tableProvider = tableProvider;
        this.dim = dim;
        this.dimDef = dimDef;
        this.resultHolder = resultHolder;
        this.latch = latch;
        this.stats = stats;
    }

    @Override
    public void run() {
        try (Stats.StatItem item = this.stats.createStatItem("build dimension:" + this.dim.getName());){
            DimensionBuildResult result = DimensionBuilderRunnable.build(this.tableProvider, this.dim, this.dimDef, item);
            this.resultHolder.put(this.dim.name, result);
        }
        this.latch.countDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DimensionBuildResult build(TableProvider tableProvider, DimensionImpl dim, SharedDimensionDef dimDef, Stats.StatItem item) throws OlapException, SQLException {
        logger.debug((Object)("building shared dimension '" + dimDef.name + "'..."));
        int errorRows = 0;
        try (Table table = null;){
            long begin = System.currentTimeMillis();
            table = tableProvider.get();
            long costOfInput = System.currentTimeMillis() - begin;
            int hc = dimDef.hierarchies.length;
            HierarchyFetch[] hfs = new HierarchyFetch[hc];
            Key primaryKey = new Key(table, dimDef.primaryKey);
            DimensionBuildResult dbr = new DimensionBuildResult(dim);
            for (int i = 0; i < hc; ++i) {
                HierarchyDef hieDef = dimDef.hierarchies[i];
                HierarchyImpl hie = dim.hies[i];
                hfs[i] = new HierarchyFetch(hieDef, hie);
            }
            int rowCount = 0;
            begin = System.currentTimeMillis();
            long nextCost = 0L;
            block4: while (true) {
                long nextBegin = System.currentTimeMillis();
                boolean hasNext = table.next();
                nextCost += System.currentTimeMillis() - nextBegin;
                if (!hasNext) break;
                ++rowCount;
                int i = 0;
                while (true) {
                    if (i >= hc) continue block4;
                    MemberImpl member = hfs[i].fetch(table);
                    Object key = primaryKey.getCurrentValue();
                    if (member == null || key == null) {
                        ++errorRows;
                    } else {
                        dbr.getHierarchyBuildResult().put(key, member);
                    }
                    ++i;
                }
                break;
            }
            long costOfIterate = System.currentTimeMillis() - begin;
            begin = System.currentTimeMillis();
            int globalOrder = 0;
            for (int i = 0; i < hc; ++i) {
                hfs[i].globalOrder = globalOrder;
                hfs[i].finish();
                globalOrder = hfs[i].globalOrder;
            }
            dim.memberCount = globalOrder;
            long costOfFinish = System.currentTimeMillis() - begin;
            item.append("Cost[input,iterate(next),finish]=[" + costOfInput + "," + costOfIterate + "(" + nextCost + ")," + costOfFinish + "],[rows,members]=[" + rowCount + "," + dim.memberCount + "]");
            logger.debug((Object)("building dimension member size '" + dim.memberCount + "'..."));
            if (errorRows > 0) {
                logger.info((Object)("Found " + errorRows + " error rows when building shared dimension '" + dimDef.name + "'..."));
                item.append("error rows:" + errorRows);
            }
            DimensionBuildResult dimensionBuildResult = dbr;
            return dimensionBuildResult;
        }
    }
}

