/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.algo.olap.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.epm.eb.algo.olap.CalculatedMember;
import kd.epm.eb.algo.olap.Cube;
import kd.epm.eb.algo.olap.Dimension;
import kd.epm.eb.algo.olap.Hierarchy;
import kd.epm.eb.algo.olap.Member;
import kd.epm.eb.algo.olap.OlapException;
import kd.epm.eb.algo.olap.exception.HierarchyNoMemberException;
import kd.epm.eb.algo.olap.impl.EvaluateContext;
import kd.epm.eb.algo.olap.impl.Point2;
import kd.epm.eb.algo.olap.mdx.CellReader;
import kd.epm.eb.algo.olap.mdx.Evaluator;
import kd.epm.eb.algo.olap.mdx.Exp;
import kd.epm.eb.algo.olap.mdx.SchemaReader;
import kd.epm.eb.algo.olap.mdx.calc.Calc;
import kd.epm.eb.algo.olap.util.Util;

public class EvaluatorImpl
implements Evaluator {
    private static Object NULL = new Object();
    protected final Cube cube;
    protected Member[] currentMembers;
    protected Member currentMeasure;
    protected final Evaluator parent;
    protected CellReader cellReader;
    protected final int depth;
    private final Map<Object, Object> expResultCache;
    private final Map<Point2, Object> cellCalculationCache;
    private Member expandingMember;
    private boolean nonEmpty;
    private boolean nonFactEmpty;
    private int currentMemberLength;
    private Map<Dimension, Integer> dimensionOrdinal;
    private Member[] slicerMember;
    protected EvaluateContext context;
    private HashMap<Object, Object> recurseCheckSet = new HashMap();

    private EvaluatorImpl(EvaluateContext context, Cube cube, CellReader cellReader, Evaluator parent, int depth, Map<Object, Object> expResultCache, Map<Point2, Object> cellCalculationCache) {
        this.context = context;
        this.cube = cube;
        this.cellReader = cellReader;
        this.parent = parent;
        this.depth = depth;
        this.expResultCache = expResultCache;
        this.cellCalculationCache = cellCalculationCache;
    }

    public EvaluatorImpl(EvaluateContext context, Cube cube, CellReader cellReader) throws OlapException {
        this(context, cube, cellReader, null, 0, new HashMap<Object, Object>(3, 2.0f), new HashMap<Point2, Object>());
        SchemaReader scr = context.getSchemaReader();
        Dimension[] dimensions = cube.getDimensions();
        this.currentMembers = new Member[dimensions.length];
        this.dimensionOrdinal = new HashMap<Dimension, Integer>(dimensions.length);
        for (int i = 0; i < dimensions.length; ++i) {
            Dimension dimension = dimensions[i];
            int ordinal = dimension.getOrdinal(cube);
            this.dimensionOrdinal.put(dimension, ordinal);
            Hierarchy hier = dimension.getDefaultHierarchy();
            Member member = scr.getHierarchyDefaultMember(hier);
            if (member == null) {
                throw new HierarchyNoMemberException(hier);
            }
            this.currentMembers[ordinal] = member;
        }
        this.currentMemberLength = this.currentMembers.length;
        this.currentMeasure = cube.getMeasures()[0];
    }

    protected EvaluatorImpl(EvaluateContext context, Cube cube, Member[] currentMembers, EvaluatorImpl parent) {
        this(context, cube, parent.cellReader, parent, parent.depth + 1, parent.expResultCache, parent.cellCalculationCache);
        this.currentMembers = currentMembers;
        this.dimensionOrdinal = parent.dimensionOrdinal;
        this.currentMemberLength = parent.currentMemberLength;
        this.slicerMember = parent.slicerMember;
        this.currentMeasure = parent.currentMeasure;
        this.recurseCheckSet = parent.recurseCheckSet;
    }

    public Map<Object, Object> getRecurseChecker() {
        return this.recurseCheckSet;
    }

    @Override
    public EvaluateContext getContext() {
        return this.context;
    }

    @Override
    public Cube getCube() {
        return this.cube;
    }

    public Map<Point2, Object> getCellCalculationCache() {
        return this.cellCalculationCache;
    }

    @Override
    public Evaluator push(Member[] members) throws OlapException {
        Evaluator evaluator = this.push();
        evaluator.setContext(members);
        return evaluator;
    }

    @Override
    public Evaluator push() {
        Member[] cloneCurrentMembers = (Member[])this.currentMembers.clone();
        EvaluatorImpl evaluator = new EvaluatorImpl(this.context, this.cube, cloneCurrentMembers, this);
        return evaluator;
    }

    @Override
    public Evaluator push(Member member) throws OlapException {
        Evaluator evaluator = this.push();
        evaluator.setContext(member);
        return evaluator;
    }

    @Override
    public Evaluator pop() {
        return this.parent;
    }

    @Override
    public Member setContext(Member member) throws OlapException {
        Member previous;
        Member m = member;
        if (m.isMeasure()) {
            previous = this.currentMeasure;
            this.currentMeasure = member;
        } else {
            int ordinal = member.getDimension().getOrdinal(this.cube);
            previous = this.currentMembers[ordinal];
            this.currentMembers[ordinal] = m;
        }
        return previous;
    }

    @Override
    public void setContext(Member[] members) throws OlapException {
        this.setContextAsObject(members);
    }

    private void setContextAsObject(Object[] members) throws OlapException {
        for (int i = 0; i < members.length; ++i) {
            Member member = (Member)members[i];
            if (member == null) continue;
            this.setContext(member);
        }
    }

    @Override
    public Member getContext(Dimension dimension) throws OlapException {
        if (dimension.isMeasureDimension()) {
            return this.currentMeasure;
        }
        int ordinal = dimension.getOrdinal(this.cube);
        return this.currentMembers[ordinal];
    }

    @Override
    public Object evaluateCurrent() throws OlapException {
        Member maxSolveMember = this.getMaxSolveMember();
        if (maxSolveMember != null) {
            Member defaultMember = maxSolveMember.getHierarchy().getDefaultMember();
            EvaluatorImpl evaluator = (EvaluatorImpl)this.push(defaultMember);
            evaluator.setExpanding(maxSolveMember);
            Object o = null;
            Exp exp = null;
            CalculatedMember cMember = (CalculatedMember)maxSolveMember;
            if (cMember.isNull()) {
                o = null;
            } else {
                exp = cMember.getExpression(true);
                Calc calc = this.context.compileExpression(exp, true);
                o = calc.evaluate(evaluator);
            }
            if (o == Util.nullValue) {
                return null;
            }
            return o;
        }
        return this.cellReader.get(this);
    }

    private void setExpanding(Member member) throws OlapException {
        this.expandingMember = member;
        int memberCount = this.currentMembers.length;
        if (this.depth > memberCount && this.depth % memberCount == 0) {
            EvaluatorImpl.checkRecursion((EvaluatorImpl)this.parent);
        }
    }

    private static void checkRecursion(EvaluatorImpl eval) throws OlapException {
        while (true) {
            if (eval == null) {
                return;
            }
            if (eval.expandingMember != null) break;
            eval = (EvaluatorImpl)eval.getParent();
        }
        block1: for (EvaluatorImpl eval2 = (EvaluatorImpl)eval.getParent(); eval2 != null; eval2 = (EvaluatorImpl)eval2.getParent()) {
            if (eval2.expandingMember != eval.expandingMember) continue;
            for (int i = 0; i < eval.currentMembers.length; ++i) {
                Member parentMember;
                Member member = eval2.currentMembers[i];
                if (member != null && member != (parentMember = eval.getContext(member.getDimension()))) continue block1;
            }
            throw new OlapException("Infinite loop while evaluating calculated member '" + eval.expandingMember + "'; context stack is " + eval.getContextString());
        }
    }

    private String getContextString() {
        boolean skipDefaultMembers = true;
        StringBuilder sb = new StringBuilder("{");
        int frameCount = 0;
        for (EvaluatorImpl eval = this; eval != null; eval = (EvaluatorImpl)eval.getParent()) {
            if (eval.expandingMember == null) continue;
            if (frameCount++ > 0) {
                sb.append(", ");
            }
            sb.append("(");
            int memberCount = 0;
            for (int j = 0; j < eval.currentMembers.length; ++j) {
                Member m = eval.currentMembers[j];
                if (skipDefaultMembers && m == m.getHierarchy().getDefaultMember()) continue;
                if (memberCount++ > 0) {
                    sb.append(", ");
                }
                sb.append(m.getUniqueName());
            }
            sb.append(", ").append(this.currentMeasure.getUniqueName());
            sb.append(")");
        }
        sb.append("}");
        return sb.toString();
    }

    public Member getMaxSolveMember() throws OlapException {
        int maxSolve = Integer.MIN_VALUE;
        Member maxSolveMember = null;
        int count = this.currentMembers.length;
        for (int i = -1; i < count; ++i) {
            int solve;
            Member currentMember = i == -1 ? this.currentMeasure : this.currentMembers[i];
            if (currentMember == null || !currentMember.isCalculated() || (solve = ((CalculatedMember)currentMember).getSolveOrder()) <= maxSolve) continue;
            maxSolve = solve;
            maxSolveMember = currentMember;
        }
        return maxSolveMember;
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    public Evaluator getParent() {
        return this.parent;
    }

    @Override
    public SchemaReader getSchemaReader() {
        return this.context.getSchemaReader();
    }

    private Object getExpResultCacheKey(Exp exp) {
        ArrayList<Serializable> key = new ArrayList<Serializable>();
        key.add(exp);
        for (int i = 0; i < this.currentMembers.length; ++i) {
            Dimension dim;
            Member member = this.currentMembers[i];
            if (member == null || !exp.dependsOn(dim = member.getDimension())) continue;
            key.add(this.currentMembers[i]);
        }
        return key;
    }

    @Override
    public Object getCachedResult(Exp exp) {
        Object key = this.getExpResultCacheKey(exp);
        return this.expResultCache.get(key);
    }

    @Override
    public void setCachedResult(Exp exp, Object result) {
        Object key = this.getExpResultCacheKey(exp);
        this.expResultCache.put(key, result);
    }

    public void clearExpResultCache(boolean clearFact) {
        this.expResultCache.clear();
    }

    @Override
    public boolean isNonEmpty() {
        return this.nonEmpty;
    }

    @Override
    public void setNonEmpty(boolean b) {
        this.nonEmpty = b;
    }

    @Override
    public boolean isNonFactEmpty() {
        return this.nonFactEmpty;
    }

    @Override
    public void setNonFactEmpty(boolean nonFactEmpty) {
        this.nonFactEmpty = nonFactEmpty;
    }

    @Override
    public Member[] getCurrentMembers() {
        return this.currentMembers;
    }

    @Override
    public Member getCurrentMeasure() {
        return this.currentMeasure;
    }

    @Override
    public Member[] getSlicerMember() {
        return this.slicerMember;
    }

    public void setSlicerMember(Member[] slicerMember) {
        this.slicerMember = slicerMember;
    }

    public CellReader getCellReader() {
        return this.cellReader;
    }

    @Override
    public void setContext(Object o) throws OlapException {
        if (o instanceof Member) {
            this.setContext((Member)o);
        } else if (o instanceof Object[]) {
            this.setContextAsObject((Member[])o);
        } else {
            throw Util.newInternal("can't go here");
        }
    }
}

