/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.algo.olap.impl;

import java.util.HashMap;
import kd.epm.eb.algo.olap.Member;
import kd.epm.eb.algo.olap.OlapException;
import kd.epm.eb.algo.olap.impl.ConnectionImpl;
import kd.epm.eb.algo.olap.impl.CubeEvaluateContext;
import kd.epm.eb.algo.olap.mdx.Evaluator;
import kd.epm.eb.algo.olap.mdx.Exp;
import kd.epm.eb.algo.olap.mdx.SchemaReader;
import kd.epm.eb.algo.olap.mdx.calc.Calc;
import kd.epm.eb.algo.olap.mdx.calc.impl.ConstantCalc;

public class LinkCellReader {
    private final SchemaReader schemaReader;
    private final CubeEvaluateContext context;
    private final Evaluator evaluator;
    private final HashMap<String, Member> memberCache = new HashMap();

    public LinkCellReader(ConnectionImpl con) {
        this.schemaReader = con.getSchemaReader();
        this.context = con.getDatabase().getEvaluateContext();
        this.evaluator = this.context.createEvaluator();
    }

    public LinkCellReader(SchemaReader schemaReader, CubeEvaluateContext context) {
        this.schemaReader = schemaReader;
        this.context = context;
        this.evaluator = context.createEvaluator();
    }

    public Object get(Member[] carryMembers, String[] overideMembers) {
        for (Member member : carryMembers) {
            if (member.isMeasure() || this.schemaReader.getCube().getDimension(member.getDimension().getName()) == null) continue;
            this.evaluator.setContext(this.schemaReader.getMemberByUniqueName(member.getUniqueName()));
        }
        for (String memberExpr : overideMembers) {
            Member m = this.memberCache.get(memberExpr);
            if (m == null) {
                Exp exp = this.context.parseExpression(memberExpr, true);
                Calc calc = this.context.compileExpression(exp, false);
                Object o = calc.evaluate(this.evaluator);
                if (!(o instanceof Member)) {
                    throw new OlapException("LinkValue " + memberExpr + " is not member.");
                }
                m = (Member)o;
                if (calc instanceof ConstantCalc) {
                    this.memberCache.put(memberExpr, m);
                }
            }
            this.evaluator.setContext(m);
        }
        return this.evaluator.evaluateCurrent();
    }
}

