/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.algo.olap.impl;

import java.util.ArrayList;
import java.util.List;
import kd.epm.eb.algo.olap.Dimension;
import kd.epm.eb.algo.olap.Hierarchy;
import kd.epm.eb.algo.olap.LeafFeature;
import kd.epm.eb.algo.olap.Level;
import kd.epm.eb.algo.olap.Member;
import kd.epm.eb.algo.olap.MemberScope;
import kd.epm.eb.algo.olap.OlapElement;
import kd.epm.eb.algo.olap.OlapException;
import kd.epm.eb.algo.olap.collection.DefaultListFactory;
import kd.epm.eb.algo.olap.collection.IMemberList;
import kd.epm.eb.algo.olap.impl.CubeElementBase;
import kd.epm.eb.algo.olap.impl.EvaluatorImpl;
import kd.epm.eb.algo.olap.impl.HasData;
import kd.epm.eb.algo.olap.impl.LevelImpl;
import kd.epm.eb.algo.olap.impl.MemberCalcFeature;
import kd.epm.eb.algo.olap.impl.MemberIndex;
import kd.epm.eb.algo.olap.impl.MemberScopeImpl;
import kd.epm.eb.algo.olap.impl.ScopedCalc;
import kd.epm.eb.algo.olap.mdx.DelegatingExpResolver;
import kd.epm.eb.algo.olap.mdx.Evaluator;
import kd.epm.eb.algo.olap.mdx.Exp;
import kd.epm.eb.algo.olap.mdx.FunCall;
import kd.epm.eb.algo.olap.mdx.SchemaReader;
import kd.epm.eb.algo.olap.mdx.Syntax;
import kd.epm.eb.algo.olap.mdx.calc.Calc;
import kd.epm.eb.algo.olap.mdx.elementexp.MemberExpr;
import kd.epm.eb.algo.olap.mdx.type.MemberType;
import kd.epm.eb.algo.olap.mdx.type.Type;
import kd.epm.eb.algo.olap.util.IntBitSet;
import kd.epm.eb.algo.olap.util.RoaringIntBitSet;
import kd.epm.eb.algo.olap.util.UniqueNameUtil;
import kd.epm.eb.algo.olap.util.Util;

public class MemberImpl
extends CubeElementBase
implements Member {
    public static final long serialVersionUID = 41234543357636L;
    byte memberType = 1;
    int ordinal;
    int globalOrder;
    int dataType;
    LevelImpl level;
    MemberImpl parent;
    private MemberImpl[] children;
    MemberImpl[] realChildren;
    protected transient String uniqueName;
    private transient Dimension dimension;
    private transient Hierarchy hierarchy;
    protected HasData hasData = new HasData();
    private boolean hasSelfData;
    private boolean childrenHasSelfData;
    private Number weight = null;
    private MemberIndex childrenIndex;
    Exp exp;
    Calc calc;
    LeafFeature leafFeature;
    private boolean desendantHasExpression;
    private Exp aggExp;
    private boolean hasDisableAgg;
    private int cellCalculationIndex = -1;
    private RoaringIntBitSet filterBitSet = new RoaringIntBitSet();
    private List<ScopedCalc> scopedCalcList = null;
    private List<ScopedCalc> leafChildrenScopedCalcList = null;
    private MemberCalcFeature memberCalcFeature;
    private boolean inScope;
    private boolean isFake;

    public MemberImpl() {
        this.childrenIndex = new MemberIndex(false);
    }

    @Override
    public Level getLevel() {
        return this.level;
    }

    public void setHasData(boolean hasData) {
        this.hasData.hasData = hasData;
        if (this.parent != null) {
            this.parent.setHasData(hasData);
        }
    }

    @Override
    public Dimension getDimension() {
        if (this.dimension == null) {
            this.dimension = this.getHierarchy().getDimension();
        }
        return this.dimension;
    }

    @Override
    public Hierarchy getHierarchy() {
        if (this.hierarchy == null) {
            this.hierarchy = this.level.getHierarchy();
        }
        return this.hierarchy;
    }

    @Override
    public Member getParentMember() {
        return this.parent;
    }

    @Override
    public String getParentUniqueName() {
        return this.parent.getUniqueName();
    }

    @Override
    public Number getWeight() {
        return this.weight;
    }

    public void setWeight(Number weight) {
        this.weight = weight;
        this.dimension.setHasWeight(true);
    }

    public boolean hasDisableAgg() {
        return this.hasDisableAgg;
    }

    public void setHasDisableAgg(boolean hasDisableAgg) {
        this.hasDisableAgg = hasDisableAgg;
        this.dimension.setHasDisableAgg(true);
    }

    @Override
    public void setProperty(String name, Object value) {
        if ("weight".equals(name)) {
            this.weight = (Number)value;
        }
        if ("disableAgg".equals(name)) {
            boolean bl = this.hasDisableAgg = value != null && (Integer)value == 1;
            if (this.hasDisableAgg) {
                this.getDimension().setHasDisableAgg(true);
            }
        }
        super.setProperty(name, value);
    }

    @Override
    public IMemberList getChildMembers() {
        return DefaultListFactory.instance.createMemberList(this.children);
    }

    @Override
    public IMemberList getChildMembersIgnoreInv() {
        return DefaultListFactory.instance.createMemberListWithIgnore(this.children);
    }

    @Override
    public IMemberList getAncestorMembers() {
        IMemberList list = DefaultListFactory.instance.createMemberList();
        for (Member parentMember = this.getParentMember(); parentMember != null; parentMember = parentMember.getParentMember()) {
            list.add(parentMember);
        }
        return list;
    }

    @Override
    public Object getKey() {
        return this.getProperty("key");
    }

    void setKey(Object key) {
        this.setProperty("key", key);
    }

    @Override
    public byte getMemberType() {
        return this.memberType;
    }

    @Override
    public int getOrdinal() {
        return this.ordinal;
    }

    @Override
    public int getOrdinalIgnoreInv() {
        Member parentMember = this.getParentMember();
        if (parentMember == null) {
            return this.ordinal;
        }
        IMemberList childMembers = parentMember.getChildMembers();
        IMemberList childMembersIgnoreInv = parentMember.getChildMembersIgnoreInv();
        if (childMembers.size() == childMembersIgnoreInv.size()) {
            return this.ordinal;
        }
        if (childMembersIgnoreInv.isEmpty()) {
            return this.ordinal;
        }
        int ordinalIgnoreInv = this.ordinal;
        for (int i = 0; i < childMembersIgnoreInv.size(); ++i) {
            if (!childMembersIgnoreInv.get(i).equals(this)) continue;
            ordinalIgnoreInv = i;
            break;
        }
        return ordinalIgnoreInv;
    }

    @Override
    public final int getGlobalOrder() {
        return this.globalOrder;
    }

    @Override
    public int getDataType() {
        return this.dataType;
    }

    public Type getExpType() {
        return new MemberType(this.getHierarchy(), this.getLevel(), null);
    }

    public int getCategory() {
        return 6;
    }

    @Override
    public boolean isNull() {
        return (this.memberType & 0x10) == 16;
    }

    @Override
    public boolean isAll() {
        return (this.memberType & 8) == 8;
    }

    @Override
    public boolean isMeasure() {
        return (this.memberType & 2) == 2;
    }

    @Override
    public boolean isCalculated() {
        return false;
    }

    @Override
    public final boolean isLeaf() {
        return this.children == null || this.children.length == 0;
    }

    @Override
    public OlapElement lookupChild(SchemaReader schemaReader, String name) throws OlapException {
        return this.childrenIndex.get(name);
    }

    public void setChildren(MemberImpl[] members) {
        this.children = members;
        if (members == null) {
            return;
        }
        for (int i = 0; i < members.length; ++i) {
            this.childrenIndex.put(members[i].getName(), members[i]);
        }
    }

    public MemberImpl[] getChildren() {
        return this.children;
    }

    public MemberImpl[] getRealOrOriginChildren() {
        return this.realChildren == null ? this.children : this.realChildren;
    }

    @Override
    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        Object key = this.getProperty("key");
        if (key != null) {
            return key.toString();
        }
        if (this.name == null && this.isAll()) {
            return this.getHierarchy().getAllMemberName();
        }
        return this.name;
    }

    @Override
    public String getCaption() {
        if (this.caption == null) {
            if (this.isAll()) {
                this.caption = this.getHierarchy().getAllMemberCaption();
            } else if (!this.isCalculated() && !this.isCalculatedInSchema() && !this.level.isInner() && this.level.getDimension().isTimeDimension()) {
                this.caption = Util.fixTimeMemberCaption(this);
                if (this.level.levelType == 4 || this.level.levelType == 3) {
                    String pname = null;
                    Member p = this;
                    while ((p = this.getParentMember()) != null) {
                        if (p.getLevel().getLevelType() != 2) continue;
                        pname = p.getCaption();
                        break;
                    }
                    if (pname != null) {
                        this.caption = pname + this.caption;
                    }
                }
            } else {
                this.caption = this.getName();
            }
        }
        return this.caption;
    }

    @Override
    public String getUniqueName() {
        if (this.uniqueName == null) {
            this.uniqueName = this.parent == null ? UniqueNameUtil.makeUniqueName(this.getHierarchy(), this.getName()) : UniqueNameUtil.makeUniqueName(this.parent, this.getName());
        }
        return this.uniqueName;
    }

    @Override
    public int getDepth() {
        return this.level.getDepth();
    }

    @Override
    public boolean isCalculatedInSchema() {
        return false;
    }

    @Override
    public Exp getExpression(boolean includeDesandant) throws OlapException {
        if (this.exp != null) {
            return this.exp;
        }
        if (includeDesandant && this.desendantHasExpression) {
            return this.getAggregationExp();
        }
        return null;
    }

    public Exp getAggregationExp() throws OlapException {
        if (this.aggExp == null) {
            this.aggExp = this.makeExp();
        }
        return this.aggExp;
    }

    private Exp makeExp() throws OlapException {
        DelegatingExpResolver expResolver = new DelegatingExpResolver();
        Exp children = new FunCall("Children", new Exp[]{new MemberExpr(this)}, Syntax.Property);
        children = children.resolve(expResolver);
        Exp aggregate = new FunCall("Aggregate", new Exp[]{children}, Syntax.Function);
        aggregate = aggregate.resolve(expResolver);
        return aggregate;
    }

    @Override
    public void setExpression(Exp exp) {
        this.setExpression(exp, LeafFeature.ALL);
    }

    @Override
    public void setExpression(Exp exp, LeafFeature leafFeature) {
        this.exp = exp;
        this.leafFeature = leafFeature;
        if (this.parent != null) {
            this.parent.setDesendantHasExpression(true);
        }
    }

    public LeafFeature getLeafFeature() {
        return this.leafFeature;
    }

    public void setDesendantHasExpression(boolean recurse) {
        this.desendantHasExpression = true;
        if (recurse && this.parent != null) {
            this.parent.setDesendantHasExpression(true);
        }
    }

    @Override
    public boolean isDesendantHasExpression() {
        return this.desendantHasExpression;
    }

    @Override
    public boolean hasData() {
        return this.isMeasure() || this.isCalculated() || this.isInner() || this.isInnerCountMeasure() || this.hasData.hasData;
    }

    @Override
    public boolean isInner() {
        return false;
    }

    public void setVisible(boolean b) {
        this.setProperty("visible", b);
    }

    @Override
    public boolean isVisible() {
        Object o = this.getProperty("visible");
        if (o != null && "false".equalsIgnoreCase(o.toString())) {
            return false;
        }
        Member parent = this.getParentMember();
        if (parent == null) {
            return true;
        }
        return this.getParentMember().isVisible();
    }

    @Override
    public boolean isInnerCountMeasure() {
        return false;
    }

    @Override
    public String toString() {
        return this.getUniqueName();
    }

    public void setHasSelfData(boolean b) {
        this.hasSelfData = b;
        if (this.parent != null) {
            this.parent.setChildrenHasSelfData(this.hasData.hasData);
        }
    }

    @Override
    public boolean hasSelfData() {
        return this.hasSelfData;
    }

    public void setChildrenHasSelfData(boolean b) {
        this.childrenHasSelfData = b;
        if (this.parent != null) {
            this.parent.setChildrenHasSelfData(this.hasData.hasData);
        }
    }

    @Override
    public boolean childrenHasSelfData() {
        return this.childrenHasSelfData;
    }

    @Override
    public int getPriorCellCalculationIndex() {
        return this.cellCalculationIndex;
    }

    @Override
    public void setPriorCellCalculationIndex(int index) {
        this.cellCalculationIndex = index;
    }

    @Override
    public IntBitSet getFilterBitSet() {
        return this.filterBitSet;
    }

    @Override
    public Calc getCalc() {
        return this.calc;
    }

    @Override
    public void setCalc(Calc calc) {
        this.calc = calc;
    }

    public void addScopedCalc(MemberScope scope, Calc calc, LeafFeature leafFeature) {
        if (this.scopedCalcList == null) {
            this.scopedCalcList = new ArrayList<ScopedCalc>();
        }
        ScopedCalc sc = new ScopedCalc((MemberScopeImpl)scope, calc, leafFeature);
        this.scopedCalcList.add(sc);
        if (this.parent != null && this.isLeaf() && leafFeature.contains(true)) {
            this.parent.addLeafChildrenScopedCalc(sc);
        }
    }

    private void addLeafChildrenScopedCalc(ScopedCalc sc) {
        if (this.leafChildrenScopedCalcList == null) {
            this.leafChildrenScopedCalcList = new ArrayList<ScopedCalc>();
        }
        this.leafChildrenScopedCalcList.add(sc);
        this.desendantHasExpression = true;
        if (this.parent != null) {
            this.parent.addLeafChildrenScopedCalc(sc);
        }
    }

    public List<ScopedCalc> getLeafChildrenScopedCalcList() {
        return this.leafChildrenScopedCalcList;
    }

    public Calc getCalc(Member[] members, EvaluatorImpl evaluator, boolean includeDesandant, boolean leaf) {
        if (this.exp != null && (this.leafFeature == null || this.leafFeature.contains(leaf))) {
            if (this.calc == null) {
                this.calc = evaluator.getContext().compileExpression(this.exp, true);
            }
            return this.calc;
        }
        if (this.scopedCalcList != null) {
            for (ScopedCalc sc : this.scopedCalcList) {
                if (sc.leafFeature != null && !sc.leafFeature.contains(leaf) || !sc.scopeIndex.validate(members, evaluator)) continue;
                return sc.calc;
            }
        }
        return null;
    }

    public MemberCalcFeature getMemberCalcFeature(Evaluator evaluator) {
        if (this.memberCalcFeature == null) {
            this.memberCalcFeature = new MemberCalcFeature(this, evaluator);
        }
        return this.memberCalcFeature;
    }

    public final List<ScopedCalc> getScopedCalcList() {
        return this.scopedCalcList;
    }

    @Override
    public boolean maybeNeedCalc() {
        return this.desendantHasExpression || this.calc != null || this.exp != null || this.scopedCalcList != null;
    }

    @Override
    public boolean hasCalc(boolean includeDesandant) {
        Exp exp = this.getExpression(includeDesandant);
        return exp != null || this.calc != null || this.scopedCalcList != null;
    }

    public List<MemberScopeImpl> getMemberScopes() {
        if (this.scopedCalcList != null) {
            ArrayList<MemberScopeImpl> result = new ArrayList<MemberScopeImpl>(2);
            for (ScopedCalc sc : this.scopedCalcList) {
                result.add(sc.scope);
            }
            return result;
        }
        return null;
    }

    public void setInScope(boolean inScope) {
        this.inScope = inScope;
    }

    public boolean isInScope() {
        return this.inScope;
    }

    public void setIsFake(boolean b) {
        this.isFake = b;
    }

    public boolean isFake() {
        return this.isFake;
    }

    public MemberImpl[] getRealChildren() {
        return this.realChildren;
    }

    public void buildRealChildren() {
        if (this.isLeaf()) {
            return;
        }
        if (this.realChildren != null) {
            return;
        }
        ArrayList<MemberImpl> list = new ArrayList<MemberImpl>();
        for (MemberImpl m : this.children) {
            if (m.realChildren == null) {
                m.buildRealChildren();
            }
            if (m.isFake()) continue;
            list.add(m);
        }
        this.realChildren = list.toArray(new MemberImpl[list.size()]);
        if (list.isEmpty() && !this.hasSelfData && !this.inScope && !this.hasCalc(false)) {
            this.isFake = true;
        }
    }

    @Override
    public boolean isInv() {
        return this.getProperty("ignore") != null && this.getProperty("ignore") instanceof Boolean && (Boolean)this.getProperty("ignore") != false;
    }
}

