/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.algo.olap.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import kd.epm.eb.algo.olap.Cube;
import kd.epm.eb.algo.olap.Dimension;
import kd.epm.eb.algo.olap.Member;
import kd.epm.eb.algo.olap.OlapException;
import kd.epm.eb.algo.olap.collection.IList;
import kd.epm.eb.algo.olap.impl.BBFilterIndex;
import kd.epm.eb.algo.olap.impl.DimensionImpl;
import kd.epm.eb.algo.olap.impl.EvaluateContext;
import kd.epm.eb.algo.olap.impl.MemberImpl;
import kd.epm.eb.algo.olap.impl.MemberScopeImpl;
import kd.epm.eb.algo.olap.mdx.Evaluator;
import kd.epm.eb.algo.olap.mdx.Exp;
import kd.epm.eb.algo.olap.mdx.calc.Calc;
import kd.epm.eb.algo.olap.util.BitSetFactory;
import kd.epm.eb.algo.olap.util.IntBitSet;
import kd.epm.eb.algo.olap.util.Pair;

public class MemberScopeIndex {
    public boolean noScope = false;
    private int[] bindexes;
    private IntBitSet[] bitSets;
    private BBFilterIndex bbFilter;
    private boolean builded = false;
    private MemberScopeImpl scope;
    private DimMatrix dimMatrix = null;

    public MemberScopeIndex(MemberScopeImpl scope) {
        this.scope = scope;
    }

    public void build(Evaluator evaluator) {
        DimInfo dimInfo;
        if (this.builded) {
            return;
        }
        this.builded = true;
        if (this.scope.list.isEmpty()) {
            this.noScope = true;
            return;
        }
        EvaluateContext ec = evaluator.getContext();
        Cube cube = ec.getSchemaReader().getCube();
        ArrayList<DimInfo> dimInfos = new ArrayList<DimInfo>();
        for (Pair<String, String> pair : this.scope.list) {
            MemberImpl member;
            String dimName = pair.getValue0();
            dimInfo = new DimInfo((DimensionImpl)cube.getDimension(dimName), cube.getDimensionOrdinal(dimName));
            dimInfos.add(dimInfo);
            String expression = pair.getValue1();
            Exp exp = ec.parseExpression(expression, true);
            Calc calc = ec.compileExpression(exp, false);
            Object value = calc.evaluate(evaluator);
            if (value instanceof IList) {
                Iterator iter = ((IList)value).iterator();
                while (iter.hasNext()) {
                    member = (MemberImpl)iter.next();
                    if (member.isCalculated()) {
                        throw new OlapException("Calculated member not support in scope: " + member.getUniqueName());
                    }
                    dimInfo.bitSet.set(member.getGlobalOrder());
                    member.setHasData(true);
                    dimInfo.members.add(member);
                }
                continue;
            }
            if (!(value instanceof Member)) continue;
            member = (MemberImpl)value;
            if (member.isCalculated()) {
                throw new OlapException("Calculated member not support in scope: " + member.getUniqueName());
            }
            dimInfo.bitSet.set(member.getGlobalOrder());
            member.setHasData(true);
            dimInfo.members.add(member);
        }
        Iterator iter = dimInfos.iterator();
        while (iter.hasNext()) {
            DimInfo dimInfo2 = (DimInfo)iter.next();
            if (dimInfo2.members.isEmpty()) {
                this.noScope = true;
                return;
            }
            if (dimInfo2.members.size() != 1 || dimInfo2.dim.getRealOrOriginMemberCount() != 1) continue;
            iter.remove();
        }
        Collections.sort(dimInfos, new Comparator<DimInfo>(){

            @Override
            public int compare(DimInfo o1, DimInfo o2) {
                return o2.members.size() - o1.members.size();
            }
        });
        int size = dimInfos.size();
        Dimension[] dims = new DimensionImpl[size];
        HashSet[] dimMembers = new HashSet[size];
        this.bitSets = new IntBitSet[size];
        this.bindexes = new int[size];
        for (int i = 0; i < dims.length; ++i) {
            dimInfo = (DimInfo)dimInfos.get(i);
            dims[i] = dimInfo.dim;
            dimMembers[i] = dimInfo.members;
            this.bitSets[i] = dimInfo.bitSet;
            this.bindexes[i] = dimInfo.dimOrder;
        }
        this.dimMatrix = new DimMatrix(evaluator.getCube(), (DimensionImpl[])dims, dimMembers);
        this.bbFilter = new DImBBFilterIndex(this.dimMatrix, evaluator.getCube(), dims);
    }

    public BBFilterIndex getBBFilter() {
        return this.bbFilter;
    }

    public int[] getDimOrdinals() {
        return this.bindexes;
    }

    public boolean inBBFilter(Member[] members) {
        return this.dimMatrix != null && this.dimMatrix.inBBFilter(members);
    }

    public boolean validate(Member[] members, Evaluator evaluator) {
        if (!this.builded) {
            this.build(evaluator);
        }
        return this.validate(members);
    }

    public boolean validate(Member[] members) {
        for (int i = 0; i < this.bindexes.length; ++i) {
            if (this.bitSets[i].get(members[this.bindexes[i]].getGlobalOrder())) continue;
            return false;
        }
        return true;
    }

    public static class DimMatrix {
        private final int[] dimIndexs;
        private final Set<Integer>[] memberScope;

        public DimMatrix(Cube cube, DimensionImpl[] dims, HashSet<Member>[] dimMembers) {
            int dimSize = dims.length;
            this.dimIndexs = new int[dimSize];
            this.memberScope = new Set[dimSize];
            int in = dims.length;
            for (int i = 0; i < in; ++i) {
                DimensionImpl _dim = dims[i];
                this.dimIndexs[i] = _dim.getOrdinal(cube);
                LinkedHashSet<Integer> scopes = new LinkedHashSet<Integer>();
                HashSet<Member> _members = dimMembers[i];
                _members.forEach(m -> scopes.add(m.getGlobalOrder()));
                this.memberScope[i] = scopes;
            }
        }

        public boolean inBBFilter(Member[] members) {
            boolean hasIn = true;
            for (int i = 0; i < this.dimIndexs.length && hasIn; ++i) {
                int _index = this.dimIndexs[i];
                hasIn = this.memberScope[i].contains(members[_index].getGlobalOrder());
            }
            return hasIn;
        }
    }

    public static final class DImBBFilterIndex
    extends BBFilterIndex {
        private DimMatrix matrix = null;

        public DImBBFilterIndex(DimMatrix matrix, Cube cube, Dimension ... dims) {
            super(cube, dims);
            this.matrix = matrix;
        }

        @Override
        public boolean get(Member[] members) {
            return this.matrix != null && this.matrix.inBBFilter(members);
        }
    }

    private static class DimInfo {
        private DimensionImpl dim;
        private IntBitSet bitSet;
        private int dimOrder;
        private HashSet<Member> members;

        DimInfo(DimensionImpl dim, int dimOrder) {
            this.dim = dim;
            this.dimOrder = dimOrder;
            this.bitSet = BitSetFactory.createIntBitSet();
            this.members = new HashSet();
        }
    }
}

