/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.algo.olap.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.epm.eb.algo.olap.LeafFeature;
import kd.epm.eb.algo.olap.Member;
import kd.epm.eb.algo.olap.MemberScope;
import kd.epm.eb.algo.olap.MemberScopeBuilder;
import kd.epm.eb.algo.olap.MetadataAPI;
import kd.epm.eb.algo.olap.OlapException;
import kd.epm.eb.algo.olap.impl.DimensionImpl;
import kd.epm.eb.algo.olap.impl.MemberImpl;
import kd.epm.eb.algo.olap.impl.MemberScopeImpl;
import kd.epm.eb.algo.olap.impl.ScopeBuilderImpl;
import kd.epm.eb.algo.olap.mdx.Exp;
import kd.epm.eb.algo.olap.mdx.FunDef;
import kd.epm.eb.algo.olap.mdx.SchemaReader;
import kd.epm.eb.algo.olap.mdx.UserDefineFunTable;
import kd.epm.eb.algo.olap.mdx.calc.Calc;

public class MetadataAPIImpl
implements MetadataAPI {
    private SchemaReader schemaReader;
    private HashMap<String, MemberScope> scopeMap = new HashMap();
    private HashMap<String, MemberScope> scopeMapByContent = new HashMap();
    private DimensionImpl calcDimension = null;
    private ArrayList<Member> rollupMembers;
    private List<String> disableCalcDimMembers;
    private List<String[]> disableCalcMembers;
    private UserDefineFunTable udfTable;

    public MetadataAPIImpl(SchemaReader schemaReader) {
        this.schemaReader = schemaReader;
        this.udfTable = new UserDefineFunTable();
    }

    @Override
    public MemberScopeBuilder getMemberScopeBuilder() {
        return new ScopeBuilderImpl();
    }

    @Override
    public void addMemberWeight(String uniqueName, int weight) {
        MemberImpl member = (MemberImpl)this.schemaReader.getMemberByUniqueName(uniqueName);
        member.setWeight(weight);
    }

    @Override
    public void addMemberWeight(String uniqueName, BigDecimal weight) {
        MemberImpl member = (MemberImpl)this.schemaReader.getMemberByUniqueName(uniqueName);
        member.setWeight(weight);
    }

    @Override
    public void setRollupMembers(List<String> memberUniqueNames) {
        ArrayList<Member> members = new ArrayList<Member>();
        for (String uniqueName : memberUniqueNames) {
            members.add(this.schemaReader.getMemberByUniqueName(uniqueName));
        }
        this.rollupMembers = members;
    }

    @Override
    public void addDefaultMemberExpression(String uniqueName, String expression, LeafFeature leafFeature) {
        MemberImpl member = (MemberImpl)this.schemaReader.getMemberByUniqueName(uniqueName);
        Exp exp = this.schemaReader.parseExpression(expression, true);
        if (LeafFeature.LEAF == leafFeature && !member.isLeaf()) {
            return;
        }
        member.setExpression(exp, leafFeature);
        Calc calc = this.schemaReader.compileExpression(exp, true);
        member.setCalc(calc);
        member.setHasData(true);
        DimensionImpl dim = (DimensionImpl)member.getDimension();
        if (this.calcDimension == null) {
            this.calcDimension = dim;
        } else if (this.calcDimension != dim) {
            throw new OlapException("Olap support one dimension has member expression.");
        }
        switch (leafFeature) {
            case ALL: {
                dim.putCalcMemberOfAll(member);
                break;
            }
            case LEAF: {
                dim.putCalcMemberOfLeaf(member);
                break;
            }
            case NOTLEAF: {
                dim.putCalcMemberOfNotLeaf(member);
            }
        }
    }

    @Override
    public void addScopedMemberExpression(String uniqueName, String scopeName, String expression, LeafFeature leafFeature) {
        MemberScopeImpl scope = (MemberScopeImpl)this.scopeMap.get(scopeName);
        if (scope == null) {
            throw new OlapException("Scope not found: " + scopeName);
        }
        MemberScopeImpl scope2 = (MemberScopeImpl)this.scopeMapByContent.get(scope.getContentString());
        if (scope2 == null) {
            throw new OlapException("Scope not found by content: " + scopeName);
        }
        scope = scope2;
        MemberImpl member = (MemberImpl)this.schemaReader.getMemberByUniqueName(uniqueName);
        Exp exp = this.schemaReader.parseExpression(expression, true);
        Calc calc = this.schemaReader.compileExpression(exp, true);
        if (LeafFeature.LEAF == leafFeature && !member.isLeaf()) {
            return;
        }
        member.addScopedCalc(scope, calc, leafFeature);
        member.setHasData(true);
        DimensionImpl dim = (DimensionImpl)member.getDimension();
        if (this.calcDimension == null) {
            this.calcDimension = dim;
        } else if (this.calcDimension != dim) {
            throw new OlapException("Olap support one dimension has member expression.");
        }
        switch (leafFeature) {
            case ALL: {
                dim.putCalcMemberOfAll(member);
                break;
            }
            case LEAF: {
                dim.putCalcMemberOfLeaf(member);
                break;
            }
            case NOTLEAF: {
                dim.putCalcMemberOfNotLeaf(member);
            }
        }
    }

    @Override
    public void addMemberSope(MemberScope scope) {
        if (this.scopeMap.put(scope.getName(), scope) != null) {
            throw new OlapException("scope " + scope.getName() + " already exists.");
        }
        String content = ((MemberScopeImpl)scope).getContentString();
        if (!this.scopeMapByContent.containsKey(content)) {
            this.scopeMapByContent.put(content, scope);
        }
    }

    @Override
    public void addMemberScope(String name, String dimension, String expression) {
        MemberScope scope = this.scopeMap.get(name);
        if (scope == null) {
            scope = new MemberScopeImpl(name);
            this.scopeMap.put(scope.getName(), scope);
            ((MemberScopeImpl)scope).addPair(dimension, expression);
            String content = ((MemberScopeImpl)scope).getContentString();
            if (!this.scopeMapByContent.containsKey(content)) {
                this.scopeMapByContent.put(content, scope);
            }
        } else {
            MemberScopeImpl scope2 = (MemberScopeImpl)scope;
            this.scopeMapByContent.remove(scope2.getContentString());
            scope2.addPair(dimension, expression);
            String content = ((MemberScopeImpl)scope).getContentString();
            if (!this.scopeMapByContent.containsKey(content)) {
                this.scopeMapByContent.put(content, scope);
            }
        }
    }

    public List<Member> getRollupMembers() {
        return this.rollupMembers;
    }

    public List<String> getDisableCalcDimMembers() {
        return this.disableCalcDimMembers;
    }

    public void setDisableCalcDimMembers(List<String> disableCalcDimMembers) {
        this.disableCalcDimMembers = disableCalcDimMembers;
    }

    public List<String[]> getDisableCalcMembers() {
        return this.disableCalcMembers;
    }

    public void setDisableCalcMembers(List<String[]> disableCalcMembers) {
        this.disableCalcMembers = disableCalcMembers;
    }

    public UserDefineFunTable getUdfTable() {
        return this.udfTable;
    }

    @Override
    public void addFunDef(FunDef funDef) {
        this.udfTable.define(funDef);
    }
}

