/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.algo.olap.impl;

import java.util.concurrent.ExecutorService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.algo.olap.OlapThreadPoolFactory;
import kd.epm.eb.algo.olap.dbsource.SqlWithParamTableDef;

public class OlapThreadPool {
    public static final Log log = LogFactory.getLog(SqlWithParamTableDef.class);
    private static String factoryClassName = System.getProperty("algo.olap.threadpoolfactory", "kd.epm.eb.algo.olap.ThreadPoolFactory");
    private static OlapThreadPoolFactory factory = null;
    private static ExecutorService es;

    public static boolean support() {
        return es != null;
    }

    public static void execute(Runnable r) {
        es.execute(r);
    }

    public static void release() {
        es.shutdown();
    }

    static {
        try {
            factory = (OlapThreadPoolFactory)Class.forName(factoryClassName).newInstance();
            es = factory.createExecutorService();
        }
        catch (Throwable t) {
            log.error("OlapThreadPoolFactory-error:", t);
        }
    }
}

