/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.algo.olap.impl;

import java.util.ArrayList;
import java.util.List;
import kd.epm.eb.algo.olap.Dimension;
import kd.epm.eb.algo.olap.MemberExpression;
import kd.epm.eb.algo.olap.OlapException;
import kd.epm.eb.algo.olap.def.CalculatedMemberDef;
import kd.epm.eb.algo.olap.def.ConditionalExpressionDef;
import kd.epm.eb.algo.olap.def.CubeDef;
import kd.epm.eb.algo.olap.def.DimensionUsageDef;
import kd.epm.eb.algo.olap.def.HierarchyDef;
import kd.epm.eb.algo.olap.def.LevelDef;
import kd.epm.eb.algo.olap.def.MeasureDef;
import kd.epm.eb.algo.olap.def.MemberExpressionDef;
import kd.epm.eb.algo.olap.def.PartitionDef;
import kd.epm.eb.algo.olap.def.PropertyDef;
import kd.epm.eb.algo.olap.def.RelationDef;
import kd.epm.eb.algo.olap.def.SchemaDef;
import kd.epm.eb.algo.olap.def.SharedDimensionDef;
import kd.epm.eb.algo.olap.impl.CalculatedMemberImpl;
import kd.epm.eb.algo.olap.impl.CubeImpl;
import kd.epm.eb.algo.olap.impl.DimensionImpl;
import kd.epm.eb.algo.olap.impl.HierarchyImpl;
import kd.epm.eb.algo.olap.impl.LevelImpl;
import kd.epm.eb.algo.olap.impl.MemberImpl;
import kd.epm.eb.algo.olap.impl.PartitionImpl;
import kd.epm.eb.algo.olap.impl.PropertyImpl;
import kd.epm.eb.algo.olap.impl.RelationImpl;
import kd.epm.eb.algo.olap.impl.SchemaImpl;
import kd.epm.eb.algo.olap.mdx.Exp;
import kd.epm.eb.algo.olap.mdx.Formula;
import kd.epm.eb.algo.olap.mdx.Literal;
import kd.epm.eb.algo.olap.mdx.MemberProperty;
import kd.epm.eb.algo.olap.mdx.ParserHelp;
import kd.epm.eb.algo.olap.util.Util;

public class SchemaBuilder {
    public static SchemaImpl buildSchema(SchemaDef def) throws OlapException {
        int i;
        SchemaImpl schema = new SchemaImpl();
        schema.setProperty("name", def.name);
        schema.setProperty("caption", def.caption);
        schema.setProperty("description", def.description);
        schema.dims = null;
        schema.dims = def.dimensions == null ? new DimensionImpl[0] : new DimensionImpl[def.dimensions.length];
        for (i = 0; i < schema.dims.length; ++i) {
            schema.dims[i] = SchemaBuilder.buildSharedDimension(schema, def.dimensions[i]);
        }
        for (i = 0; i < schema.dims.length; ++i) {
            String dependon = (String)schema.dims[i].getProperty("dependOnDimension");
            if (dependon == null) continue;
            schema.dims[i].setProperty("dependOnDimension", schema.getDimension(dependon));
        }
        if (def.relations != null) {
            schema.relations = new RelationImpl[def.relations.length];
            for (i = 0; i < schema.relations.length; ++i) {
                schema.relations[i] = SchemaBuilder.buildRelation(schema, def.relations[i]);
            }
        }
        if (def.partition != null) {
            schema.partition = SchemaBuilder.buildPartition(schema, def.partition);
        }
        schema.cubes = new CubeImpl[def.cubes.length];
        for (i = 0; i < schema.cubes.length; ++i) {
            schema.cubes[i] = SchemaBuilder.buildCube(schema, def.cubes[i]);
        }
        return schema;
    }

    private static PartitionImpl buildPartition(SchemaImpl schema, PartitionDef partition) throws OlapException {
        String[] parts = partition.dimensions.split(",");
        if (parts.length != 1) {
            throw new OlapException("Only one partition dimensions supported now.");
        }
        Dimension dim = schema.getDimension(parts[0]);
        if (dim == null) {
            throw new OlapException("Partition dimension " + parts[0] + " not found.");
        }
        if (dim.getDimensionType() != 0 || dim.getHierarchy().getLevels().length != 1 || dim.isParentChildrenDimension()) {
            throw new OlapException("Partition dimension only support one level Standard Dimension.");
        }
        return new PartitionImpl(dim);
    }

    private static RelationImpl buildRelation(SchemaImpl schema, RelationDef relationDef) throws OlapException {
        RelationImpl rel = new RelationImpl();
        rel.name = relationDef.name;
        String[] parts = relationDef.dimensions.split(",");
        Dimension[] dims = new Dimension[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            dims[i] = schema.getDimension(parts[i].trim());
            if (dims[i] != null) continue;
            throw new OlapException("Dimension " + parts[i] + " not found.");
        }
        rel.setDimensions(dims);
        return rel;
    }

    private static DimensionImpl buildSharedDimension(SchemaImpl schema, SharedDimensionDef x) throws OlapException {
        DimensionImpl dim = new DimensionImpl();
        dim.setProperty("name", x.name);
        dim.setProperty("caption", x.caption);
        dim.setProperty("description", x.description);
        dim.setProperty("table", x.table);
        dim.setProperty("sql", x.sql);
        dim.setProperty("type", x.type);
        dim.setProperty("primaryKey", x.primaryKey);
        dim.dimensionType = x.type != null && x.type.equalsIgnoreCase("Time") ? (byte)1 : 0;
        dim.hies = new HierarchyImpl[x.hierarchies.length];
        for (int i = 0; i < dim.hies.length; ++i) {
            dim.hies[i] = SchemaBuilder.buildHierarchy(i, dim, x.hierarchies[i]);
        }
        dim.setProperty("Permission", x.permission);
        dim.setProperty("dependOnDimension", x.dependOnDimension);
        return dim;
    }

    private static HierarchyImpl buildHierarchy(int ordinal, DimensionImpl dim, HierarchyDef x) throws OlapException {
        int i;
        HierarchyImpl hie = new HierarchyImpl(dim, x.name, x.caption);
        hie.ordinal = ordinal;
        hie.setProperty("description", x.description);
        hie.setProperty("hasAll", x.hasAll);
        hie.setProperty("allMemberName", x.allMemberName);
        hie.setProperty("allMemberCaption", x.allMemberCaption);
        hie.setProperty("virtualAllMemberCaption", x.v$AllMemberCaption);
        hie.levels = new LevelImpl[x.levels.length];
        for (i = 0; i < hie.levels.length; ++i) {
            hie.levels[i] = SchemaBuilder.buildLevel(hie, x.levels[i]);
        }
        for (i = 0; i < hie.levels.length; ++i) {
            if (i > 0) {
                hie.levels[i].parent = hie.levels[i - 1];
            }
            if (i < hie.levels.length - 1) {
                hie.levels[i].child = hie.levels[i + 1];
            }
            hie.levels[i].depth = x.hasAll ? (byte)(i + 1) : (byte)i;
        }
        return hie;
    }

    private static LevelImpl buildLevel(HierarchyImpl hie, LevelDef x) throws OlapException {
        LevelImpl level = new LevelImpl();
        level.hie = hie;
        level.setProperty("name", x.name);
        level.setProperty("caption", x.caption);
        level.setProperty("description", x.description);
        level.setProperty("type", x.type);
        level.levelType = x.type == null ? (byte)0 : Util.getLevelType(x.type);
        level.setProperty("column", x.column);
        level.setProperty("orderBy", x.orderBy);
        level.setProperty("parentColumn", x.parentColumn);
        level.setProperty("childColumn", x.childColumn);
        level.setProperty("dataType", x.dataType);
        level.setProperty("closureDataType", x.closureDataType);
        level.setProperty("rule", x.rule);
        level.props = new PropertyImpl[x.properties.length];
        for (int i = 0; i < level.props.length; ++i) {
            level.props[i] = SchemaBuilder.buildProperty(x.properties[i]);
        }
        if (x.parentColumn != null) {
            hie.dim.isParentChildren = true;
        }
        return level;
    }

    private static PropertyImpl buildProperty(PropertyDef x) {
        PropertyImpl p = new PropertyImpl();
        p.setProperty("name", x.name);
        p.setProperty("caption", x.caption);
        p.setProperty("description", x.description);
        p.setProperty("column", x.column);
        p.setProperty("dataType", x.dataType);
        return p;
    }

    private static CubeImpl buildCube(SchemaImpl schema, CubeDef x) throws OlapException {
        int i;
        CubeImpl cube = new CubeImpl(x);
        cube.schema = schema;
        cube.setProperty("name", x.name);
        cube.setProperty("caption", x.caption);
        cube.setProperty("description", x.description);
        cube.setProperty("table", x.table);
        cube.initMeasures(x);
        cube.dims = new DimensionImpl[x.dimensions.length];
        for (int i2 = 0; i2 < cube.dims.length; ++i2) {
            if (!(x.dimensions[i2] instanceof DimensionUsageDef)) continue;
            cube.dims[i2] = SchemaBuilder.buildDimensionUsage((DimensionImpl)schema.getDimension(x.dimensions[i2].name), (DimensionUsageDef)x.dimensions[i2]);
        }
        DimensionImpl md = cube.measureDimension;
        cube.measures = new MemberImpl[x.measures.length];
        for (i = 0; i < cube.measures.length; ++i) {
            MemberImpl measure;
            cube.measures[i] = measure = SchemaBuilder.buildMeasure(cube, x.measures[i]);
            measure.globalOrder = i;
            measure.ordinal = i;
            md.mapOrderToMember.put(i, measure);
        }
        md.memberCount = cube.measures.length;
        cube.measureHierarchy.setMembers(cube.measures);
        if (x.calculatedMembers == null) {
            cube.calculatedMembers = new CalculatedMemberImpl[0];
        } else {
            cube.calculatedMembers = new CalculatedMemberImpl[x.calculatedMembers.length];
            for (i = 0; i < x.calculatedMembers.length; ++i) {
                cube.calculatedMembers[i] = SchemaBuilder.buildCalculatedMember(cube, x.calculatedMembers[i]);
            }
        }
        if (x.memberExpressions == null) {
            cube.memberExpressions = new MemberExpression[0];
        } else {
            cube.memberExpressions = new MemberExpression[x.memberExpressions.length];
            for (i = 0; i < x.memberExpressions.length; ++i) {
                cube.memberExpressions[i] = SchemaBuilder.buildMemberExpression(cube, x.memberExpressions[i]);
            }
        }
        return cube;
    }

    private static MemberExpression buildMemberExpression(CubeImpl cube, MemberExpressionDef memberExpressionDef) {
        List<ConditionalExpressionDef> list;
        MemberExpression me = new MemberExpression(memberExpressionDef.getUniqueName());
        if (memberExpressionDef.getExpressionDef() != null) {
            me.setExpression(memberExpressionDef.getExpressionDef().getText());
        }
        if ((list = memberExpressionDef.getConditionalExpressionList()) != null) {
            for (ConditionalExpressionDef ce : list) {
                me.addConditionalExpression(ce.getCondition().getText(), ce.getExpression().getText());
            }
        }
        return me;
    }

    private static CalculatedMemberImpl buildCalculatedMember(CubeImpl cube, CalculatedMemberDef def) throws OlapException {
        String[] uniqueName = new String[]{def.dimension, def.name};
        Exp exp = ParserHelp.parseExpression(def.formula);
        ArrayList<MemberProperty> jlist = new ArrayList<MemberProperty>();
        if (def.formatString != null) {
            jlist.add(new MemberProperty("formatString", Literal.createString(def.formatString)));
        }
        if (def.color != null) {
            jlist.add(new MemberProperty("color", Literal.createString(def.color)));
        }
        if (def.bgColor != null) {
            jlist.add(new MemberProperty("bgColor", Literal.createString(def.bgColor)));
        }
        if (def.trend != null) {
            jlist.add(new MemberProperty("trend", Literal.createString(def.trend)));
        }
        if (def.status != null) {
            jlist.add(new MemberProperty("status", Literal.createString(def.status)));
        }
        if (def.solveOrder != null) {
            jlist.add(new MemberProperty("SOLVE_ORDER", Literal.create(Integer.valueOf(def.solveOrder))));
        }
        if (def.caption != null) {
            jlist.add(new MemberProperty("caption", Literal.createString(def.caption)));
        }
        if (!def.visible) {
            jlist.add(new MemberProperty("visible", Literal.createString("false")));
        }
        if (def.properties != null) {
            for (int i = 0; i < def.properties.length; ++i) {
                jlist.add(new MemberProperty(def.properties[i].name, Literal.createString(def.properties[i].value)));
            }
        }
        MemberProperty[] properties = new MemberProperty[jlist.size()];
        jlist.toArray(properties);
        Formula formula = new Formula(uniqueName, exp, properties, null);
        Dimension dim = cube.getDimension(def.dimension);
        CalculatedMemberImpl m = (CalculatedMemberImpl)dim.getDefaultHierarchy().createMember(def.name, def.caption, formula, true);
        formula.setMember(m);
        return m;
    }

    private static DimensionImpl buildDimensionUsage(DimensionImpl source, DimensionUsageDef x) throws OlapException {
        source.setProperty("foreignKey", x.foreignKey);
        return source;
    }

    private static MemberImpl buildMeasure(CubeImpl cube, MeasureDef x) {
        MemberImpl measure = new MemberImpl();
        if (x.name.equals("V$COUNTMEASURE")) {
            measure = (MemberImpl)cube.measureHierarchy.lookupInnerMember(x.name);
            measure.setProperty("caption", x.caption);
            return measure;
        }
        measure.memberType = (byte)2;
        measure.level = cube.measureLevel;
        measure.setProperty("name", x.name);
        measure.setProperty("caption", x.caption);
        measure.setProperty("description", x.description);
        measure.setProperty("column", x.column);
        measure.setProperty("aggregator", x.aggregator);
        measure.setProperty("formatString", x.formatString);
        measure.setProperty("color", x.color);
        measure.setProperty("bgColor", x.bgColor);
        measure.setProperty("trend", x.trend);
        measure.setProperty("status", x.status);
        measure.setProperty("visible", x.visible);
        if (x.properties != null) {
            for (int i = 0; i < x.properties.length; ++i) {
                measure.setProperty(x.properties[i].name, x.properties[i].value);
            }
        }
        return measure;
    }
}

