/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.algo.olap.mdx;

import java.io.Serializable;
import java.util.ArrayList;
import kd.epm.eb.algo.olap.Member;
import kd.epm.eb.algo.olap.OlapElement;
import kd.epm.eb.algo.olap.OlapException;
import kd.epm.eb.algo.olap.mdx.Exp;
import kd.epm.eb.algo.olap.mdx.ExpBase;
import kd.epm.eb.algo.olap.mdx.ExpResolver;
import kd.epm.eb.algo.olap.mdx.FunTable;
import kd.epm.eb.algo.olap.mdx.Literal;
import kd.epm.eb.algo.olap.mdx.SchemaLookup;
import kd.epm.eb.algo.olap.mdx.type.Type;

public class CompoundId
extends ExpBase {
    private static final long serialVersionUID = 1090901463536428209L;
    private ArrayList<NamePart> names = new ArrayList();

    public CompoundId(String name, boolean isKey) {
        this.names.add(new NamePart(name, isKey, false));
    }

    public CompoundId(String name, boolean isKey, boolean isMemberRef) {
        this.names.add(new NamePart(name, isKey, isMemberRef));
    }

    public CompoundId(String name) {
        this(name, false);
    }

    public CompoundId(String[] names) {
        for (int i = 0; i < names.length; ++i) {
            this.names.add(new NamePart(names[i], false, false));
        }
    }

    public void append(String name, boolean isKey) {
        this.names.add(new NamePart(name, isKey, false));
    }

    public void append(String name, boolean isKey, boolean isMemberRef) {
        this.names.add(new NamePart(name, isKey, isMemberRef));
    }

    public void append(String name) {
        this.names.add(new NamePart(name, false, false));
    }

    public String[] toStringArray() {
        String[] ret = new String[this.names.size()];
        int i = 0;
        for (NamePart np : this.names) {
            ret[i++] = np.name;
        }
        return ret;
    }

    private CompoundId() {
    }

    @Override
    public Object clone() {
        CompoundId cloned = new CompoundId();
        for (NamePart np : this.names) {
            cloned.append(np.name, np.isKey, np.isMemberRef);
        }
        return cloned;
    }

    @Override
    public int getCategory() {
        return 0;
    }

    @Override
    public Exp resolve(ExpResolver resolver) throws OlapException {
        int size = this.names.size();
        if (size == 1) {
            String s = this.names.get(0).name;
            if (FunTable.instance.isReserved(s)) {
                if (s.equalsIgnoreCase("NULL")) {
                    return Literal.createNull();
                }
                return Literal.createSymbol(s.toUpperCase());
            }
        } else if (size == 2 && this.names.get(1).isMemberRef) {
            Member e = resolver.getSchemaReader().getMemberByName(this.names.get(0).name, this.names.get(1).name);
            return SchemaLookup.createExpr(e);
        }
        OlapElement e = SchemaLookup.lookup(resolver.getSchemaReader(), this.toStringArray());
        return SchemaLookup.createExpr(e);
    }

    @Override
    public Type getType() {
        throw new UnsupportedOperationException();
    }

    public void unparse(StringBuffer sb) {
        boolean isFollow = false;
        for (NamePart np : this.names) {
            if (isFollow) {
                sb.append(".");
            }
            isFollow = true;
            if (np.isKey) {
                sb.append("&");
            }
            sb.append("`").append(np.name).append("`");
        }
    }

    private static class NamePart
    implements Serializable {
        private static final long serialVersionUID = -7887871473708983625L;
        private String name;
        private boolean isKey;
        private boolean isMemberRef;

        protected NamePart(String name, boolean isKey, boolean isMemberRef) {
            name = name.trim();
            if (isKey) {
                name = name.substring(1, name.length());
            }
            if (name.startsWith("[") || name.startsWith("`")) {
                name = name.substring(1, name.length() - 1);
            }
            this.name = name;
            this.isKey = isKey;
            this.isMemberRef = isMemberRef;
        }
    }
}

