/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.algo.olap.mdx;

import java.io.Serializable;
import kd.epm.eb.algo.olap.Dimension;
import kd.epm.eb.algo.olap.Member;
import kd.epm.eb.algo.olap.OlapException;
import kd.epm.eb.algo.olap.mdx.Exp;
import kd.epm.eb.algo.olap.mdx.FunCall;
import kd.epm.eb.algo.olap.mdx.Syntax;
import kd.epm.eb.algo.olap.mdx.calc.Calc;
import kd.epm.eb.algo.olap.mdx.calc.ExpCompiler;
import kd.epm.eb.algo.olap.mdx.type.Type;

public abstract class ExpBase
implements Exp,
Serializable {
    public static final long serialVersionUID = 4576383108127547547L;

    protected ExpBase() {
    }

    @Override
    public abstract Object clone();

    @Override
    public final boolean isSet() {
        int cat = this.getCategory();
        return cat == 8 || cat == 10;
    }

    @Override
    public final boolean isMember() {
        return this.getCategory() == 6;
    }

    @Override
    public final boolean isElement() {
        int category = this.getCategory();
        return this.isMember() || category == 3 || category == 4 || category == 2;
    }

    @Override
    public final boolean isEmptySet() {
        if (this instanceof FunCall) {
            FunCall f = (FunCall)this;
            return f.getSyntax() == Syntax.Braces && f.getArgCount() == 0;
        }
        return false;
    }

    public final Member[] isConstantTuple() {
        if (this instanceof Member) {
            return new Member[]{(Member)((Object)this)};
        }
        if (!(this instanceof FunCall)) {
            return null;
        }
        FunCall f = (FunCall)this;
        if (!f.isCallToTuple()) {
            return null;
        }
        int len = f.getArgCount();
        for (int i = 0; i < len; ++i) {
            if (f.getArg(i) instanceof Member) continue;
            return null;
        }
        Member[] members = new Member[len];
        System.arraycopy(f.getArgs(), 0, members, 0, len);
        return members;
    }

    public static int[] getCategorys(Exp[] exps) {
        int[] types = new int[exps.length];
        for (int i = 0; i < exps.length; ++i) {
            types[i] = exps[i].getCategory();
        }
        return types;
    }

    @Override
    public boolean dependsOn(Dimension dimension) {
        Type type = this.getType();
        return !type.usesDimension(dimension);
    }

    @Override
    public String toMdx() {
        StringBuilder sb = new StringBuilder();
        this.unparse(sb);
        return sb.toString();
    }

    @Override
    public void unparse(StringBuilder sb) {
        sb.append(this.toString());
    }

    public static void unparseList(StringBuilder sb, Exp[] exps, String start, String mid, String end) {
        sb.append(start);
        for (int i = 0; i < exps.length; ++i) {
            if (i > 0) {
                sb.append(mid);
            }
            exps[i].unparse(sb);
        }
        sb.append(end);
    }

    static Exp[] cloneArray(Exp[] a) {
        Exp[] a2 = new Exp[a.length];
        for (int i = 0; i < a.length; ++i) {
            a2[i] = (Exp)a[i].clone();
        }
        return a2;
    }

    @Override
    public Calc compile(ExpCompiler compiler) throws OlapException {
        throw new UnsupportedOperationException(this.toString());
    }
}

