/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.algo.olap.mdx;

import kd.epm.eb.algo.olap.Cube;
import kd.epm.eb.algo.olap.Dimension;
import kd.epm.eb.algo.olap.Hierarchy;
import kd.epm.eb.algo.olap.Level;
import kd.epm.eb.algo.olap.OlapException;
import kd.epm.eb.algo.olap.mdx.Category;
import kd.epm.eb.algo.olap.mdx.Exp;
import kd.epm.eb.algo.olap.mdx.ExpResolver;
import kd.epm.eb.algo.olap.mdx.FunCall;
import kd.epm.eb.algo.olap.mdx.FunDef;
import kd.epm.eb.algo.olap.mdx.FuncResolver;
import kd.epm.eb.algo.olap.mdx.Syntax;
import kd.epm.eb.algo.olap.mdx.TypeConvertUtil;
import kd.epm.eb.algo.olap.mdx.func.FuncUtil2;
import kd.epm.eb.algo.olap.mdx.type.BooleanType;
import kd.epm.eb.algo.olap.mdx.type.CubeType;
import kd.epm.eb.algo.olap.mdx.type.DimensionType;
import kd.epm.eb.algo.olap.mdx.type.HierarchyType;
import kd.epm.eb.algo.olap.mdx.type.LevelType;
import kd.epm.eb.algo.olap.mdx.type.MemberType;
import kd.epm.eb.algo.olap.mdx.type.NumericType;
import kd.epm.eb.algo.olap.mdx.type.ScalarType;
import kd.epm.eb.algo.olap.mdx.type.SetType;
import kd.epm.eb.algo.olap.mdx.type.StringType;
import kd.epm.eb.algo.olap.mdx.type.SymbolType;
import kd.epm.eb.algo.olap.mdx.type.Type;
import kd.epm.eb.algo.olap.mdx.type.TypeUtil;
import kd.epm.eb.algo.olap.util.Util;

public abstract class FunDefBase
implements FunDef {
    private final Syntax syntax;
    private final String name;
    private final String description;
    protected final int returnCategory;
    protected final int[] argCategorys;

    public FunDefBase(String name, String description, Syntax syntax, int returnCategory, int[] argCategorys) {
        this.name = name;
        this.description = description;
        this.syntax = syntax;
        this.returnCategory = returnCategory;
        this.argCategorys = argCategorys;
    }

    protected FunDefBase(String name, String signature, String description, String flags) {
        this(name, description, FuncUtil2.decodeSyntacticType(flags), FuncUtil2.decodeReturnCategory(flags), FuncUtil2.decodeArgCategory(flags));
    }

    public FunDefBase(FuncResolver resolver, int returnCategory, int[] argCategorys) {
        this(resolver.getName(), null, resolver.getSyntax(), returnCategory, argCategorys);
    }

    public FunDefBase(FunDef funDef) {
        this(funDef.getName(), funDef.getDescription(), funDef.getSyntax(), funDef.getReturnCategory(), funDef.getArgCategorys());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Syntax getSyntax() {
        return this.syntax;
    }

    @Override
    public int getReturnCategory() {
        return this.returnCategory;
    }

    @Override
    public int[] getArgCategorys() {
        return this.argCategorys;
    }

    @Override
    public FunCall resolveCall(ExpResolver resolver, FunCall call) throws OlapException {
        int[] types = this.getArgCategorys();
        Exp[] args = call.getArgs();
        for (int i = 0; i < args.length; ++i) {
            Exp arg = args[i];
            args[i] = TypeConvertUtil.convert(arg, types[i], resolver);
        }
        Type type = this.getResultType(resolver, args);
        if (type == null) {
            throw new OlapException("could not derive type");
        }
        call.setType(type);
        call.setResolved(true);
        return call;
    }

    static Type guessResultType(Exp[] args, int category, String name) {
        switch (category) {
            case 5: {
                return new BooleanType();
            }
            case 7: {
                return new NumericType();
            }
            case 9: {
                return new StringType();
            }
            case 11: {
                return new SymbolType();
            }
            case 13: {
                return new ScalarType();
            }
            case 12: {
                if (args.length <= 0 || !(args[0] instanceof Cube)) break;
                return new CubeType((Cube)((Object)args[0]));
            }
            case 2: {
                if (args.length <= 0) break;
                Type type = args[0].getType();
                Hierarchy hierarchy = type.getHierarchy();
                Dimension dimension = hierarchy == null ? null : hierarchy.getDimension();
                return new DimensionType(dimension);
            }
            case 3: {
                if (args.length <= 0) break;
                Type type = args[0].getType();
                Hierarchy hierarchy = type.getHierarchy();
                return new HierarchyType(hierarchy);
            }
            case 4: {
                if (args.length <= 0 || !(args[0] instanceof Level)) break;
                Type type = args[0].getType();
                Level level = TypeUtil.typeToLevel(type);
                return new LevelType(level.getHierarchy(), level);
            }
            case 6: 
            case 10: {
                if (args.length > 0) {
                    Type type = args[0].getType();
                    if ((type = TypeUtil.toMemberType(type)) != null) {
                        return type;
                    }
                }
                return MemberType.Unknown;
            }
            case 8: {
                if (args.length <= 0) break;
                Type type = args[0].getType();
                return new SetType(TypeUtil.toMemberType(type));
            }
            default: {
                throw Category.instance.badValue(category);
            }
        }
        throw Util.newInternal("Cannot deduce type of call to function '" + name + "'");
    }

    public Type getResultType(ExpResolver resolver, Exp[] args) throws OlapException {
        return FunDefBase.guessResultType(args, this.getReturnCategory(), this.name);
    }

    @Override
    public void unparse(Exp[] args, StringBuilder sb) {
        this.getSyntax().unparse(this.getName(), args, sb);
    }

    @Override
    public boolean shouldCacheFact() {
        return false;
    }
}

