/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.algo.olap.mdx;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.epm.eb.algo.olap.OlapException;
import kd.epm.eb.algo.olap.mdx.FunCall;
import kd.epm.eb.algo.olap.mdx.FunDef;
import kd.epm.eb.algo.olap.mdx.FunFactory;
import kd.epm.eb.algo.olap.mdx.FuncResolver;
import kd.epm.eb.algo.olap.mdx.FunctionException;
import kd.epm.eb.algo.olap.mdx.SimpleFuncResolver;
import kd.epm.eb.algo.olap.mdx.Syntax;
import kd.epm.eb.algo.olap.mdx.func.BaseFunFactory;
import kd.epm.eb.algo.olap.util.IntHolder;

public class FunTable {
    public static FunTable instance = new FunTable();
    private final List resolvers = new ArrayList();
    private final HashSet reservedWords = new HashSet();
    private final HashSet propertyWords = new HashSet();
    private HashMap<String, ArrayList<FuncResolver>> mapNameToResolvers = new HashMap();
    private FunFactory[] funFactorys = new FunFactory[]{new BaseFunFactory(this)};

    private FunTable() {
        this.init();
    }

    private void init() {
        int i;
        this.defineReserved("NULL");
        for (i = 0; i < this.funFactorys.length; ++i) {
            this.funFactorys[i].defineFunctions();
        }
        int n = this.resolvers.size();
        for (i = 0; i < n; ++i) {
            FuncResolver resolver = (FuncResolver)this.resolvers.get(i);
            String key = FunTable.makeResolverKey(resolver.getName(), resolver.getSyntax());
            ArrayList<FuncResolver> v2 = this.mapNameToResolvers.get(key);
            if (v2 == null) {
                v2 = new ArrayList();
                this.mapNameToResolvers.put(key, v2);
            }
            v2.add(resolver);
        }
    }

    protected void define(FunDef funDef) {
        this.define(new SimpleFuncResolver(funDef));
    }

    protected void define(FuncResolver resolver) {
        if (resolver.getSyntax() == Syntax.Property) {
            this.defineProperty(resolver.getName());
        }
        this.resolvers.add(resolver);
        String[] reservedWords = resolver.getReservedWords();
        for (int i = 0; i < reservedWords.length; ++i) {
            String reservedWord = reservedWords[i];
            this.defineReserved(reservedWord);
        }
    }

    public boolean isReserved(String s) {
        return this.reservedWords.contains(s.toUpperCase());
    }

    protected void defineReserved(String s) {
        this.reservedWords.add(s.toUpperCase());
    }

    public boolean isProperty(String s) {
        return this.propertyWords.contains(s.toUpperCase());
    }

    protected void defineProperty(String s) {
        this.propertyWords.add(s.toUpperCase());
    }

    private static String makeResolverKey(String name, Syntax syntax) {
        return name.toUpperCase() + "$" + syntax;
    }

    public FunDef getDef(FunCall call) throws OlapException {
        String key = FunTable.makeResolverKey(call.getFunction(), call.getSyntax());
        ArrayList<FuncResolver> resolvers = this.mapNameToResolvers.get(key);
        if (resolvers == null || resolvers.isEmpty()) {
            throw new FunctionException("function " + call.toMdx() + " not exist.");
        }
        IntHolder conversionCount = new IntHolder(0);
        int minConversions = Integer.MAX_VALUE;
        int matchCount = 0;
        FunDef matchDef = null;
        for (FuncResolver resolver : resolvers) {
            conversionCount.value = 0;
            FunDef def = resolver.resolve(call.getArgs(), conversionCount);
            if (def == null) continue;
            int conversions = conversionCount.value;
            if (conversions < minConversions) {
                minConversions = conversions;
                matchCount = 1;
                matchDef = def;
                continue;
            }
            if (conversions != minConversions) continue;
            ++matchCount;
        }
        switch (matchCount) {
            case 0: {
                throw new FunctionException("function " + call.toMdx() + " not exist.");
            }
            case 1: {
                return matchDef;
            }
        }
        throw new FunctionException("function " + call.toMdx() + " is ambiguous, multiple functions matched.");
    }
}

