/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.algo.olap.mdx;

import java.math.BigDecimal;
import kd.epm.eb.algo.olap.mdx.Category;
import kd.epm.eb.algo.olap.mdx.Exp;
import kd.epm.eb.algo.olap.mdx.ExpBase;
import kd.epm.eb.algo.olap.mdx.ExpResolver;
import kd.epm.eb.algo.olap.mdx.calc.Calc;
import kd.epm.eb.algo.olap.mdx.calc.ExpCompiler;
import kd.epm.eb.algo.olap.mdx.calc.impl.ConstantCalc;
import kd.epm.eb.algo.olap.mdx.type.NumericType;
import kd.epm.eb.algo.olap.mdx.type.StringType;
import kd.epm.eb.algo.olap.mdx.type.SymbolType;
import kd.epm.eb.algo.olap.mdx.type.Type;
import kd.epm.eb.algo.olap.util.Util;

public class Literal
extends ExpBase {
    private static final long serialVersionUID = 6259324092429508681L;
    public int type;
    private Object o;
    public static final Literal emptyString = new Literal("", false);
    public static final Literal zero = new Literal(0);
    public static final Literal one = new Literal(1);
    public static final Literal doubleZero = new Literal(0.0);
    public static final Literal doubleOne = new Literal(1.0);
    public static final Literal bigDecimalZero = new Literal(BigDecimal.ZERO);
    public static final Literal bigDecimalOne = new Literal(BigDecimal.ONE);
    public boolean isNull = false;

    private Literal(String s, boolean isSymbol) {
        this.o = s;
        this.type = isSymbol ? 11 : 9;
    }

    public static Literal createNull() {
        Literal l = new Literal(null, false);
        l.type = 64;
        l.isNull = true;
        return l;
    }

    public static Literal create(boolean b) {
        return new Literal(b);
    }

    public static Literal createString(String s) {
        if (s.equals("")) {
            return emptyString;
        }
        return new Literal(s, false);
    }

    public static Literal createSymbol(String s) {
        return new Literal(s, true);
    }

    private Literal(Number d) {
        this.o = d;
        this.type = 7;
    }

    private Literal(boolean b) {
        this.o = b;
        this.type = 5;
    }

    public static Literal create(Double d) {
        if (d == 0.0) {
            return bigDecimalZero;
        }
        if (d == 1.0) {
            return bigDecimalOne;
        }
        return new Literal(new BigDecimal(d.toString()));
    }

    private Literal(Integer i) {
        this.o = i;
        this.type = 7;
    }

    public static Literal create(Integer i) {
        if (i == 0) {
            return zero;
        }
        if (i == 1) {
            return one;
        }
        return new Literal(i);
    }

    @Override
    public Object clone() {
        return this;
    }

    public String stringValue() {
        if (this.type == 9) {
            String str = (String)this.o;
            if (str.startsWith("'") && str.endsWith("'") || str.startsWith("\"") && str.endsWith("\"")) {
                return str.substring(1, str.length() - 1);
            }
            return str;
        }
        if (this.isNull) {
            return "NULL";
        }
        return this.o.toString();
    }

    public int intValue() {
        if (this.o instanceof Number) {
            return ((Number)this.o).intValue();
        }
        throw Util.newInternal("cannot convert " + this.o + " to int");
    }

    public Object getValueObject() {
        if (this.type == 9) {
            return this.stringValue();
        }
        return this.o;
    }

    @Override
    public int getCategory() {
        return this.type;
    }

    @Override
    public Exp resolve(ExpResolver resolver) {
        return this;
    }

    @Override
    public Calc compile(ExpCompiler compiler) {
        return new ConstantCalc(this.getType(), this.getValueObject());
    }

    @Override
    public Type getType() {
        if (this.isNull) {
            return new NumericType();
        }
        switch (this.type) {
            case 11: {
                return new SymbolType();
            }
            case 7: {
                return new NumericType();
            }
            case 9: {
                return new StringType();
            }
        }
        throw Category.instance.badValue(this.type);
    }

    public void unparse(StringBuffer sb) {
        if (this.isNull) {
            sb.append("NULL");
            return;
        }
        switch (this.type) {
            case 5: 
            case 7: 
            case 11: {
                sb.append(this.o);
                break;
            }
            case 9: {
                sb.append(Util.quoteForMdx(this.stringValue()));
                break;
            }
            default: {
                throw Util.newInternal("bad literal type " + this.type);
            }
        }
    }
}

