/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.algo.olap.mdx;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.epm.eb.algo.olap.CalculatedMember;
import kd.epm.eb.algo.olap.Connection;
import kd.epm.eb.algo.olap.Cube;
import kd.epm.eb.algo.olap.Dimension;
import kd.epm.eb.algo.olap.Hierarchy;
import kd.epm.eb.algo.olap.Member;
import kd.epm.eb.algo.olap.OlapElement;
import kd.epm.eb.algo.olap.OlapException;
import kd.epm.eb.algo.olap.collection.DefaultListFactory;
import kd.epm.eb.algo.olap.collection.IList;
import kd.epm.eb.algo.olap.collection.IListFactory;
import kd.epm.eb.algo.olap.impl.BBFilterIndexWithMeasure;
import kd.epm.eb.algo.olap.impl.ConnectionImpl;
import kd.epm.eb.algo.olap.impl.CubeImpl;
import kd.epm.eb.algo.olap.impl.DimensionImpl;
import kd.epm.eb.algo.olap.impl.EvaluateContext;
import kd.epm.eb.algo.olap.impl.EvaluatorImpl;
import kd.epm.eb.algo.olap.impl.LinkCellReader;
import kd.epm.eb.algo.olap.mdx.CacheType;
import kd.epm.eb.algo.olap.mdx.DelegatingSchemaReader;
import kd.epm.eb.algo.olap.mdx.DimensionProperty;
import kd.epm.eb.algo.olap.mdx.Evaluator;
import kd.epm.eb.algo.olap.mdx.Exp;
import kd.epm.eb.algo.olap.mdx.ExpResolver;
import kd.epm.eb.algo.olap.mdx.Formula;
import kd.epm.eb.algo.olap.mdx.Literal;
import kd.epm.eb.algo.olap.mdx.MemberProperty;
import kd.epm.eb.algo.olap.mdx.ParserHelp;
import kd.epm.eb.algo.olap.mdx.QueryAxis;
import kd.epm.eb.algo.olap.mdx.QueryObject;
import kd.epm.eb.algo.olap.mdx.SchemaReader;
import kd.epm.eb.algo.olap.mdx.Set;
import kd.epm.eb.algo.olap.mdx.StackExpResolver;
import kd.epm.eb.algo.olap.mdx.calc.BooleanCalc;
import kd.epm.eb.algo.olap.mdx.calc.Calc;
import kd.epm.eb.algo.olap.mdx.calc.ExpCompiler;
import kd.epm.eb.algo.olap.mdx.calc.ListCalc;
import kd.epm.eb.algo.olap.mdx.calc.impl.BetterScalarExpCompiler;
import kd.epm.eb.algo.olap.mdx.type.SetType;
import kd.epm.eb.algo.olap.mdx.type.TupleType;
import kd.epm.eb.algo.olap.mdx.type.Type;
import kd.epm.eb.algo.olap.util.RoaringIntBitSet;
import kd.epm.eb.algo.olap.util.RoaringLongBitSet;
import kd.epm.eb.algo.olap.util.UniqueNameUtil;
import kd.epm.eb.algo.olap.util.Util;
import org.roaringbitmap.IntIterator;

public class MdxQuery
extends QueryObject
implements EvaluateContext,
Serializable {
    List<Formula> formulas = new ArrayList<Formula>();
    ArrayList axisDef = null;
    String cubeName;
    transient Connection connection;
    List cellProps = new ArrayList();
    Exp slicer = null;
    private QueryAxis[] axes = null;
    private Calc[] axisCalcs = null;
    private Calc slicerCalc = null;
    private CubeImpl cube;
    public long useTime = 0L;
    private List<CellCalculationInfo> cellCalculations = null;
    CCFilters ccFilters;
    QuerySchemaReader schemaReader = null;
    IListFactory listFactory = null;
    private HashMap<String, LinkCellReader> linkCellReaderMap;

    public void afterParse(Connection cn) throws OlapException {
        if (this.axisDef != null) {
            this.axes = this.axisDef.toArray(new QueryAxis[0]);
            this.axisDef = null;
        }
        this.connection = cn;
        this.resolve();
        this.cube = (CubeImpl)this.getCube();
        ((ConnectionImpl)cn).setMdxQuery(this);
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public ExpResolver createExpResolver() throws OlapException {
        Cube cube = this.connection.getSchemaReader().getCube(this.cubeName);
        if (cube == null) {
            throw new OlapException("Cube named " + this.cubeName + " not found.");
        }
        StackExpResolver resolver = new StackExpResolver(this.getSchemaReader(), ((ConnectionImpl)this.connection).getDatabase().getUdfTable());
        return resolver;
    }

    private ExpCompiler createCompiler(ExpResolver resolver) {
        BetterScalarExpCompiler compiler = new BetterScalarExpCompiler(resolver);
        return compiler;
    }

    public void resolve() throws OlapException {
        ExpResolver resolver = this.createExpResolver();
        this.resolve(resolver);
        ExpCompiler compiler = this.createCompiler(resolver);
        this.compile(compiler);
    }

    public void resolve(ExpResolver resolver) throws OlapException {
        Cube cube;
        if (this.formulas != null) {
            Formula formula;
            int i;
            for (i = 0; i < this.formulas.size(); ++i) {
                formula = this.formulas.get(i);
                formula.createElement(resolver.getSchemaReader());
            }
            for (i = 0; i < this.formulas.size(); ++i) {
                formula = this.formulas.get(i);
                resolver.resolve(formula);
            }
        }
        if ((cube = this.getCube()).getCalculatedMembers() != null) {
            CalculatedMember[] members = cube.getCalculatedMembers();
            for (int i = 0; i < members.length; ++i) {
                resolver.resolve(members[i].getFormula());
            }
        }
        if (this.axes != null) {
            for (int i = 0; i < this.axes.length; ++i) {
                resolver.resolve(this.axes[i]);
            }
        }
        if (this.slicer != null) {
            this.slicer = this.slicer.resolve(resolver);
        }
    }

    @Override
    public Calc compileExpression(Exp exp, boolean scalar) throws OlapException {
        ExpResolver resolver = this.createExpResolver();
        ExpCompiler compiler = this.createCompiler(resolver);
        Calc calc = scalar ? compiler.compileScalar(exp, false) : exp.compile(compiler);
        return calc;
    }

    private int getDimensionIndexInCube(Dimension dim) {
        Cube cube = this.connection.getSchemaReader().getCubes()[0];
        Dimension[] dims = cube.getDimensions();
        for (int i = 0; i < dims.length; ++i) {
            if (!dims[i].equals(dim)) continue;
            return i;
        }
        return dims.length;
    }

    @Override
    public Evaluator createEvaluator() throws OlapException {
        return new EvaluatorImpl(this, this.cube, this.connection.getCellReader());
    }

    public java.util.Set getCellCalculationMemberSet(Evaluator evaluator) throws OlapException {
        if (this.cellCalculations == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<Member> set = new HashSet<Member>();
        for (int i = this.cellCalculations.size() - 1; i >= 0; --i) {
            CellCalculationInfo info = this.cellCalculations.get(i);
            if (info.list == null) {
                info.list = info.listCalc.evaluateList(evaluator);
            }
            Iterator iter = info.list.iterator();
            while (iter.hasNext()) {
                Member[] members = Util.toMemberArray(iter.next());
                for (int j = 0; j < members.length; ++j) {
                    set.add(members[j]);
                }
            }
        }
        return set;
    }

    @Override
    public Calc getCellCalculation(Evaluator evaluator) throws OlapException {
        if (this.cellCalculations == null || this.cellCalculations.isEmpty()) {
            return null;
        }
        if (this.ccFilters == null) {
            this.ccFilters = new CCFilters();
        }
        long st = System.currentTimeMillis();
        Calc calc = this.ccFilters.getCellCalculationInfo(evaluator);
        this.useTime = this.useTime + System.currentTimeMillis() - st;
        return calc;
    }

    public Calc getCellCalculation0(Evaluator evaluator) throws OlapException {
        if (this.cellCalculations == null || this.cellCalculations.isEmpty()) {
            return null;
        }
        Member[] context = evaluator.getCurrentMembers();
        for (int i = this.cellCalculations.size() - 1; i >= 0; --i) {
            CellCalculationInfo info = this.cellCalculations.get(i);
            if (info.forAll) {
                if (info.conditionCalc != null) {
                    if (!info.conditionCalc.evaluateBoolean(evaluator)) continue;
                    return info.calc;
                }
                return info.calc;
            }
            if (info.list == null) {
                info.list = info.listCalc.evaluateList(evaluator);
            }
            Iterator iter = info.list.iterator();
            while (iter.hasNext()) {
                Member[] members = Util.toMemberArray(iter.next());
                if (!Util.tupleContains(context, members)) continue;
                if (info.conditionCalc != null) {
                    if (!info.conditionCalc.evaluateBoolean(evaluator)) continue;
                    return info.calc;
                }
                return info.calc;
            }
        }
        return null;
    }

    private void compile(ExpCompiler compiler) throws OlapException {
        if (this.formulas != null && !this.formulas.isEmpty()) {
            for (Formula formula : this.formulas) {
                if (!formula.isCellCalculation()) continue;
                boolean forAll = false;
                ListCalc listCalc = null;
                BooleanCalc conditionCalc = null;
                if (formula.scope instanceof Literal && "all".equalsIgnoreCase(((Literal)formula.scope).toString())) {
                    forAll = true;
                } else {
                    listCalc = compiler.compileList(formula.scope);
                }
                Calc calc = compiler.compileScalar(formula.exp, true);
                Exp condition = formula.getCondition();
                if (condition != null) {
                    try {
                        conditionCalc = compiler.compileBoolean(condition);
                    }
                    catch (ClassCastException e) {
                        throw new OlapException("Cell Calculation Condition must be Boolean,but " + condition.toMdx() + " is not.", e);
                    }
                }
                if (this.cellCalculations == null) {
                    this.cellCalculations = new ArrayList<CellCalculationInfo>();
                }
                this.cellCalculations.add(new CellCalculationInfo(forAll, listCalc, calc, conditionCalc));
            }
        }
        if (this.axes != null) {
            this.axisCalcs = new Calc[this.axes.length];
            for (int i = 0; i < this.axes.length; ++i) {
                this.axisCalcs[i] = this.axes[i].compile(compiler);
            }
        }
        if (this.slicer != null) {
            this.slicerCalc = compiler.compile(this.slicer);
        }
    }

    @Override
    public SchemaReader getSchemaReader() {
        if (this.schemaReader == null) {
            this.schemaReader = new QuerySchemaReader(this.connection.getSchemaReader());
        }
        return this.schemaReader;
    }

    public Member lookupMemberFromDefined(String s) {
        for (Formula formula : this.formulas) {
            if (!formula.isMember() || !formula.getUniqeName().equalsIgnoreCase(s)) continue;
            return formula.getMember();
        }
        return null;
    }

    public QueryAxis[] getAxes() {
        return this.axes;
    }

    public QueryAxis getAxis(String name) {
        for (int i = 0; i < this.axes.length; ++i) {
            if (!name.equalsIgnoreCase(this.axes[i].getName())) continue;
            return this.axes[i];
        }
        return null;
    }

    public Calc getAxisCalc(String name) {
        for (int i = 0; i < this.axes.length; ++i) {
            if (!name.equalsIgnoreCase(this.axes[i].getName())) continue;
            return this.axisCalcs[i];
        }
        return null;
    }

    public void setAxes(QueryAxis[] axes) {
        this.axes = axes;
    }

    public Cube getCube() {
        return this.connection.getSchemaReader().getCube(this.cubeName);
    }

    public String getCubeName() {
        if (this.cubeName.charAt(0) == '[' && this.cubeName.charAt(this.cubeName.length() - 1) == ']') {
            return this.cubeName.substring(1, this.cubeName.length() - 1);
        }
        return this.cubeName;
    }

    public void setCubeName(String cubeName) {
        this.cubeName = cubeName;
    }

    public Formula[] getFormulas() {
        return this.formulas.toArray(new Formula[0]);
    }

    @Override
    public boolean hasFormulas() {
        return this.formulas.size() > 0;
    }

    public String toString() {
        try {
            this.resolve();
        }
        catch (OlapException olapException) {
            // empty catch block
        }
        return this.toMdx();
    }

    @Override
    public String toMdx() {
        StringBuilder mdx = new StringBuilder();
        if (this.formulas.size() > 0) {
            mdx.append("WITH ");
            Iterator<Formula> iter = this.formulas.iterator();
            while (iter.hasNext()) {
                mdx.append(' ');
                Formula form = iter.next();
                mdx.append(form.toMdx());
            }
            mdx.append(' ');
        }
        mdx.append("SELECT ");
        boolean isFollow = false;
        for (int i = 0; i < this.axes.length; ++i) {
            QueryAxis qa = this.axes[i];
            if (isFollow) {
                mdx.append(", ");
            }
            isFollow = true;
            mdx.append(qa.toMdx());
        }
        mdx.append(" FROM ");
        mdx.append(this.cubeName);
        if (this.slicer != null) {
            mdx.append(" WHERE ");
            mdx.append(this.slicer.toMdx());
        }
        return mdx.toString();
    }

    public Object clone() {
        MdxQuery cloned = new MdxQuery();
        if (this.formulas.size() > 0) {
            ArrayList<Formula> clonedFormulas = new ArrayList<Formula>();
            for (Formula form : this.formulas) {
                clonedFormulas.add((Formula)form.clone());
            }
            cloned.formulas = clonedFormulas;
        }
        if (this.axes.length > 0) {
            QueryAxis[] clonedAxes = new QueryAxis[this.axes.length];
            for (int i = 0; i < clonedAxes.length; ++i) {
                clonedAxes[i] = (QueryAxis)this.axes[i].clone();
            }
            cloned.setAxes(clonedAxes);
        }
        if (this.slicer != null) {
            cloned.slicer = (Exp)this.slicer.clone();
        }
        cloned.setCubeName("[" + this.getCubeName() + "]");
        return cloned;
    }

    public Exp getSlicer() {
        return this.slicer;
    }

    public void setSlicer(Exp exp) {
        this.slicer = exp;
    }

    public Formula addFormula(String[] names, Exp exp, MemberProperty[] memberProperties, CacheType cacheType) {
        Formula newFormula = new Formula(names, exp, memberProperties, cacheType);
        this.formulas.add(newFormula);
        return newFormula;
    }

    public void removeFormula(Formula formula) {
        this.formulas.remove(formula);
    }

    public Formula addFormula(String[] names, Exp exp) {
        Formula newFormula = new Formula(names, exp);
        this.formulas.add(newFormula);
        return newFormula;
    }

    public Formula addFormula(String[] names, Exp scope, Exp exp, MemberProperty[] memberProperties) {
        Formula formula = new Formula(names, scope, exp, memberProperties);
        this.formulas.add(formula);
        return formula;
    }

    public void removeFormula(String uniqueName) {
        Iterator<Formula> iter = this.formulas.iterator();
        while (iter.hasNext()) {
            Formula formula = iter.next();
            if (!uniqueName.equals(formula.getUniqeName())) continue;
            iter.remove();
        }
    }

    public void swapAxes() {
        if (this.axes.length == 2) {
            Exp e0 = this.axes[0].getExp();
            boolean nonEmpty0 = this.axes[0].isNonEmpty();
            DimensionProperty[] dimProps0 = this.axes[0].getResolvedProps();
            DimensionProperty[] dimProps1 = this.axes[1].getResolvedProps();
            Exp e1 = this.axes[1].getExp();
            boolean nonEmpty1 = this.axes[1].isNonEmpty();
            this.axes[1].setExp(e0);
            this.axes[1].setNonEmpty(nonEmpty0);
            this.axes[1].setResolvedProps(dimProps0);
            this.axes[0].setExp(e1);
            this.axes[0].setNonEmpty(nonEmpty1);
            this.axes[0].setResolvedProps(dimProps1);
        }
    }

    public Hierarchy[] getMdxHierarchiesOnAxis(int axis) {
        if (axis == -1 && this.slicer == null) {
            return null;
        }
        return this.collectHierarchies(axis == -1 ? this.slicer : this.axes[axis].getExp());
    }

    public Hierarchy[] collectHierarchies(Exp queryPart) {
        Type type = queryPart.getType();
        if (type instanceof SetType) {
            type = ((SetType)type).getElementType();
        }
        if (type instanceof TupleType) {
            Type[] types = ((TupleType)type).elementTypes;
            ArrayList<Hierarchy> hierarchyList = new ArrayList<Hierarchy>();
            for (int i = 0; i < types.length; ++i) {
                Hierarchy hierarchy = types[i].getHierarchy();
                hierarchyList.add(hierarchy);
            }
            return hierarchyList.toArray(new Hierarchy[hierarchyList.size()]);
        }
        return new Hierarchy[]{type.getHierarchy()};
    }

    public Calc[] getAxisCalcs() {
        return this.axisCalcs;
    }

    public Calc getSlicerCalc() {
        return this.slicerCalc;
    }

    public void setAxisCalcs(Calc[] axisCalcs) {
        this.axisCalcs = axisCalcs;
    }

    public void setSlicerCalc(Calc slicerCalc) {
        this.slicerCalc = slicerCalc;
    }

    public Member[] getCalculatedMembers() throws OlapException {
        if (this.schemaReader == null) {
            this.getSchemaReader();
        }
        return this.schemaReader.getCalculatedMembers(this.schemaReader.getCube(this.cubeName));
    }

    public IListFactory getListFactory() {
        if (this.listFactory == null) {
            this.listFactory = DefaultListFactory.instance;
        }
        return this.listFactory;
    }

    public void release() {
        if (this.listFactory != null) {
            this.listFactory.release();
            this.listFactory = null;
        }
    }

    @Override
    public Exp parseExpression(String expression, boolean resolve) {
        Exp exp = ParserHelp.parseExpression(expression);
        if (resolve) {
            ExpResolver resolver = this.createExpResolver();
            return resolver.resolve(exp);
        }
        return exp;
    }

    @Override
    public LinkCellReader getLinkCellReader(String linkName) {
        LinkCellReader lcr;
        ConnectionImpl cn = (ConnectionImpl)this.connection;
        Connection linkConnection = cn.getLink(linkName);
        if (this.linkCellReaderMap == null) {
            this.linkCellReaderMap = new HashMap();
        }
        if ((lcr = this.linkCellReaderMap.get(linkName)) == null) {
            lcr = new LinkCellReader((ConnectionImpl)linkConnection);
            this.linkCellReaderMap.put(linkName, lcr);
        }
        return lcr;
    }

    private static class CellCalculationInfo {
        boolean forAll;
        ListCalc listCalc;
        Calc calc;
        BooleanCalc conditionCalc;
        IList list;

        public CellCalculationInfo(boolean forAll, ListCalc listCalc, Calc calc, BooleanCalc conditionCalc) {
            this.forAll = forAll;
            this.listCalc = listCalc;
            this.calc = calc;
            this.conditionCalc = conditionCalc;
        }
    }

    private class CCFilter {
        int dimCount;
        RoaringLongBitSet[] bitSets;
        HashMap<Dimension, RoaringLongBitSet> bitSetMap = new HashMap();
        BBFilterIndexWithMeasure filterIndex;
        private boolean empty;
        private final CellCalculationInfo info;
        private final int index;
        private boolean hasMeasure;

        CCFilter(int index, CellCalculationInfo info, Evaluator evaluator) throws OlapException {
            Iterator iter;
            this.index = index;
            this.info = info;
            if (info.list == null) {
                info.list = info.listCalc.evaluateList(evaluator);
            }
            if (!(iter = info.list.iterator()).hasNext()) {
                this.empty = true;
                return;
            }
            Object o = iter.next();
            if (o instanceof Member) {
                this.init((Member)o, iter);
            } else {
                this.init((Member[])o, iter);
            }
        }

        private void init(Member[] ms, Iterator iter) throws OlapException {
            int i;
            for (Member m : ms) {
                if (!m.isMeasure()) continue;
                if (m.isCalculated()) {
                    throw new OlapException("Measure calculated member is not supported in cell calculation: " + m.getUniqueName());
                }
                this.hasMeasure = true;
                break;
            }
            this.dimCount = ms.length;
            this.bitSets = new RoaringLongBitSet[this.dimCount];
            int[] indexes = new int[this.dimCount];
            int[] cards = new int[this.dimCount];
            for (i = 0; i < this.dimCount; ++i) {
                DimensionImpl dim = (DimensionImpl)ms[i].getDimension();
                this.bitSets[i] = new RoaringLongBitSet();
                this.bitSetMap.put(dim, this.bitSets[i]);
                indexes[i] = MdxQuery.this.getDimensionIndexInCube(dim);
                cards[i] = dim.getMemberCount();
            }
            this.filterIndex = new BBFilterIndexWithMeasure(cards, indexes);
            while (true) {
                for (i = 0; i < this.dimCount; ++i) {
                    this.bitSets[i].set(ms[i].getGlobalOrder());
                    ms[i].getFilterBitSet().set(this.index);
                }
                this.filterIndex.addNarrow(ms);
                if (!iter.hasNext()) break;
                ms = (Member[])iter.next();
            }
        }

        private void init(Member m, Iterator iter) throws OlapException {
            this.hasMeasure = m.isMeasure();
            if (this.hasMeasure && m.isCalculated()) {
                throw new OlapException("Measure calculated member is not supported in cell calculation: " + m.getUniqueName());
            }
            DimensionImpl dim = (DimensionImpl)m.getDimension();
            this.dimCount = 1;
            this.bitSets = new RoaringLongBitSet[1];
            this.bitSets[0] = new RoaringLongBitSet();
            this.bitSetMap.put(dim, this.bitSets[0]);
            int[] indexes = new int[]{MdxQuery.this.getDimensionIndexInCube(m.getDimension())};
            int[] cards = new int[]{dim.getMemberCount()};
            this.filterIndex = new BBFilterIndexWithMeasure(cards, indexes);
            while (true) {
                this.bitSets[0].set(m.getGlobalOrder());
                m.getFilterBitSet().set(this.index);
                this.filterIndex.addNarrow(m);
                if (!iter.hasNext()) break;
                m = (Member)iter.next();
            }
        }

        boolean hasMemberContext(Member[] members, Member measure) {
            if (this.empty) {
                return false;
            }
            if (this.hasMeasure) {
                return this.filterIndex.get(members, measure);
            }
            return this.filterIndex.get(members);
        }
    }

    private class CCFilters {
        CCFilter[] filters;
        HashMap<Dimension, RoaringLongBitSet> dimensionBitSetMap = new HashMap();
        RoaringLongBitSet[] dimensionBitSets = null;
        RoaringLongBitSet measureBitSet = null;
        private int[] hasFilterDimensionIndex = null;
        RoaringIntBitSet tempBitSet = new RoaringIntBitSet();

        public CCFilters() throws OlapException {
            if (MdxQuery.this.cellCalculations == null || MdxQuery.this.cellCalculations.isEmpty()) {
                return;
            }
            this.filters = new CCFilter[MdxQuery.this.cellCalculations.size()];
            Evaluator evaluator = null;
            for (int i = 0; i < this.filters.length; ++i) {
                CCFilter filter;
                evaluator = MdxQuery.this.createEvaluator();
                this.filters[i] = filter = new CCFilter(i, (CellCalculationInfo)MdxQuery.this.cellCalculations.get(i), evaluator);
                for (Map.Entry<Dimension, RoaringLongBitSet> entry : filter.bitSetMap.entrySet()) {
                    Dimension dim = entry.getKey();
                    if (dim.isMeasureDimension()) {
                        if (this.measureBitSet != null) {
                            this.measureBitSet.or(entry.getValue());
                            continue;
                        }
                        this.measureBitSet = entry.getValue();
                        continue;
                    }
                    RoaringLongBitSet bs = this.dimensionBitSetMap.get(dim);
                    if (bs != null) {
                        bs.or(entry.getValue());
                        continue;
                    }
                    this.dimensionBitSetMap.put(dim, entry.getValue());
                }
            }
            if (evaluator != null) {
                Member[] ms = evaluator.getCurrentMembers();
                this.dimensionBitSets = new RoaringLongBitSet[ms.length];
                this.hasFilterDimensionIndex = new int[this.dimensionBitSetMap.size()];
                int cur = 0;
                for (int i = 0; i < ms.length; ++i) {
                    this.dimensionBitSets[i] = this.dimensionBitSetMap.get(ms[i].getDimension());
                    if (this.dimensionBitSets[i] == null) continue;
                    this.hasFilterDimensionIndex[cur++] = i;
                }
            }
        }

        private IntIterator getFilterIntIterator(Member[] members, Member measure) {
            this.tempBitSet.clear();
            for (int i = 0; i < this.hasFilterDimensionIndex.length; ++i) {
                this.tempBitSet.or(members[this.hasFilterDimensionIndex[i]].getFilterBitSet());
            }
            if (this.measureBitSet != null) {
                this.tempBitSet.or(measure.getFilterBitSet());
            }
            return this.tempBitSet.reverseIterator();
        }

        Calc getCellCalculationInfo(Evaluator evaluator) throws OlapException {
            if (evaluator.getCurrentMeasure().isCalculated()) {
                return null;
            }
            Member[] members = evaluator.getCurrentMembers();
            IntIterator iter = this.getFilterIntIterator(members, evaluator.getCurrentMeasure());
            while (iter.hasNext()) {
                int i = iter.next();
                if (!this.filters[i].hasMemberContext(members, evaluator.getCurrentMeasure())) continue;
                CellCalculationInfo info = this.filters[i].info;
                if (info.conditionCalc != null) {
                    if (!info.conditionCalc.evaluateBoolean(evaluator)) continue;
                    return info.calc;
                }
                return info.calc;
            }
            return null;
        }
    }

    private class QuerySchemaReader
    extends DelegatingSchemaReader {
        public QuerySchemaReader(SchemaReader schemaReader) {
            super(schemaReader);
        }

        @Override
        public Member getMemberByUniqueName(Cube cube, String uniqueName) throws OlapException {
            Member member = this.getCalculatedMember(cube, uniqueName);
            if (member == null) {
                member = this.schemaReader.getMemberByUniqueName(cube, uniqueName);
            }
            return member;
        }

        @Override
        public Member getCalculatedMember(Cube cube, String uniqueName) {
            Member member = MdxQuery.this.lookupMemberFromDefined(uniqueName);
            if (member == null) {
                member = this.schemaReader.getCalculatedMember(cube, uniqueName);
            }
            return member;
        }

        @Override
        public Member[] getCalculatedMembers(Cube cube, Hierarchy hierarchy) {
            ArrayList<Member> result = new ArrayList<Member>();
            HashSet<String> set = new HashSet<String>();
            for (Formula formula : MdxQuery.this.formulas) {
                Member member;
                if (!formula.isMember() || !(member = formula.getMember()).getHierarchy().equals(hierarchy)) continue;
                set.add(member.getUniqueName());
                result.add(member);
            }
            Member[] cMemberInSchema = this.schemaReader.getCalculatedMembers(cube, hierarchy);
            if (cMemberInSchema != null) {
                for (int i = 0; i < cMemberInSchema.length; ++i) {
                    if (set.contains(cMemberInSchema[i].getUniqueName())) continue;
                    result.add(cMemberInSchema[i]);
                }
            }
            return result.toArray(new Member[0]);
        }

        @Override
        public Member[] getCalculatedMembers(Cube cube) throws OlapException {
            ArrayList<Member> result = new ArrayList<Member>(2);
            HashSet<String> set = new HashSet<String>(2);
            for (Formula formula : MdxQuery.this.formulas) {
                if (!formula.isMember()) continue;
                Member member = formula.getMember();
                set.add(member.getUniqueName());
                result.add(member);
            }
            Member[] cMemberInSchema = this.schemaReader.getCalculatedMembers(cube);
            if (cMemberInSchema != null) {
                for (int i = 0; i < cMemberInSchema.length; ++i) {
                    if (set.contains(cMemberInSchema[i].getUniqueName())) continue;
                    result.add(cMemberInSchema[i]);
                }
            }
            return result.toArray(new Member[0]);
        }

        public Set getSet(String name) {
            for (int i = 0; i < MdxQuery.this.formulas.size(); ++i) {
                Formula formula = MdxQuery.this.formulas.get(i);
                if (!formula.isSet() || !formula.getFirstName().equalsIgnoreCase(name)) continue;
                return formula.getSet();
            }
            return null;
        }

        @Override
        public OlapElement getElementChild(OlapElement parent, String s) throws OlapException {
            OlapElement mdxElement = this.schemaReader.getElementChild(parent, s);
            if (mdxElement != null) {
                return mdxElement;
            }
            for (int i = 0; i < MdxQuery.this.formulas.size(); ++i) {
                Formula formula = MdxQuery.this.formulas.get(i);
                if (!formula.isSet() || !formula.getFirstName().equalsIgnoreCase(s)) continue;
                return formula.getSet();
            }
            return mdxElement;
        }

        @Override
        public OlapElement lookupCompound(OlapElement parent, String[] names, int category) throws OlapException {
            switch (category) {
                case 0: 
                case 6: {
                    Set set;
                    if (parent != this.getCube(MdxQuery.this.cubeName)) break;
                    String uniqueName = UniqueNameUtil.createUniqueName(names);
                    Member calculatedMember = this.getCalculatedMember(this.getCube(MdxQuery.this.cubeName), uniqueName);
                    if (calculatedMember != null) {
                        return calculatedMember;
                    }
                    if (names.length != 1 || (set = this.getSet(names[0])) == null) break;
                    return set;
                }
            }
            OlapElement olapElement = super.lookupCompound(parent, names, category);
            return olapElement;
        }
    }
}

