/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.algo.olap.mdx;

import kd.epm.eb.algo.olap.OlapException;
import kd.epm.eb.algo.olap.mdx.Exp;
import kd.epm.eb.algo.olap.mdx.FunDef;
import kd.epm.eb.algo.olap.mdx.FuncResolver;
import kd.epm.eb.algo.olap.mdx.Syntax;
import kd.epm.eb.algo.olap.mdx.TypeConvertUtil;
import kd.epm.eb.algo.olap.mdx.func.FuncUtil2;
import kd.epm.eb.algo.olap.util.IntHolder;
import kd.epm.eb.algo.olap.util.Util;

public abstract class MultiFuncResolver
implements FuncResolver {
    private final String name;
    private final String description;
    private final String[] signatures;
    private final Syntax syntax;

    public MultiFuncResolver(String name, String signature, String description, String[] signatures) {
        this.name = name;
        this.description = description;
        this.signatures = signatures;
        this.syntax = FuncUtil2.decodeSyntacticType(signatures[0]);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Syntax getSyntax() {
        return this.syntax;
    }

    @Override
    public String[] getReservedWords() {
        return Util.emptyStringArray;
    }

    public String[] getSignatures() {
        return this.signatures;
    }

    @Override
    public FunDef resolve(Exp[] args, IntHolder conversionCount) throws OlapException {
        block0: for (int j = 0; j < this.signatures.length; ++j) {
            int[] argCategorys = FuncUtil2.decodeArgCategory(this.signatures[j]);
            if (argCategorys.length != args.length) continue;
            for (int i = 0; i < args.length; ++i) {
                if (!TypeConvertUtil.canConvert(args[i], argCategorys[i], conversionCount)) continue block0;
            }
            String signature = this.signatures[j];
            int returnCategory = FuncUtil2.decodeReturnCategory(signature);
            return this.createFunDef(args, returnCategory, argCategorys);
        }
        return null;
    }

    protected abstract FunDef createFunDef(Exp[] var1, int var2, int[] var3) throws OlapException;
}

