/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.algo.olap.mdx;

import java.io.Serializable;
import kd.epm.eb.algo.olap.mdx.Category;
import kd.epm.eb.algo.olap.mdx.Exp;
import kd.epm.eb.algo.olap.mdx.ExpBase;
import kd.epm.eb.algo.olap.mdx.FunCall;
import kd.epm.eb.algo.olap.util.EnumeratedValues;
import kd.epm.eb.algo.olap.util.Util;

public class Syntax
extends EnumeratedValues.BasicValue
implements Serializable {
    public static final Syntax Function = new Syntax("Function", 0){

        @Override
        public void unparse(String fun, Exp[] args, StringBuilder sb) {
            if (fun.equals("_Value") && args[0] instanceof FunCall && ((FunCall)args[0]).isCallToTuple()) {
                ((FunCall)args[0]).unparse(sb);
                return;
            }
            ExpBase.unparseList(sb, args, fun + "(", ", ", ")");
        }
    };
    public static final Syntax Property = new Syntax("Property", 1){

        @Override
        public void unparse(String fun, Exp[] args, StringBuilder sb) {
            Util.assertTrue(args.length >= 1);
            args[0].unparse(sb);
            sb.append(".");
            sb.append(fun);
        }

        @Override
        public String getSignature(String name, int returnType, int[] argTypes) {
            return Syntax.getTypeDescription(argTypes[0]) + "." + name;
        }
    };
    public static final Syntax Method = new Syntax("Method", 2){

        @Override
        public void unparse(String fun, Exp[] args, StringBuilder sb) {
            Util.assertTrue(args.length >= 1);
            args[0].unparse(sb);
            sb.append(".");
            sb.append(fun);
            sb.append("(");
            for (int i = 1; i < args.length; ++i) {
                if (i > 1) {
                    sb.append(", ");
                }
                args[i].unparse(sb);
            }
            sb.append(")");
        }

        @Override
        public String getSignature(String name, int returnType, int[] argTypes) {
            return (returnType == 0 ? "" : Syntax.getTypeDescription(returnType) + " ") + Syntax.getTypeDescription(argTypes[0]) + "." + name + "(" + Syntax.getTypeDescriptionCommaList(argTypes, 1) + ")";
        }
    };
    public static final Syntax Infix = new Syntax("Infix", 3){

        @Override
        public void unparse(String fun, Exp[] args, StringBuilder sb) {
            if (Syntax.needParen(args)) {
                ExpBase.unparseList(sb, args, "(", " " + fun + " ", ")");
            } else {
                ExpBase.unparseList(sb, args, "", " " + fun + " ", "");
            }
        }

        @Override
        public String getSignature(String name, int returnType, int[] argTypes) {
            return Syntax.getTypeDescription(argTypes[0]) + " " + name + " " + Syntax.getTypeDescription(argTypes[1]);
        }
    };
    public static final Syntax Prefix = new Syntax("Prefix", 4){

        @Override
        public void unparse(String fun, Exp[] args, StringBuilder sb) {
            if (Syntax.needParen(args)) {
                ExpBase.unparseList(sb, args, "(" + fun + " ", null, ")");
            } else {
                ExpBase.unparseList(sb, args, "" + fun + " ", null, "");
            }
        }

        @Override
        public String getSignature(String name, int returnType, int[] argTypes) {
            return name + " " + Syntax.getTypeDescription(argTypes[0]);
        }
    };
    public static final Syntax Braces = new Syntax("Braces", 5){

        @Override
        public String getSignature(String name, int returnType, int[] argTypes) {
            return "{" + Syntax.getTypeDescriptionCommaList(argTypes, 0) + "}";
        }

        @Override
        public void unparse(String fun, Exp[] args, StringBuilder sb) {
            ExpBase.unparseList(sb, args, "{", ", ", "}");
        }
    };
    public static final Syntax Parentheses = new Syntax("Parentheses", 6){

        @Override
        public String getSignature(String name, int returnType, int[] argTypes) {
            return "(" + Syntax.getTypeDescriptionCommaList(argTypes, 0) + ")";
        }

        @Override
        public void unparse(String fun, Exp[] args, StringBuilder sb) {
            ExpBase.unparseList(sb, args, "(", ", ", ")");
        }
    };
    public static final Syntax Case = new Syntax("Case", 7){

        @Override
        public void unparse(String fun, Exp[] args, StringBuilder sb) {
            sb.append("CASE");
            int j = 0;
            if (fun.equals("_CaseMatch")) {
                sb.append(" ");
                args[j++].unparse(sb);
            } else {
                Util.assertTrue(fun.equals("_CaseTest"));
            }
            int clauseCount = (args.length - j) / 2;
            for (int i = 0; i < clauseCount; ++i) {
                sb.append(" WHEN ");
                args[j++].unparse(sb);
                sb.append(" THEN ");
                args[j++].unparse(sb);
            }
            if (j < args.length) {
                sb.append(" ELSE ");
                args[j++].unparse(sb);
            }
            Util.assertTrue(j == args.length);
            sb.append(" END");
        }

        @Override
        public String getSignature(String name, int returnType, int[] argTypes) {
            String s = Syntax.getTypeDescription(argTypes[0]);
            if (argTypes[0] == 5) {
                return "CASE WHEN " + s + " THEN <Expression> ... END";
            }
            return "CASE " + s + " WHEN " + s + " THEN <Expression> ... END";
        }
    };
    public static final Syntax Internal = new Syntax("Internal", 8);
    public static final Syntax QuotedProperty = new Syntax("Quoted property", Syntax.Property.ordinal_ | 0x100);
    public static final Syntax AmpersandQuotedProperty = new Syntax("Ampersand-quoted property", Syntax.Property.ordinal_ | 0x200);
    private static final int mask = 255;
    public static final EnumeratedValues enumeration = new EnumeratedValues(new Syntax[]{Function, Property, Method, Infix, Prefix, Braces, Parentheses, Case, Internal});

    public Syntax(String name, int ordinal) {
        super(name, ordinal, null);
    }

    public static Syntax get(int ordinal) {
        return (Syntax)enumeration.getValue(ordinal & 0xFF);
    }

    public void unparse(String fun, Exp[] args, StringBuilder sb) {
        throw new UnsupportedOperationException();
    }

    public String getSignature(String name, int returnType, int[] argTypes) {
        return (returnType == 0 ? "" : Syntax.getTypeDescription(returnType) + " ") + name + "(" + Syntax.getTypeDescriptionCommaList(argTypes, 0) + ")";
    }

    private static boolean needParen(Exp[] args) {
        return args.length != 1 || !(args[0] instanceof FunCall) || ((FunCall)args[0]).getSyntax() != Parentheses;
    }

    private static String getTypeDescription(int type) {
        return "<" + Category.instance.getDescription(type & 0x1F) + ">";
    }

    private static String getTypeDescriptionCommaList(int[] types, int start) {
        int initialSize = (types.length - start) * 16;
        StringBuilder sb = new StringBuilder(initialSize > 0 ? initialSize : 16);
        for (int i = start; i < types.length; ++i) {
            if (i > start) {
                sb.append(", ");
            }
            sb.append("<").append(Category.instance.getDescription(types[i] & 0x1F)).append(">");
        }
        return sb.toString();
    }
}

