/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.algo.olap.mdx;

import java.util.ArrayList;
import java.util.HashMap;
import kd.epm.eb.algo.olap.OlapException;
import kd.epm.eb.algo.olap.mdx.FunCall;
import kd.epm.eb.algo.olap.mdx.FunDef;
import kd.epm.eb.algo.olap.mdx.FuncResolver;
import kd.epm.eb.algo.olap.mdx.FunctionException;
import kd.epm.eb.algo.olap.mdx.SimpleFuncResolver;
import kd.epm.eb.algo.olap.mdx.Syntax;
import kd.epm.eb.algo.olap.util.IntHolder;

public class UserDefineFunTable {
    private HashMap<String, ArrayList<FuncResolver>> mapNameToResolvers = new HashMap();

    public void define(FunDef funDef) {
        this.define(new SimpleFuncResolver(funDef));
    }

    private void define(FuncResolver resolver) {
        if (resolver.getSyntax() == Syntax.Property) {
            throw new OlapException("Not supported");
        }
        String key = UserDefineFunTable.makeResolverKey(resolver.getName(), resolver.getSyntax());
        ArrayList<FuncResolver> v2 = this.mapNameToResolvers.get(key);
        if (v2 == null) {
            v2 = new ArrayList();
            this.mapNameToResolvers.put(key, v2);
        }
        v2.add(resolver);
    }

    private static String makeResolverKey(String name, Syntax syntax) {
        return name.toUpperCase() + "$" + syntax;
    }

    public FunDef getDef(FunCall call) throws OlapException {
        String key = UserDefineFunTable.makeResolverKey(call.getFunction(), call.getSyntax());
        ArrayList<FuncResolver> resolvers = this.mapNameToResolvers.get(key);
        if (resolvers == null || resolvers.isEmpty()) {
            return null;
        }
        IntHolder conversionCount = new IntHolder(0);
        int minConversions = Integer.MAX_VALUE;
        int matchCount = 0;
        FunDef matchDef = null;
        for (FuncResolver resolver : resolvers) {
            conversionCount.value = 0;
            FunDef def = resolver.resolve(call.getArgs(), conversionCount);
            if (def == null) continue;
            int conversions = conversionCount.value;
            if (conversions < minConversions) {
                minConversions = conversions;
                matchCount = 1;
                matchDef = def;
                continue;
            }
            if (conversions != minConversions) continue;
            ++matchCount;
        }
        switch (matchCount) {
            case 0: {
                return null;
            }
            case 1: {
                return matchDef;
            }
        }
        throw new FunctionException("function " + call.toMdx() + " is ambiguous, multiple functions matched.");
    }
}

