/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.algo.olap.mdx.calc.impl;

import java.math.BigDecimal;
import kd.epm.eb.algo.olap.AvgValue;
import kd.epm.eb.algo.olap.OlapException;
import kd.epm.eb.algo.olap.mdx.Evaluator;
import kd.epm.eb.algo.olap.mdx.Exp;
import kd.epm.eb.algo.olap.mdx.ExpResolver;
import kd.epm.eb.algo.olap.mdx.calc.BigDecimalCalc;
import kd.epm.eb.algo.olap.mdx.calc.BooleanCalc;
import kd.epm.eb.algo.olap.mdx.calc.Calc;
import kd.epm.eb.algo.olap.mdx.calc.DoubleCalc;
import kd.epm.eb.algo.olap.mdx.calc.IntegerCalc;
import kd.epm.eb.algo.olap.mdx.calc.NumberCalc;
import kd.epm.eb.algo.olap.mdx.calc.impl.AbstractBigDecimalCalc;
import kd.epm.eb.algo.olap.mdx.calc.impl.AbstractDoubleCalc;
import kd.epm.eb.algo.olap.mdx.calc.impl.AbstractExpCompiler;
import kd.epm.eb.algo.olap.mdx.calc.impl.AbstractIntegerCalc;
import kd.epm.eb.algo.olap.util.Util;

public class BetterScalarExpCompiler
extends AbstractExpCompiler {
    public BetterScalarExpCompiler(ExpResolver resolver) {
        super(resolver);
    }

    @Override
    public BigDecimalCalc compileBigDecimal(Exp exp) throws OlapException {
        final Calc calc = this.compileScalar(exp, false);
        if (calc instanceof BigDecimalCalc) {
            return (BigDecimalCalc)calc;
        }
        if (calc instanceof DoubleCalc) {
            final DoubleCalc doubleCalc = (DoubleCalc)calc;
            return new AbstractBigDecimalCalc(exp, new Calc[]{doubleCalc}){

                @Override
                public BigDecimal evaluateBigDecimal(Evaluator evaluator) throws OlapException {
                    double result = doubleCalc.evaluateDouble(evaluator);
                    return BigDecimal.valueOf(result);
                }
            };
        }
        if (calc instanceof IntegerCalc) {
            final IntegerCalc integerCalc = (IntegerCalc)calc;
            return new AbstractBigDecimalCalc(exp, new Calc[]{integerCalc}){

                @Override
                public BigDecimal evaluateBigDecimal(Evaluator evaluator) throws OlapException {
                    int result = integerCalc.evaluateInteger(evaluator);
                    return BigDecimal.valueOf((double)result);
                }
            };
        }
        return new AbstractBigDecimalCalc(exp, new Calc[]{calc}){

            @Override
            public BigDecimal evaluateBigDecimal(Evaluator evaluator) throws OlapException {
                Object o = calc.evaluate(evaluator);
                if (o == null) {
                    return null;
                }
                if (o instanceof BigDecimal) {
                    return (BigDecimal)o;
                }
                if (o instanceof Number) {
                    return new BigDecimal(o.toString());
                }
                if (o instanceof AvgValue) {
                    AvgValue avgValue = (AvgValue)o;
                    return Util.toBigDecimal(avgValue.getAvgValue());
                }
                throw new OlapException("cannot cast " + this.exp.toMdx() + " to Number.");
            }
        };
    }

    @Override
    public DoubleCalc compileDouble(Exp exp) throws OlapException {
        Calc calc = this.compileScalar(exp, false);
        if (calc instanceof DoubleCalc) {
            return (DoubleCalc)calc;
        }
        if (calc instanceof IntegerCalc) {
            final IntegerCalc integerCalc = (IntegerCalc)calc;
            return new AbstractDoubleCalc(exp, new Calc[]{integerCalc}){

                @Override
                public double evaluateDouble(Evaluator evaluator) throws OlapException {
                    int result = integerCalc.evaluateInteger(evaluator);
                    return result;
                }
            };
        }
        if (calc instanceof NumberCalc) {
            final NumberCalc numberCalc = (NumberCalc)calc;
            return new AbstractDoubleCalc(exp, new Calc[]{numberCalc}){

                @Override
                public double evaluateDouble(Evaluator evaluator) throws OlapException {
                    Number number = numberCalc.evaluateNumber(evaluator);
                    if (number == null) {
                        return 0.0;
                    }
                    return number.doubleValue();
                }
            };
        }
        throw new OlapException("cannot cast " + exp + " to Double.");
    }

    @Override
    public IntegerCalc compileInteger(Exp exp) throws OlapException {
        Calc calc = this.compileScalar(exp, false);
        if (calc instanceof IntegerCalc) {
            return (IntegerCalc)calc;
        }
        if (calc instanceof DoubleCalc) {
            final DoubleCalc doubleCalc = (DoubleCalc)calc;
            return new AbstractIntegerCalc(exp, new Calc[]{doubleCalc}){

                @Override
                public int evaluateInteger(Evaluator evaluator) throws OlapException {
                    return (int)doubleCalc.evaluateDouble(evaluator);
                }
            };
        }
        if (calc instanceof BigDecimalCalc) {
            final BigDecimalCalc bigDecimalCalc = (BigDecimalCalc)calc;
            return new AbstractIntegerCalc(exp, new Calc[]{bigDecimalCalc}){

                @Override
                public int evaluateInteger(Evaluator evaluator) throws OlapException {
                    return bigDecimalCalc.evaluateBigDecimal(evaluator).intValue();
                }
            };
        }
        if (calc instanceof NumberCalc) {
            final NumberCalc numberCalc = (NumberCalc)calc;
            return new AbstractIntegerCalc(exp, new Calc[]{numberCalc}){

                @Override
                public int evaluateInteger(Evaluator evaluator) throws OlapException {
                    Number number = numberCalc.evaluateNumber(evaluator);
                    if (number == null) {
                        return 0;
                    }
                    return number.intValue();
                }
            };
        }
        throw new OlapException("cannot cast " + exp + " to Integer.");
    }

    @Override
    public BooleanCalc compileBoolean(Exp exp) throws OlapException {
        return (BooleanCalc)this.compileScalar(exp, false);
    }
}

