/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.algo.olap.mdx.calc.impl;

import kd.epm.eb.algo.olap.Dimension;
import kd.epm.eb.algo.olap.Hierarchy;
import kd.epm.eb.algo.olap.Level;
import kd.epm.eb.algo.olap.Member;
import kd.epm.eb.algo.olap.mdx.Evaluator;
import kd.epm.eb.algo.olap.mdx.calc.Calc;
import kd.epm.eb.algo.olap.mdx.calc.DimensionCalc;
import kd.epm.eb.algo.olap.mdx.calc.DummyExp;
import kd.epm.eb.algo.olap.mdx.calc.HierarchyCalc;
import kd.epm.eb.algo.olap.mdx.calc.IntegerCalc;
import kd.epm.eb.algo.olap.mdx.calc.LevelCalc;
import kd.epm.eb.algo.olap.mdx.calc.MemberCalc;
import kd.epm.eb.algo.olap.mdx.calc.impl.GenericCalc;
import kd.epm.eb.algo.olap.mdx.type.DimensionType;
import kd.epm.eb.algo.olap.mdx.type.HierarchyType;
import kd.epm.eb.algo.olap.mdx.type.LevelType;
import kd.epm.eb.algo.olap.mdx.type.MemberType;
import kd.epm.eb.algo.olap.mdx.type.NumericType;
import kd.epm.eb.algo.olap.mdx.type.Type;

public class ConstantCalc
extends GenericCalc {
    private final Object o;
    private final int i;
    private final double d;

    public ConstantCalc(Type type, Object o) {
        super(new DummyExp(type));
        this.o = o;
        this.i = o instanceof Number ? ((Number)o).intValue() : 0;
        this.d = o instanceof Number ? ((Number)o).doubleValue() : 0.0;
    }

    @Override
    public Object evaluate(Evaluator evaluator) {
        return this.o;
    }

    @Override
    public int evaluateInteger(Evaluator evaluator) {
        return this.i;
    }

    @Override
    public double evaluateDouble(Evaluator evaluator) {
        return this.d;
    }

    @Override
    public Calc[] getCalcs() {
        return new Calc[0];
    }

    public static IntegerCalc constantInteger(int i) {
        return new ConstantIntegerCalc(new NumericType(), i);
    }

    public static ConstantCalc constantNull(Type type) {
        return new ConstantCalc(type, null);
    }

    public static MemberCalc constantMember(Member member) {
        return new ConstantMemberCalc(new MemberType(member.getHierarchy(), member.getLevel(), member), member);
    }

    public static LevelCalc constantLevel(Level level) {
        return new ConstantLevelCalc(new LevelType(level.getHierarchy(), level), level);
    }

    public static HierarchyCalc constantHierarchy(Hierarchy hierarchy) {
        return new ConstantHierarchyCalc(new HierarchyType(hierarchy), hierarchy);
    }

    public static DimensionCalc constantDimension(Dimension dimension) {
        return new ConstantDimensionCalc(new DimensionType(dimension), dimension);
    }

    public static class ConstantIntegerCalc
    extends ConstantCalc
    implements IntegerCalc {
        public ConstantIntegerCalc(Type type, Object o) {
            super(type, o);
        }
    }

    public static class ConstantLevelCalc
    extends ConstantCalc
    implements LevelCalc {
        public ConstantLevelCalc(Type type, Object o) {
            super(type, o);
        }
    }

    public static class ConstantDimensionCalc
    extends ConstantCalc
    implements DimensionCalc {
        public ConstantDimensionCalc(Type type, Object o) {
            super(type, o);
        }
    }

    public static class ConstantHierarchyCalc
    extends ConstantCalc
    implements HierarchyCalc {
        public ConstantHierarchyCalc(Type type, Object o) {
            super(type, o);
        }
    }

    public static class ConstantMemberCalc
    extends ConstantCalc
    implements MemberCalc {
        public ConstantMemberCalc(Type type, Object o) {
            super(type, o);
        }
    }
}

