/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.algo.olap.mdx.calc.impl.extend;

import java.util.Iterator;
import kd.epm.eb.algo.olap.Member;
import kd.epm.eb.algo.olap.OlapException;
import kd.epm.eb.algo.olap.collection.IList;
import kd.epm.eb.algo.olap.collection.ListFactoryFactory;
import kd.epm.eb.algo.olap.mdx.Evaluator;
import kd.epm.eb.algo.olap.mdx.Exp;
import kd.epm.eb.algo.olap.mdx.calc.Calc;
import kd.epm.eb.algo.olap.mdx.calc.ListCalc;
import kd.epm.eb.algo.olap.mdx.calc.impl.AbstractListCalc;
import kd.epm.eb.algo.olap.mdx.func.FuncUtil2;
import kd.epm.eb.algo.olap.util.Util;

public class OrderCrossJoinCalc
extends AbstractListCalc {
    ListCalc calc1;
    ListCalc calc2;
    Calc expCalc;
    boolean desc;

    public OrderCrossJoinCalc(Exp exp, ListCalc calc1, ListCalc calc2, Calc expCalc, boolean desc) {
        super(exp, new Calc[]{calc1, calc2, expCalc});
        this.calc1 = calc1;
        this.calc2 = calc2;
        this.expCalc = expCalc;
        this.desc = desc;
    }

    @Override
    public IList evaluateList(Evaluator evaluator) throws OlapException {
        IList list1 = this.calc1.evaluateList(evaluator);
        IList list2 = this.calc2.evaluateList(evaluator);
        IList result = ListFactoryFactory.getListFactory().createArrayList();
        if (list1.isEmpty() || list2.isEmpty()) {
            return result;
        }
        Object left = list1.getFirst();
        Object right = list2.getFirst();
        boolean isMember1 = left instanceof Member;
        boolean isMember2 = right instanceof Member;
        int type = isMember1 && isMember2 ? 0 : (isMember2 ? 1 : 2);
        Iterator iter = list1.iterator();
        while (iter.hasNext()) {
            Object left2 = iter.next();
            evaluator.setContext(left2);
            FuncUtil2.sort(evaluator, list2, this.expCalc, this.desc, false);
            Iterator iter2 = list2.iterator();
            while (iter2.hasNext()) {
                Object right2 = iter2.next();
                switch (type) {
                    case 0: {
                        result.add(Util.makeTuple((Member)left2, (Member)right2));
                        break;
                    }
                    case 1: {
                        result.add(Util.makeTuple((Member[])left2, (Member)right2));
                        break;
                    }
                    case 2: {
                        result.add(Util.makeTuple((Member)left2, (Member[])right2));
                    }
                }
            }
        }
        return result;
    }
}

