/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.algo.olap.mdx.calc.impl.func;

import kd.epm.eb.algo.olap.Level;
import kd.epm.eb.algo.olap.Member;
import kd.epm.eb.algo.olap.OlapException;
import kd.epm.eb.algo.olap.collection.IMemberList;
import kd.epm.eb.algo.olap.collection.ListFactoryFactory;
import kd.epm.eb.algo.olap.mdx.Evaluator;
import kd.epm.eb.algo.olap.mdx.Exp;
import kd.epm.eb.algo.olap.mdx.SchemaReader;
import kd.epm.eb.algo.olap.mdx.calc.Calc;
import kd.epm.eb.algo.olap.mdx.calc.LevelCalc;
import kd.epm.eb.algo.olap.mdx.calc.MemberCalc;
import kd.epm.eb.algo.olap.mdx.calc.impl.AbstractMemberListCalc;
import kd.epm.eb.algo.olap.mdx.func.FuncUtil2;

public class DescendantsCalc
extends AbstractMemberListCalc {
    private MemberCalc memberCalc;
    private LevelCalc levelCalc;
    private final boolean self;
    private final boolean before;
    private final boolean after;
    private final boolean depthSpecified;
    private final int depthLimit;

    public DescendantsCalc(Exp exp, MemberCalc memberCalc, LevelCalc levelCalc, boolean self, boolean before, boolean after, boolean depthSpecified, int depthLimit) {
        super(exp, new Calc[]{memberCalc, levelCalc});
        this.memberCalc = memberCalc;
        this.levelCalc = levelCalc;
        this.self = self;
        this.before = before;
        this.after = after;
        this.depthSpecified = depthSpecified;
        this.depthLimit = depthLimit;
    }

    @Override
    public IMemberList evaluateMemberList(Evaluator evaluator) throws OlapException {
        Member member = this.memberCalc.evaluateMember(evaluator);
        IMemberList result = ListFactoryFactory.getListFactory().createMemberList();
        SchemaReader schemaReader = evaluator.getSchemaReader();
        if (this.depthSpecified) {
            DescendantsCalc.descendantsByDepth(evaluator, member, result, schemaReader, this.depthLimit, this.before, this.self, this.after);
        } else {
            Level level = this.levelCalc != null ? this.levelCalc.evaluateLevel(evaluator) : member.getLevel();
            schemaReader.getMemberDescendants(member, result, level, this.before, this.self, this.after);
        }
        FuncUtil2.hierarchize(result, false);
        return result;
    }

    private static IMemberList descendantsByDepth(Evaluator evaluator, Member member, IMemberList result, SchemaReader schemaReader, int depthLimitFinal, boolean before, boolean self, boolean after) {
        IMemberList children = ListFactoryFactory.getListFactory().createMemberList();
        children.add(member);
        int depth = 0;
        while (true) {
            if (depth == depthLimitFinal) {
                if (self) {
                    FuncUtil2.addAll(result, children);
                }
                if (!after) {
                    break;
                }
            } else if (depth < depthLimitFinal) {
                if (before) {
                    FuncUtil2.addAll(result, children);
                }
            } else {
                if (!after) break;
                FuncUtil2.addAll(result, children);
            }
            try {
                children = schemaReader.getMemberChildren(children);
            }
            catch (OlapException e) {
                break;
            }
            if (children.isEmpty()) break;
            ++depth;
        }
        return result;
    }
}

