/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.algo.olap.mdx.calc.impl.func;

import kd.epm.eb.algo.olap.Dimension;
import kd.epm.eb.algo.olap.Hierarchy;
import kd.epm.eb.algo.olap.Level;
import kd.epm.eb.algo.olap.Member;
import kd.epm.eb.algo.olap.OlapException;
import kd.epm.eb.algo.olap.collection.IMemberList;
import kd.epm.eb.algo.olap.mdx.Evaluator;
import kd.epm.eb.algo.olap.mdx.Exp;
import kd.epm.eb.algo.olap.mdx.calc.Calc;
import kd.epm.eb.algo.olap.mdx.calc.DimensionCalc;
import kd.epm.eb.algo.olap.mdx.calc.LevelCalc;
import kd.epm.eb.algo.olap.mdx.calc.Scope;
import kd.epm.eb.algo.olap.mdx.calc.impl.AbstractMemberCalc;
import kd.epm.eb.algo.olap.mdx.calc.impl.ConstantCalc;
import kd.epm.eb.algo.olap.mdx.calc.impl.func.LevelFirstMemberCalc;

public class DimensionFirstMemberCalc
extends AbstractMemberCalc {
    DimensionCalc dimensionCalc;

    public DimensionFirstMemberCalc(Exp exp, DimensionCalc dimensionCalc) {
        super(exp, new Calc[]{dimensionCalc});
        this.dimensionCalc = dimensionCalc;
    }

    @Override
    public Calc optimize(Scope scope, Evaluator evaluator) throws OlapException {
        Dimension dimension = this.dimensionCalc.evaluateDimension(null);
        Level level = dimension.getDefaultHierarchy().getLevels()[0];
        LevelCalc levelCalc = ConstantCalc.constantLevel(level);
        return new LevelFirstMemberCalc(null, levelCalc).optimize(scope, evaluator);
    }

    @Override
    public Member evaluateMember(Evaluator evaluator) throws OlapException {
        Dimension dimension = this.dimensionCalc.evaluateDimension(evaluator);
        Hierarchy hierarchy = dimension.getDefaultHierarchy();
        IMemberList list = evaluator.getSchemaReader().getHierarchyRootMembers(hierarchy);
        if (list.isEmpty()) {
            return hierarchy.getNullMember();
        }
        return (Member)list.getFirst();
    }
}

