/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.algo.olap.mdx.calc.impl.func;

import kd.epm.eb.algo.olap.Hierarchy;
import kd.epm.eb.algo.olap.Level;
import kd.epm.eb.algo.olap.OlapException;
import kd.epm.eb.algo.olap.collection.IMemberList;
import kd.epm.eb.algo.olap.collection.ListFactoryFactory;
import kd.epm.eb.algo.olap.mdx.Evaluator;
import kd.epm.eb.algo.olap.mdx.Exp;
import kd.epm.eb.algo.olap.mdx.calc.Calc;
import kd.epm.eb.algo.olap.mdx.calc.HierarchyCalc;
import kd.epm.eb.algo.olap.mdx.calc.IntegerCalc;
import kd.epm.eb.algo.olap.mdx.calc.Scope;
import kd.epm.eb.algo.olap.mdx.calc.impl.AbstractMemberListCalc;
import kd.epm.eb.algo.olap.mdx.func.FuncUtil2;

public class HierarchyMembersAboveLevelCalc
extends AbstractMemberListCalc {
    private HierarchyCalc hierarchyCalc;
    private IntegerCalc integerCalc;
    private Scope.NeedHierarchize needHierarchize = Scope.NeedHierarchize.Yes;

    public HierarchyMembersAboveLevelCalc(Exp exp, HierarchyCalc hierarchyCalc, IntegerCalc integerCalc) {
        super(exp, new Calc[]{hierarchyCalc, integerCalc});
        this.hierarchyCalc = hierarchyCalc;
        this.integerCalc = integerCalc;
    }

    @Override
    public Calc optimize(Scope scope, Evaluator evaluator) throws OlapException {
        this.needHierarchize = scope.getNeedHierarchize();
        return super.optimize(scope, evaluator);
    }

    @Override
    public IMemberList evaluateMemberList(Evaluator evaluator) throws OlapException {
        Hierarchy hierarchy = this.hierarchyCalc.evaluateHierarchy(evaluator);
        int index = this.integerCalc.evaluateInteger(evaluator);
        Level level = hierarchy.getLevels()[0];
        if (index < 0) {
            index = 0;
        }
        IMemberList members = ListFactoryFactory.getListFactory().createMemberList();
        while (level != null && index > level.getDepth()) {
            members.addList(evaluator.getSchemaReader().getLevelMembers(level));
            level = level.getChildLevel();
        }
        if (this.needHierarchize != Scope.NeedHierarchize.No) {
            FuncUtil2.hierarchize(members, false);
        }
        return members;
    }
}

